/*
 * tgmb-mgr.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "tgmb-mgr.h"
#include "tgmb-conn.h"


DEFINE_OTCL_CLASS(TGMB_Manager, "TGMB_Manager")
{
	INSTPROC(create_dummy_rcvr);
}



TGMB_Manager *TGMB_Manager::this_=NULL;


int
TGMB_Manager::create_dummy_rcvr(int argc, const char * const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	SRM_Source *local =
		session()->source_manager()->first_local_source();
	MTrace(trcMB|trcExcessive, ("Trying to create local source for %s",
				    (const char *)local->id()));
	TGMB_DummyLocalRcvr *pRcvr = new TGMB_DummyLocalRcvr(this,local->id());
	SrcId sid = local->id();
	INIT_LOG(sid.ss_uid);
	assert(AddReceiver(pRcvr) && "local receiver created twice?");
	LocalRcvr(pRcvr);
	LocalSid(sid);

	return TCL_OK;

}


/* virtual */
MBBaseRcvr *
TGMB_Manager::NewReceiver(const SrcId &srcId, Bool isLocal)
{
	SRM_Source *local =
		session()->source_manager()->first_local_source();
	if (isLocal==TRUE) {
		if (local==NULL) {
			// this is a local source
			// AND we haven't yet created the dummy local source
			return NULL;
		}

		return new TGMB_LocalRcvr(this, srcId);
	}

	MTrace(trcMB|trcVerbose,
	       ("Creating new receiver for %s", (const char*)srcId));
	return new MBReceiver(this, srcId);
}


/* virtual */
MBPageObject *
TGMB_Manager::NewPageObject(const PageId &pageId, Bool newPage)
{
	MBPageObject *pPage = MBManager::NewPageObject(pageId, newPage);
	if (pPage) {
		((Page*)pPage)->setIsVisible(TRUE);
	}
	return pPage;
}


int
TGMB_Manager::next_ADU(u_char *pb, int len, srm_src &id, int &pkt_type,
		       int &next)
{
	MBPageObject *pPage;

	next=0;
	pkt_type = APP_DATA;
	// TODO: should poll all receivers or preq as well

	if (currNextADU_==NULL) {
		MTrace(trcTGMB, ("No source for data yet!"));
		return 0;
	}

	int outlen=0;
	TGMB_LocalRcvr *pRcvr = currNextADU_;
	do {
		PageId pgId = pRcvr->conn_->curr_pgid();
		if (pgId.sid.ss_uid==0 && pgId.sid.ss_addr==0 && pgId.uid==0) {
			pPage = NULL;
		} else {
			pPage =pRcvr->DefinePage(pRcvr->conn_->curr_pgid());
		}
		outlen = pRcvr->NextADU(pb, len, next, pPage);
		if (outlen==0) {
			pRcvr = pRcvr->next_;
		} else {
			// set the id of this guy
			id = pRcvr->getSrcId();
			currNextADU_ = pRcvr->next_;
		}

	} while(outlen==0 && pRcvr!=currNextADU_);

	return outlen;
}


int
TGMB_Manager::periodic_update(Byte *pb)
{
	if (currFillSA_==NULL) {
		MTrace(trcTGMB, ("No source for announcement yet!"));
		return 0;
	}

	int outlen=0;
	TGMB_LocalRcvr *pRcvr = currFillSA_;
	do {
		outlen = pRcvr->FillSA(pb, getMTU());
		if (outlen==0) {
			pRcvr = pRcvr->next_;
		} else {
			// we have constructed a session announcement
			currFillSA_ = pRcvr->next_;
		}

	} while(outlen==0 && pRcvr!=currFillSA_);

	if (outlen==0) {
		// I don't have anything to send; I should reset the SA timer
		// FIXME: ignoring the return code from this method
		session()->sa_timer()->Invoke("reset", NULL);
	}
	return outlen;
}


TGMB_LocalRcvr*
TGMB_Manager::Upgrade(MBReceiver *pRcvr)
{
	// FIXME
	printf("************ upgrading\n");
	TGMB_LocalRcvr *local =
		new TGMB_LocalRcvr(this, pRcvr->getSrcId());
	RemoveReceiver(pRcvr);
	local->Swap(pRcvr);
	AddReceiver(local);
	delete pRcvr;
	return local;
}


//
// This means that a remote receiver has detected that this local
// receiver is outdated. Besides updating the the page state,
// We need to bump up the lastSent_ value of the page
void
TGMB_LocalRcvr::HandleSA(Pkt_PgStatus* aPgStatus, int numPgs)
{
	// note: when numPgs is zero the following loop is skipped
	for (Pkt_PgStatus* pPgStatus= aPgStatus;
	     pPgStatus < aPgStatus+numPgs;
	     pPgStatus++) {
		PageId pgid;
		net2host(pPgStatus->pageid, pgid);
		MBPageObject* pPage = DefinePage(pgid);
		ulong maxSn=net2host(pPgStatus->maxSn);
		pPage->Update(getSrcId(), maxSn);
		pPage->SetLastSent(maxSn);
	}
}

