# cf-tm.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1995-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
# Handle commands that come over conference bus for manipulating
# overlaid images (e.g., from a title generator).
#

Class Titler
Class Titler/411 -superclass {Titler Module/Compositor/411}
Class Titler/422 -superclass {Titler Module/Compositor/422}

Titler proc insert grabber {
	Titler instvar enable_ grabber_ tm_
	if ![info exists enable_] {
		return 0
	}
	if [info exists tm_] {
		delete $tm_
		unset tm_
	}
	set target [$grabber target]
	set ff [$target frame-format]
	if { $ff == "cif" } {
		set ff 411
	}
	if { $ff == "411" || $ff == "422" } {
		set tm_ [new Titler/$ff]
		$tm target $encoder
		$grabber target $tm
		set grabber_ $grabber
		return 1
	} else {
		return 0
	}
}

Titler proc enable {} {
	Titler instvar enable_ grabber_
	set enable_ 1
	if [info exists grabber_] {
		Titler insert $grabber_
	}
}

Titler proc disable {} {
	Titler instvar enable_ grabber_ tm_
	catch "unset enable_"
	if [info exists grabber_] {
		# remove the title-maker from the path
		# FIXME this assumes the title-maker is the first
		# intervening modules
		$grabber_ target [$tm_ target]
		delete $tm_
		unset tm_
	}
}

Titler instproc check id {
	$self instvar obj_
	return [info exists obj_($id)]
}

Titler instproc create_obj { id file width height } {
puts define/$id/$file/$width/$height
	$self instvar obj_
	if [$self check $id] {
		$self destroy_obj $id
	}
	set obj_($id) [new overlay]
	#FIXME check for error
	$obj_($id) load $file $width $height
}

Titler instproc transparent { id lum } {
puts transparent:$id/$lum
	$self instvar obj_
	if [$self check $id] {
		$obj_($id) transparent $lum
	}
}

Titler instproc destroy_obj id {
	$self instvar obj_
	if [$self check $id] {
		set o $obj_($id)
		unset obj_($id)
		$self detach $o
		delete $o
	}
}

Titler instproc place { id x y depth } {
	$self instvar obj_
	if [$self check $id] {
		set o $obj_($id)
		if { ![info exists depth_($o)] } {
			set depth_($o) $depth
			$self attach $o $x $y $depth
		} elseif { $depth_($o) != $depth } {
			set depth_($o) $depth
			$self detach $o
			$self attach $o $x $y $depth
		} else {
			$self move $o $x $y
		}
	}
}

Titler instproc remove id {
	if [$self check $id] {
		$self instvar obj_
		set o $obj_($id)
		unset obj_($id)
		$self detach $o
		delete $o
	}
}

#
#FIXME this is broken: easiest to wait for cleaner coodbus API
# initialize the dispatch table with the title-maker API
#
foreach proc { tm_enable tm_disable tm_define tm_destroy \
	tm_place tm_remove tm_transparent } {
	set cb_dispatch($proc) $proc
}
