# application-fca.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


Class FCApp -superclass Application

FCApp instproc init argv {
	set config [new Configuration]
	$self set options_ $config

    $self next fca
    $self init_args $config
    $self init_resources $config
    $self parse_args $argv
    $self init_net
    $self init_ui
}


FCApp instproc init_args o {
    $self register_option $o -m moderators
}


FCApp instproc init_resources o {
    $o add_default sessionAddr "224.2.55.100/5000"
}


FCApp instproc init_net {} {
    $self instvar mgr_ uiMgr_ session_ localSrc_

    puts "come into init_net"

# floor control policy: manual, 1 moderator, 15 max rqs, 3 floors max
#                       and default floors
# the policy should be obtained from SDR plug in
#!! chairs are the initial floor holders

    set moderatorIds [$self resource moderators]
    DbgOut "moderatorIds = { $moderatorIds }"
    set addr [$self resource sessionAddr]
    DbgOut "session addr: $addr"

    set policy [new FCAPolicy 0 1 5]
    $policy addFloor 1 1
    $policy addFloor 2 1
    $policy addFloor 3 1

    set mgr_ [new SRMAppMgr/FCA/Tcl $policy $moderatorIds]
    set session_ [Session/SRM create-session $mgr_ $addr]
    set localSrc_ [$session_ default-local]
    puts "*$localSrc_*"
    $mgr_ attach_session_ $session_
    $mgr_ setLocalSrcId [$localSrc_ srcid]
    $mgr_ create_dynamics
    # must call create_dynamics only after we've attached the local src

    DbgOut "local srcid: [$localSrc_ srcid]"

    [$session_ data-net] loopback 1
    [$session_ ctrl-net] loopback 1

    set uiMgr_ [new FCA_UIMgr .main_frame $mgr_]
    $mgr_ attach_uiMgr $uiMgr_

    $uiMgr_ add_floor 1 Audio Audio_Icon
    $uiMgr_ add_floor 2 Video Video_Icon
    $uiMgr_ add_floor 3 Mediaboard Mediaboard_Icon

    set sm [$session_ set sm_]
    $sm attach_src_update_handler $uiMgr_
    pack .main_frame -expand 1 -fill both
}


FCApp instproc init_ui {} {
}
