# application-null.tcl --
#
#       An example Service Discovery App that does nothing
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPApplication
import CSdsService
import CServiceManager
import CService
import DpClient

#
# Code for CRnSwitcherApplication
#

Class CNullServiceApplication -superclass RTPApplication

CNullServiceApplication instproc InitArgs { options } {
    # for the service discovery service
    $options register_option -sa optServiceAddress
    $options register_option -sp optServicePort
    $options register_option -st optServiceTTL

    # for the service discovery service
    $options register_option -rp optComPort

    # for the amx info
    $options register_option -amxaddr optAMXAddress
    $options register_option -amxport optAMXPort
}

CNullServiceApplication instproc InitResources { options } {
    # for the service discovery service
    $options add_default optServiceAddress "224.4.6.8"
    $options add_default optServicePort "12344"
    $options add_default optServiceTTL "16"

    # for the service discovery service
    $options add_default optComPort "11410"
}

CNullServiceApplication instproc init { argv } {
    $self next NullService

    # Initiailization of variables and resources.
    set options [$self options]
    $self InitArgs $options
    $self InitResources $options
    $options load_preferences "rtp rvc"
    set argv [$options parse_args $argv]

    # create the sds session object
    set inetServiceAddr [$options get_option optServiceAddress]
    set iServicePort [$options get_option optServicePort]
    set iServiceTTL [$options get_option optServiceTTL]

    $self instvar m_sdsService
    set m_sdsService [new CSdsService $self $inetServiceAddr \
	    $iServicePort $iServicePort $iServiceTTL]

    # setup the service objects
    $self instvar m_serviceManager
    $self instvar m_service

    set iPort [$options get_option optComPort]
    set m_serviceManager [new CServiceManager "ServiceApp" "Service" $iPort]
    $m_serviceManager Attach $self

    set m_service ""
}

##############################################################################
#
# CNullServiceApplication instproc NewConnection { service } {
#
# Input:
# service - the new service that got connected
#
# Output:
# 1 - if handling this service
# 0 - otherwise
#
# Description:
# A call back function for the service manager.  This function will be called
# when a new connection has just been noticed by the service manager
#
##############################################################################
CNullServiceApplication instproc NewConnection { service } {
    $self instvar m_service

    set m_service $service

    # Add the service calls
    $m_service MapMessage "SYN_SERVICE_IMAGE" $self SynServiceImage
    $m_service MapMessage "GET_UI_WINDOW" $self GetUIWindow
    $m_service MapMessage "CLOSE_LINK" $self CloseService

    return 1
}

##############################################################################
#
# CNullServiceApplication instproc CloseService { service arguments }
#
# Input:
# service - the service object that called this function
# arguments - the arguments that are passed to this funct from remote caller
#
# Output:
# none
#
# Description:
# Need to close the service and allow other connections to be made
#
##############################################################################
CNullServiceApplication instproc CloseService { service arguments } {
    $self instvar m_service
    set m_service ""

    exit
}


##############################################################################
#
# CNullServiceApplication public SynServiceImage { service arguments } {
#
# Input:
# service - the service that called this function
# arguments - the arguments associated with this call
#
# Output:
# none
#
# Description:
# This is called by the remote service client when it wants the image or text
# to display the service.  The simple protocol goes as such:
# type type_dependent_arguments.  The type could be text and it's argument
# the ascii of title.  It could also be image and be a bitmap of the image
#
##############################################################################
CNullServiceApplication public SynServiceImage { service arguments } {
    $service Send "SYN_SERVICE_IMAGE" "text NullService"
}


##############################################################################
#
# CNullServiceApplication public GetUIWindow { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the arguments associated with this call
#
# Output:
# none
#
# Description:
# This is called by the remote service client when it wants the code
# to make the window.  It should send back the code to build the window.
# There are two things that are assumed to be set by the client.  One is
# winFrame the window to draw into.  Another is service, which is the
# m_service object to send back to yourself.
#
##############################################################################
CNullServiceApplication public GetUIWindow { service arguments } {
    $service Send "GET_UI_WINDOW" ""
}

##############################################################################
#
# CNullServiceApplication public GetSdsServiceData { } {
#
# Input:
# none
#
# Output:
# the data that the will go out to the sds system
#
# Description:
# This is a callback function for the service discovery system.  Need to
# return the data that will go out to the sds system.  So far there are
# three fields with their values
#
##############################################################################
CNullServiceApplication public GetSdsServiceData { } {
    $self instvar m_lConfig

    set options [$self options]
    set iComPort [$options get_option optComPort]
    set hostname [exec hostname]

    set location "Locationless"
    set type "Null Service"

    set data [list "UPDATE:" [concat $hostname $iComPort] \
	    [list [list "LOCATION:" $location] \
	    	  [list "TYPE:" $type]]]

    return $data
}

