# ui-tk.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/common/ui-tk.tcl,v 1.20 2002/02/03 04:25:43 lim Exp $


import Configuration Application

#
# An abstract base class for defining some common methods for tk
# windows.  TkWindows are not necessarily toplevel windows.
#
Class TkWindow -configuration {
	background gray85
}

#
# An abstract base class for defining some common methods for toplevel
# windows. <p>
# All concrete subclasses representing toggle-able windows should
# implement a <i>build</i> method.
#
Class TopLevelWindow -superclass TkWindow

#
# Add the <i>path</i> of this tk widget to the data structure.
#
TkWindow public init {path} {
	$self next
	$self instvar path_
	set path_ $path
}

#
# Accessor function.
#
TkWindow public widget_path {} {
	$self instvar path_
	return $path_
}

#
# A mechanism for deleting the widget represented by this TkWindow,
# including all its children.
#
TkWindow instproc destroy {} {
	$self instvar path_
	if [winfo exists $path_] {
		destroy $path_
	}
	$self next
}

#
# Color the background of this widget and all its children.
#
TkWindow instproc highlight { color } {
	$self instvar path_

	if { $path_ != "" } {
		$path_ configure -background $color
		foreach child [winfo children $path_] {
			window_highlight $child $color
		}
	}
}

#
# Color the background of the window.
#
TkWindow instproc set_background { color } {
	$self instvar path_
	$path_ configure -background $color
}

#
# Builds the window itself if one does not already exist by this
# TkWindow's widgetpath.
#
TopLevelWindow public build_window {} {
	$self instvar path_
	if ![winfo exists $path_] {
		$self build $path_
	}
}


#
# If the window does not already exist, build it. If the window is
# currently being displayed, withdraw it.  If the window is not
# currently being displayed, map it (i.e. display it).
#
TopLevelWindow instproc toggle {} {
	$self build_window
	$self instvar path_
	set w $path_
	$self instvar __mappedBefore__
	if { [winfo ismapped $w] } {
		wm withdraw $w
		return
	} elseif ![info exists __mappedBefore__] {
		set __mappedBefore__ 1
		wm transient $w .
		update idletasks
		set x [winfo rootx .]
		set y [winfo rooty .]
		incr y [winfo height .]
		incr y -[winfo reqheight $w]
		incr y -20
 		# adjust for virtual desktops
		incr x [winfo vrootx .]
		incr y [winfo vrooty .]
		if { $y < 0 } { set y 0 }
		if { $x < 0 } {
			set x 0
		} else {
			set right [expr [winfo screenwidth .] - \
					[winfo reqwidth $w]]
			if { $x > $right } {
				set x $right
			}
		}
		wm geometry $w +$x+$y
	}
	wm deiconify $w
}

#
# Instantiate, but do not yet display or iconify, a toplevel using
# the provided widgetpath, <i>w</i>.  Also label this window and its icon
# with the provided <i>title</i>.
#
TopLevelWindow instproc create-window { w title } {
	Application toplevel $w
	set title "[$self get_option iconPrefix] $title"
	wm transient $w .
	wm title $w $title
	wm iconname $w $title
	bind $w <Enter> "focus $w"
	wm withdraw $w
}

#
# A toggle-able toplevel window for displaying bulleted text-items.
#
Class HelpWindow -superclass TopLevelWindow

#
# Instantiate, but do not yet display or iconify, a toplevel window using the
# provided widgetpath, <i>w</i>.  Within <i>w</i>, create a bulleted
# message for each member of the <i>items</i> list, which should be a
# series of quoted chunks of text.  Include a "Dismiss" button to unmap
# this window.  Also label this window and its icon with the provided
# <i>title</i>.
#
HelpWindow instproc create-window { w title items } {
	$self next $w $title
	frame $w.frame -borderwidth 0 -relief flat
	set p $w.frame
	set n 0
	foreach m $items {
		set h $w.h$n
		incr n
		frame $h
		$self helpitem $h $m
		pack $h -expand 1 -fill both
	}
	button $w.frame.ok -text " Dismiss " -borderwidth 2 -relief raised \
		-command "wm withdraw $w" -font [$self get_option medfont]
	pack $w.frame.ok -pady 6 -padx 6 -anchor e
	pack $w.frame -expand 1 -fill both
        wm protocol $w WM_DELETE_WINDOW "wm withdraw $w"
}

#
# Within the provided widget, <i>w</i>, display a bulleted tk-message
# widget containing the provided <i>text</i>. <br> The options database
# must define helpFont before invoking this method.
#
HelpWindow instproc helpitem { w text } {
	set f [$self get_option helpFont]
	canvas $w.bullet -width 12 -height 12
	$w.bullet create oval 6 3 12 9 -fill black
	message $w.msg -justify left -anchor w -font $f -width 450 -text $text
	pack $w.bullet -side left -anchor ne -pady 5
	pack $w.msg -side left -expand 1 -fill x -anchor nw
}

#
# A toplevel window at ".dialog" for presenting the user with an error message.
#
Class ErrorWindow -superclass TopLevelWindow
#FIXME

#
# Creates a toplevel window that displays the <i>text</i> error message.
# The window includes an "OK" button that must be selected before
# continuing execution. <br>
# The options database must include medfont before this method is invoked.
#
ErrorWindow public init text {
	set w .dialog
	$self next $w
	catch "destroy $w"
	#FIXME
	global V
	set applname [Application name]
	if { $applname == "" } {
		set applname "mash shell"
	}
	$self create-window $w "$applname error"

	label $w.label -text "$applname: $text" -font [$self get_option medfont] \
		-borderwidth 2 -relief groove
	button $w.button -text OK -command "$self destroy" \
			-font [$self get_option medfont]
	pack $w.label -expand 1 -fill x -ipadx 4 -ipady 4
	pack $w.button -pady 4

	wm withdraw $w
	update idletasks
	set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
		- [winfo vrootx [winfo parent $w]]]
	set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
		- [winfo vrooty [winfo parent $w]]]
	wm geom $w +$x+$y
	wm deiconify $w

	bind $w <Enter> "focus $w"
	tkwait window .dialog
}

#
Class CheckButton

#
CheckButton public init { w args } {
	$self instvar var_ path_
	set path_ $w
	set var_ [TclObject getid]
	eval checkbutton $w -variable $var_ $args
}

#
CheckButton instproc get_val {} {
	$self instvar var_
	global $var_
	return [set $var_]
}

#
CheckButton instproc set_val v {
	$self instvar var_
	global $var_
	set $var_ $v
}

# backward compat
CheckButton instproc set-val v { $self set_val $v }
# backward compat
CheckButton instproc get-val {} { $self get_val }

#
# pass undefined methods to tk widget
#
CheckButton instproc unknown args {
	$self instvar path_
	eval $path_ $args
}


#
Class RadioButtonsObj

#
RadioButtonsObj public init { w labelsList args } {
    $self instvar var_ path_ numButtons_
    set path_ $w
    set var_ [TclObject getid]
    set c 0
    #set labelsList [lindex $labelsList 0]
    foreach i $labelsList {
	eval radiobutton $w.rb$c -variable $var_ $args
	$w.rb$c configure -text [list $i]
	$w.rb$c configure -value [list $i]
	pack $w.rb$c -in $w -anchor w
	incr c
    }
    set numButtons_ $c
}

#
RadioButtonsObj public get_val {} {
    $self instvar var_
    global $var_
    return [set $var_]
}

#
RadioButtonsObj public set_val {v} {
    $self instvar var_
    global $var_
    set $var_ $v
}

#
RadioButtonsObj private unknown args {
    $self instvar path_ numButtons_
    for {set i 0} {$i < $numButtons_} {incr i} {
	eval $path_.rb$i $args
    }
}

#
Class ScaleObj

#
ScaleObj public init { w args } {
    $self instvar var_ path_
    set path_ $w
    set var_ [TclObject getid]
    eval scale $w -variable $var_ $args
}

#
ScaleObj public get_val {} {
    $self instvar var_
    global $var_
    return [set $var_]
}

#
ScaleObj public set_val {v} {
    $self instvar var_
    global $var_
    set $var_ $v
}

#
ScaleObj private unknown args {
    $self instvar path_
    eval $path_ $args
}

#
Class EntryObj

#
EntryObj public init { w args } {
    $self instvar var_ path_
    set path_ $w
    set var_ [TclObject getid]
    eval entry $w -textvariable $var_ $args
}

#
EntryObj public get_val {} {
    $self instvar var_
    global $var_
    return [set $var_]
}

#
EntryObj private unknown args {
    $self instvar path_
    eval $path_ $args
}
