# timer.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import Timer/Adaptive

#
# A binary exponential backoff timer.
#
Class Timer/Adaptive/Backoff -superclass Timer/Adaptive

#
# The binary exponential backoff timer constructor. The arguments
# <i>c1</i>, <i>c2</i> and <d> control the backoff like this:
# [c1*d, (c1+c2)*d].
#
Timer/Adaptive/Backoff public init { c1 c2 d app } {
	$self instvar c1_ c2_ d_ app_ i_

	set c1_ $c1
	set c2_ $c2
	set d_ $d
	set app_ $app
	set i_ 0

	$self next
	$self start
}

#
# Do a binary exponential backoff of the current timer value.
#
Timer/Adaptive/Backoff private adapt { interval } {
	$self instvar id_ c1_ c2_ d_ i_

	set t [expr pow(2,$i_) * ([random]/double(0x7fffffff) * ($c2_*$d_) + ($c1_*$d_))]
	incr i_

	return $t
}

#
# Called when need to backoff the current timer.
#
Timer/Adaptive/Backoff public backoff { } {
	$self instvar i_

	# schedule the next backoff, and start implicitly call cancel
	# if required
	incr i_
	$self start
}

#
# A url get timer which is backoff exponentially.
#
Class URL_Get_Timer -superclass Timer/Adaptive/Backoff

#
# The url get timer constructor.
#
URL_Get_Timer public init { url c1 c2 d app } {
	$self instvar url_
	set url_ $url

	$self next $c1 $c2 $d $app
}

#
# Called when the timer timeouts. This first does a callback
# to the web cache control so it can notify other caches that
# it has won the get timer war, and then backoff the get timer.
#
URL_Get_Timer public timeout { } {
	$self instvar url_ app_

	# do a callback to the application
	$app_ send_announcement WC_URL_GET $url_
}

#
# A url response timer which is backoff exponentially.
#
Class URL_Resp_Timer -superclass Timer/Adaptive/Backoff

#
# The url response timer constructor.
#
URL_Resp_Timer public init { url c1 c2 d app } {
	$self instvar url_
	set url_ $url

	$self next $c1 $c2 $d $app
}

URL_Resp_Timer public destroy { } {
	$self instvar url_
	#puts "destroy URL_Resp_Timer $url_ $self"
	$self next
}

#
# Called when the timer timeouts. This does a callback to
# the web cache control so it can notify other caches that
# it is going to send the contents of the url to the session.
#
URL_Resp_Timer public timeout { } {
	$self instvar url_ app_

	# puts "control: win_resp_timer $url_ $self"

	# send out the data or do a HTTP request to the origin server
	$app_ win_resp_timer $url_
}

