# main.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Auxiliary files
source tcl/common/application.tcl
source tcl/common/dbg-err.tcl
source tcl/srm/cf-srm.tcl
source tcl/mb/debug.tcl
source tcl/mb/utils.tcl

# generic ato files
source tcl/atobj/application-atp.tcl
source tcl/atobj/anm-view.tcl
source tcl/atobj/datasrc.tcl
source tcl/atobj/datasrc-local.tcl
source tcl/atobj/anm-obj.tcl
source tcl/atobj/atobj-rcvr.tcl
source tcl/atobj/atobj-sm.tcl

# nam files
source tcl/atobj/anm-view-nam.tcl
source tcl/atobj/datasrc-nam.tcl
source tcl/atobj/nam-edge.tcl
source tcl/atobj/nam-node.tcl
source tcl/atobj/nam-pkt.tcl
source tcl/atobj/nam-network.tcl
source tcl/atobj/nam-ui.tcl

proc DbgOut { args } {
        # return

        upvar self slf
        global mb
        if ![info exists slf] {
                puts $args
        } else {
                set class [$slf info class]
                if {[eval $class info vars nodbg_]!=""} {
                        return
                }
                puts "[$slf info class] $slf: $args"
        }
}

# classes with nodbg_ set will not display debug information
#
AnmView/Nam set nodbg_ 1
DataSrc/Local/Nam set nodbg_ 1
NamUI set nodbg_ 1
DataSrc/Nam set nodbg_ 1

proc DbgVar {args} {
        upvar self slf

        foreach v $args {
                upvar $v var
                if ![info exists slf] {
                        puts [concat $v "=" $var]
                } else {
                        set class [$slf info class]
                        if {[eval $class info vars nodbg_]!=""} {
                                return
                        }
                        if [info exists var] {
                                puts "[$slf info class]|$slf: $v=$var"
                        } else {
                                puts "[$slf info class]|$slf: $v not found!"
                        }
                }
        }
}

proc DbgAssert { bool } {
        if {!$bool} {
                puts "assert failed!"
                error "Assert failed!"
        }
}

proc main {argv} {
        new ATP $argv
}

main $argv

