# al-gw.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/as/al-gw.tcl,v 1.9 2002/02/03 04:25:20 lim Exp $


import AnnounceListenManager/AS

#
Class AnnounceListenManager/AS/Service -superclass AnnounceListenManager/AS

AnnounceListenManager/AS/Service instproc init { agent spec bw sspec } {
	$self next $spec $bw srv
	$self set srv_inst_ $sspec
	$self set agent_ $agent
}

AnnounceListenManager/AS/Service instproc recv_msg { atype aspec addr \
	        srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar agent_ srv_inst_

	if { $srv_inst != $srv_inst_ } {
		return
	}
	if { $atype == "client" } {
		$self send_announcement
	} else {
		# Duplicate server announcement.
		if { [string compare $aspec [$self agent_instance]] < 0 } {
			puts stderr "duplicate gateway at $addr - exiting."
			$self announce_death
			exit 0
		}
	}
}

AnnounceListenManager/AS/Service instproc register { atype aspec addr \
	        srv_name srv_inst msg } {}

AnnounceListenManager/AS/Service instproc unregister { atype aspec addr \
	        srv_name srv_inst msg } {
	$self instvar agentbytype_ srv_inst_ agenttab_

	# If we are alive and a client with a different SID died --
	# no need to check.
	if { $atype != "client" || $srv_inst != $srv_inst_ } {
		return
	}
	foreach aspec $agentbytype_(client) {
		set sid [lindex $agenttab_($aspec) 4]
		if { $sid == $srv_inst_ } {
			# Still have a client
			return
		}
	}
	# No clients with our SID, exit
	puts stderr "no more clients -- exiting"
	exit 0
}

AnnounceListenManager/AS/Service instproc service_instance {} {
	$self instvar srv_inst_
	return $srv_inst_
}

