/*
 * rreq-srmv2.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "srmv2.h"
#include "rreq-srmv2.h"

SRMv2_RReq::SRMv2_RReq(unsigned int ss, unsigned int es, unsigned int cid,
		   unsigned int sbytes, unsigned int ebytes) :
	Timer(), ss_(ss), es_(es), sbytes_(sbytes),
	ebytes_(ebytes), cid_(cid)
{ }

SRMv2_RReq::~SRMv2_RReq()
{
	printf("cancelling (%d %d %d)\n", cid_, sbytes_, ebytes_);
	cancel();
}

void
SRMv2_RReq::sched_timeout(int ms, SRMv2_Session *session, SRMv2_Source *src)
{
	msec_ = ms;
	if (session)
		session_ = session;
	source_ = src;
	printf("[sched_timeo] : %dms (%d %d %d %d %d)\n", msec_, cid_, ss_, es_, sbytes_, ebytes_);
	msched(ms);
}


void
SRMv2_RReq::timeout()
{
	/* Change this to traverse the list and stack RREQs */
//	for (int i = 0; i < 4; i ++)
//		printf("%d ", source_->source_id(i));
	printf("S: %dms %d %d %d %d %d\n", msec_, cid_, ss_, es_, sbytes_, ebytes_);
	session_->send_rreq(source_, ss_, es_, sbytes_, ebytes_, cid_);
	msec_ *= 2; // Exponential backoff
	sched_timeout(msec_, 0, source_);
}

