/*
 * smash-main.cc --
 *
 *      This is the main entry point for the smash shell.
 *      Execution starts here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/smash-main.cc,v 1.10 2002/02/10 03:02:28 lim Exp $
 */


#include <tcl.h>
#include <tclcl.h>
#include "rate-variable.h"
#include "mash-init.h"
#ifdef HAVE_SRMV2_API_H
#include "srmv2-api.h"
#endif
#ifdef HAVE_JPEGWC_H
#include "jpegwc.h"
#endif

#ifdef __PSVP_ENABLED__
extern int Psvp_Init(Tcl_Interp *interp);
#endif

#if defined(WIN32) && !defined(NDEBUG)
#   include <crtdbg.h>
#endif

/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tk_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

int
main(int argc, char** argv)
{
#if defined(WIN32) && !defined(NDEBUG)
    /*
     * Turn on automatic leak checking for Windows debug builds.
     */
    int debugFlag;
    debugFlag = _CrtSetDbgFlag(_CRTDBG_REPORT_FLAG);
    debugFlag |= _CRTDBG_CHECK_CRT_DF;
    debugFlag |= _CRTDBG_LEAK_CHECK_DF;
    _CrtSetDbgFlag(debugFlag);
#endif

    Tcl_Main(argc, argv, Smash_AppInit);
    return 0;
}


int
Smash_AppInit(Tcl_Interp *interp)
{
        /*
         * Tcl_Init is commented out because they also commented out Tcl_Init
         * in Mash_AppInit.  It doesn't seem to hurt because Tcl_Init doesn't
         * really do much.  If you don't call Tcl_Init, users can move smash to
         * any directory without getting the "Can't find a usable init.tcl"
         * error message.  This feature is nice, but not calling Tcl_Init seems
         * questionable.  We may need to revisit this decision in the future.
         *   --LL
         */

	Tcl_SetVar(interp, "tcl_library", "./lib/tcl8.3", TCL_GLOBAL_ONLY);
#if 0
	if (Tcl_Init(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Tcl_Init failed!");
		return TCL_ERROR;
	}
#endif
	if (Otcl_Init(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Otcl_Init failed!");
		return TCL_ERROR;
	}

	if (Mash_TclInit(interp) == TCL_ERROR) {
		WIN32_OutputErr(interp, "Mash_TclInit failed!");
		return TCL_ERROR;
	}

	/* FIXME: must move this to Mash_TclInit once we get rid of the
	 * Tcl-only files from et_tk
	 */
//#ifdef notdef
	extern EmbeddedTcl et_tcl;
	et_tcl.load();
//#endif

	return TCL_OK;
}
