/*
 * mb.h --
 *
 *      main header file for MediaBoard
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /usr/mash/src/repository/mash/mash-1/mb/mb.h,v 1.19 2002/02/03 03:16:30 lim Exp $
 */

#ifndef MASH_MB_H
#define MASH_MB_H

#ifdef WIN32
#include <windows.h>
#endif

//
// Common routines
//
extern "C"
{
#ifndef MASH_ASSERT_H
#define MASH_ASSERT_H
#include <assert.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <tk.h>
};

#include "tclcl.h"
#include "mb/error.h"
#include "misc/str.h"
#include "srm/srm.h"
#include "misc/all-types.h"
#include "misc/mtrace.h"

//
// MediaBoard wide variable declarations
//
typedef unsigned long int ulong;
typedef unsigned long int n_long;

typedef int RetCode;

typedef double Coord;


//typedef unsigned char Byte;

typedef struct Point_s {
	Coord x;
	Coord y;
} Point;

inline Bool operator==(const Point& p1, const Point& p2) {
	return ((p1.x==p2.x) && (p1.y==p2.y));
}
inline Bool operator!=(const Point& p1, const Point& p2) {
	return !(p1==p2);
}

typedef srm_src SrcId;

class PageId {
public:
	PageId() : sid(), uid(0) { }
	int operator==(const PageId& right) const
		{ return (sid==right.sid) && (uid==right.uid); }
	int operator!=(const PageId& right) const
		{ return !operator==(right); }
	// data
	SrcId sid;				// source ID
	n_long uid;				// locally unique ID
};
extern const PageId cNullPageId;

// length for the string representation of l
#define SLEN(l) sizeof(#l)+1

// maximum number of characters in a string that rep. an integer
// add 1 for allowance since unsigned could be twice as large
#define MAX_N_LONG_CHAR (SLEN(LONG_MAX)+2)
#define MAX_INT_CHAR (SLEN(INT_MAX)+2)

#define OFFSET Tk_Offset

// a cast with reference
#define REFCAST(type,var) (*(type*)&(var))

// convenience macros dealing with Tcl
#define MB_Interp (Tcl::instance().interp())
#define MB_DefTcl(x) Tcl& x=Tcl::instance()

// command execution return codes
#define MB_EXE_OK TCL_OK
#define MB_EXE_ERROR TCL_ERROR

// disable the asserts if MB_DEBUG is not defined; enable logging if MB_DEBUG
// is defined
#ifdef MB_DEBUG
#define MB_USE_LOG
/*#else
#ifndef NDEBUG
#define NDEBUG
#endif*/
#endif // MB_DEBUG

#ifdef MB_USE_LOG

extern MLogObject* mbLog;
#define MB_DECLARE_LOG(v);                     \
	MLogObject* v=NULL;

#define INIT_LOG(uid)                         \
	if (mbLog==NULL) mbLog = new MLogObject( (uid_t) uid);

#define MBLOG(str) \
	if (mbLog!=NULL) mbLog->print str;

#define END_LOG()                              \
	delete mbLog;

#else /* !MB_USE_LOG */

#define MB_DECLARE_LOG(v)
#define INIT_LOG(uid)
#define END_LOG()
#define MBLOG(str)

#endif /* !MB_USE_LOG */

#include "mb-time.h"

extern XColor *MB_GetColorByValue(XColor *clr);
extern void MB_FreeColor(XColor *clr);
extern char *MB_NameOfFont(Tk_Font tkfont);
extern Tk_Font MB_GetFont(const char *string);
extern void MB_FreeFont(Tk_Font tkfont);

#endif /* MASH_MB_H */
