/*
 * mb-basecmd.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/mb-basecmd.cc,v 1.10 2002/02/03 03:16:30 lim Exp $
 */

#include "mb/mb-obj.h"
#include "mb/mb-cmd.h"


/*static*/
MBCmd*
MBCmd::Create(ulong seqno, Byte* pb)
{
    Pkt_CmdHdr* pHdr = (Pkt_CmdHdr*)pb;
    MBCmdType cmdType = (MBCmdType)net2host(pHdr->dh_type);
    MBCmd* pNewCmd = NULL;

    switch (cmdType) {
    case CCreateItem:
        pNewCmd = new MBCmdCreate();
        break;
    case CPgName:
        pNewCmd = new MBCmdPgName();
        break;
#ifdef OLD
    case CCoord:
        pNewCmd = new MBCmdCoord();
        break;
#endif
    case CGroup:
        pNewCmd = MBCmdGroup::Create((Byte*)(pHdr+1));
        break;
    case CDel:
        pNewCmd = new MBCmdDel();
        break;
    case CMove:
        pNewCmd = new MBCmdMove();
        break;
    case CDup:
        pNewCmd = new MBCmdDup();
        break;
    case CChar:
        pNewCmd = new MBCmdChar();
        break;
    case CFrag:
        pNewCmd = new MBCmdFrag();
        break;
    case CInvalid:
    default:
        disperr("Attempting to create invalid command!");
       return NULL;
    }
    assert(cmdType==pNewCmd->cmdType_);
    pNewCmd->seqno_ = seqno;
    pNewCmd->timestamp_ = net2host(pHdr->dh_ts);

    pNewCmd->Extract((Byte*)(pHdr+1));
    return pNewCmd;
}

Byte*
MBCmd::Packetize(Byte* pb)
{
    Pkt_CmdHdr* pHdr = (Pkt_CmdHdr*) pb;
    pHdr->dh_ts = host2net(timestamp_);
    // use the virtual function to calculate total length
    pHdr->dh_len = host2net(getPacketLen());
    pHdr->dh_flags = 0;         // nothing for now
    pHdr->dh_type = host2net((u_char)cmdType_);
    return (Byte*) (pHdr+1);
}


Byte*
MBCmdCreate::Extract(Byte* pb)
{
    Pkt_CmdCreate *pRaw = (Pkt_CmdCreate *) pb;
    PageItemType itemType = (PageItemType)net2host(pRaw->itemType);
    assert(pItem_==NULL);
    pItem_ = PageItem::create(itemType, TRUE, (Byte*)(pRaw+1));
    return (Byte*)NULL;                // return value is not needed
}


Byte*
MBCmdCreate::Packetize(Byte* pb)
{
    Byte* pbCurr = MBCmd::Packetize(pb);

    Pkt_CmdCreate *pRaw = (Pkt_CmdCreate*) pbCurr;
    pRaw->itemType = host2net((u_int)pItem_->getType());
    assert(pItem_!=0);
    return (pItem_->packetize(TRUE, (Byte*)(pRaw+1) ));
}


//
// Returns 0 if it is completed, otherwise return the first dependency
//
n_long
MBCmdGroup::Incomplete(MBPageObject* pPage) const
{
    assert(snEnd_!=getSeqno());
    for (ulong seq=snStart_; seq <= snEnd_; ++seq) {
        MBCmd *pCmd = pPage->getCmd(seq);
        if (!pCmd) return seq;
        ulong cseq = pCmd->Incomplete(pPage);
        if (cseq) return cseq;
    }
    return 0;
}


MBCmdGroup*
MBCmdGroup::Create(n_long timestamp, PageItemType groupType,
		   n_long snStart, n_long snEnd, PageItem *pItem,
		   int argc/*=0*/, const char*const* argv/*=NULL*/)
{
    switch (groupType)     {

    case PgItemMLine:
        return new MBCmdMLine(timestamp,groupType,snStart,snEnd,pItem);
    case PgItemText:
        return new MBCmdText(timestamp,groupType,snStart,snEnd,pItem);
    case PgItemImage:
        return new MBCmdImage(timestamp,snStart,snEnd,pItem,argc,argv);
    case PgItemPS:
        return new MBCmdPS(timestamp,snStart,snEnd,pItem);
    default:
        assert(FALSE);
    }
    return NULL;
}


/*static*/
MBCmdGroup*
MBCmdGroup::Create(Byte* pb)
{
    Pkt_CmdGroup *pRaw = (Pkt_CmdGroup *) pb;
    PageItemType groupType = (PageItemType)net2host(pRaw->groupType);
    switch (groupType) {

    case PgItemMLine:
        return new MBCmdMLine();
    case PgItemText:
        return new MBCmdText();
    case PgItemImage:
        return new MBCmdImage();
    case PgItemPS:
        return new MBCmdPS();

    default:
        assert(FALSE);
        return NULL;
    }
    return NULL;
}


Byte*
MBCmdGroup::Extract(Byte* pb)
{
    Pkt_CmdGroup *pPkt = (Pkt_CmdGroup *) pb;
    snStart_   = net2host(pPkt->snStart);
    snEnd_     = net2host(pPkt->snEnd);
    groupType_ = (PageItemType)net2host(pPkt->groupType);
    assert(!pItem_);
#ifdef OLD
    pItem_ = PageItem::Create(groupType_, FALSE, (Byte*)(pPkt+1) );
#endif // OLD
    return (Byte*)(pPkt+1);
}


/* virtual */
Byte*
MBCmdGroup::Packetize(Byte* pb)
{
    Byte* pbCurr = MBCmd::Packetize(pb);

    Pkt_CmdGroup *pRaw = (Pkt_CmdGroup*) pbCurr;
    pRaw->groupType = host2net((u_int16_t)groupType_);
    pRaw->snStart  = host2net(snStart_);
    pRaw->snEnd  = host2net(snEnd_);
#ifdef OLD
    assert(pItem_!=0);
    return (pItem_->Packetize(FALSE, (Byte*)(pRaw+1) ));
#endif // OLD
    return (Byte*)(pRaw+1);
}


//
// Returns 0 if it is completed, or the first item that we depend on
//

/* virtual */
n_long
MBCmdChar::Incomplete(MBPageObject* pPage) const
{
    MBCmd *pCmd=NULL;
    // only depends on the targetItem_
    if (!(pCmd=pPage->getCmd(targetItem_)))
        return targetItem_;
    return pCmd->Incomplete(pPage);
}


//
// MBCmdMove member functions
//
///////////

Bool
MBCmdMove::Apply(PageItem* pItem)
{
    Point* aPoints=pItem->getPoints();
    for (Point* pPoint=aPoints;
         pPoint<aPoints+(pItem->getNumPoints()); pPoint++) {
        (pPoint->x)+=dx_;
        (pPoint->y)+=dy_;
    }
//    pItem->SetPoints(aPoints, pItem->getNumPoints());
    return TRUE;
}


//
// Returns 0 if it is completed, or the first item that we depend on
//
/* virtual */
n_long
MBCmdMove::Incomplete(MBPageObject* pPage) const
{
    MBCmd *pCmd=NULL;
    // only depends on the targetItem_
    if (!(pCmd=pPage->getCmd(targetId_)))
        return targetId_;
    return pCmd->Incomplete(pPage);
}

// packetization
Byte*
MBCmdMove::Extract(Byte* pb) {
    Pkt_CmdMove *pPkt = (Pkt_CmdMove*) pb;
    targetId_ = net2host(pPkt->targetId);
    dx_ = (double)net2host(pPkt->dx);
    dy_ = (double)net2host(pPkt->dy);
    return (Byte*)NULL;                // return value is not needed
}

Byte*
MBCmdMove::Packetize(Byte* pb)
{
    Byte* pbCurr = MBCmd::Packetize(pb);
    Pkt_CmdMove *pPkt = (Pkt_CmdMove*) pbCurr;
    pPkt->targetId = host2net(targetId_);
    pPkt->dx = host2net((float)dx_);
    pPkt->dy = host2net((float)dy_);
    return (Byte*)(pPkt+1);
}


//
// Returns 0 if it is completed, or the first item that we depend on
//
/* virtual */
n_long
MBCmdDup::Incomplete(MBPageObject* pPage) const
{
    // REVIEW: send dependencies? make moves touch all refered items?
    // It is possible for commands inbetween seqno_ and target
    // to move the item,
    // so we have to wait for all inbetween to arrive, to ensure we moved the
    // correct item.
    //
    MBCmd *pCmd=NULL;
    // only depends on the targetItem_
    if (!(pCmd=pPage->getCmd(targetId_)))
        return targetId_;
    ulong id = pCmd->Incomplete(pPage);
    return id;

        // solve this later
    ulong topReceived = pPage->getTopReceived();
    if (topReceived>targetId_ && topReceived<getSeqno()) {
        return topReceived+1;
    }
    // worth it to check the gap?
    else return topReceived+1;

    return 0;
}

// packetization
Byte*
MBCmdDup::Extract(Byte* pb) {
    Pkt_CmdDup *pPkt = (Pkt_CmdDup*) pb;
    targetId_ = net2host(pPkt->targetId);
    return (Byte*)NULL;                // return value is not needed
}


Byte*
MBCmdDup::Packetize(Byte* pb)
{
    Byte* pbCurr = MBCmd::Packetize(pb);
    Pkt_CmdDup *pPkt = (Pkt_CmdDup*) pbCurr;
    pPkt->targetId = host2net(targetId_);
    return (Byte*)(pPkt+1);
}


//
// Returns 0 if it is completed, or the first item that we depend on
//
/* virtual */
n_long MBCmdDel::Incomplete(MBPageObject* pPage) const
{
    MBCmd *pCmd=NULL;
    // only depends on the targetItem_
    if (!(pCmd=pPage->getCmd(itemId_)))
        return itemId_;
    return pCmd->Incomplete(pPage);
}


// packetization
Byte*
MBCmdDel::Extract(Byte* pb) {
    Pkt_CmdDel *pPkt = (Pkt_CmdDel*) pb;
    itemId_ = net2host(pPkt->itemId);
    return (Byte*)NULL;                // return value is not needed
}


Byte*
MBCmdDel::Packetize(Byte* pb)
{
    Byte* pbCurr = MBCmd::Packetize(pb);
    Pkt_CmdDel *pPkt = (Pkt_CmdDel*) pbCurr;
    pPkt->itemId = host2net(itemId_);
    return (Byte*)(pPkt+1);
}


// packetization
Byte*
MBCmdPgName::Extract(Byte* pb) {
    Pkt_CmdPgName *pPkt = (Pkt_CmdPgName*) pb;
    delete[] szPgName_;
    ::AllocNNCopy(&szPgName_, pPkt->achName, net2host(pPkt->nameLen));
    return (Byte*)NULL;                // return value is not needed
}


Byte*
MBCmdPgName::Packetize(Byte* pb)
{
    Byte* pbCurr = MBCmd::Packetize(pb);
    Pkt_CmdPgName *pPkt = (Pkt_CmdPgName*) pbCurr;
    u_short strl = strlen(szPgName_);
    pPkt->nameLen = host2net(strl);
    strncpy(pPkt->achName, szPgName_, strl);
    return pbCurr + PKT_ROUNDUP(sizeof(Pkt_CmdPgName) + (strl)*sizeof(char));
}


short
MBCmdPgName::getPacketLen()
{
    u_short sz= PKT_ROUNDUP(sizeof(Pkt_CmdPgName)+strlen(szPgName_));
    return (sz+MBCmd::getPacketLen());
}

const char* achCmdNames[] = {
    "Nop",
    "CreateItem",                // 1 MBCmdCreate
    "Group",                     // 2 MBCmdGroup
    "Del",                       // 3 MBCmdDel
    "Coord",                     // 4 MBCmdCoord
    "Move",                      // 5 MBCmdMove
    "Dup",                       // 6 MBCmdDup
    "PgName",                    // 7 MBCmdPgName
    "Char",                      // 8 MBCmdChar
    "Invalid"                    // 9 *invalid*, used as stopper
};

#ifdef MB_DEBUG
void MBCmd::DumpTS(Tcl_Obj* pObj)
{
    assert(this);
    char szStr[200];
    sprintf(szStr, "%lx: sn=%lu cmd=%s ts=%lu\n",
	    (unsigned long) this, seqno_, achCmdNames[cmdType_], timestamp_);
    Tcl_AppendToObj(pObj, szStr, -1);
}
#endif // MB_DEBUG

