/*
 * rtp-play.h --
 *
 *      RTP Play header file
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MASH_RTP_PLAY_H
#define MASH_RTP_PLAY_H


#include "archive/archive-stream.h"
#include <tclcl.h>
#include "net/pktbuf.h"
#include "archive/rtp-archive.h"
#include "rtp/session-rtp.h"
#include "archive/rtp-session-play.h"
#include "misc/observe.h"

class Source;
class Network;



#define MTU (2048-32)





class RTPPlayRcvr : public PacketModule, public Observer {
public:
	virtual void recv(pktbuf* pb) { pb->release(); }
};

class RTPPlaybackStream : public PlaybackStream {
public:
	RTPPlaybackStream();
	virtual ~RTPPlaybackStream ();

	virtual void Clip(timeval start, timeval end);
	virtual void LTS_Speed();
	virtual void LTS_Reference();

	// obtain the timeout value for the next event
	// returns: FALSE when I'm done
	virtual int  NextEvent(timeval &logical);
	virtual void DoEvent(); // do the next event
	int attach_agent(int argc, const char * const *argv);
	int buffer_pool(int argc, const char * const *argv);
	int header_info(int argc, const char * const *argv);



protected:
	u_int32_t startTS_;
	u_int32_t endTS_;
	Network* dnet_;
	Network* cnet_;
        RTPPacket* free_;
	int eof_;
	int skipctrl_;
	double converter_;
	RTPprivatehdr phdr_;
	FileHeader hdr_;
	Bool firstTime_;
	BufferPool* bufferPool_;
	u_int cs_;
	u_int firstseq_;
	RTPPacket* p_;
	RTPPacket* lastp_;
	RTPPlaySession* agent_;
	double lastNotify_;

	void EmptyBuffs();
	void IterateIndex(int real_endpos);
	int SeekTime(timeval goal);
	RTPPacket* getpkt(u_int its);
	u_int ts() const;
	inline u_int first_seq() {return (firstseq_);}
	void addpacket(RTPPacket *p, u_int ts, u_int seqno);
	int  nextpkt(RTPPacket* p);
	int  fillone();
	void fill();
	void free(RTPPacket* p);
	int IsDone();
	RTPPacket* allocate();

};


#endif
