#!/usr/bin/perl

# sample program that demonstrates how to write the CDRs to a log file
# and also send the CDR data to a radius server
# modified script by Patrick <patrick@dmv.com>

use Net::Radius::Dictionary;
use Net::Radius::Packet;
use Net::Gen qw(:af);
use Net::Inet qw(:routines);
use Net::UDP;
use Net::TCP;
use Fcntl;
use POSIX qw(uname);
use strict;


my $logfile = "/var/log/gk/cdr.log";
my $gk_host = "localhost";
my $gk_port = 7000;
my $gk_pid;

# details of RADIUS authentication and accounting servers
my $accthost = "my.radius.server.com";
my $acctport = 1813;
my $secret = "mysecret";  # Shared secret for this client

# Parse the RADIUS dictionary file (must have dictionary in current dir)
my $dict = new Net::Radius::Dictionary "/etc/raddb/dictionary"
        or die "Couldn't read dictionary: $!";

# discover my own IP address
my $myip = join '.',unpack "C4",gethostbyname((uname)[1]);

# subroutine to make string of 16 random bytes
sub bigrand() {
        pack "n8",
                rand(65536), rand(65536), rand(65536), rand(65536),
                rand(65536), rand(65536), rand(65536), rand(65536);
}

my ($acctaddr, $paddr);
my ($req, $resp);

$paddr = gethostbyname($accthost) or die "Can't resolve host $accthost\n";
$acctaddr = pack_sockaddr_in(AF_INET, $acctport, $paddr);


if ($gk_pid = fork()) {
        # parent will listen to gatekeeper status
        sleep(1);       # wait for gk to start
        my $sock = Net::TCP->new($gk_host, $gk_port) or die $!;

        if (!defined $sock) {
                die "Can't connect to gatekeeper at $gk_host:$gk_port";
        }
	# pass HUP to gatekeeper
        $SIG{HUP} = sub { kill 1, $gk_pid; };
	# close file when terminated
        $SIG{INT} = sub { close (CDRFILE); $sock->close; kill 9, $gk_pid; };

        open (CDRFILE, ">>$logfile");
        CDRFILE->autoflush(1);  # don't buffer output
        while (!$sock->eof()) {
                my $msg = $sock->getline();
                $msg = (split(/;/, $msg))[0];   # remove junk at end of line
                my $msgtype = (split(/\|/, $msg))[0];
                if ($msgtype eq "CDR") {
                        print CDRFILE "$msg\n";

			# Set up the network socket
			my $s = new Net::UDP or die $!;

			my @radtemp=split(/\|/, $msg);
			my $user = (split(/\:/, $radtemp[11]))[0];
			my $calledstation = (split(/\:/, $radtemp[10]))[0];
			my $callingstation = (split(/\:/, $radtemp[6]))[0];
			$req = new Net::Radius::Packet $dict;
			$req->set_code('Accounting-Request');
			$req->set_attr('Acct-Status-Type', 'Stop');
			$req->set_attr('Acct-Session-Id' => $radtemp[2]);
			$req->set_attr('NAS-Identifier' => 'GnuGK');
			$req->set_attr('NAS-Port' => $radtemp[1]);
			$req->set_attr('NAS-IP-Address' => $myip);
			$req->set_attr('Calling-Station-Id' => $user);
			$req->set_attr('Called-Station-Id' => $calledstation);
			$req->set_attr('Acct-Terminate-Cause', 'User-Request');
			$req->set_attr('Acct-Session-Time', $radtemp[3]);
			$req->set_attr('Framed-IP-Address', $callingstation);

			$s->sendto(auth_resp($req->pack,$secret), $acctaddr);

                }
        }
        close (CDRFILE);
        $sock->close;
	kill 9, $gk_pid;
} else {
        # child starts gatekeeper
        exec("/usr/sbin/gnugk -c /etc/gnugk.ini -ttttt -o /var/log/gk/gk.log");
}

