; -- OpenCV script for Inno Setup 2.0 Installer --

[Setup]
AppName=Intel(R) Open Source Computer Vision Library
AppVerName=Intel(R) Open Source Computer Vision Library, beta 3.1
AppCopyright=Copyright (C) 2000-2002 Intel Corporation
DefaultDirName={pf}\OpenCV
DefaultGroupName=OpenCV
UninstallDisplayIcon={app}\apps\CamShiftDemo\res\CamShiftDemo.ico
SourceDir=..
Compression=bzip/9
LicenseFile="docs\license.txt"
OutputBaseFilename=OpenCV_b3.1
; uncomment the following line if you want your installation to run on NT 3.51 too.
; MinVersion=4,3.51

[Dirs]

; workspaces
Name: "{app}\_dsw"

; cv
Name: "{app}\cv"
Name: "{app}\cv\include"
Name: "{app}\cv\src"
Name: "{app}\cv\make"

; cvaux
Name: "{app}\cvaux"
Name: "{app}\cvaux\include"
Name: "{app}\cvaux\src"
Name: "{app}\cvaux\make"

; otherlibs
Name: "{app}\otherlibs"
Name: "{app}\otherlibs\_graphics"
Name: "{app}\otherlibs\_graphics\include"
Name: "{app}\otherlibs\_graphics\lib"
Name: "{app}\otherlibs\_fltk"
Name: "{app}\otherlibs\_fltk\include"
Name: "{app}\otherlibs\_fltk\lib"
Name: "{app}\otherlibs\highgui"
Name: "{app}\otherlibs\cvcam"
Name: "{app}\otherlibs\cvcam\include"
Name: "{app}\otherlibs\cvcam\make_win"
Name: "{app}\otherlibs\cvcam\src"
Name: "{app}\otherlibs\cvcam\src\windows"
Name: "{app}\otherlibs\cvcam\src\unix"

; interfaces
Name: "{app}\interfaces"
Name: "{app}\interfaces\ch"
Name: "{app}\interfaces\ch\Devel"
Name: "{app}\interfaces\ch\Devel\include"
Name: "{app}\interfaces\ch\Devel\createchf"
Name: "{app}\interfaces\ch\Devel\c"
Name: "{app}\interfaces\ch\Devel\c\cv"
Name: "{app}\interfaces\ch\Devel\c\highgui"
Name: "{app}\interfaces\ch\Devel\lib.handmade"
Name: "{app}\interfaces\ch\OpenCV"
Name: "{app}\interfaces\ch\OpenCV\bin"
Name: "{app}\interfaces\ch\OpenCV\include"
Name: "{app}\interfaces\ch\OpenCV\lib"
Name: "{app}\interfaces\ch\OpenCV\dl"
Name: "{app}\interfaces\ch\OpenCV\demos"

Name: "{app}\interfaces\matlab"
Name: "{app}\interfaces\matlab\src"
Name: "{app}\interfaces\matlab\toolbox"
Name: "{app}\interfaces\matlab\toolbox\opencv"
Name: "{app}\interfaces\matlab\toolbox\opencv\cvdemos"

; documentation
Name: "{app}\docs"
Name: "{app}\docs\ref"
Name: "{app}\docs\ref\pics"
Name: "{app}\docs\papers"
Name: "{app}\docs\appPage"
Name: "{app}\docs\appPage\3dTracker"
Name: "{app}\docs\appPage\Calibration"
Name: "{app}\docs\appPage\CamShift"
Name: "{app}\docs\appPage\ConDensation"
Name: "{app}\docs\appPage\FaceRecognition"
Name: "{app}\docs\appPage\Kalman"
Name: "{app}\docs\appPage\LKTracker"

; sample code
Name: "{app}\samples"
Name: "{app}\samples\c"

; batch tests
Name: "{app}\tests"
Name: "{app}\tests\trs"
Name: "{app}\tests\trs\include"
Name: "{app}\tests\trs\make"
Name: "{app}\tests\trs\src"
Name: "{app}\tests\cv"
Name: "{app}\tests\cv\src"
Name: "{app}\tests\cv\testdata"
Name: "{app}\tests\cv\testdata\cameracalibration"
Name: "{app}\tests\cv\testdata\drawing"
Name: "{app}\tests\cv\testdata\gesturerecognition"
Name: "{app}\tests\cv\testdata\optflow"
Name: "{app}\tests\cv\testdata\snakes"

; utilities
Name: "{app}\utils"
Name: "{app}\utils\cvinfo"

; direct show filters
Name: "{app}\filters"
Name: "{app}\filters\Kalman"
Name: "{app}\filters\Condens"
Name: "{app}\filters\CamShift"
Name: "{app}\filters\CalibFilter"
Name: "{app}\filters\ProxyTrans"
Name: "{app}\filters\SyncFilter"
Name: "{app}\filters\Tracker3dFilter"
Name: "{app}\filters\Tracker3dFilter\include"
Name: "{app}\filters\Tracker3dFilter\src"
Name: "{app}\filters\Tracker3dFilter\trackers"
Name: "{app}\filters\Tracker3dFilter\trackers\BlobTracker"
Name: "{app}\filters\Tracker3dFilter\trackers\CamShiftTracker"
Name: "{app}\filters\Tracker3dFilter\data"
Name: "{app}\filters\Tracker3dFilter\data\CameraCalibration"
Name: "{app}\filters\Tracker3dFilter\data\Tracking"

; applications
Name: "{app}\apps\"
Name: "{app}\apps\Common"
Name: "{app}\apps\cvcsdemo"
Name: "{app}\apps\cvcsdemo\pictures"
Name: "{app}\apps\cvlkdemo"
Name: "{app}\apps\cvlkdemo\pictures"
Name: "{app}\apps\vmdemotk"
Name: "{app}\apps\vmdemotk\media"
Name: "{app}\apps\CamShiftDemo"
Name: "{app}\apps\CamShiftDemo\res"
Name: "{app}\apps\HMMDemo"
Name: "{app}\apps\HMMDemo\res"
Name: "{app}\apps\HMMDemo\SampleBase"
Name: "{app}\apps\HMMDemo\SampleBase\Sergey.Molinov"
Name: "{app}\apps\HMMDemo\SampleBase\Vadim.Pisarevsky"
Name: "{app}\apps\HMMDemo\SampleBase\Valery.Cherepennikov"
Name: "{app}\apps\HMMDemo\SampleBase\Valery.Mosyagin"
Name: "{app}\apps\HMMDemo\SampleBase\Victor.Eruhimov"
Name: "{app}\apps\LKDemo"
Name: "{app}\apps\LKDemo\res"
Name: "{app}\apps\HaarFaceDetect"
Name: "{app}\apps\HaarFaceDetect\SampleBase"
Name: "{app}\apps\HaarFaceDetect\SampleBase\0"
Name: "{app}\apps\HaarFaceDetect\SampleBase\1"
Name: "{app}\apps\HaarFaceDetect\SampleBase\2"
Name: "{app}\apps\HaarFaceDetect\SampleBase\3"
Name: "{app}\apps\HaarFaceDetect\SampleBase\4"
Name: "{app}\apps\HaarFaceDetect\SampleBase\5"
Name: "{app}\apps\HaarFaceDetect\SampleBase\6"
Name: "{app}\apps\HaarFaceDetect\SampleBase\7"
Name: "{app}\apps\HaarFaceDetect\SampleBase\8"
Name: "{app}\apps\HaarFaceDetect\SampleBase\9"
Name: "{app}\apps\HaarFaceDetect\SampleBase\10"
Name: "{app}\apps\HaarFaceDetect\SampleBase\11"
Name: "{app}\apps\HaarFaceDetect\SampleBase\12"
Name: "{app}\apps\HaarFaceDetect\SampleBase\13"
Name: "{app}\apps\HaarFaceDetect\SampleBase\14"
Name: "{app}\apps\HaarFaceDetect\SampleBase\15"
Name: "{app}\apps\HaarFaceDetect\SampleBase\16"
Name: "{app}\apps\HaarFaceDetect\SampleBase\17"
Name: "{app}\apps\HaarFaceDetect\SampleBase\18"
Name: "{app}\apps\HaarFaceDetect\SampleBase\19"
Name: "{app}\apps\HaarFaceDetect\SampleBase\20"
Name: "{app}\apps\HaarFaceDetect\SampleBase\21"
Name: "{app}\apps\HaarFaceDetect\SampleBase\22"
Name: "{app}\apps\HaarFaceDetect\SampleBase\23"
Name: "{app}\apps\HaarFaceDetect\SampleBase\24"
Name: "{app}\apps\HaarTraining"
Name: "{app}\apps\HaarTraining\include"
Name: "{app}\apps\HaarTraining\make"
Name: "{app}\apps\HaarTraining\src"
Name: "{app}\apps\HaarTraining\doc"
Name: "{app}\apps\StereoDemo"
Name: "{app}\apps\VMDemo"
Name: "{app}\apps\VMDemo\res"
Name: "{app}\apps\VMDemo\Media"
Name: "{app}\apps\Tracker3dDemo"
Name: "{app}\apps\Hawk"
Name: "{app}\apps\Hawk\res"
Name: "{app}\apps\Hawk\"
Name: "{app}\apps\Hawk\CvEiCL"
Name: "{app}\apps\Hawk\CvEiCL\wrappers"
Name: "{app}\apps\Hawk\CvEiCL\EiC"
Name: "{app}\apps\Hawk\CvEiCL\EiC\src"
Name: "{app}\apps\Hawk\CvEiCL\EiC\src\win32"
Name: "{app}\apps\Hawk\CvEiCL\EiC\src\win32\sys"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\test"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_FREEBSD"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_HPUX"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_IRIX"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_LINUX"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_NETBSD"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_OSF1"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_SOLARIS"
Name: "{app}\apps\Hawk\CvEiCL\EiC\module\stdClib\src\_SUNOS"

; precompiled binaries
Name: "{app}\bin"
Name: "{app}\bin\Hawk"
Name: "{app}\bin\Hawk\Release"
Name: "{app}\bin\Hawk\Release\wrappers"
Name: "{app}\bin\Hawk\Release\wrappers\std"
Name: "{app}\bin\Hawk\Release\wrappers\std\sys"
Name: "{app}\lib"


[Files]

; root
Source: "README"; DestDir: "{app}"
Source: "ChangeLog"; DestDir: "{app}"
Source: "TODO"; DestDir: "{app}"
Source: "AUTHORS"; DestDir: "{app}"
Source: "THANKS"; DestDir: "{app}"
Source: "INSTALL"; DestDir: "{app}"
Source: "Makefile.*"; DestDir: "{app}"

; _dsw
Source: "_dsw\OpenCV.dsw"; DestDir: "{app}\_dsw"
Source: "_dsw\OpenCVlight.dsw"; DestDir: "{app}\_dsw"
Source: "_dsw\3dTracker.dsw"; DestDir: "{app}\_dsw"

; cv
Source: "cv\include\*.h*"; DestDir: "{app}\cv\include"
Source: "cv\include\Makefile.*"; DestDir: "{app}\cv\include"
Source: "cv\src\*.c*"; DestDir: "{app}\cv\src"
Source: "cv\src\*.h*"; DestDir: "{app}\cv\src"
Source: "cv\src\Makefile.*"; DestDir: "{app}\cv\src"
Source: "cv\src\*.rc"; DestDir: "{app}\cv\src"
Source: "cv\make\Makefile.*"; DestDir: "{app}\cv\make"
Source: "cv\make\*.dsp"; DestDir: "{app}\cv\make"
Source: "cv\Makefile.*"; DestDir: "{app}\cv"

; cvaux
Source: "cvaux\include\*.h*"; DestDir: "{app}\cvaux\include"
Source: "cvaux\include\Makefile.*"; DestDir: "{app}\cvaux\include"
Source: "cvaux\src\*.c*"; DestDir: "{app}\cvaux\src"
Source: "cvaux\src\*.h*"; DestDir: "{app}\cvaux\src"
Source: "cvaux\src\Makefile.*"; DestDir: "{app}\cvaux\src"
Source: "cvaux\src\*.rc"; DestDir: "{app}\cvaux\src"
Source: "cvaux\make\Makefile.*"; DestDir: "{app}\cvaux\make"
Source: "cvaux\make\*.dsp"; DestDir: "{app}\cvaux\make"
Source: "cvaux\Makefile.*"; DestDir: "{app}\cvaux"

; otherlibs
Source: "otherlibs\Makefile.*"; DestDir: "{app}\otherlibs"

; graphic libraries
Source: "otherlibs\_graphics\include\*.h"; DestDir: "{app}\otherlibs\_graphics\include"
Source: "otherlibs\_graphics\lib\*.a"; DestDir: "{app}\otherlibs\_graphics\lib"
Source: "otherlibs\_graphics\lib\*.lib"; DestDir: "{app}\otherlibs\_graphics\lib"
Source: "otherlibs\_graphics\readme.txt"; DestDir: "{app}\otherlibs\_graphics"

; otherlibs: fltk
Source: "otherlibs\_fltk\include\*.h"; DestDir: "{app}\otherlibs\_fltk\include"
Source: "otherlibs\_fltk\include\FL\*.H"; DestDir: "{app}\otherlibs\_fltk\include\FL"
Source: "otherlibs\_fltk\include\FL\*.r"; DestDir: "{app}\otherlibs\_fltk\include\FL"
Source: "otherlibs\_fltk\lib\fltk*.lib"; DestDir: "{app}\otherlibs\_fltk\lib"
Source: "otherlibs\_fltk\readme.txt"; DestDir: "{app}\otherlibs\_fltk"

; otherlibs: highgui
Source: "otherlibs\highgui\*.c*"; DestDir: "{app}\otherlibs\highgui"
Source: "otherlibs\highgui\*.h*"; DestDir: "{app}\otherlibs\highgui"
Source: "otherlibs\highgui\*.rc"; DestDir: "{app}\otherlibs\highgui"
Source: "otherlibs\highgui\*.dsp"; DestDir: "{app}\otherlibs\highgui"
Source: "otherlibs\highgui\Makefile.*"; DestDir: "{app}\otherlibs\highgui"

; otherlibs: cvcam
Source: "otherlibs\cvcam\include\*.h*"; DestDir: "{app}\otherlibs\cvcam\include"
Source: "otherlibs\cvcam\include\Makefile.*"; DestDir: "{app}\otherlibs\cvcam\include"
Source: "otherlibs\cvcam\src\windows\*.c*"; DestDir: "{app}\otherlibs\cvcam\src\windows"
Source: "otherlibs\cvcam\src\windows\*.h*"; DestDir: "{app}\otherlibs\cvcam\src\windows"
Source: "otherlibs\cvcam\src\windows\*.rc"; DestDir: "{app}\otherlibs\cvcam\src\windows"
Source: "otherlibs\cvcam\src\windows\*.txt"; DestDir: "{app}\otherlibs\cvcam\src\windows"
Source: "otherlibs\cvcam\src\unix\*.c*"; DestDir: "{app}\otherlibs\cvcam\src\unix"
Source: "otherlibs\cvcam\src\unix\*.h*"; DestDir: "{app}\otherlibs\cvcam\src\unix"
Source: "otherlibs\cvcam\src\unix\Makefile.*"; DestDir: "{app}\otherlibs\cvcam\src\unix"
Source: "otherlibs\cvcam\make_win\*.dsp"; DestDir: "{app}\otherlibs\cvcam\make_win"
Source: "otherlibs\cvcam\Makefile.*"; DestDir: "{app}\otherlibs\cvcam"
Source: "otherlibs\cvcam\src\Makefile.*"; DestDir: "{app}\otherlibs\cvcam\src"

; interfaces
Source: "interfaces\ch\ReadMe.txt"; DestDir: "{app}\interfaces\ch"
Source: "interfaces\ch\Devel\*.ch"; DestDir: "{app}\interfaces\ch\Devel"
Source: "interfaces\ch\Devel\include\*.h"; DestDir: "{app}\interfaces\ch\Devel\include"
Source: "interfaces\ch\Devel\createchf\*.h"; DestDir: "{app}\interfaces\ch\Devel\createchf"
Source: "interfaces\ch\Devel\c\cv\*.c"; DestDir: "{app}\interfaces\ch\Devel\c\cv"
Source: "interfaces\ch\Devel\c\cv\Makefile"; DestDir: "{app}\interfaces\ch\Devel\c\cv"
Source: "interfaces\ch\Devel\c\highgui\*.c"; DestDir: "{app}\interfaces\ch\Devel\c\highgui"
Source: "interfaces\ch\Devel\c\highgui\Makefile"; DestDir: "{app}\interfaces\ch\Devel\c\highgui"
Source: "interfaces\ch\Devel\c\cvcam\*.c"; DestDir: "{app}\interfaces\ch\Devel\c\cvcam"
Source: "interfaces\ch\Devel\c\cvcam\Makefile"; DestDir: "{app}\interfaces\ch\Devel\c\cvcam"
Source: "interfaces\ch\Devel\lib.handmade\*.chf"; DestDir: "{app}\interfaces\ch\Devel\lib.handmade"
Source: "interfaces\ch\OpenCV\lib\*.chf"; DestDir: "{app}\interfaces\ch\OpenCV\lib"
Source: "interfaces\ch\OpenCV\dl\*.dl"; DestDir: "{app}\interfaces\ch\OpenCV\dl"
; add files from CV (because Inno handles duplicated files, this won't increase install size)
Source: "cv\include\*.h*"; DestDir: "{app}\interfaces\ch\OpenCV\include"
Source: "otherlibs\highgui\highgui.h"; DestDir: "{app}\interfaces\ch\OpenCV\include"
Source: "otherlibs\cvcam\include\cvcam.h"; DestDir: "{app}\interfaces\ch\OpenCV\include"
Source: "bin\cv.dll"; DestDir: "{app}\interfaces\ch\OpenCV\bin"
Source: "bin\highgui.dll"; DestDir: "{app}\interfaces\ch\OpenCV\bin"
Source: "bin\cvcam.dll"; DestDir: "{app}\interfaces\ch\OpenCV\bin"
Source: "samples\c\*.c"; DestDir: "{app}\interfaces\ch\OpenCV\demos"
Source: "samples\c\*.jpg"; DestDir: "{app}\interfaces\ch\OpenCV\demos"
Source: "samples\c\*.png"; DestDir: "{app}\interfaces\ch\OpenCV\demos"


Source: "interfaces\matlab\ReadMe.txt"; DestDir: "{app}\interfaces\matlab"
Source: "interfaces\matlab\src\*.c*"; DestDir: "{app}\interfaces\matlab\src"
Source: "interfaces\matlab\src\*.h*"; DestDir: "{app}\interfaces\matlab\src"
Source: "interfaces\matlab\src\*.dsp"; DestDir: "{app}\interfaces\matlab\src"
Source: "interfaces\matlab\src\*.def"; DestDir: "{app}\interfaces\matlab\src"
;Source: "interfaces\matlab\toolbox\*.*"; DestDir: "{app}\interfaces\matlab\toolbox"
Source: "interfaces\matlab\toolbox\opencv\*.m"; DestDir: "{app}\interfaces\matlab\toolbox\opencv"
Source: "interfaces\matlab\toolbox\opencv\cvwrap.dll"; DestDir: "{app}\interfaces\matlab\toolbox\opencv"
Source: "interfaces\matlab\toolbox\opencv\cvdemos\*.m*"; DestDir: "{app}\interfaces\matlab\toolbox\opencv\cvdemos"

; documentation
Source: "docs\*.htm*"; DestDir: "{app}\docs"
Source: "docs\*.jp*"; DestDir: "{app}\docs"
Source: "docs\*.txt"; DestDir: "{app}\docs"
Source: "docs\*.pdf"; DestDir: "{app}\docs"
Source: "docs\*.rtf"; DestDir: "{app}\docs"
Source: "docs\Makefile.*"; DestDir: "{app}\docs"
Source: "docs\ref\*.htm*"; DestDir: "{app}\docs\ref"
Source: "docs\ref\Makefile.*"; DestDir: "{app}\docs\ref"
Source: "docs\ref\*.css"; DestDir: "{app}\docs\ref"
Source: "docs\ref\pics\*.jp*"; DestDir: "{app}\docs\ref\pics"
Source: "docs\ref\pics\*.png"; DestDir: "{app}\docs\ref\pics"
Source: "docs\ref\pics\Makefile.*"; DestDir: "{app}\docs\ref\pics"
Source: "docs\papers\*.pdf"; DestDir: "{app}\docs\papers"
Source: "docs\papers\*.ps"; DestDir: "{app}\docs\papers"
Source: "docs\appPage\appindex.htm"; DestDir: "{app}\docs\appPage"
Source: "docs\appPage\*.png"; DestDir: "{app}\docs\appPage"
Source: "docs\appPage\3dTracker\*.htm*"; DestDir: "{app}\docs\appPage\3dTracker"
Source: "docs\appPage\3dTracker\*.png"; DestDir: "{app}\docs\appPage\3dTracker"
Source: "docs\appPage\Calibration\*.htm*"; DestDir: "{app}\docs\appPage\Calibration"
Source: "docs\appPage\Calibration\*.png"; DestDir: "{app}\docs\appPage\Calibration"
Source: "docs\appPage\Calibration\*.jp*"; DestDir: "{app}\docs\appPage\Calibration"
Source: "docs\appPage\CamShift\*.htm*"; DestDir: "{app}\docs\appPage\CamShift"
Source: "docs\appPage\CamShift\*.png"; DestDir: "{app}\docs\appPage\CamShift"
Source: "docs\appPage\CamShift\*.jp*"; DestDir: "{app}\docs\appPage\CamShift"
Source: "docs\appPage\ConDensation\*.htm*"; DestDir: "{app}\docs\appPage\ConDensation"
Source: "docs\appPage\ConDensation\*.png"; DestDir: "{app}\docs\appPage\ConDensation"
Source: "docs\appPage\ConDensation\*.jp*"; DestDir: "{app}\docs\appPage\ConDensation"
Source: "docs\appPage\FaceRecognition\*.htm*"; DestDir: "{app}\docs\appPage\FaceRecognition"
Source: "docs\appPage\FaceRecognition\*.png"; DestDir: "{app}\docs\appPage\FaceRecognition"
Source: "docs\appPage\FaceRecognition\*.jp*"; DestDir: "{app}\docs\appPage\FaceRecognition"
Source: "docs\appPage\Kalman\*.htm*"; DestDir: "{app}\docs\appPage\Kalman"
Source: "docs\appPage\Kalman\*.png"; DestDir: "{app}\docs\appPage\Kalman"
Source: "docs\appPage\Kalman\*.jp*"; DestDir: "{app}\docs\appPage\Kalman"
Source: "docs\appPage\LKTracker\*.htm*"; DestDir: "{app}\docs\appPage\LKTracker"
;Source: "docs\appPage\LKTracker\*.png"; DestDir: "{app}\docs\appPage\LKTracker"
Source: "docs\appPage\LKTracker\*.jp*"; DestDir: "{app}\docs\appPage\LKTracker"

; sample code
Source: "samples\c\*.c"; DestDir: "{app}\samples\c"
Source: "samples\c\*.jp*"; DestDir: "{app}\samples\c"
Source: "samples\c\*.png"; DestDir: "{app}\samples\c"
Source: "samples\c\Makefile.*"; DestDir: "{app}\samples\c"

; batch tests
Source: "tests\Makefile.*"; DestDir: "{app}\tests"
Source: "tests\trs\Makefile.*"; DestDir: "{app}\tests\trs"
Source: "tests\trs\include\*.h*"; DestDir: "{app}\tests\trs\include"
Source: "tests\trs\include\Makefile.*"; DestDir: "{app}\tests\trs\include"
Source: "tests\trs\make\Makefile.*"; DestDir: "{app}\tests\trs\make"
Source: "tests\trs\make\*.dsp"; DestDir: "{app}\tests\trs\make"
Source: "tests\trs\src\*.c*"; DestDir: "{app}\tests\trs\src"
Source: "tests\trs\src\Makefile.*"; DestDir: "{app}\tests\trs\src"
Source: "tests\cv\Makefile.*"; DestDir: "{app}\tests\cv"
Source: "tests\cv\src\*.c*"; DestDir: "{app}\tests\cv\src"
Source: "tests\cv\src\*.h*"; DestDir: "{app}\tests\cv\src"
Source: "tests\cv\src\Makefile.*"; DestDir: "{app}\tests\cv\src"
Source: "tests\cv\src\*.dsp"; DestDir: "{app}\tests\cv\src"
Source: "tests\cv\src\*.inc"; DestDir: "{app}\tests\cv\src"

Source: "tests\cv\testdata\cameracalibration\*.*"; DestDir: "{app}\tests\cv\testdata\cameracalibration"
Source: "tests\cv\testdata\drawing\*.*"; DestDir: "{app}\tests\cv\testdata\drawing"
Source: "tests\cv\testdata\gesturerecognition\*.*"; DestDir: "{app}\tests\cv\testdata\gesturerecognition"
Source: "tests\cv\testdata\optflow\*.*"; DestDir: "{app}\tests\cv\testdata\optflow"
Source: "tests\cv\testdata\snakes\*.*"; DestDir: "{app}\tests\cv\testdata\snakes"

; utilities
Source: "utils\*.cmd"; DestDir: "{app}\utils"
Source: "utils\*.pl"; DestDir: "{app}\utils"
Source: "utils\*.py"; DestDir: "{app}\utils"
Source: "utils\*.iss"; DestDir: "{app}\utils"
Source: "utils\Makefile.*"; DestDir: "{app}\utils"
Source: "utils\cvinfo\*.c*"; DestDir: "{app}\utils\cvinfo"
Source: "utils\cvinfo\*.dsp"; DestDir: "{app}\utils\cvinfo"
Source: "utils\cvinfo\Makefile.*"; DestDir: "{app}\utils\cvinfo"

; direct show filters
;Source: "filters\*.*"; DestDir: "{app}\filters"
Source: "filters\Kalman\*.c*"; DestDir: "{app}\filters\Kalman"
Source: "filters\Kalman\*.h*"; DestDir: "{app}\filters\Kalman"
Source: "filters\Kalman\*.rc"; DestDir: "{app}\filters\Kalman"
Source: "filters\Kalman\*.def"; DestDir: "{app}\filters\Kalman"
Source: "filters\Kalman\*.dsp"; DestDir: "{app}\filters\Kalman"

Source: "filters\Condens\*.c*"; DestDir: "{app}\filters\Condens"
Source: "filters\Condens\*.h*"; DestDir: "{app}\filters\Condens"
Source: "filters\Condens\*.rc"; DestDir: "{app}\filters\Condens"
Source: "filters\Condens\*.def"; DestDir: "{app}\filters\Condens"
Source: "filters\Condens\*.dsp"; DestDir: "{app}\filters\Condens"

Source: "filters\CamShift\*.c*"; DestDir: "{app}\filters\CamShift"
Source: "filters\CamShift\*.h*"; DestDir: "{app}\filters\CamShift"
Source: "filters\CamShift\*.rc"; DestDir: "{app}\filters\CamShift"
Source: "filters\CamShift\*.def"; DestDir: "{app}\filters\CamShift"
Source: "filters\CamShift\*.dsp"; DestDir: "{app}\filters\CamShift"

Source: "filters\CalibFilter\*.c*"; DestDir: "{app}\filters\CalibFilter"
Source: "filters\CalibFilter\*.h*"; DestDir: "{app}\filters\CalibFilter"
Source: "filters\CalibFilter\*.rc"; DestDir: "{app}\filters\CalibFilter"
Source: "filters\CalibFilter\*.def"; DestDir: "{app}\filters\CalibFilter"
Source: "filters\CalibFilter\*.dsp"; DestDir: "{app}\filters\CalibFilter"

Source: "filters\ProxyTrans\*.c*"; DestDir: "{app}\filters\ProxyTrans"
Source: "filters\ProxyTrans\*.h*"; DestDir: "{app}\filters\ProxyTrans"
Source: "filters\ProxyTrans\*.rc"; DestDir: "{app}\filters\ProxyTrans"
Source: "filters\ProxyTrans\*.def"; DestDir: "{app}\filters\ProxyTrans"
Source: "filters\ProxyTrans\*.dsp"; DestDir: "{app}\filters\ProxyTrans"
Source: "filters\ProxyTrans\*.txt"; DestDir: "{app}\filters\ProxyTrans"

Source: "filters\SyncFilter\*.c*"; DestDir: "{app}\filters\SyncFilter"
Source: "filters\SyncFilter\*.h*"; DestDir: "{app}\filters\SyncFilter"
;Source: "filters\ProxyTrans\*.rc"; DestDir: "{app}\filters\ProxyTrans"
Source: "filters\SyncFilter\*.def"; DestDir: "{app}\filters\SyncFilter"
Source: "filters\SyncFilter\*.dsp"; DestDir: "{app}\filters\SyncFilter"

;Source: "filters\Tracker3dFilter\*.*"; DestDir: "{app}\filters\Tracker3dFilter"
Source: "filters\Tracker3dFilter\include\*.h*"; DestDir: "{app}\filters\Tracker3dFilter\include"
Source: "filters\Tracker3dFilter\src\*.c*"; DestDir: "{app}\filters\Tracker3dFilter\src"
Source: "filters\Tracker3dFilter\src\*.h*"; DestDir: "{app}\filters\Tracker3dFilter\src"
Source: "filters\Tracker3dFilter\src\*.rc"; DestDir: "{app}\filters\Tracker3dFilter\src"
Source: "filters\Tracker3dFilter\src\*.def"; DestDir: "{app}\filters\Tracker3dFilter\src"
Source: "filters\Tracker3dFilter\src\*.dsp"; DestDir: "{app}\filters\Tracker3dFilter\src"

;Source: "filters\Tracker3dFilter\trackers\*.*"; DestDir: "{app}\filters\Tracker3dFilter\trackers"
Source: "filters\Tracker3dFilter\trackers\BlobTracker\*.c*"; DestDir: "{app}\filters\Tracker3dFilter\trackers\BlobTracker"
Source: "filters\Tracker3dFilter\trackers\BlobTracker\*.h*"; DestDir: "{app}\filters\Tracker3dFilter\trackers\BlobTracker"
Source: "filters\Tracker3dFilter\trackers\BlobTracker\*.rc"; DestDir: "{app}\filters\Tracker3dFilter\trackers\BlobTracker"
Source: "filters\Tracker3dFilter\trackers\BlobTracker\*.def"; DestDir: "{app}\filters\Tracker3dFilter\trackers\BlobTracker"
Source: "filters\Tracker3dFilter\trackers\BlobTracker\*.dsp"; DestDir: "{app}\filters\Tracker3dFilter\trackers\BlobTracker"

Source: "filters\Tracker3dFilter\trackers\CamShiftTracker\*.c*"; DestDir: "{app}\filters\Tracker3dFilter\trackers\CamShiftTracker"
Source: "filters\Tracker3dFilter\trackers\CamShiftTracker\*.h*"; DestDir: "{app}\filters\Tracker3dFilter\trackers\CamShiftTracker"
Source: "filters\Tracker3dFilter\trackers\CamShiftTracker\*.rc"; DestDir: "{app}\filters\Tracker3dFilter\trackers\CamShiftTracker"
Source: "filters\Tracker3dFilter\trackers\CamShiftTracker\*.def"; DestDir: "{app}\filters\Tracker3dFilter\trackers\CamShiftTracker"
Source: "filters\Tracker3dFilter\trackers\CamShiftTracker\*.dsp"; DestDir: "{app}\filters\Tracker3dFilter\trackers\CamShiftTracker"

;Source: "filters\Tracker3dFilter\data\*.*"; DestDir: "{app}\filters\Tracker3dFilter\data"
Source: "filters\Tracker3dFilter\data\CameraCalibration\*.*"; DestDir: "{app}\filters\Tracker3dFilter\data\CameraCalibration"
Source: "filters\Tracker3dFilter\data\Tracking\*.*"; DestDir: "{app}\filters\Tracker3dFilter\data\Tracking"


; applications
;Source: "apps\*.*"; DestDir: "{app}\apps"
Source: "apps\Common\Camera.*"; DestDir: "{app}\apps\Common"

Source: "apps\cvcsdemo\*.c*"; DestDir: "{app}\apps\cvcsdemo"
Source: "apps\cvcsdemo\*.h*"; DestDir: "{app}\apps\cvcsdemo"
Source: "apps\cvcsdemo\*.tcl"; DestDir: "{app}\apps\cvcsdemo"
Source: "apps\cvcsdemo\*.dsp"; DestDir: "{app}\apps\cvcsdemo"
Source: "apps\cvcsdemo\Makefile.*"; DestDir: "{app}\apps\cvcsdemo"
Source: "apps\cvcsdemo\pictures\*.*"; DestDir: "{app}\apps\cvcsdemo\pictures"

Source: "apps\cvlkdemo\*.c*"; DestDir: "{app}\apps\cvlkdemo"
Source: "apps\cvlkdemo\*.h*"; DestDir: "{app}\apps\cvlkdemo"
Source: "apps\cvlkdemo\*.tcl"; DestDir: "{app}\apps\cvlkdemo"
Source: "apps\cvlkdemo\*.dsp"; DestDir: "{app}\apps\cvlkdemo"
Source: "apps\cvlkdemo\Makefile.*"; DestDir: "{app}\apps\cvlkdemo"
Source: "apps\cvlkdemo\pictures\*.*"; DestDir: "{app}\apps\cvlkdemo\pictures"

Source: "apps\vmdemotk\*.c*"; DestDir: "{app}\apps\vmdemotk"
Source: "apps\vmdemotk\*.h*"; DestDir: "{app}\apps\vmdemotk"
Source: "apps\vmdemotk\*.tcl"; DestDir: "{app}\apps\vmdemotk"
Source: "apps\vmdemotk\*.ds*"; DestDir: "{app}\apps\vmdemotk"
Source: "apps\vmdemotk\Makefile.*"; DestDir: "{app}\apps\vmdemotk"
Source: "apps\vmdemotk\media\*.*"; DestDir: "{app}\apps\vmdemotk\media"

Source: "apps\CamShiftDemo\*.c*"; DestDir: "{app}\apps\CamShiftDemo"
Source: "apps\CamShiftDemo\*.h*"; DestDir: "{app}\apps\CamShiftDemo"
Source: "apps\CamShiftDemo\*.rc"; DestDir: "{app}\apps\CamShiftDemo"
Source: "apps\CamShiftDemo\*.dsp"; DestDir: "{app}\apps\CamShiftDemo"
Source: "apps\CamShiftDemo\res\*.*"; DestDir: "{app}\apps\CamShiftDemo\res"

Source: "apps\HMMDemo\*.c*"; DestDir: "{app}\apps\HMMDemo"
Source: "apps\HMMDemo\*.h*"; DestDir: "{app}\apps\HMMDemo"
Source: "apps\HMMDemo\*.rc"; DestDir: "{app}\apps\HMMDemo"
Source: "apps\HMMDemo\*.dsp"; DestDir: "{app}\apps\HMMDemo"
Source: "apps\HMMDemo\res\*.*"; DestDir: "{app}\apps\HMMDemo\res"

Source: "apps\HMMDemo\SampleBase\*.*"; DestDir: "{app}\apps\HMMDemo\SampleBase"
Source: "apps\HMMDemo\SampleBase\Sergey.Molinov\*.*"; DestDir: "{app}\apps\HMMDemo\SampleBase\Sergey.Molinov"
Source: "apps\HMMDemo\SampleBase\Vadim.Pisarevsky\*.*"; DestDir: "{app}\apps\HMMDemo\SampleBase\Vadim.Pisarevsky"
Source: "apps\HMMDemo\SampleBase\Valery.Cherepennikov\*.*"; DestDir: "{app}\apps\HMMDemo\SampleBase\Valery.Cherepennikov"
Source: "apps\HMMDemo\SampleBase\Valery.Mosyagin\*.*"; DestDir: "{app}\apps\HMMDemo\SampleBase\Valery.Mosyagin"
Source: "apps\HMMDemo\SampleBase\Victor.Eruhimov\*.*"; DestDir: "{app}\apps\HMMDemo\SampleBase\Victor.Eruhimov"

Source: "apps\LKDemo\*.c*"; DestDir: "{app}\apps\LKDemo"
Source: "apps\LKDemo\*.h*"; DestDir: "{app}\apps\LKDemo"
Source: "apps\LKDemo\*.rc"; DestDir: "{app}\apps\LKDemo"
Source: "apps\LKDemo\*.dsp"; DestDir: "{app}\apps\LKDemo"
Source: "apps\LKDemo\res\*.*"; DestDir: "{app}\apps\LKDemo\res"

Source: "apps\HaarFaceDetect\*.c*"; DestDir: "{app}\apps\HaarFaceDetect"
Source: "apps\HaarFaceDetect\*.h*"; DestDir: "{app}\apps\HaarFaceDetect"
Source: "apps\HaarFaceDetect\*.dsp"; DestDir: "{app}\apps\HaarFaceDetect"
Source: "apps\HaarFaceDetect\*.zip"; DestDir: "{app}\apps\HaarFaceDetect"
Source: "apps\HaarFaceDetect\Makefile.*"; DestDir: "{app}\apps\HaarFaceDetect"

;Source: "apps\HaarFaceDetect\SampleBase\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase"
Source: "apps\HaarFaceDetect\SampleBase\0\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\0"
Source: "apps\HaarFaceDetect\SampleBase\1\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\1"
Source: "apps\HaarFaceDetect\SampleBase\2\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\2"
Source: "apps\HaarFaceDetect\SampleBase\3\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\3"
Source: "apps\HaarFaceDetect\SampleBase\4\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\4"
Source: "apps\HaarFaceDetect\SampleBase\5\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\5"
Source: "apps\HaarFaceDetect\SampleBase\6\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\6"
Source: "apps\HaarFaceDetect\SampleBase\7\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\7"
Source: "apps\HaarFaceDetect\SampleBase\8\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\8"
Source: "apps\HaarFaceDetect\SampleBase\9\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\9"
Source: "apps\HaarFaceDetect\SampleBase\10\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\10"
Source: "apps\HaarFaceDetect\SampleBase\11\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\11"
Source: "apps\HaarFaceDetect\SampleBase\12\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\12"
Source: "apps\HaarFaceDetect\SampleBase\13\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\13"
Source: "apps\HaarFaceDetect\SampleBase\14\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\14"
Source: "apps\HaarFaceDetect\SampleBase\15\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\15"
Source: "apps\HaarFaceDetect\SampleBase\16\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\16"
Source: "apps\HaarFaceDetect\SampleBase\17\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\17"
Source: "apps\HaarFaceDetect\SampleBase\18\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\18"
Source: "apps\HaarFaceDetect\SampleBase\19\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\19"
Source: "apps\HaarFaceDetect\SampleBase\20\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\20"
Source: "apps\HaarFaceDetect\SampleBase\21\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\21"
Source: "apps\HaarFaceDetect\SampleBase\22\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\22"
Source: "apps\HaarFaceDetect\SampleBase\23\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\23"
Source: "apps\HaarFaceDetect\SampleBase\24\*.*"; DestDir: "{app}\apps\HaarFaceDetect\SampleBase\24"
;Source: "apps\HaarTraining\*.*"; DestDir: "{app}\apps\HaarTraining"
Source: "apps\HaarTraining\include\*.h*"; DestDir: "{app}\apps\HaarTraining\include"
Source: "apps\HaarTraining\make\*.ds*"; DestDir: "{app}\apps\HaarTraining\make"
Source: "apps\HaarTraining\src\*.c*"; DestDir: "{app}\apps\HaarTraining\src"
Source: "apps\HaarTraining\src\*.h*"; DestDir: "{app}\apps\HaarTraining\src"
Source: "apps\HaarTraining\doc\*.doc"; DestDir: "{app}\apps\HaarTraining\doc"

Source: "apps\StereoDemo\*.c*"; DestDir: "{app}\apps\StereoDemo"
Source: "apps\StereoDemo\*.h*"; DestDir: "{app}\apps\StereoDemo"
Source: "apps\StereoDemo\*.dsp"; DestDir: "{app}\apps\StereoDemo"
Source: "apps\StereoDemo\*.txt"; DestDir: "{app}\apps\StereoDemo"

Source: "apps\VMDemo\*.c*"; DestDir: "{app}\apps\VMDemo"
Source: "apps\VMDemo\*.h*"; DestDir: "{app}\apps\VMDemo"
Source: "apps\VMDemo\*.rc"; DestDir: "{app}\apps\VMDemo"
Source: "apps\VMDemo\*.dsp"; DestDir: "{app}\apps\VMDemo"
Source: "apps\VMDemo\res\*.*"; DestDir: "{app}\apps\VMDemo\res"
Source: "apps\VMDemo\Media\*.*"; DestDir: "{app}\apps\VMDemo\Media"

Source: "apps\Tracker3dDemo\*.c*"; DestDir: "{app}\apps\Tracker3dDemo"
Source: "apps\Tracker3dDemo\*.h*"; DestDir: "{app}\apps\Tracker3dDemo"
Source: "apps\Tracker3dDemo\*.rc"; DestDir: "{app}\apps\Tracker3dDemo"
Source: "apps\Tracker3dDemo\*.ds*"; DestDir: "{app}\apps\Tracker3dDemo"

Source: "apps\Hawk\*.c*"; DestDir: "{app}\apps\Hawk"
Source: "apps\Hawk\*.h*"; DestDir: "{app}\apps\Hawk"
Source: "apps\Hawk\*.rc"; DestDir: "{app}\apps\Hawk"
Source: "apps\Hawk\*.dsp"; DestDir: "{app}\apps\Hawk"
Source: "apps\Hawk\*.in"; DestDir: "{app}\apps\Hawk"
Source: "apps\Hawk\res\*.*"; DestDir: "{app}\apps\Hawk\res"
Source: "apps\Hawk\*.*"; DestDir: "{app}\apps\Hawk"
Source: "apps\Hawk\CVEiCL\CVEiCL.dsp"; DestDir: "{app}\apps\Hawk\CVEiCL"
Source: "apps\Hawk\CVEiCL\wrappers\*.h*"; DestDir: "{app}\apps\Hawk\CVEiCL\wrappers"
Source: "apps\Hawk\CVEiCL\wrappers\*.c*"; DestDir: "{app}\apps\Hawk\CVEiCL\wrappers"
Source: "apps\Hawk\CVEiCL\EiC\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC"
Source: "apps\Hawk\CVEiCL\EiC\src\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\src"
Source: "apps\Hawk\CVEiCL\EiC\src\win32\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\src\win32"
Source: "apps\Hawk\CVEiCL\EiC\src\win32\sys\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\src\win32\sys"
Source: "apps\Hawk\CVEiCL\EiC\module\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\test\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\test"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_FREEBSD\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_FREEBSD"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_HPUX\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_HPUX"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_IRIX\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_IRIX"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_LINUX\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_LINUX"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_NETBSD\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_NETBSD"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_OSF1\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_OSF1"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_SOLARIS\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_SOLARIS"
Source: "apps\Hawk\CVEiCL\EiC\module\stdClib\src\_SUNOS\*.*"; DestDir: "{app}\apps\Hawk\CVEiCL\EiC\module\stdClib\src\_SUNOS"

; precompiled binaries
Source: "bin\cv.dll"; DestDir: "{app}\bin"
Source: "bin\cvaux.dll"; DestDir: "{app}\bin"
Source: "bin\highgui.dll"; DestDir: "{app}\bin"
Source: "bin\cvcam.dll"; DestDir: "{app}\bin"
Source: "bin\trs.dll"; DestDir: "{app}\bin"
Source: "bin\cvtest.exe"; DestDir: "{app}\bin"
Source: "bin\cvinfo.exe"; DestDir: "{app}\bin"
Source: "bin\LkDemo.exe"; DestDir: "{app}\bin"
Source: "bin\HMMDemo.exe"; DestDir: "{app}\bin"
Source: "bin\HaarFaceDetect.exe"; DestDir: "{app}\bin"
Source: "bin\VMDemo.exe"; DestDir: "{app}\bin"
Source: "bin\CamShiftDemo.exe"; DestDir: "{app}\bin"
Source: "bin\StereoDemo.exe"; DestDir: "{app}\bin"
Source: "bin\CamShift.ax"; DestDir: "{app}\bin"
Source: "bin\Kalman.ax"; DestDir: "{app}\bin"
Source: "bin\ConDens.ax"; DestDir: "{app}\bin"
Source: "bin\CalibFilter.ax"; DestDir: "{app}\bin"
Source: "bin\ProxyTrans.ax"; DestDir: "{app}\bin"
Source: "bin\SyncFilter.ax"; DestDir: "{app}\bin"
Source: "bin\RegisterAll.bat"; DestDir: "{app}\bin"

; 3D Tracking
Source: "bin\Tracker3dDemo.exe"; DestDir: "{app}\bin"
Source: "bin\Tracker3dFilter.ax"; DestDir: "{app}\bin"
Source: "bin\BlobTracker.dll"; DestDir: "{app}\bin"
Source: "bin\CamShiftTracker.dll"; DestDir: "{app}\bin"
Source: "bin\tracking_expected_results*"; DestDir: "{app}\bin"
Source: "bin\trackingtest*"; DestDir: "{app}\bin"
Source: "bin\cam*.txt"; DestDir: "{app}\bin"

;Source: "bin\Hawk\*.*"; DestDir: "{app}\bin\Hawk"
Source: "bin\Hawk\Release\*.*"; DestDir: "{app}\bin\Hawk\Release"
Source: "bin\Hawk\Release\wrappers\*.h*"; DestDir: "{app}\bin\Hawk\Release\wrappers"
Source: "bin\Hawk\Release\wrappers\*.in"; DestDir: "{app}\bin\Hawk\Release\wrappers"
Source: "bin\Hawk\Release\wrappers\std\*.h"; DestDir: "{app}\bin\Hawk\Release\wrappers\std"
Source: "bin\Hawk\Release\wrappers\std\sys\*.h"; DestDir: "{app}\bin\Hawk\Release\wrappers\std\sys"

; optimized binaries
Source: "bin\OptCV*.dll"; DestDir: "{app}\bin"

Source: "lib\cv.lib"; DestDir: "{app}\lib"
Source: "lib\cvaux.lib"; DestDir: "{app}\lib"
Source: "lib\highgui.lib"; DestDir: "{app}\lib"
Source: "lib\cvcam.lib"; DestDir: "{app}\lib"
Source: "lib\trs.lib"; DestDir: "{app}\lib"

[Icons]
Name: "{group}\OpenCV Workspace"; Filename: "{app}\_dsw\opencv.dsw"
Name: "{group}\Documentation"; Filename: "{app}\docs\index.htm"
Name: "{group}\Lucas-Kanade Tracker"; Filename: "{app}\bin\lkdemo.exe"
Name: "{group}\HMM Face Recognition"; Filename: "{app}\bin\hmmdemo.exe"
Name: "{group}\Color Object Tracker"; Filename: "{app}\bin\camshiftdemo.exe"
Name: "{group}\Face Detection"; Filename: "{app}\bin\haarfacedetect.exe"
Name: "{group}\Hawk (scripting environment)"; Filename: "{app}\bin\Hawk\Release\Hawk.exe"

[Tasks]
Name: add_opencv_path; Description: "Add <...>\OpenCV\bin to the system PATH"; Flags: checkedonce

[Registry]
; Start "Software\My Company\My Program" keys under HKEY_CURRENT_USER
; and HKEY_LOCAL_MACHINE. The flags tell it to always delete the
; "My Program" keys upon uninstall, and delete the "My Company" keys
; if there is nothing left in them.
Root: HKCU; Subkey: "Environment"; ValueType: string; ValueName: "Path"; ValueData: "{app}\bin;{olddata}"; Flags: createvalueifdoesntexist; Tasks: add_opencv_path
Root: HKCU; Subkey: "Software\Intel"; Flags: uninsdeletekeyifempty
Root: HKCU; Subkey: "Software\Intel\OpenCV"; Flags: uninsdeletekey
Root: HKCU; Subkey: "Software\Intel\OpenCV\Settings"; ValueType: string; ValueName: "Path"; ValueData: "{app}"

[Run]
Filename: "{app}\bin\RegisterAll.bat"; WorkingDir: "{app}\bin"
Filename: "{app}\docs\index.htm"; Description: "View Documentation"; Flags: postinstall shellexec

[UninstallRun]
Filename: "{app}\bin\RegisterAll.bat"; Parameters: "/U"; WorkingDir: "{app}\bin"



