/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                        Intel License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000, Intel Corporation, all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of Intel Corporation may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

/* Default haar cascade for face detection */

#include "_cvaux.h"

extern const char* icvDefaultFaceCascade[] = {
/* Stage 0 */
" 9 1 2 6 4 12 9 0 -1 6 7 12 3 0 3 haar_y3 -0.031512 0 -1 2.087538 -2.217210  1 2 6 4 12 7 0 -1\n"
" 10 4 4 7 0 3 haar_x3 0.012396 0 -1 -1.863394 1.327205  1 2 3 9 18 9 0 -1 3 12 18 3 0 3\n"
" haar_y3 0.021928 0 -1 -1.510525 1.062573  1 2 8 18 9 6 0 -1 8 20 9 2 0 3 haar_y3\n"
" 0.005753 0 -1 -0.874639 1.176034  1 2 3 5 4 19 0 -1 5 5 2 19 0 2 haar_x2 0.015014 0 -1\n"
" -0.779457 1.260842  1 2 6 5 12 16 0 -1 6 13 12 8 0 2 haar_y2 0.099371 0 -1 0.557513 -1.874300 \n"
" 1 2 5 8 12 6 0 -1 5 11 12 3 0 2 haar_y2 0.002734 0 -1 -1.691193 0.440097  1 2 11 14 4 10 0 -1\n"
" 11 19 4 5 0 2 haar_y2 -0.018859 0 -1 -1.476954 0.443501  1 2 4 0 7 6 0 -1 4 3 7 3 0 2\n"
" haar_y2 0.005974 0 -1 -0.859092 0.852556  -5.042550\n"
,

/* Stage 1 */
" 16 1 2 6 6 12 6 0 -1 6 8 12 2 0 3 haar_y3 -0.021110 0 -1 1.243565 -1.571301  1 2\n"
" 6 4 12 7 0 -1 10 4 4 7 0 3 haar_x3 0.020356 0 -1 -1.620478 1.181776  1 2 1 8 19 12 0 -1\n"
" 1 12 19 4 0 3 haar_y3 0.021309 0 -1 -1.941593 0.700691  1 2 0 2 24 3 0 -1 8 2 8 3 0 3\n"
" haar_x3 0.091660 0 -1 -0.556701 1.728442  1 2 9 9 6 15 0 -1 9 14 6 5 0 3 haar_y3\n"
" 0.036288 0 -1 0.267638 -2.183181  1 2 5 6 14 10 0 -1 5 11 14 5 0 2 haar_y2 -0.019110 0 -1\n"
" -2.673021 0.456708  1 2 5 0 14 9 0 -1 5 3 14 3 0 3 haar_y3 0.008254 0 -1 -1.085291 0.535642 \n"
" 1 2 13 11 9 6 0 -1 16 11 3 6 0 3 haar_x3 0.018355 0 -1 -0.352002 0.933392  1 2 7 5 6 10 0 -1\n"
" 9 5 2 10 0 3 haar_x3 -0.007057 0 -1 0.927821 -0.663499  1 2 10 8 6 10 0 -1 12 8 2 10 0 3\n"
" haar_x3 -0.009877 0 -1 1.157747 -0.297748  1 2 2 5 4 9 0 -1 4 5 2 9 0 2 haar_x2 0.015814 0 -1\n"
" -0.419606 1.357604  1 2 18 0 6 11 0 -1 20 0 2 11 0 3 haar_x3 -0.020700 0 -1 1.459002 -0.197394 \n"
" 1 2 0 6 24 13 0 -1 8 6 8 13 0 3 haar_x3 -0.137608 0 -1 1.118676 -0.529155  1 2 9 6 6 9 0 -1\n"
" 11 6 2 9 0 3 haar_x3 0.014319 0 -1 -0.351272 1.144086  1 2 7 18 10 6 0 -1 7 20 10 2 0 3\n"
" haar_y3 0.010253 0 -1 -0.608506 0.770985  1 2 5 7 14 12 0 -1 5 13 14 6 0 2 haar_y2\n"
" 0.091508 0 -1 0.388178 -1.512294  -4.984240\n"
,

/* Stage 2 */
" 27 1 2 0 3 24 3 0 -1 8 3 8 3 0 3 haar_x3 0.069747 0 -1 -1.013088 1.468735  1 2 5 8 15 6 0 -1\n"
" 5 11 15 3 0 2 haar_y2 0.031503 0 -1 -1.646364 1.000063  1 2 9 6 5 14 0 -1 9 13 5 7 0 2\n"
" haar_y2 0.014261 0 -1 0.464803 -1.595989  1 2 9 5 6 10 0 -1 11 5 2 10 0 3 haar_x3\n"
" 0.014453 0 -1 -0.655119 0.830218  1 2 6 6 3 12 0 -1 6 12 3 6 0 2 haar_y2 -0.003051 0 -1\n"
" -1.398231 0.425506  1 2 3 21 18 3 0 -1 9 21 6 3 0 3 haar_x3 0.032723 0 -1 -0.507026 1.052611 \n"
" 1 2 5 6 13 6 0 -1 5 8 13 2 0 3 haar_y3 -0.007296 0 -1 0.363569 -1.346489  1 2 18 1 6 15 0 -1\n"
" 18 1 3 15 0 2 haar_x2 0.050425 0 -1 -0.304614 1.450413  1 2 1 1 6 15 0 -1 4 1 3 15 0 2\n"
" haar_x2 0.046879 0 -1 -0.402862 1.214561  1 2 0 8 24 15 0 -1 8 8 8 15 0 3 haar_x3\n"
" -0.069359 0 -1 1.053936 -0.457197  1 3 5 6 14 12 0 -1 5 6 7 6 0 2 12 12 7 6 0 2 haar_x2_y2\n"
" -0.049034 0 -1 -1.625309 0.153790  1 2 2 12 21 12 0 -1 2 16 21 4 0 3 haar_y3 0.084828 0 -1\n"
" 0.284030 -1.566206  1 2 8 1 4 10 0 -1 10 1 2 10 0 2 haar_x2 -0.001723 0 -1 -1.014746 0.232948 \n"
" 1 2 2 13 20 10 0 -1 2 13 10 10 0 2 haar_x2 0.115622 0 -1 -0.167329 1.280407  1 2\n"
" 0 1 6 13 0 -1 2 1 2 13 0 3 haar_x3 -0.051280 0 -1 1.516239 -0.302711  1 2 20 2 4 13 0 -1\n"
" 20 2 2 13 0 2 haar_x2 -0.042707 0 -1 1.763192 -0.051832  1 2 0 5 22 19 0 -1 11 5 11 19 0 2\n"
" haar_x2 0.371781 0 -1 -0.313892 1.535798  1 2 18 4 6 9 0 -1 20 4 2 9 0 3 haar_x3\n"
" 0.019413 0 -1 -0.100176 0.936554  1 2 0 3 6 11 0 -1 2 3 2 11 0 3 haar_x3 0.017439 0 -1\n"
" -0.403799 0.962930  1 2 12 1 4 9 0 -1 12 1 2 9 0 2 haar_x2 0.039639 0 -1 0.170391 -2.960299 \n"
" 1 2 0 6 19 3 0 -1 0 7 19 1 0 3 haar_y3 -0.009147 0 -1 0.887868 -0.438187  1 2 12 1 4 9 0 -1\n"
" 12 1 2 9 0 2 haar_x2 0.001722 0 -1 -0.372186 0.400189  1 2 8 1 4 9 0 -1 10 1 2 9 0 2\n"
" haar_x2 0.030231 0 -1 0.065924 -2.646918  1 3 5 5 14 14 0 -1 12 5 7 7 0 2 5 12 7 7 0 2\n"
" haar_x2_y2 -0.078796 0 -1 -1.749146 0.284753  1 2 1 10 18 2 0 -1 1 11 18 1 0 2 haar_y2\n"
" 0.002111 0 -1 -0.939081 0.232052  1 2 17 13 4 11 0 -1 17 13 2 11 0 2 haar_x2 0.027091 0 -1\n"
" -0.052664 1.075682  1 2 0 4 6 9 0 -1 0 7 6 3 0 3 haar_y3 -0.044965 0 -1 -1.829448 0.099562 \n"
" -4.655190\n"
,

/* Stage 3 */
" 32 1 2 6 4 12 9 0 -1 6 7 12 3 0 3 haar_y3 -0.065701 0 -1 1.155851 -1.071636  1 2\n"
" 6 5 12 6 0 -1 10 5 4 6 0 3 haar_x3 0.015840 0 -1 -1.563472 0.768771  1 2 0 1 24 5 0 -1\n"
" 8 1 8 5 0 3 haar_x3 0.145709 0 -1 -0.574501 1.380872  1 2 4 10 18 6 0 -1 4 12 18 2 0 3\n"
" haar_y3 0.006139 0 -1 -1.457056 0.516103  1 3 2 17 12 6 0 -1 2 17 6 3 0 2 8 20 6 3 0 2\n"
" haar_x2_y2 0.006718 0 -1 -0.835336 0.585222  1 2 19 3 4 13 0 -1 19 3 2 13 0 2 haar_x2\n"
" 0.018518 0 -1 -0.313121 1.169668  1 2 1 3 4 13 0 -1 3 3 2 13 0 2 haar_x2 0.019958 0 -1\n"
" -0.434426 0.954469  1 2 0 1 24 23 0 -1 8 1 8 23 0 3 haar_x3 -0.277550 0 -1 1.490618 -0.138159 \n"
" 1 2 1 7 8 12 0 -1 1 11 8 4 0 3 haar_y3 0.009186 0 -1 -0.963615 0.276655  1 2 14 7 3 14 0 -1\n"
" 14 14 3 7 0 2 haar_y2 -0.037738 0 -1 -2.446411 0.236196  1 3 3 12 16 6 0 -1 3 12 8 3 0 2\n"
" 11 15 8 3 0 2 haar_x2_y2 0.018463 0 -1 0.175392 -1.342313  1 2 6 6 12 6 0 -1 6 8 12 2 0 3\n"
" haar_y3 -0.011115 0 -1 0.487108 -0.898519  1 2 8 7 6 12 0 -1 8 13 6 6 0 2 haar_y2\n"
" 0.033928 0 -1 0.178742 -1.634228  1 2 15 15 9 6 0 -1 15 17 9 2 0 3 haar_y3 -0.035649 0 -1\n"
" -1.960740 0.181025  1 2 1 17 18 3 0 -1 1 18 18 1 0 3 haar_y3 -0.011438 0 -1 0.990107 -0.381032 \n"
" 1 2 4 4 16 12 0 -1 4 10 16 6 0 2 haar_y2 -0.065236 0 -1 -2.579416 0.247536  1 2 0 1 4 20 0 -1\n"
" 2 1 2 20 0 2 haar_x2 -0.042272 0 -1 1.441184 -0.295083  1 2 3 0 18 2 0 -1 3 1 18 1 0 2\n"
" haar_y2 0.001922 0 -1 -0.496086 0.631736  1 3 1 5 20 14 0 -1 1 5 10 7 0 2 11 12 10 7 0 2\n"
" haar_x2_y2 -0.129218 0 -1 -2.331427 0.054497  1 2 5 8 14 12 0 -1 5 12 14 4 0 3 haar_y3\n"
" 0.022931 0 -1 -0.844471 0.387381  1 2 3 14 7 9 0 -1 3 17 7 3 0 3 haar_y3 -0.034120 0 -1\n"
" -1.443150 0.098423  1 2 14 15 9 6 0 -1 14 17 9 2 0 3 haar_y3 0.026223 0 -1 0.182231 -1.258652 \n"
" 1 2 1 15 9 6 0 -1 1 17 9 2 0 3 haar_y3 0.022237 0 -1 0.069808 -2.382095  1 3 11 6 8 10 0 -1\n"
" 15 6 4 5 0 2 11 11 4 5 0 2 haar_x2_y2 -0.005824 0 -1 0.393325 -0.275428  1 3 5 5 14 14 0 -1\n"
" 5 5 7 7 0 2 12 12 7 7 0 2 haar_x2_y2 0.043653 0 -1 0.148327 -1.136878  1 2 6 0 12 5 0 -1\n"
" 10 0 4 5 0 3 haar_x3 0.057267 0 -1 0.246281 -1.268740  1 2 9 0 6 9 0 -1 9 3 6 3 0 3\n"
" haar_y3 0.002341 0 -1 -0.754489 0.271638  1 2 9 6 6 9 0 -1 11 6 2 9 0 3 haar_x3 0.012996 0 -1\n"
" -0.363949 0.709592  1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 -0.026517 0 -1 -2.322186 0.035744 \n"
" 1 2 10 6 6 9 0 -1 12 6 2 9 0 3 haar_x3 -0.005840 0 -1 0.421943 -0.048185  1 2 8 6 6 9 0 -1\n"
" 10 6 2 9 0 3 haar_x3 -0.016569 0 -1 1.109994 -0.348497  1 2 3 8 18 4 0 -1 9 8 6 4 0 3\n"
" haar_x3 -0.068157 0 -1 -3.326999 0.212990  -4.453159\n"
,

/* Stage 4 */
" 52 1 2 6 0 12 9 0 -1 6 3 12 3 0 3 haar_y3 0.039974 0 -1 -1.217345 1.082671  1 2 0 0 24 6 0 -1\n"
" 8 0 8 6 0 3 haar_x3 0.188195 0 -1 -0.482894 1.404525  1 2 4 7 16 12 0 -1 4 11 16 4 0 3\n"
" haar_y3 0.078027 0 -1 -1.078215 0.740403  1 2 11 6 6 6 0 -1 11 6 3 6 0 2 haar_x2\n"
" 0.000119 0 -1 -1.201998 0.377492  1 2 0 20 24 3 0 -1 8 20 8 3 0 3 haar_x3 0.085057 0 -1\n"
" -0.439391 1.264734  1 2 11 6 4 9 0 -1 11 6 2 9 0 2 haar_x2 0.008972 0 -1 -0.184405 0.457264 \n"
" 1 2 4 13 15 4 0 -1 9 13 5 4 0 3 haar_x3 0.008812 0 -1 0.303967 -0.959911  1 2 11 6 4 9 0 -1\n"
" 11 6 2 9 0 2 haar_x2 -0.023508 0 -1 1.248753 0.046228  1 2 9 6 4 9 0 -1 11 6 2 9 0 2\n"
" haar_x2 0.007004 0 -1 -0.594421 0.539633  1 2 9 12 6 12 0 -1 9 18 6 6 0 2 haar_y2\n"
" 0.033852 0 -1 0.284961 -1.489525  1 2 1 22 18 2 0 -1 1 23 18 1 0 2 haar_y2 -0.003253 0 -1\n"
" 0.481208 -0.527124  1 2 10 7 4 10 0 -1 10 12 4 5 0 2 haar_y2 0.029097 0 -1 0.267439 -1.600785 \n"
" 1 2 6 7 8 10 0 -1 6 12 8 5 0 2 haar_y2 -0.008479 0 -1 -1.310764 0.152431  1 2 7 6 10 6 0 -1\n"
" 7 8 10 2 0 3 haar_y3 -0.010795 0 -1 0.456136 -0.720509  1 2 0 14 10 4 0 -1 0 16 10 2 0 2\n"
" haar_y2 -0.024620 0 -1 -1.732062 0.068363  1 2 6 18 18 2 0 -1 6 19 18 1 0 2 haar_y2\n"
" 0.003738 0 -1 -0.193033 0.682435  1 2 1 1 22 3 0 -1 1 2 22 1 0 3 haar_y3 -0.012264 0 -1\n"
" -1.609529 0.075268  1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 -0.004867 0 -1 0.742865 -0.215102 \n"
" 1 2 2 4 6 15 0 -1 5 4 3 15 0 2 haar_x2 0.076726 0 -1 -0.268351 1.309414  1 2 20 4 4 10 0 -1\n"
" 20 4 2 10 0 2 haar_x2 0.028578 0 -1 -0.058793 1.219633  1 2 0 4 4 10 0 -1 2 4 2 10 0 2\n"
" haar_x2 0.019694 0 -1 -0.351429 0.849270  1 3 2 16 20 6 0 -1 12 16 10 3 0 2 2 19 10 3 0 2\n"
" haar_x2_y2 -0.029094 0 -1 -1.050730 0.298063  1 2 0 12 8 9 0 -1 4 12 4 9 0 2 haar_x2\n"
" -0.029144 0 -1 0.825478 -0.326872  1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 0.019741 0 -1\n"
" 0.204526 -0.837602  1 2 5 10 6 6 0 -1 8 10 3 6 0 2 haar_x2 0.004330 0 -1 0.205779 -0.668298 \n"
" 1 3 11 8 12 6 0 -1 17 8 6 3 0 2 11 11 6 3 0 2 haar_x2_y2 -0.035501 0 -1 -1.296990 0.138975 \n"
" 1 3 0 8 12 6 0 -1 0 8 6 3 0 2 6 11 6 3 0 2 haar_x2_y2 -0.016173 0 -1 -1.311057 0.075752 \n"
" 1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 -0.022151 0 -1 -1.052439 0.192411  1 2 6 0 6 9 0 -1\n"
" 8 0 2 9 0 3 haar_x3 -0.022707 0 -1 -1.373531 0.066781  1 2 8 14 9 6 0 -1 8 16 9 2 0 3\n"
" haar_y3 0.016608 0 -1 -0.037136 0.778464  1 2 0 16 9 6 0 -1 0 18 9 2 0 3 haar_y3\n"
" -0.013309 0 -1 -0.998507 0.122481  1 2 10 8 6 10 0 -1 12 8 2 10 0 3 haar_x3 -0.033732 0 -1\n"
" 1.446136 0.013152  1 2 3 19 12 3 0 -1 9 19 6 3 0 2 haar_x2 0.016935 0 -1 -0.371213 0.528422 \n"
" 1 2 2 10 20 2 0 -1 2 11 20 1 0 2 haar_y2 0.003326 0 -1 -0.575685 0.392619  1 3 2 9 18 12 0 -1\n"
" 2 9 9 6 0 2 11 15 9 6 0 2 haar_x2_y2 0.083644 0 -1 0.016116 -2.117328  1 2 3 0 18 24 0 -1\n"
" 3 0 9 24 0 2 haar_x2 0.257852 0 -1 -0.081609 0.987825  1 3 5 6 14 10 0 -1 5 6 7 5 0 2\n"
" 12 11 7 5 0 2 haar_x2_y2 -0.036567 0 -1 -1.151211 0.096459  1 3 9 5 10 12 0 -1 14 5 5 6 0 2\n"
" 9 11 5 6 0 2 haar_x2_y2 -0.016446 0 -1 0.373155 -0.145854  1 3 4 5 12 12 0 -1 4 5 6 6 0 2\n"
" 10 11 6 6 0 2 haar_x2_y2 -0.003752 0 -1 0.261793 -0.581567  1 2 4 14 18 3 0 -1 4 15 18 1 0 3\n"
" haar_y3 -0.006366 0 -1 0.754774 -0.170552  1 2 6 13 8 8 0 -1 6 17 8 4 0 2 haar_y2\n"
" -0.003850 0 -1 0.226540 -0.638764  1 2 3 16 18 6 0 -1 3 19 18 3 0 2 haar_y2 -0.045494 0 -1\n"
" -1.264030 0.252607  1 2 0 0 6 6 0 -1 3 0 3 6 0 2 haar_x2 -0.023941 0 -1 0.870684 -0.271047 \n"
" 1 2 6 6 12 18 0 -1 10 6 4 18 0 3 haar_x3 -0.077558 0 -1 -1.390161 0.236123  1 2 6 1 4 14 0 -1\n"
" 8 1 2 14 0 2 haar_x2 0.023614 0 -1 0.066140 -1.264542  1 2 3 2 19 2 0 -1 3 3 19 1 0 2\n"
" haar_y2 -0.002575 0 -1 -0.538417 0.303791  1 2 1 8 22 13 0 -1 12 8 11 13 0 2 haar_x2\n"
" 0.120108 0 -1 -0.353430 0.528662  1 2 8 9 11 4 0 -1 8 11 11 2 0 2 haar_y2 0.002290 0 -1\n"
" -0.587020 0.240610  1 2 0 12 15 10 0 -1 5 12 5 10 0 3 haar_x3 0.069717 0 -1 -0.333489 0.519163 \n"
" 1 2 12 16 12 6 0 -1 16 16 4 6 0 3 haar_x3 -0.046670 0 -1 0.697954 -0.014896  1 2\n"
" 0 16 12 6 0 -1 4 16 4 6 0 3 haar_x3 -0.050129 0 -1 0.861462 -0.259860  1 2 19 1 5 12 0 -1\n"
" 19 5 5 4 0 3 haar_y3 0.030148 0 -1 0.193328 -0.591311  -4.386459\n"
,

/* Stage 5 */
" 53 1 2 0 2 24 4 0 -1 8 2 8 4 0 3 haar_x3 0.091085 0 -1 -0.892331 1.043423  1 2 6 8 12 4 0 -1\n"
" 6 10 12 2 0 2 haar_y2 0.012819 0 -1 -1.259767 0.553171  1 2 7 5 9 6 0 -1 10 5 3 6 0 3\n"
" haar_x3 0.015932 0 -1 -0.862544 0.637318  1 2 9 17 6 6 0 -1 9 20 6 3 0 2 haar_y2\n"
" 0.002278 0 -1 -0.746392 0.531556  1 2 0 7 22 15 0 -1 0 12 22 5 0 3 haar_y3 0.031841 0 -1\n"
" -1.265049 0.361539  1 2 4 1 17 9 0 -1 4 4 17 3 0 3 haar_y3 0.002696 0 -1 -0.982904 0.360130 \n"
" 1 2 7 5 6 10 0 -1 9 5 2 10 0 3 haar_x3 -0.012055 0 -1 0.640684 -0.501250  1 2 18 1 6 8 0 -1\n"
" 18 1 3 8 0 2 haar_x2 0.021325 0 -1 -0.240350 0.854480  1 2 0 1 6 7 0 -1 3 1 3 7 0 2\n"
" haar_x2 0.030486 0 -1 -0.342736 1.142885  1 2 18 0 6 22 0 -1 18 0 3 22 0 2 haar_x2\n"
" -0.045080 0 -1 1.097695 -0.179746  1 2 0 0 6 22 0 -1 3 0 3 22 0 2 haar_x2 -0.071701 0 -1\n"
" 1.573500 -0.314335  1 2 16 7 8 16 0 -1 16 7 4 16 0 2 haar_x2 0.059218 0 -1 -0.275824 1.044857 \n"
" 1 2 2 10 19 6 0 -1 2 12 19 2 0 3 haar_y3 0.006701 0 -1 -1.097402 0.198012  1 2 9 9 6 12 0 -1\n"
" 9 13 6 4 0 3 haar_y3 0.041047 0 -1 0.305477 -1.328800  1 2 2 15 17 6 0 -1 2 17 17 2 0 3\n"
" haar_y3 -0.000855 0 -1 0.258071 -0.700529  1 2 14 7 3 14 0 -1 14 14 3 7 0 2 haar_y2\n"
" -0.030360 0 -1 -1.230642 0.226094  1 3 5 6 8 10 0 -1 5 6 4 5 0 2 9 11 4 5 0 2 haar_x2_y2\n"
" -0.012930 0 -1 0.407586 -0.512345  1 2 15 8 9 11 0 -1 18 8 3 11 0 3 haar_x3 0.037368 0 -1\n"
" -0.094755 0.617651  1 2 0 8 9 11 0 -1 3 8 3 11 0 3 haar_x3 0.024434 0 -1 -0.411006 0.476305 \n"
" 1 2 8 6 10 18 0 -1 8 15 10 9 0 2 haar_y2 0.057008 0 -1 0.252493 -0.686698  1 2 7 7 3 14 0 -1\n"
" 7 14 3 7 0 2 haar_y2 -0.016314 0 -1 -0.939284 0.114481  1 2 0 14 24 8 0 -1 8 14 8 8 0 3\n"
" haar_x3 -0.176489 0 -1 1.245109 -0.056519  1 2 1 10 18 14 0 -1 10 10 9 14 0 2 haar_x2\n"
" 0.176146 0 -1 -0.325282 0.827915  1 2 14 12 6 6 0 -1 14 15 6 3 0 2 haar_y2 -0.007391 0 -1\n"
" 0.347837 -0.179291  1 3 7 0 10 16 0 -1 7 0 5 8 0 2 12 8 5 8 0 2 haar_x2_y2 0.060891 0 -1\n"
" 0.055098 -1.548078  1 2 10 0 9 6 0 -1 13 0 3 6 0 3 haar_x3 -0.029123 0 -1 -1.025564 0.241069 \n"
" 1 2 4 3 16 4 0 -1 12 3 8 4 0 2 haar_x2 -0.045649 0 -1 1.030160 -0.316721  1 2 10 0 9 6 0 -1\n"
" 13 0 3 6 0 3 haar_x3 0.037333 0 -1 0.216206 -0.825899  1 3 1 1 20 4 0 -1 1 1 10 2 0 2\n"
" 11 3 10 2 0 2 haar_x2_y2 -0.024411 0 -1 -1.595796 0.051139  1 2 10 0 9 6 0 -1 13 0 3 6 0 3\n"
" haar_x3 -0.059807 0 -1 -1.031229 0.130923  1 2 5 0 9 6 0 -1 8 0 3 6 0 3 haar_x3 -0.030106 0 -1\n"
" -1.478163 0.037212  1 2 8 18 10 6 0 -1 8 20 10 2 0 3 haar_y3 0.007421 0 -1 -0.240241 0.493340 \n"
" 1 2 6 3 6 9 0 -1 8 3 2 9 0 3 haar_x3 -0.002191 0 -1 0.289415 -0.572596  1 2 7 3 12 6 0 -1\n"
" 7 5 12 2 0 3 haar_y3 0.020861 0 -1 -0.231484 0.637659  1 2 0 10 18 3 0 -1 0 11 18 1 0 3\n"
" haar_y3 -0.006699 0 -1 -1.210775 0.064018  1 2 1 10 22 3 0 -1 1 11 22 1 0 3 haar_y3\n"
" 0.018758 0 -1 0.244613 -0.997867  1 2 5 11 8 8 0 -1 9 11 4 8 0 2 haar_x2 -0.044323 0 -1\n"
" -1.369919 0.036052  1 2 12 11 6 6 0 -1 12 11 3 6 0 2 haar_x2 0.022860 0 -1 0.212884 -1.039762 \n"
" 1 2 6 11 6 6 0 -1 9 11 3 6 0 2 haar_x2 -0.000986 0 -1 0.324436 -0.542918  1 2 7 10 11 6 0 -1\n"
" 7 12 11 2 0 3 haar_y3 0.017239 0 -1 -0.283239 0.444682  1 3 0 13 24 4 0 -1 0 13 12 2 0 2\n"
" 12 15 12 2 0 2 haar_x2_y2 -0.034531 0 -1 -2.310702 -0.003140  1 3 2 4 22 12 0 -1\n"
" 13 4 11 6 0 2 2 10 11 6 0 2 haar_x2_y2 0.067007 0 -1 0.287157 -0.644810  1 2 2 0 20 17 0 -1\n"
" 12 0 10 17 0 2 haar_x2 0.237769 0 -1 -0.271748 0.802191  1 2 14 0 2 24 0 -1 14 0 1 24 0 2\n"
" haar_x2 -0.012903 0 -1 -1.531762 0.214236  1 2 8 0 2 24 0 -1 9 0 1 24 0 2 haar_x2\n"
" 0.010515 0 -1 0.077038 -1.058114  1 2 14 1 2 22 0 -1 14 1 1 22 0 2 haar_x2 0.016969 0 -1\n"
" 0.143067 -0.858284  1 2 8 1 2 22 0 -1 9 1 1 22 0 2 haar_x2 -0.007246 0 -1 -1.102013 0.064907 \n"
" 1 2 17 6 3 18 0 -1 18 6 1 18 0 3 haar_x3 0.010557 0 -1 0.013964 0.636015  1 2 6 14 9 6 0 -1\n"
" 6 16 9 2 0 3 haar_y3 0.006138 0 -1 -0.345459 0.562968  1 2 13 14 9 4 0 -1 13 16 9 2 0 2\n"
" haar_y2 0.013158 0 -1 0.199273 -1.504032  1 2 3 18 18 3 0 -1 3 19 18 1 0 3 haar_y3\n"
" 0.003131 0 -1 -0.409037 0.377964  1 3 9 4 8 18 0 -1 13 4 4 9 0 2 9 13 4 9 0 2 haar_x2_y2\n"
" -0.109207 0 -1 -2.222708 0.121782  1 2 0 17 18 3 0 -1 0 18 18 1 0 3 haar_y3 0.008182 0 -1\n"
" -0.286520 0.678908  -4.129930\n"
,

/* Stage 6 */
" 62 1 2 0 2 12 4 0 -1 6 2 6 4 0 2 haar_x2 0.031347 0 -1 -0.888846 0.949368  1 2 6 8 14 6 0 -1\n"
" 6 11 14 3 0 2 haar_y2 0.031918 0 -1 -1.114688 0.488890  1 2 7 5 6 6 0 -1 10 5 3 6 0 2\n"
" haar_x2 0.006594 0 -1 -1.009769 0.497238  1 2 10 5 6 16 0 -1 10 13 6 8 0 2 haar_y2\n"
" 0.026148 0 -1 0.259913 -1.253748  1 2 1 4 9 16 0 -1 4 4 3 16 0 3 haar_x3 0.012845 0 -1\n"
" -0.571386 0.596595  1 2 5 0 18 9 0 -1 5 3 18 3 0 3 haar_y3 0.026345 0 -1 -0.552032 0.302174 \n"
" 1 2 9 15 5 8 0 -1 9 19 5 4 0 2 haar_y2 -0.015083 0 -1 -1.287124 0.223542  1 2 20 0 4 9 0 -1\n"
" 20 0 2 9 0 2 haar_x2 -0.038887 0 -1 1.742505 -0.099747  1 2 2 0 18 3 0 -1 2 1 18 1 0 3\n"
" haar_y3 -0.005703 0 -1 -1.052324 0.183626  1 2 5 22 19 2 0 -1 5 23 19 1 0 2 haar_y2\n"
" -0.001486 0 -1 0.567842 -0.467420  1 2 0 0 4 9 0 -1 2 0 2 9 0 2 haar_x2 -0.028486 0 -1\n"
" 1.308291 -0.264609  1 2 5 6 19 18 0 -1 5 12 19 6 0 3 haar_y3 0.066225 0 -1 -0.462107 0.417496 \n"
" 1 2 0 1 6 9 0 -1 2 1 2 9 0 3 haar_x3 0.008857 0 -1 -0.414749 0.592048  1 3 6 5 14 12 0 -1\n"
" 13 5 7 6 0 2 6 11 7 6 0 2 haar_x2_y2 0.011356 0 -1 0.361031 -0.457812  1 2 0 1 20 2 0 -1\n"
" 0 2 20 1 0 2 haar_y2 -0.002768 0 -1 -0.892389 0.141990  1 2 1 2 22 3 0 -1 1 3 22 1 0 3\n"
" haar_y3 0.011247 0 -1 0.293534 -0.973306  1 2 2 8 7 9 0 -1 2 11 7 3 0 3 haar_y3 0.007197 0 -1\n"
" -0.793349 0.183134  1 3 2 12 22 4 0 -1 13 12 11 2 0 2 2 14 11 2 0 2 haar_x2_y2 0.031769 0 -1\n"
" 0.155231 -1.324564  1 3 0 12 22 4 0 -1 0 12 11 2 0 2 11 14 11 2 0 2 haar_x2_y2 0.025174 0 -1\n"
" 0.034215 -2.094813  1 2 9 7 6 11 0 -1 11 7 2 11 0 3 haar_x3 0.007536 0 -1 -0.394506 0.513340 \n"
" 1 2 7 1 9 6 0 -1 10 1 3 6 0 3 haar_x3 0.032873 0 -1 0.088373 -1.281412  1 2 11 2 4 10 0 -1\n"
" 11 7 4 5 0 2 haar_y2 -0.002738 0 -1 0.552865 -0.463850  1 2 6 4 12 12 0 -1 6 10 12 6 0 2\n"
" haar_y2 -0.038075 0 -1 -1.849727 0.045944  1 2 18 1 6 15 0 -1 18 6 6 5 0 3 haar_y3\n"
" -0.038984 0 -1 -0.482237 0.347606  1 2 3 15 18 3 0 -1 3 16 18 1 0 3 haar_y3 0.002803 0 -1\n"
" -0.451547 0.428063  1 2 18 5 6 9 0 -1 18 8 6 3 0 3 haar_y3 -0.054146 0 -1 -0.845208 0.166749 \n"
" 1 3 1 5 16 6 0 -1 1 5 8 3 0 2 9 8 8 3 0 2 haar_x2_y2 -0.008328 0 -1 0.353483 -0.471632 \n"
" 1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3 0.033778 0 -1 0.184631 -1.668667  1 3 0 4 24 14 0 -1\n"
" 0 4 12 7 0 2 12 11 12 7 0 2 haar_x2_y2 -0.112381 0 -1 -1.252157 0.035992  1 2 13 0 4 13 0 -1\n"
" 13 0 2 13 0 2 haar_x2 -0.010408 0 -1 -0.816204 0.234286  1 2 7 0 4 13 0 -1 9 0 2 13 0 2\n"
" haar_x2 -0.004944 0 -1 -0.925847 0.100348  1 2 11 6 6 9 0 -1 13 6 2 9 0 3 haar_x3\n"
" -0.009303 0 -1 0.564993 -0.188819  1 2 8 7 6 9 0 -1 10 7 2 9 0 3 haar_x3 -0.011750 0 -1\n"
" 0.803024 -0.382770  1 2 13 17 9 6 0 -1 13 19 9 2 0 3 haar_y3 -0.023217 0 -1 -0.849270 0.196712 \n"
" 1 3 2 18 14 6 0 -1 2 18 7 3 0 2 9 21 7 3 0 2 haar_x2_y2 0.016866 0 -1 -0.405919 0.506953 \n"
" 1 3 3 18 18 4 0 -1 12 18 9 2 0 2 3 20 9 2 0 2 haar_x2_y2 -0.024031 0 -1 -1.529752 0.233450 \n"
" 1 2 0 20 15 4 0 -1 5 20 5 4 0 3 haar_x3 -0.036946 0 -1 0.630077 -0.317804  1 2 9 15 15 9 0 -1\n"
" 14 15 5 9 0 3 haar_x3 -0.061564 0 -1 0.586279 -0.012108  1 2 4 4 16 4 0 -1 4 6 16 2 0 2\n"
" haar_y2 0.021661 0 -1 -0.256237 1.040985  1 2 7 6 10 6 0 -1 7 8 10 2 0 3 haar_y3\n"
" -0.003671 0 -1 0.291711 -0.832873  1 2 0 14 15 10 0 -1 5 14 5 10 0 3 haar_x3 0.044849 0 -1\n"
" -0.396332 0.456620  1 3 7 9 10 14 0 -1 12 9 5 7 0 2 7 16 5 7 0 2 haar_x2_y2 0.057195 0 -1\n"
" 0.210239 -1.500480  1 2 7 6 6 9 0 -1 9 6 2 9 0 3 haar_x3 -0.011342 0 -1 0.440713 -0.386538 \n"
" 1 2 3 6 18 3 0 -1 3 7 18 1 0 3 haar_y3 -0.012004 0 -1 0.939546 -0.105895  1 2 0 10 18 3 0 -1\n"
" 0 11 18 1 0 3 haar_y3 0.022516 0 -1 0.009448 -1.679951  1 3 3 16 18 4 0 -1 12 16 9 2 0 2\n"
" 3 18 9 2 0 2 haar_x2_y2 -0.019809 0 -1 -1.013364 0.241466  1 3 4 6 14 6 0 -1 4 6 7 3 0 2\n"
" 11 9 7 3 0 2 haar_x2_y2 0.015891 0 -1 -0.375076 0.466141  1 2 13 0 2 18 0 -1 13 0 1 18 0 2\n"
" haar_x2 -0.009142 0 -1 -0.804841 0.178170  1 2 9 0 2 18 0 -1 10 0 1 18 0 2 haar_x2\n"
" -0.004474 0 -1 -1.056207 0.073305  1 2 5 7 15 10 0 -1 10 7 5 10 0 3 haar_x3 0.127425 0 -1\n"
" 0.201656 -1.546793  1 2 1 20 21 4 0 -1 8 20 7 4 0 3 haar_x3 0.047703 0 -1 -0.379378 0.378860 \n"
" 1 2 10 5 5 18 0 -1 10 14 5 9 0 2 haar_y2 0.053608 0 -1 0.212205 -1.239971  1 3 0 2 24 6 0 -1\n"
" 0 2 12 3 0 2 12 5 12 3 0 2 haar_x2_y2 -0.039681 0 -1 -1.025755 0.051283  1 3 1 1 22 8 0 -1\n"
" 12 1 11 4 0 2 1 5 11 4 0 2 haar_x2_y2 -0.067327 0 -1 -1.030475 0.230053  1 2 4 0 15 9 0 -1\n"
" 4 3 15 3 0 3 haar_y3 0.133376 0 -1 -0.208690 1.227251  1 2 0 0 24 19 0 -1 8 0 8 19 0 3\n"
" haar_x3 -0.209193 0 -1 0.879299 -0.044255  1 2 2 21 18 3 0 -1 11 21 9 3 0 2 haar_x2\n"
" -0.065589 0 -1 1.044343 -0.216821  1 2 9 7 10 4 0 -1 9 7 5 4 0 2 haar_x2 0.061883 0 -1\n"
" 0.137982 -1.900906  1 2 5 7 10 4 0 -1 10 7 5 4 0 2 haar_x2 -0.025579 0 -1 -1.660760 0.005844 \n"
" 1 3 17 8 6 16 0 -1 20 8 3 8 0 2 17 16 3 8 0 2 haar_x2_y2 -0.034827 0 -1 0.799404 -0.082407 \n"
" 1 3 1 15 20 4 0 -1 1 15 10 2 0 2 11 17 10 2 0 2 haar_x2_y2 -0.018210 0 -1 -0.960740 0.066320 \n"
" 1 2 14 15 10 6 0 -1 14 17 10 2 0 3 haar_y3 0.015071 0 -1 0.198994 -0.764330  -4.021809\n"
"\n"
,

/* Stage 7 */
" 72 1 2 3 0 16 9 0 -1 3 3 16 3 0 3 haar_y3 0.046325 0 -1 -1.036267 0.822015  1 2 15 6 7 15 0 -1\n"
" 15 11 7 5 0 3 haar_y3 0.015407 0 -1 -1.232759 0.296477  1 2 9 1 6 13 0 -1 11 1 2 13 0 3\n"
" haar_x3 0.012809 0 -1 -0.758523 0.579855  1 2 17 2 6 14 0 -1 17 2 3 14 0 2 haar_x2\n"
" 0.049151 0 -1 -0.389839 0.896803  1 3 3 14 12 10 0 -1 3 14 6 5 0 2 9 19 6 5 0 2 haar_x2_y2\n"
" 0.012621 0 -1 -0.717993 0.504409  1 2 7 6 10 6 0 -1 7 8 10 2 0 3 haar_y3 -0.018769 0 -1\n"
" 0.551476 -0.705554  1 2 1 2 6 14 0 -1 4 2 3 14 0 2 haar_x2 0.041965 0 -1 -0.447821 0.709855 \n"
" 1 2 10 4 5 12 0 -1 10 8 5 4 0 3 haar_y3 -0.051402 0 -1 -1.093212 0.267019  1 2 0 17 24 5 0 -1\n"
" 8 17 8 5 0 3 haar_x3 -0.070961 0 -1 0.836184 -0.383181  1 2 15 7 5 12 0 -1 15 11 5 4 0 3\n"
" haar_y3 0.016746 0 -1 -0.257331 0.259665  1 3 3 1 6 12 0 -1 3 1 3 6 0 2 6 7 3 6 0 2\n"
" haar_x2_y2 -0.006240 0 -1 0.316315 -0.587969  1 2 12 13 6 6 0 -1 12 16 6 3 0 2 haar_y2\n"
" -0.039398 0 -1 -1.049121 0.168224  1 2 6 13 6 6 0 -1 6 16 6 3 0 2 haar_y2 0.000000 0 -1\n"
" 0.161442 -0.878769  1 2 14 6 3 16 0 -1 14 14 3 8 0 2 haar_y2 -0.022308 0 -1 -0.690535 0.236070 \n"
" 1 2 1 12 13 6 0 -1 1 14 13 2 0 3 haar_y3 0.001892 0 -1 0.249892 -0.565833  1 2 13 1 4 9 0 -1\n"
" 13 1 2 9 0 2 haar_x2 0.001073 0 -1 -0.504158 0.383745  1 2 7 0 9 6 0 -1 10 0 3 6 0 3\n"
" haar_x3 0.039231 0 -1 0.042619 -1.387589  1 2 12 2 6 9 0 -1 12 2 3 9 0 2 haar_x2\n"
" 0.062238 0 -1 0.141194 -1.068886  1 2 6 2 6 9 0 -1 9 2 3 9 0 2 haar_x2 0.002140 0 -1\n"
" -0.896224 0.197964  1 2 6 18 12 6 0 -1 6 20 12 2 0 3 haar_y3 0.000918 0 -1 -0.453373 0.435327 \n"
" 1 2 7 6 6 9 0 -1 9 6 2 9 0 3 haar_x3 -0.006917 0 -1 0.338228 -0.447930  1 2 7 7 12 3 0 -1\n"
" 7 7 6 3 0 2 haar_x2 -0.023867 0 -1 -0.789086 0.225118  1 2 8 3 8 21 0 -1 8 10 8 7 0 3\n"
" haar_y3 -0.102628 0 -1 -2.283144 -0.005396  1 2 7 4 10 12 0 -1 7 8 10 4 0 3 haar_y3\n"
" -0.009524 0 -1 0.393467 -0.522422  1 2 0 1 6 9 0 -1 0 4 6 3 0 3 haar_y3 0.039877 0 -1\n"
" 0.032799 -1.507949  1 2 15 2 2 20 0 -1 15 2 1 20 0 2 haar_x2 -0.013145 0 -1 -1.083999 0.184824 \n"
" 1 2 0 3 6 9 0 -1 0 6 6 3 0 3 haar_y3 -0.050591 0 -1 -1.882229 -0.002220  1 2 15 3 2 21 0 -1\n"
" 15 3 1 21 0 2 haar_x2 0.024917 0 -1 0.145934 -2.219652  1 2 7 0 2 23 0 -1 8 0 1 23 0 2\n"
" haar_x2 -0.007637 0 -1 -1.016457 0.058797  1 2 15 8 9 4 0 -1 15 10 9 2 0 2 haar_y2\n"
" 0.042912 0 -1 0.154430 -1.184389  1 2 0 8 9 4 0 -1 0 10 9 2 0 2 haar_y2 0.000230 0 -1\n"
" -0.773058 0.121899  1 2 8 14 9 6 0 -1 8 16 9 2 0 3 haar_y3 0.009093 0 -1 -0.114501 0.710913 \n"
" 1 2 0 14 9 6 0 -1 0 16 9 2 0 3 haar_y3 0.011145 0 -1 0.070001 -1.053482  1 2 3 10 18 4 0 -1\n"
" 9 10 6 4 0 3 haar_x3 -0.052453 0 -1 -1.759436 0.195238  1 2 0 0 24 19 0 -1 8 0 8 19 0 3\n"
" haar_x3 -0.230207 0 -1 0.958403 -0.250457  1 2 9 1 8 12 0 -1 9 7 8 6 0 2 haar_y2\n"
" -0.016366 0 -1 0.467319 -0.211084  1 2 10 6 4 10 0 -1 12 6 2 10 0 2 haar_x2 -0.017208 0 -1\n"
" 0.708357 -0.280183  1 3 7 9 10 12 0 -1 12 9 5 6 0 2 7 15 5 6 0 2 haar_x2_y2 -0.036648 0 -1\n"
" -1.101334 0.243411  1 2 5 0 3 19 0 -1 6 0 1 19 0 3 haar_x3 -0.010305 0 -1 -1.093313 0.056259 \n"
" 1 2 14 0 6 10 0 -1 16 0 2 10 0 3 haar_x3 -0.013713 0 -1 -0.264381 0.198210  1 3 2 0 6 12 0 -1\n"
" 2 0 3 6 0 2 5 6 3 6 0 2 haar_x2_y2 0.029308 0 -1 -0.221424 1.052595  1 2 0 11 24 2 0 -1\n"
" 0 12 24 1 0 2 haar_y2 0.024077 0 -1 0.184857 -1.720397  1 2 4 9 13 4 0 -1 4 11 13 2 0 2\n"
" haar_y2 0.006128 0 -1 -0.927215 0.058753  1 2 9 8 6 9 0 -1 9 11 6 3 0 3 haar_y3 -0.022378 0 -1\n"
" 1.964656 0.027786  1 2 0 12 16 4 0 -1 0 14 16 2 0 2 haar_y2 -0.007044 0 -1 0.214276 -0.484076 \n"
" 1 2 18 12 6 9 0 -1 18 15 6 3 0 3 haar_y3 -0.040603 0 -1 -1.175435 0.160612  1 2 0 12 6 9 0 -1\n"
" 0 15 6 3 0 3 haar_y3 -0.024466 0 -1 -1.123990 0.041110  1 2 8 7 10 4 0 -1 8 7 5 4 0 2\n"
" haar_x2 0.002531 0 -1 -0.171697 0.321788  1 2 8 7 6 9 0 -1 10 7 2 9 0 3 haar_x3 -0.019589 0 -1\n"
" 0.827202 -0.263767  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3 -0.029636 0 -1 -1.152477 0.149993 \n"
" 1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 -0.015030 0 -1 -1.049183 0.040161  1 2 12 3 6 15 0 -1\n"
" 14 3 2 15 0 3 haar_x3 -0.060715 0 -1 -1.090384 0.153308  1 2 6 3 6 15 0 -1 8 3 2 15 0 3\n"
" haar_x3 -0.012790 0 -1 0.422486 -0.423992  1 2 15 2 9 4 0 -1 15 4 9 2 0 2 haar_y2\n"
" -0.020248 0 -1 -0.918670 0.184857  1 2 5 10 6 7 0 -1 8 10 3 7 0 2 haar_x2 -0.030684 0 -1\n"
" -1.595867 0.002576  1 2 9 14 6 10 0 -1 9 19 6 5 0 2 haar_y2 -0.020718 0 -1 -0.663000 0.310372 \n"
" 1 2 7 13 5 8 0 -1 7 17 5 4 0 2 haar_y2 -0.001729 0 -1 0.191834 -0.650850  1 2 14 5 3 16 0 -1\n"
" 14 13 3 8 0 2 haar_y2 -0.031394 0 -1 -0.636430 0.154084  1 2 2 17 18 3 0 -1 2 18 18 1 0 3\n"
" haar_y3 0.019003 0 -1 -0.189194 1.529451  1 2 5 18 19 3 0 -1 5 19 19 1 0 3 haar_y3\n"
" 0.006177 0 -1 -0.105979 0.648596  1 2 9 0 6 9 0 -1 11 0 2 9 0 3 haar_x3 -0.010166 0 -1\n"
" -1.080270 0.037176  1 2 12 4 3 18 0 -1 13 4 1 18 0 3 haar_x3 -0.001417 0 -1 0.341575 -0.097738 \n"
" 1 2 9 4 3 18 0 -1 10 4 1 18 0 3 haar_x3 -0.004080 0 -1 0.476246 -0.343663  1 2 3 3 18 9 0 -1\n"
" 9 3 6 9 0 3 haar_x3 -0.044097 0 -1 0.976343 -0.019173  1 2 6 1 6 14 0 -1 8 1 2 14 0 3\n"
" haar_x3 -0.060670 0 -1 -2.175285 -0.028926  1 2 12 16 9 6 0 -1 12 19 9 3 0 2 haar_y2\n"
" -0.032932 0 -1 -0.643831 0.164941  1 3 1 3 20 16 0 -1 1 3 10 8 0 2 11 11 10 8 0 2\n"
" haar_x2_y2 -0.147228 0 -1 -1.474583 0.002584  1 3 12 5 6 12 0 -1 15 5 3 6 0 2 12 11 3 6 0 2\n"
" haar_x2_y2 -0.011930 0 -1 0.424414 -0.177126  1 3 1 2 22 16 0 -1 1 2 11 8 0 2 12 10 11 8 0 2\n"
" haar_x2_y2 0.145179 0 -1 0.025445 -1.277940  1 2 10 14 5 10 0 -1 10 19 5 5 0 2 haar_y2\n"
" 0.051448 0 -1 0.156784 -1.518843  1 2 3 21 18 3 0 -1 3 22 18 1 0 3 haar_y3 0.003148 0 -1\n"
" -0.404244 0.324297  1 2 10 14 6 10 0 -1 12 14 2 10 0 3 haar_x3 -0.043600 0 -1 -1.993226 0.150186 \n"
" -3.883209\n"
,

/* Stage 8 */
" 83 1 2 0 2 24 4 0 -1 8 2 8 4 0 3 haar_x3 0.128996 0 -1 -0.621620 1.111652  1 2 6 4 12 9 0 -1\n"
" 6 7 12 3 0 3 haar_y3 -0.091262 0 -1 1.014306 -0.613352  1 2 6 6 12 5 0 -1 10 6 4 5 0 3\n"
" haar_x3 0.014272 0 -1 -1.026166 0.397800  1 2 5 8 14 12 0 -1 5 12 14 4 0 3 haar_y3\n"
" 0.032890 0 -1 -1.138608 0.286908  1 3 4 14 8 10 0 -1 4 14 4 5 0 2 8 19 4 5 0 2 haar_x2_y2\n"
" 0.012590 0 -1 -0.566456 0.451724  1 2 11 6 5 14 0 -1 11 13 5 7 0 2 haar_y2 0.014661 0 -1\n"
" 0.305060 -0.681296  1 2 7 6 3 16 0 -1 7 14 3 8 0 2 haar_y2 -0.033556 0 -1 -1.720894 0.061439 \n"
" 1 2 3 7 18 8 0 -1 9 7 6 8 0 3 haar_x3 0.142527 0 -1 0.231922 -1.729715  1 2 2 3 20 2 0 -1\n"
" 2 4 20 1 0 2 haar_y2 -0.006208 0 -1 -1.216330 0.121602  1 2 3 12 19 6 0 -1 3 14 19 2 0 3\n"
" haar_y3 0.018179 0 -1 0.325537 -0.810040  1 2 8 6 6 9 0 -1 10 6 2 9 0 3 haar_x3 0.025037 0 -1\n"
" -0.316988 0.673614  1 2 16 6 6 14 0 -1 16 6 3 14 0 2 haar_x2 0.046561 0 -1 -0.110898 0.840825 \n"
" 1 2 7 9 6 12 0 -1 9 9 2 12 0 3 haar_x3 -0.009000 0 -1 0.395745 -0.476246  1 3 18 6 6 18 0 -1\n"
" 21 6 3 9 0 2 18 15 3 9 0 2 haar_x2_y2 0.040806 0 -1 -0.000180 0.945707  1 3 0 6 6 18 0 -1\n"
" 0 6 3 9 0 2 3 15 3 9 0 2 haar_x2_y2 -0.034222 0 -1 0.752063 -0.315315  1 2 18 2 6 9 0 -1\n"
" 18 5 6 3 0 3 haar_y3 -0.039716 0 -1 -0.831396 0.177444  1 2 3 18 15 6 0 -1 3 20 15 2 0 3\n"
" haar_y3 0.002517 0 -1 -0.593780 0.246570  1 2 18 2 6 9 0 -1 18 5 6 3 0 3 haar_y3\n"
" 0.027429 0 -1 0.159984 -0.427820  1 2 0 2 6 9 0 -1 0 5 6 3 0 3 haar_y3 0.034986 0 -1\n"
" 0.035056 -1.598860  1 2 5 10 18 2 0 -1 5 11 18 1 0 2 haar_y2 0.004497 0 -1 -0.520343 0.378283 \n"
" 1 2 6 0 12 6 0 -1 6 2 12 2 0 3 haar_y3 0.002770 0 -1 -0.531826 0.249510  1 2 10 0 6 9 0 -1\n"
" 12 0 2 9 0 3 haar_x3 0.035174 0 -1 0.199834 -1.444613  1 2 8 0 6 9 0 -1 10 0 2 9 0 3\n"
" haar_x3 0.025971 0 -1 0.044427 -1.362298  1 2 15 12 9 6 0 -1 15 14 9 2 0 3 haar_y3\n"
" -0.015784 0 -1 -0.910204 0.271903  1 2 3 6 13 6 0 -1 3 8 13 2 0 3 haar_y3 -0.007588 0 -1\n"
" 0.092065 -0.816289  1 2 15 12 9 6 0 -1 15 14 9 2 0 3 haar_y3 0.020754 0 -1 0.211857 -0.747290 \n"
" 1 2 2 5 6 15 0 -1 5 5 3 15 0 2 haar_x2 0.059829 0 -1 -0.273011 0.809233  1 2 8 8 9 6 0 -1\n"
" 11 8 3 6 0 3 haar_x3 0.039039 0 -1 -0.104323 0.862262  1 2 8 6 3 14 0 -1 8 13 3 7 0 2\n"
" haar_y2 0.021666 0 -1 0.062709 -0.988943  1 2 15 12 9 6 0 -1 15 14 9 2 0 3 haar_y3\n"
" -0.027497 0 -1 -0.926910 0.155863  1 2 4 12 10 4 0 -1 9 12 5 4 0 2 haar_x2 0.010462 0 -1\n"
" 0.134181 -0.703864  1 2 13 1 4 19 0 -1 13 1 2 19 0 2 haar_x2 0.024871 0 -1 0.197067 -0.402633 \n"
" 1 2 7 1 4 19 0 -1 9 1 2 19 0 2 haar_x2 -0.016036 0 -1 -1.140983 0.073998  1 2 18 9 6 9 0 -1\n"
" 18 12 6 3 0 3 haar_y3 0.048627 0 -1 0.169904 -0.721522  1 2 1 21 18 3 0 -1 1 22 18 1 0 3\n"
" haar_y3 0.001262 0 -1 -0.473898 0.262550  1 2 14 13 10 9 0 -1 14 16 10 3 0 3 haar_y3\n"
" -0.088035 0 -1 -2.160652 0.145548  1 3 1 13 22 4 0 -1 1 13 11 2 0 2 12 15 11 2 0 2\n"
" haar_x2_y2 0.018357 0 -1 0.044751 -1.076637  1 3 4 6 16 6 0 -1 12 6 8 3 0 2 4 9 8 3 0 2\n"
" haar_x2_y2 0.035275 0 -1 -0.032919 1.215389  1 3 1 0 18 22 0 -1 1 0 9 11 0 2 10 11 9 11 0 2\n"
" haar_x2_y2 -0.203929 0 -1 -1.318800 0.015504  1 3 10 7 8 14 0 -1 14 7 4 7 0 2 10 14 4 7 0 2\n"
" haar_x2_y2 -0.016619 0 -1 0.368502 -0.152837  1 3 0 4 6 20 0 -1 0 4 3 10 0 2 3 14 3 10 0 2\n"
" haar_x2_y2 0.037739 0 -1 -0.257278 0.706553  1 2 15 0 6 9 0 -1 17 0 2 9 0 3 haar_x3\n"
" 0.002272 0 -1 -0.077603 0.333678  1 2 3 0 6 9 0 -1 5 0 2 9 0 3 haar_x3 -0.014803 0 -1\n"
" -0.785248 0.076934  1 3 15 12 6 12 0 -1 18 12 3 6 0 2 15 18 3 6 0 2 haar_x2_y2 -0.048319 0 -1\n"
" 1.702232 0.049722  1 3 3 12 6 12 0 -1 3 12 3 6 0 2 6 18 3 6 0 2 haar_x2_y2 -0.029539 0 -1\n"
" 0.776707 -0.245343  1 2 15 12 9 6 0 -1 15 14 9 2 0 3 haar_y3 -0.046169 0 -1 -1.492278 0.123400 \n"
" 1 2 0 12 9 6 0 -1 0 14 9 2 0 3 haar_y3 -0.028065 0 -1 -2.134537 -0.025797  1 2 4 14 19 3 0 -1\n"
" 4 15 19 1 0 3 haar_y3 -0.005734 0 -1 0.569826 -0.120566  1 2 2 13 19 3 0 -1 2 14 19 1 0 3\n"
" haar_y3 -0.010111 0 -1 0.679114 -0.266380  1 2 14 15 10 6 0 -1 14 17 10 2 0 3 haar_y3\n"
" 0.011360 0 -1 0.247898 -0.644930  1 3 6 0 10 12 0 -1 6 0 5 6 0 2 11 6 5 6 0 2 haar_x2_y2\n"
" 0.051809 0 -1 0.014716 -1.239558  1 3 17 1 6 12 0 -1 20 1 3 6 0 2 17 7 3 6 0 2 haar_x2_y2\n"
" 0.033292 0 -1 -0.008256 1.016847  1 3 1 1 6 12 0 -1 1 1 3 6 0 2 4 7 3 6 0 2 haar_x2_y2\n"
" -0.014494 0 -1 0.450668 -0.362510  1 2 16 14 6 9 0 -1 16 17 6 3 0 3 haar_y3 -0.034222 0 -1\n"
" -0.952925 0.206846  1 2 7 3 9 12 0 -1 7 9 9 6 0 2 haar_y2 -0.080654 0 -1 -2.013950 -0.023085 \n"
" 1 2 12 1 4 12 0 -1 12 7 4 6 0 2 haar_y2 -0.000894 0 -1 0.395720 -0.293513  1 2 4 0 14 8 0 -1\n"
" 4 4 14 4 0 2 haar_y2 0.097162 0 -1 -0.249803 1.085922  1 2 10 6 6 9 0 -1 12 6 2 9 0 3\n"
" haar_x3 0.036614 0 -1 -0.057844 1.216216  1 2 2 10 18 3 0 -1 8 10 6 3 0 3 haar_x3\n"
" 0.051694 0 -1 0.043063 -1.063616  1 2 15 15 9 6 0 -1 15 17 9 2 0 3 haar_y3 -0.024557 0 -1\n"
" -0.489468 0.171829  1 2 0 1 21 23 0 -1 7 1 7 23 0 3 haar_x3 0.327368 0 -1 -0.296886 0.517983 \n"
" 1 2 6 9 17 4 0 -1 6 11 17 2 0 2 haar_y2 0.007696 0 -1 -0.598059 0.248032  1 2 1 0 11 18 0 -1\n"
" 1 6 11 6 0 3 haar_y3 0.161722 0 -1 -0.029614 -2.316253  1 2 6 15 13 6 0 -1 6 17 13 2 0 3\n"
" haar_y3 -0.004789 0 -1 0.374579 -0.327792  1 2 0 15 9 6 0 -1 0 17 9 2 0 3 haar_y3\n"
" -0.018403 0 -1 -0.996927 0.072948  1 2 8 7 15 4 0 -1 13 7 5 4 0 3 haar_x3 0.077665 0 -1\n"
" 0.141757 -1.723873  1 2 9 12 6 9 0 -1 9 15 6 3 0 3 haar_y3 0.018921 0 -1 -0.212731 1.016519 \n"
" 1 2 6 8 18 3 0 -1 12 8 6 3 0 3 haar_x3 -0.079398 0 -1 -1.316435 0.149820  1 2 0 14 24 4 0 -1\n"
" 8 14 8 4 0 3 haar_x3 -0.068037 0 -1 0.494220 -0.290910  1 2 16 10 3 12 0 -1 16 16 3 6 0 2\n"
" haar_y2 -0.006101 0 -1 0.424305 -0.338993  1 2 0 3 24 3 0 -1 0 4 24 1 0 3 haar_y3\n"
" 0.031927 0 -1 -0.031047 -2.346000  1 2 14 17 10 6 0 -1 14 19 10 2 0 3 haar_y3 -0.029844 0 -1\n"
" -0.789896 0.154177  1 2 1 13 18 3 0 -1 7 13 6 3 0 3 haar_x3 -0.080542 0 -1 -2.250923 -0.030907 \n"
" 1 2 5 0 18 9 0 -1 5 3 18 3 0 3 haar_y3 0.003811 0 -1 -0.255773 0.237855  1 2 4 3 16 9 0 -1\n"
" 4 6 16 3 0 3 haar_y3 0.033647 0 -1 -0.225414 0.923074  1 2 16 5 3 12 0 -1 16 11 3 6 0 2\n"
" haar_y2 0.008281 0 -1 -0.288962 0.310462  1 2 0 7 18 4 0 -1 6 7 6 4 0 3 haar_x3 0.101044 0 -1\n"
" -0.034864 -2.710262  1 2 10 6 6 9 0 -1 12 6 2 9 0 3 haar_x3 -0.010009 0 -1 0.597154 -0.033831 \n"
" 1 2 9 8 6 10 0 -1 11 8 2 10 0 3 haar_x3 0.007192 0 -1 -0.477380 0.226860  1 2 9 15 6 9 0 -1\n"
" 11 15 2 9 0 3 haar_x3 0.024969 0 -1 0.228777 -1.043553  1 2 3 1 18 21 0 -1 12 1 9 21 0 2\n"
" haar_x2 0.279080 0 -1 -0.258181 0.767805  1 2 6 8 12 7 0 -1 6 8 6 7 0 2 haar_x2 -0.044213 0 -1\n"
" -0.597980 0.280399  1 2 8 5 6 9 0 -1 10 5 2 9 0 3 haar_x3 -0.014137 0 -1 0.709873 -0.256452 \n"
" -3.842491\n"
,

/* Stage 9 */
" 91 1 2 0 2 24 4 0 -1 8 2 8 4 0 3 haar_x3 0.137712 0 -1 -0.558706 1.095377  1 2 14 7 5 12 0 -1\n"
" 14 11 5 4 0 3 haar_y3 0.034461 0 -1 -0.711719 0.528996  1 2 5 7 5 12 0 -1 5 11 5 4 0 3\n"
" haar_y3 0.018580 0 -1 -1.115752 0.405940  1 2 9 6 6 9 0 -1 11 6 2 9 0 3 haar_x3 0.025042 0 -1\n"
" -0.408925 0.741300  1 2 0 1 6 17 0 -1 3 1 3 17 0 2 haar_x2 0.057179 0 -1 -0.380543 0.736477 \n"
" 1 2 3 1 19 9 0 -1 3 4 19 3 0 3 haar_y3 0.014932 0 -1 -0.699455 0.379510  1 3 3 18 12 6 0 -1\n"
" 3 18 6 3 0 2 9 21 6 3 0 2 haar_x2_y2 0.008890 0 -1 -0.545586 0.363325  1 2 20 4 4 19 0 -1\n"
" 20 4 2 19 0 2 haar_x2 0.030436 0 -1 -0.101246 0.795859  1 2 0 16 10 7 0 -1 5 16 5 7 0 2\n"
" haar_x2 -0.044160 0 -1 0.844109 -0.329764  1 3 8 7 10 12 0 -1 13 7 5 6 0 2 8 13 5 6 0 2\n"
" haar_x2_y2 0.018461 0 -1 0.263266 -0.967365  1 3 6 7 10 12 0 -1 6 7 5 6 0 2 11 13 5 6 0 2\n"
" haar_x2_y2 0.010615 0 -1 0.152519 -1.058987  1 2 9 2 9 6 0 -1 12 2 3 6 0 3 haar_x3\n"
" -0.045974 0 -1 -1.991834 0.136291  1 2 1 20 21 4 0 -1 8 20 7 4 0 3 haar_x3 0.082900 0 -1\n"
" -0.320372 0.603042  1 2 9 12 9 6 0 -1 9 14 9 2 0 3 haar_y3 -0.008913 0 -1 0.595866 -0.211396 \n"
" 1 2 7 2 9 6 0 -1 10 2 3 6 0 3 haar_x3 0.042814 0 -1 0.022925 -1.467933  1 2 13 0 4 14 0 -1\n"
" 13 0 2 14 0 2 haar_x2 -0.008714 0 -1 -0.439895 0.204397  1 2 7 0 4 14 0 -1 9 0 2 14 0 2\n"
" haar_x2 -0.004339 0 -1 -0.890668 0.104700  1 2 14 15 9 6 0 -1 14 17 9 2 0 3 haar_y3\n"
" 0.008075 0 -1 0.211642 -0.402316  1 2 2 8 18 5 0 -1 8 8 6 5 0 3 haar_x3 0.096739 0 -1\n"
" 0.013320 -1.608536  1 2 18 3 6 11 0 -1 20 3 2 11 0 3 haar_x3 -0.030537 0 -1 1.006374 -0.134133 \n"
" 1 2 6 5 11 14 0 -1 6 12 11 7 0 2 haar_y2 -0.060856 0 -1 -1.468998 0.009424  1 2 18 4 6 9 0 -1\n"
" 18 7 6 3 0 3 haar_y3 -0.038162 0 -1 -0.816364 0.261712  1 2 7 6 9 6 0 -1 7 8 9 2 0 3\n"
" haar_y3 -0.009696 0 -1 0.115617 -0.716932  1 2 18 4 6 9 0 -1 18 7 6 3 0 3 haar_y3\n"
" 0.048903 0 -1 0.130505 -1.644837  1 2 0 4 6 9 0 -1 0 7 6 3 0 3 haar_y3 -0.041612 0 -1\n"
" -1.179584 0.025017  1 2 9 4 9 4 0 -1 9 6 9 2 0 2 haar_y2 -0.020188 0 -1 0.631882 -0.104904 \n"
" 1 2 0 22 19 2 0 -1 0 23 19 1 0 2 haar_y2 -0.000979 0 -1 0.185078 -0.535659  1 2 17 14 6 9 0 -1\n"
" 17 17 6 3 0 3 haar_y3 -0.033622 0 -1 -0.931276 0.200715  1 2 1 14 6 9 0 -1 1 17 6 3 0 3\n"
" haar_y3 0.019456 0 -1 0.038029 -1.011221  1 2 14 11 4 9 0 -1 14 11 2 9 0 2 haar_x2\n"
" -0.000318 0 -1 0.364577 -0.276109  1 2 6 11 4 9 0 -1 8 11 2 9 0 2 haar_x2 -0.000389 0 -1\n"
" 0.196659 -0.534105  1 2 3 9 18 7 0 -1 9 9 6 7 0 3 haar_x3 -0.093496 0 -1 -1.677235 0.207271 \n"
" 1 2 9 12 6 10 0 -1 9 17 6 5 0 2 haar_y2 -0.077878 0 -1 -3.076063 -0.035804  1 2 12 0 6 9 0 -1\n"
" 14 0 2 9 0 3 haar_x3 0.016948 0 -1 0.214474 -0.713763  1 2 6 0 6 9 0 -1 8 0 2 9 0 3\n"
" haar_x3 -0.021459 0 -1 -1.146806 0.015856  1 2 6 17 18 3 0 -1 6 18 18 1 0 3 haar_y3\n"
" -0.012866 0 -1 0.838124 -0.065944  1 2 1 17 18 3 0 -1 1 18 18 1 0 3 haar_y3 0.007822 0 -1\n"
" -0.280268 0.793769  1 2 10 6 11 12 0 -1 10 12 11 6 0 2 haar_y2 0.102944 0 -1 0.178323 -0.684122 \n"
" 1 3 5 6 14 6 0 -1 5 6 7 3 0 2 12 9 7 3 0 2 haar_x2_y2 -0.037488 0 -1 0.961900 -0.217356 \n"
" 1 2 5 4 15 4 0 -1 5 6 15 2 0 2 haar_y2 0.025506 0 -1 0.010104 1.246111  1 2 0 0 22 2 0 -1\n"
" 0 1 22 1 0 2 haar_y2 0.000667 0 -1 -0.534882 0.147463  1 2 0 0 24 24 0 -1 8 0 8 24 0 3\n"
" haar_x3 -0.288679 0 -1 0.821728 -0.014948  1 2 1 15 18 4 0 -1 10 15 9 4 0 2 haar_x2\n"
" 0.091295 0 -1 -0.196054 1.080317  1 2 6 8 12 9 0 -1 6 11 12 3 0 3 haar_y3 0.120566 0 -1\n"
" -0.023849 1.139261  1 2 4 12 7 12 0 -1 4 16 7 4 0 3 haar_y3 -0.073775 0 -1 -1.358384 -0.004204 \n"
" 1 3 1 2 22 6 0 -1 12 2 11 3 0 2 1 5 11 3 0 2 haar_x2_y2 -0.033128 0 -1 -0.644832 0.241422 \n"
" 1 2 5 20 14 3 0 -1 12 20 7 3 0 2 haar_x2 -0.043937 0 -1 0.842854 -0.206248  1 3 0 0 24 16 0 -1\n"
" 12 0 12 8 0 2 0 8 12 8 0 2 haar_x2_y2 0.181102 0 -1 0.192121 -1.222214  1 3 3 13 18 4 0 -1\n"
" 3 13 9 2 0 2 12 15 9 2 0 2 haar_x2_y2 -0.011851 0 -1 -0.726774 0.052688  1 2 2 10 22 2 0 -1\n"
" 2 11 22 1 0 2 haar_y2 0.004592 0 -1 -0.363052 0.292238  1 2 6 3 11 8 0 -1 6 7 11 4 0 2\n"
" haar_y2 0.007062 0 -1 0.058116 -0.671616  1 2 14 5 6 6 0 -1 14 8 6 3 0 2 haar_y2\n"
" -0.023715 0 -1 0.471421 0.018580  1 2 0 7 24 6 0 -1 0 9 24 2 0 3 haar_y3 -0.067172 0 -1\n"
" -1.133189 0.023781  1 3 14 0 10 10 0 -1 19 0 5 5 0 2 14 5 5 5 0 2 haar_x2_y2 -0.065310 0 -1\n"
" 0.982535 0.028362  1 3 0 0 10 10 0 -1 0 0 5 5 0 2 5 5 5 5 0 2 haar_x2_y2 0.022791 0 -1\n"
" -0.282137 0.589934  1 3 0 1 24 4 0 -1 12 1 12 2 0 2 0 3 12 2 0 2 haar_x2_y2 -0.019038 0 -1\n"
" -0.637115 0.265146  1 2 0 17 18 3 0 -1 0 18 18 1 0 3 haar_y3 -0.006869 0 -1 0.374873 -0.332321 \n"
" 1 3 5 15 16 6 0 -1 13 15 8 3 0 2 5 18 8 3 0 2 haar_x2_y2 -0.040146 0 -1 -1.304873 0.157243 \n"
" 1 3 3 15 16 6 0 -1 3 15 8 3 0 2 11 18 8 3 0 2 haar_x2_y2 -0.040531 0 -1 -2.045805 -0.026926 \n"
" 1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 -0.012254 0 -1 0.776494 -0.042971  1 2 0 13 21 10 0 -1\n"
" 0 18 21 5 0 2 haar_y2 -0.027220 0 -1 0.174244 -0.446009  1 2 13 0 6 24 0 -1 15 0 2 24 0 3\n"
" haar_x3 -0.088366 0 -1 -1.503642 0.142899  1 2 7 4 6 11 0 -1 9 4 2 11 0 3 haar_x3\n"
" -0.007916 0 -1 0.286667 -0.379237  1 2 9 5 9 6 0 -1 12 5 3 6 0 3 haar_x3 -0.041960 0 -1\n"
" 1.384695 0.065027  1 2 1 4 2 20 0 -1 1 14 2 10 0 2 haar_y2 0.045663 0 -1 -0.224523 0.795210 \n"
" 1 2 13 0 6 24 0 -1 15 0 2 24 0 3 haar_x3 -0.140906 0 -1 -1.587932 0.113590  1 2 5 0 6 24 0 -1\n"
" 7 0 2 24 0 3 haar_x3 -0.059216 0 -1 -1.194596 -0.007164  1 3 16 7 6 14 0 -1 19 7 3 7 0 2\n"
" 16 14 3 7 0 2 haar_x2_y2 0.004339 0 -1 -0.155287 0.406645  1 2 4 7 4 12 0 -1 6 7 2 12 0 2\n"
" haar_x2 -0.002037 0 -1 0.259279 -0.383683  1 2 0 5 24 14 0 -1 8 5 8 14 0 3 haar_x3\n"
" 0.275165 0 -1 -0.088498 0.767875  1 2 5 13 10 6 0 -1 5 15 10 2 0 3 haar_y3 -0.026602 0 -1\n"
" 0.750245 -0.226220  1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 0.040906 0 -1 0.121586 -1.456691 \n"
" 1 3 2 7 6 14 0 -1 2 7 3 7 0 2 5 14 3 7 0 2 haar_x2_y2 0.005532 0 -1 -0.366115 0.259686 \n"
" 1 2 15 2 9 15 0 -1 18 2 3 15 0 3 haar_x3 0.031879 0 -1 -0.075019 0.484848  1 2 0 2 6 9 0 -1\n"
" 2 2 2 9 0 3 haar_x3 -0.041482 0 -1 0.782204 -0.219922  1 3 12 2 10 14 0 -1 17 2 5 7 0 2\n"
" 12 9 5 7 0 2 haar_x2_y2 -0.096131 0 -1 -0.894563 0.146807  1 2 11 6 2 18 0 -1 12 6 1 18 0 2\n"
" haar_x2 -0.011569 0 -1 0.827141 -0.202756  1 2 9 5 15 6 0 -1 14 5 5 6 0 3 haar_x3\n"
" 0.018313 0 -1 0.016368 0.273068  1 2 8 6 6 10 0 -1 10 6 2 10 0 3 haar_x3 -0.034166 0 -1\n"
" 1.130732 -0.188109  1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 -0.024477 0 -1 -0.577913 0.158125 \n"
" 1 2 3 3 9 7 0 -1 6 3 3 7 0 3 haar_x3 0.048957 0 -1 -0.022565 -1.637328  1 2 6 7 14 3 0 -1\n"
" 6 7 7 3 0 2 haar_x2 -0.020703 0 -1 -0.545121 0.240870  1 2 7 7 8 6 0 -1 11 7 4 6 0 2\n"
" haar_x2 -0.023002 0 -1 -1.223654 -0.007344  1 2 12 7 7 12 0 -1 12 13 7 6 0 2 haar_y2\n"
" 0.064585 0 -1 0.146956 -0.449675  1 3 10 6 4 18 0 -1 10 6 2 9 0 2 12 15 2 9 0 2 haar_x2_y2\n"
" 0.012666 0 -1 -0.278739 0.438766  1 2 16 14 6 9 0 -1 16 17 6 3 0 3 haar_y3 -0.012003 0 -1\n"
" -0.242891 0.253501  1 2 4 0 6 13 0 -1 6 0 2 13 0 3 haar_x3 -0.026444 0 -1 -0.858648 0.026026 \n"
" 1 2 2 2 21 3 0 -1 9 2 7 3 0 3 haar_x3 -0.025548 0 -1 0.692879 -0.002116  1 2 5 4 5 12 0 -1\n"
" 5 8 5 4 0 3 haar_y3 0.039115 0 -1 -0.165891 1.520914  1 2 10 3 4 10 0 -1 10 8 4 5 0 2\n"
" haar_y2 -0.006033 0 -1 0.438569 -0.216137  1 2 8 4 5 8 0 -1 8 8 5 4 0 2 haar_y2 -0.033937 0 -1\n"
" -0.979984 0.022133  -3.647861\n"
,

/* Stage 10 */
" 99 1 2 6 0 11 9 0 -1 6 3 11 3 0 3 haar_y3 0.040673 0 -1 -0.904747 0.644106  1 2 6 6 12 5 0 -1\n"
" 10 6 4 5 0 3 haar_x3 0.025610 0 -1 -0.792170 0.574900  1 2 0 0 24 5 0 -1 8 0 8 5 0 3\n"
" haar_x3 0.199595 0 -1 -0.300996 1.314385  1 2 1 10 23 6 0 -1 1 12 23 2 0 3 haar_y3\n"
" 0.012405 0 -1 -0.898830 0.292058  1 2 3 21 18 3 0 -1 9 21 6 3 0 3 haar_x3 0.039208 0 -1\n"
" -0.419552 0.534633  1 2 3 6 21 6 0 -1 3 8 21 2 0 3 haar_y3 -0.030844 0 -1 0.457934 -0.446291 \n"
" 1 2 0 5 6 12 0 -1 2 5 2 12 0 3 haar_x3 -0.035523 0 -1 0.913105 -0.273732  1 2 10 2 4 15 0 -1\n"
" 10 7 4 5 0 3 haar_y3 -0.061650 0 -1 -1.469780 0.203641  1 2 8 7 8 10 0 -1 8 12 8 5 0 2\n"
" haar_y2 -0.011740 0 -1 -1.048288 0.067802  1 2 5 7 15 12 0 -1 10 7 5 12 0 3 haar_x3\n"
" 0.066934 0 -1 0.292745 -0.522829  1 2 0 17 10 6 0 -1 0 19 10 2 0 3 haar_y3 -0.020631 0 -1\n"
" -1.285514 0.044551  1 2 14 18 9 6 0 -1 14 20 9 2 0 3 haar_y3 -0.022357 0 -1 -0.857538 0.184340 \n"
" 1 2 9 6 6 16 0 -1 9 14 6 8 0 2 haar_y2 0.001150 0 -1 0.164055 -0.691250  1 2 14 18 9 6 0 -1\n"
" 14 20 9 2 0 3 haar_y3 0.035873 0 -1 0.157565 -0.842626  1 2 1 18 9 6 0 -1 1 20 9 2 0 3\n"
" haar_y3 0.030660 0 -1 0.021637 -1.363469  1 2 15 9 9 6 0 -1 15 11 9 2 0 3 haar_y3\n"
" 0.005556 0 -1 -0.167370 0.258884  1 2 0 9 9 6 0 -1 0 11 9 2 0 3 haar_y3 -0.006116 0 -1\n"
" -0.972718 0.066100  1 2 17 3 6 9 0 -1 19 3 2 9 0 3 haar_x3 -0.030317 0 -1 0.984742 -0.016448 \n"
" 1 2 2 17 18 3 0 -1 2 18 18 1 0 3 haar_y3 -0.009720 0 -1 0.476047 -0.325167  1 2 3 15 21 6 0 -1\n"
" 3 17 21 2 0 3 haar_y3 -0.057127 0 -1 -0.959207 0.199382  1 2 9 17 6 6 0 -1 9 20 6 3 0 2\n"
" haar_y2 0.004006 0 -1 -0.526125 0.224287  1 2 18 3 6 9 0 -1 18 6 6 3 0 3 haar_y3\n"
" 0.033734 0 -1 0.170701 -1.073758  1 2 0 3 6 9 0 -1 0 6 6 3 0 3 haar_y3 -0.034642 0 -1\n"
" -1.134313 0.036540  1 3 4 0 16 10 0 -1 12 0 8 5 0 2 4 5 8 5 0 2 haar_x2_y2 0.046923 0 -1\n"
" 0.258323 -0.715358  1 3 2 0 10 16 0 -1 2 0 5 8 0 2 7 8 5 8 0 2 haar_x2_y2 -0.008766 0 -1\n"
" 0.196409 -0.533551  1 2 14 0 10 5 0 -1 14 0 5 5 0 2 haar_x2 0.065628 0 -1 -0.051195 0.976107 \n"
" 1 2 0 0 10 5 0 -1 5 0 5 5 0 2 haar_x2 -0.044165 0 -1 1.063192 -0.234626  1 2 18 3 6 10 0 -1\n"
" 18 3 3 10 0 2 haar_x2 0.017305 0 -1 -0.185829 0.458899  1 3 5 11 12 6 0 -1 5 11 6 3 0 2\n"
" 11 14 6 3 0 2 haar_x2_y2 0.033136 0 -1 -0.029382 -2.665133  1 2 21 0 3 18 0 -1 22 0 1 18 0 3\n"
" haar_x3 -0.021030 0 -1 0.999799 0.024937  1 2 6 0 6 9 0 -1 8 0 2 9 0 3 haar_x3 0.029784 0 -1\n"
" -0.029606 -2.169587  1 2 8 8 9 7 0 -1 11 8 3 7 0 3 haar_x3 0.055292 0 -1 -0.000756 0.746520 \n"
" 1 3 7 12 8 10 0 -1 7 12 4 5 0 2 11 17 4 5 0 2 haar_x2_y2 -0.033598 0 -1 -1.527416 0.011060 \n"
" 1 2 21 0 3 18 0 -1 22 0 1 18 0 3 haar_x3 0.019603 0 -1 0.033575 0.995262  1 2 10 6 4 9 0 -1\n"
" 12 6 2 9 0 2 haar_x2 -0.020787 0 -1 0.766129 -0.246708  1 2 15 0 9 6 0 -1 15 2 9 2 0 3\n"
" haar_y3 0.032536 0 -1 0.162634 -0.611343  1 2 0 2 24 3 0 -1 0 3 24 1 0 3 haar_y3\n"
" -0.010788 0 -1 -0.978397 0.028970  1 2 11 7 6 9 0 -1 13 7 2 9 0 3 haar_x3 -0.009956 0 -1\n"
" 0.461458 -0.135105  1 2 7 6 6 10 0 -1 9 6 2 10 0 3 haar_x3 -0.003749 0 -1 0.254582 -0.519556 \n"
" 1 2 12 1 6 12 0 -1 14 1 2 12 0 3 haar_x3 -0.041780 0 -1 -0.805651 0.152085  1 2 6 4 12 12 0 -1\n"
" 6 10 12 6 0 2 haar_y2 -0.034221 0 -1 -1.313780 -0.003580  1 2 14 3 2 21 0 -1 14 3 1 21 0 2\n"
" haar_x2 0.010130 0 -1 0.201758 -0.613396  1 2 6 1 12 8 0 -1 6 5 12 4 0 2 haar_y2\n"
" -0.089849 0 -1 0.976328 -0.208848  1 2 3 0 18 8 0 -1 3 4 18 4 0 2 haar_y2 0.026098 0 -1\n"
" -0.188080 0.477058  1 2 3 0 18 3 0 -1 3 1 18 1 0 3 haar_y3 -0.003754 0 -1 -0.679804 0.112888 \n"
" 1 3 0 13 24 4 0 -1 12 13 12 2 0 2 0 15 12 2 0 2 haar_x2_y2 0.031973 0 -1 0.189517 -1.496748 \n"
" 1 2 10 5 4 9 0 -1 12 5 2 9 0 2 haar_x2 0.019333 0 -1 -0.236099 0.813205  1 2 11 1 6 9 0 -1\n"
" 13 1 2 9 0 3 haar_x3 0.001949 0 -1 0.248304 -0.069212  1 2 6 2 6 22 0 -1 8 2 2 22 0 3\n"
" haar_x3 -0.044147 0 -1 -1.041892 0.048053  1 3 16 10 8 14 0 -1 20 10 4 7 0 2 16 17 4 7 0 2\n"
" haar_x2_y2 -0.044682 0 -1 0.513463 -0.007380  1 2 3 4 16 15 0 -1 3 9 16 5 0 3 haar_y3\n"
" -0.107575 0 -1 1.620202 -0.186676  1 3 16 10 8 14 0 -1 20 10 4 7 0 2 16 17 4 7 0 2\n"
" haar_x2_y2 -0.128468 0 -1 2.986948 0.095428  1 3 0 10 8 14 0 -1 0 10 4 7 0 2 4 17 4 7 0 2\n"
" haar_x2_y2 -0.044758 0 -1 0.604053 -0.270587  1 2 10 14 11 6 0 -1 10 17 11 3 0 2\n"
" haar_y2 -0.043991 0 -1 -0.617905 0.159972  1 2 0 7 24 9 0 -1 8 7 8 9 0 3 haar_x3\n"
" -0.122690 0 -1 0.663272 -0.236370  1 2 13 1 4 16 0 -1 13 1 2 16 0 2 haar_x2 -0.019983 0 -1\n"
" -1.122866 0.196167  1 2 7 1 4 16 0 -1 9 1 2 16 0 2 haar_x2 -0.015528 0 -1 -1.077027 0.020693 \n"
" 1 3 5 5 16 8 0 -1 13 5 8 4 0 2 5 9 8 4 0 2 haar_x2_y2 -0.048971 0 -1 0.811683 -0.017252 \n"
" 1 2 0 9 6 9 0 -1 0 12 6 3 0 3 haar_y3 0.055976 0 -1 -0.022529 -1.735676  1 2 6 16 18 3 0 -1\n"
" 6 17 18 1 0 3 haar_y3 -0.009858 0 -1 0.678814 -0.058180  1 2 3 12 6 9 0 -1 3 15 6 3 0 3\n"
" haar_y3 0.013481 0 -1 0.057848 -0.772553  1 2 8 14 9 6 0 -1 8 16 9 2 0 3 haar_y3\n"
" 0.006561 0 -1 -0.131469 0.670558  1 3 2 13 8 10 0 -1 2 13 4 5 0 2 6 18 4 5 0 2 haar_x2_y2\n"
" 0.007115 0 -1 -0.378806 0.309790  1 2 15 5 3 18 0 -1 15 11 3 6 0 3 haar_y3 0.004816 0 -1\n"
" -0.584704 0.256021  1 2 3 5 18 3 0 -1 3 6 18 1 0 3 haar_y3 0.009532 0 -1 -0.302170 0.412533 \n"
" 1 2 17 5 6 11 0 -1 19 5 2 11 0 3 haar_x3 -0.027475 0 -1 0.591547 0.017964  1 2 1 5 6 11 0 -1\n"
" 3 5 2 11 0 3 haar_x3 -0.039520 0 -1 0.969135 -0.210203  1 2 19 1 4 9 0 -1 19 1 2 9 0 2\n"
" haar_x2 -0.030659 0 -1 0.911559 0.040550  1 2 1 1 4 9 0 -1 3 1 2 9 0 2 haar_x2 -0.001468 0 -1\n"
" -0.604898 0.169609  1 2 4 15 18 9 0 -1 4 15 9 9 0 2 haar_x2 0.190776 0 -1 0.043515 0.818929 \n"
" 1 2 6 9 12 4 0 -1 6 11 12 2 0 2 haar_y2 0.005179 0 -1 -0.936173 0.024937  1 2 15 2 9 6 0 -1\n"
" 15 4 9 2 0 3 haar_y3 0.024126 0 -1 0.181755 -0.341859  1 2 0 2 9 6 0 -1 0 4 9 2 0 3\n"
" haar_y3 -0.026384 0 -1 -1.291258 -0.003428  1 2 15 0 6 17 0 -1 17 0 2 17 0 3 haar_x3\n"
" 0.005414 0 -1 -0.046292 0.252696  1 2 3 0 6 17 0 -1 5 0 2 17 0 3 haar_x3 0.054216 0 -1\n"
" -0.012848 -1.430454  1 2 8 17 9 4 0 -1 8 19 9 2 0 2 haar_y2 0.000238 0 -1 -0.266767 0.335883 \n"
" 1 2 6 5 3 18 0 -1 6 11 3 6 0 3 haar_y3 0.015217 0 -1 -0.513673 0.130051  1 2 5 2 14 12 0 -1\n"
" 5 8 14 6 0 2 haar_y2 0.017008 0 -1 0.415759 -0.312412  1 2 10 2 3 12 0 -1 10 8 3 6 0 2\n"
" haar_y2 0.030497 0 -1 -0.248210 0.708285  1 2 10 7 14 15 0 -1 10 12 14 5 0 3 haar_y3\n"
" 0.006543 0 -1 -0.226370 0.191846  1 2 0 7 14 15 0 -1 0 12 14 5 0 3 haar_y3 0.141640 0 -1\n"
" 0.065227 -0.888095  1 2 15 0 9 6 0 -1 15 2 9 2 0 3 haar_y3 0.019338 0 -1 0.188912 -0.273977 \n"
" 1 2 0 0 9 6 0 -1 0 2 9 2 0 3 haar_y3 -0.017324 0 -1 -0.948667 0.024197  1 2 12 6 6 14 0 -1\n"
" 14 6 2 14 0 3 haar_x3 -0.006207 0 -1 0.369384 -0.174949  1 2 9 7 6 9 0 -1 11 7 2 9 0 3\n"
" haar_x3 -0.016109 0 -1 0.961595 -0.200053  1 2 12 6 6 15 0 -1 14 6 2 15 0 3 haar_x3\n"
" -0.101225 0 -1 -3.069911 0.113638  1 2 6 6 6 15 0 -1 8 6 2 15 0 3 haar_x3 -0.007551 0 -1\n"
" 0.229210 -0.456451  1 2 15 3 8 9 0 -1 15 3 4 9 0 2 haar_x2 0.044248 0 -1 -0.000316 0.392253 \n"
" 1 2 0 0 9 21 0 -1 3 0 3 21 0 3 haar_x3 -0.116360 0 -1 0.952337 -0.202016  1 2 11 9 8 12 0 -1\n"
" 11 13 8 4 0 3 haar_y3 0.004736 0 -1 -0.099177 0.203705  1 3 6 7 10 12 0 -1 6 7 5 6 0 2\n"
" 11 13 5 6 0 2 haar_x2_y2 0.022459 0 -1 0.008728 -1.021707  1 3 10 6 4 18 0 -1 12 6 2 9 0 2\n"
" 10 15 2 9 0 2 haar_x2_y2 -0.012109 0 -1 0.648126 -0.090149  1 2 0 0 6 9 0 -1 0 3 6 3 0 3\n"
" haar_y3 0.056120 0 -1 -0.036760 -1.927559  1 2 3 14 18 3 0 -1 3 15 18 1 0 3 haar_y3\n"
" -0.008738 0 -1 0.692613 -0.068375  1 3 3 14 8 10 0 -1 3 14 4 5 0 2 7 19 4 5 0 2 haar_x2_y2\n"
" 0.006640 0 -1 -0.405698 0.186257  1 3 0 12 24 4 0 -1 12 12 12 2 0 2 0 14 12 2 0 2\n"
" haar_x2_y2 -0.018132 0 -1 -0.645182 0.219764  1 2 0 2 3 20 0 -1 1 2 1 20 0 3 haar_x3\n"
" -0.022719 0 -1 0.977762 -0.186543  1 3 12 16 10 8 0 -1 17 16 5 4 0 2 12 20 5 4 0 2\n"
" haar_x2_y2 0.012705 0 -1 -0.105466 0.374041  1 3 2 16 10 8 0 -1 2 16 5 4 0 2 7 20 5 4 0 2\n"
" haar_x2_y2 -0.013683 0 -1 0.610641 -0.268811  -3.870049\n"
,

/* Stage 11 */
" 115 1 2 7 0 10 9 0 -1 7 3 10 3 0 3 haar_y3 0.031358 0 -1 -1.018391 0.575286  1 2\n"
" 0 0 24 3 0 -1 8 0 8 3 0 3 haar_x3 0.093050 0 -1 -0.412975 1.009120  1 2 3 8 15 4 0 -1\n"
" 3 10 15 2 0 2 haar_y2 0.025950 0 -1 -0.585879 0.566062  1 2 6 5 12 6 0 -1 10 5 4 6 0 3\n"
" haar_x3 0.016472 0 -1 -0.928575 0.309245  1 2 5 13 14 6 0 -1 5 16 14 3 0 2 haar_y2\n"
" -0.001878 0 -1 0.119510 -1.118013  1 2 11 14 4 10 0 -1 11 19 4 5 0 2 haar_y2 -0.009013 0 -1\n"
" -0.578495 0.331544  1 2 0 6 6 7 0 -1 3 6 3 7 0 2 haar_x2 0.022548 0 -1 -0.383251 0.524622 \n"
" 1 2 18 0 6 6 0 -1 18 0 3 6 0 2 haar_x2 -0.037780 0 -1 1.179067 -0.034167  1 2 3 1 18 3 0 -1\n"
" 3 2 18 1 0 3 haar_y3 -0.005380 0 -1 -0.862659 0.118679  1 2 9 6 14 18 0 -1 9 12 14 6 0 3\n"
" haar_y3 -0.023893 0 -1 -0.749506 0.210114  1 2 0 0 6 6 0 -1 3 0 3 6 0 2 haar_x2 -0.026522 0 -1\n"
" 0.921286 -0.282528  1 2 13 11 6 6 0 -1 13 11 3 6 0 2 haar_x2 0.012280 0 -1 0.266628 -0.700136 \n"
" 1 2 0 20 24 3 0 -1 8 20 8 3 0 3 haar_x3 0.096595 0 -1 -0.284540 0.731690  1 2 13 11 6 7 0 -1\n"
" 13 11 3 7 0 2 haar_x2 -0.027415 0 -1 -0.614927 0.155762  1 2 4 12 10 6 0 -1 4 14 10 2 0 3\n"
" haar_y3 -0.015767 0 -1 0.575512 -0.343622  1 2 13 11 6 6 0 -1 13 11 3 6 0 2 haar_x2\n"
" -0.002110 0 -1 0.325997 -0.130083  1 2 5 11 6 7 0 -1 8 11 3 7 0 2 haar_x2 0.012007 0 -1\n"
" 0.089323 -0.960256  1 2 7 4 11 12 0 -1 7 8 11 4 0 3 haar_y3 -0.015422 0 -1 0.344495 -0.467120 \n"
" 1 2 6 15 10 4 0 -1 6 17 10 2 0 2 haar_y2 -0.004158 0 -1 0.236963 -0.525633  1 2 14 0 6 9 0 -1\n"
" 16 0 2 9 0 3 haar_x3 -0.021186 0 -1 -0.742677 0.217020  1 2 4 0 6 9 0 -1 6 0 2 9 0 3\n"
" haar_x3 -0.017077 0 -1 -0.904718 0.066012  1 2 11 2 4 15 0 -1 11 7 4 5 0 3 haar_y3\n"
" -0.040850 0 -1 -0.344466 0.215037  1 2 0 0 20 3 0 -1 0 1 20 1 0 3 haar_y3 -0.008193 0 -1\n"
" -0.933886 0.050471  1 2 13 18 10 6 0 -1 13 20 10 2 0 3 haar_y3 -0.019238 0 -1 -0.532037 0.172406 \n"
" 1 2 2 7 6 11 0 -1 5 7 3 11 0 2 haar_x2 -0.044192 0 -1 0.920750 -0.221485  1 2 10 14 10 9 0 -1\n"
" 10 17 10 3 0 3 haar_y3 -0.062392 0 -1 -0.710538 0.183239  1 2 8 2 4 9 0 -1 10 2 2 9 0 2\n"
" haar_x2 -0.001008 0 -1 -0.870631 0.055330  1 2 14 3 10 4 0 -1 14 3 5 4 0 2 haar_x2\n"
" 0.023870 0 -1 -0.228542 0.524156  1 3 6 6 12 6 0 -1 6 6 6 3 0 2 12 9 6 3 0 2 haar_x2_y2\n"
" 0.021391 0 -1 -0.303259 0.558606  1 3 8 8 8 10 0 -1 12 8 4 5 0 2 8 13 4 5 0 2 haar_x2_y2\n"
" 0.020255 0 -1 0.269015 -0.702618  1 2 7 4 4 16 0 -1 7 12 4 8 0 2 haar_y2 -0.028772 0 -1\n"
" -1.183503 0.046512  1 2 8 8 9 4 0 -1 8 10 9 2 0 2 haar_y2 0.003420 0 -1 -0.546521 0.259625 \n"
" 1 2 5 2 14 9 0 -1 5 5 14 3 0 3 haar_y3 0.056983 0 -1 -0.269829 0.581707  1 2 3 16 19 8 0 -1\n"
" 3 20 19 4 0 2 haar_y2 -0.093892 0 -1 -0.910464 0.196777  1 2 0 0 10 8 0 -1 5 0 5 8 0 2\n"
" haar_x2 0.017700 0 -1 -0.440033 0.213495  1 2 5 2 16 18 0 -1 5 2 8 18 0 2 haar_x2\n"
" 0.228442 0 -1 0.023605 0.771716  1 2 0 11 24 11 0 -1 8 11 8 11 0 3 haar_x3 -0.182875 0 -1\n"
" 0.792286 -0.246448  1 2 3 3 18 5 0 -1 3 3 9 5 0 2 haar_x2 -0.069892 0 -1 0.802678 -0.036072 \n"
" 1 2 1 16 18 3 0 -1 1 17 18 1 0 3 haar_y3 0.015297 0 -1 -0.200723 1.103060  1 2 5 17 18 3 0 -1\n"
" 5 18 18 1 0 3 haar_y3 0.006750 0 -1 -0.045968 0.720945  1 2 1 13 9 6 0 -1 1 15 9 2 0 3\n"
" haar_y3 -0.015983 0 -1 -0.903572 0.044988  1 2 1 9 23 10 0 -1 1 14 23 5 0 2 haar_y2\n"
" 0.013088 0 -1 0.352971 -0.377106  1 2 3 7 18 3 0 -1 3 8 18 1 0 3 haar_y3 0.013061 0 -1\n"
" -0.195836 1.119894  1 2 6 8 12 3 0 -1 6 8 6 3 0 2 haar_x2 -0.039907 0 -1 -1.399843 0.191451 \n"
" 1 2 6 2 3 22 0 -1 7 2 1 22 0 3 haar_x3 0.015027 0 -1 0.002360 -1.161125  1 2 14 17 10 6 0 -1\n"
" 14 19 10 2 0 3 haar_y3 -0.020518 0 -1 -0.489081 0.167434  1 2 1 18 10 6 0 -1 1 20 10 2 0 3\n"
" haar_y3 -0.022359 0 -1 -1.220298 -0.011976  1 2 11 3 6 12 0 -1 13 3 2 12 0 3 haar_x3\n"
" -0.007915 0 -1 0.372281 -0.085063  1 2 10 6 4 9 0 -1 12 6 2 9 0 2 haar_x2 0.015258 0 -1\n"
" -0.294126 0.594064  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3 -0.031666 0 -1 -1.439557 0.135788 \n"
" 1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 -0.030774 0 -1 -2.254537 -0.033971  1 2 12 10 9 6 0 -1\n"
" 15 10 3 6 0 3 haar_x3 -0.015483 0 -1 0.377007 0.015848  1 2 2 11 6 9 0 -1 5 11 3 9 0 2\n"
" haar_x2 0.035167 0 -1 -0.294461 0.531591  1 2 14 5 3 19 0 -1 15 5 1 19 0 3 haar_x3\n"
" -0.017906 0 -1 -0.997882 0.162360  1 2 6 6 9 6 0 -1 6 8 9 2 0 3 haar_y3 -0.003180 0 -1\n"
" 0.047657 -0.752499  1 2 14 5 3 19 0 -1 15 5 1 19 0 3 haar_x3 0.015720 0 -1 0.148738 -0.653754 \n"
" 1 2 0 3 6 9 0 -1 0 6 6 3 0 3 haar_y3 0.029864 0 -1 -0.014952 -1.227519  1 2 5 21 18 3 0 -1\n"
" 5 22 18 1 0 3 haar_y3 0.002990 0 -1 -0.142637 0.432728  1 2 1 10 18 4 0 -1 7 10 6 4 0 3\n"
" haar_x3 0.084750 0 -1 -0.019281 -1.194641  1 3 13 4 8 10 0 -1 17 4 4 5 0 2 13 9 4 5 0 2\n"
" haar_x2_y2 -0.058725 0 -1 -1.732822 0.143747  1 2 7 8 9 6 0 -1 10 8 3 6 0 3 haar_x3\n"
" 0.044756 0 -1 -0.241406 0.540200  1 2 12 9 9 8 0 -1 15 9 3 8 0 3 haar_x3 0.040369 0 -1\n"
" 0.005768 0.565781  1 2 0 6 5 12 0 -1 0 10 5 4 0 3 haar_y3 0.037736 0 -1 0.038181 -0.793704 \n"
" 1 3 7 6 14 6 0 -1 14 6 7 3 0 2 7 9 7 3 0 2 haar_x2_y2 0.060753 0 -1 0.076453 1.481321 \n"
" 1 2 7 5 3 19 0 -1 8 5 1 19 0 3 haar_x3 -0.019832 0 -1 -1.697172 -0.027370  1 2 8 4 15 20 0 -1\n"
" 13 4 5 20 0 3 haar_x3 -0.165927 0 -1 0.629760 0.031763  1 2 1 4 15 20 0 -1 6 4 5 20 0 3\n"
" haar_x3 0.069015 0 -1 -0.334632 0.300767  1 2 13 10 6 6 0 -1 13 10 3 6 0 2 haar_x2\n"
" 0.011358 0 -1 0.227415 -0.382247  1 2 5 10 6 6 0 -1 8 10 3 6 0 2 haar_x2 0.001700 0 -1\n"
" 0.192238 -0.527351  1 3 14 2 6 14 0 -1 17 2 3 7 0 2 14 9 3 7 0 2 haar_x2_y2 0.079769 0 -1\n"
" 0.091492 2.104905  1 3 4 2 6 14 0 -1 4 2 3 7 0 2 7 9 3 7 0 2 haar_x2_y2 -0.057144 0 -1\n"
" -1.745213 -0.040910  1 2 12 4 6 7 0 -1 12 4 3 7 0 2 haar_x2 0.007383 0 -1 -0.242148 0.355778 \n"
" 1 2 9 4 6 9 0 -1 11 4 2 9 0 3 haar_x3 -0.018041 0 -1 1.178000 -0.176767  1 2 11 4 8 10 0 -1\n"
" 11 4 4 10 0 2 haar_x2 0.094503 0 -1 0.139361 -1.299370  1 2 5 4 8 10 0 -1 9 4 4 10 0 2\n"
" haar_x2 0.005421 0 -1 -0.546086 0.139164  1 2 8 18 10 6 0 -1 8 20 10 2 0 3 haar_y3\n"
" 0.007029 0 -1 -0.215972 0.392581  1 2 1 18 21 6 0 -1 1 20 21 2 0 3 haar_y3 0.034516 0 -1\n"
" 0.063189 -0.721081  1 2 9 2 12 6 0 -1 9 2 6 6 0 2 haar_x2 -0.051925 0 -1 0.686676 0.063273 \n"
" 1 2 3 2 12 6 0 -1 9 2 6 6 0 2 haar_x2 -0.069162 0 -1 1.741181 -0.166193  1 3 12 5 12 6 0 -1\n"
" 18 5 6 3 0 2 12 8 6 3 0 2 haar_x2_y2 -0.005523 0 -1 0.306947 -0.166629  1 2 8 8 6 9 0 -1\n"
" 8 11 6 3 0 3 haar_y3 0.068600 0 -1 -0.214054 0.731850  1 2 2 7 20 6 0 -1 2 9 20 2 0 3\n"
" haar_y3 -0.067039 0 -1 -0.793606 0.205258  1 3 0 5 12 6 0 -1 0 5 6 3 0 2 6 8 6 3 0 2\n"
" haar_x2_y2 -0.021005 0 -1 0.373444 -0.296186  1 3 14 14 8 10 0 -1 18 14 4 5 0 2 14 19 4 5 0 2\n"
" haar_x2_y2 0.020279 0 -1 -0.015200 0.405553  1 3 2 14 8 10 0 -1 2 14 4 5 0 2 6 19 4 5 0 2\n"
" haar_x2_y2 -0.047108 0 -1 1.211685 -0.174643  1 2 2 11 20 13 0 -1 2 11 10 13 0 2\n"
" haar_x2 0.187685 0 -1 -0.022909 0.696458  1 2 6 9 12 5 0 -1 12 9 6 5 0 2 haar_x2\n"
" -0.043229 0 -1 -1.060248 -0.000556  1 3 5 6 16 6 0 -1 13 6 8 3 0 2 5 9 8 3 0 2 haar_x2_y2\n"
" 0.020004 0 -1 -0.032751 0.538051  1 2 1 19 9 4 0 -1 1 21 9 2 0 2 haar_y2 0.008088 0 -1\n"
" 0.037548 -0.747689  1 2 7 5 12 5 0 -1 11 5 4 5 0 3 haar_x3 0.027101 0 -1 -0.081790 0.333871 \n"
" 1 3 3 5 14 12 0 -1 3 5 7 6 0 2 10 11 7 6 0 2 haar_x2_y2 -0.091746 0 -1 -1.921351 -0.038953 \n"
" 1 2 9 4 9 6 0 -1 12 4 3 6 0 3 haar_x3 -0.012455 0 -1 0.483606 0.018168  1 2 2 6 19 3 0 -1\n"
" 2 7 19 1 0 3 haar_y3 0.014649 0 -1 -0.199067 0.728154  1 2 18 10 6 9 0 -1 18 13 6 3 0 3\n"
" haar_y3 0.029102 0 -1 0.198711 -0.492168  1 2 3 7 18 2 0 -1 3 8 18 1 0 2 haar_y2\n"
" 0.008780 0 -1 -0.194996 0.773174  1 3 20 2 4 18 0 -1 22 2 2 9 0 2 20 11 2 9 0 2 haar_x2_y2\n"
" -0.054740 0 -1 1.808719 0.068323  1 2 2 18 20 3 0 -1 2 19 20 1 0 3 haar_y3 -0.014798 0 -1\n"
" 0.780649 -0.187096  1 2 1 9 22 3 0 -1 1 10 22 1 0 3 haar_y3 0.025013 0 -1 0.152853 -1.602102 \n"
" 1 3 0 2 4 18 0 -1 0 2 2 9 0 2 2 11 2 9 0 2 haar_x2_y2 0.046548 0 -1 -0.167382 1.190206 \n"
" 1 2 19 0 4 23 0 -1 19 0 2 23 0 2 haar_x2 0.017624 0 -1 -0.102855 0.391759  1 2 0 3 6 19 0 -1\n"
" 3 3 3 19 0 2 haar_x2 0.163196 0 -1 -0.035624 -1.609817  1 2 18 2 6 9 0 -1 20 2 2 9 0 3\n"
" haar_x3 0.013138 0 -1 -0.056359 0.541589  1 2 0 5 10 6 0 -1 0 7 10 2 0 3 haar_y3\n"
" -0.015665 0 -1 0.280631 -0.317086  1 3 7 0 12 12 0 -1 13 0 6 6 0 2 7 6 6 6 0 2 haar_x2_y2\n"
" 0.080554 0 -1 0.126404 -1.029753  1 3 0 3 24 6 0 -1 0 3 12 3 0 2 12 6 12 3 0 2 haar_x2_y2\n"
" 0.035364 0 -1 0.020753 -0.791056  1 2 10 14 4 10 0 -1 10 19 4 5 0 2 haar_y2 0.032987 0 -1\n"
" 0.190571 -0.838399  1 2 8 9 4 15 0 -1 8 14 4 5 0 3 haar_y3 0.012195 0 -1 0.073729 -0.627807 \n"
" 1 2 4 11 17 6 0 -1 4 14 17 3 0 2 haar_y2 0.043066 0 -1 0.047385 1.571294  1 3 2 5 18 8 0 -1\n"
" 2 5 9 4 0 2 11 9 9 4 0 2 haar_x2_y2 0.030327 0 -1 -0.273146 0.385720  1 3 7 6 14 6 0 -1\n"
" 14 6 7 3 0 2 7 9 7 3 0 2 haar_x2_y2 0.035493 0 -1 0.054594 0.525834  1 3 3 6 14 6 0 -1\n"
" 3 6 7 3 0 2 10 9 7 3 0 2 haar_x2_y2 -0.014597 0 -1 0.381526 -0.283324  1 2 16 5 3 18 0 -1\n"
" 17 5 1 18 0 3 haar_x3 0.012607 0 -1 0.154551 -0.305015  1 2 5 5 3 18 0 -1 6 5 1 18 0 3\n"
" haar_x3 0.010172 0 -1 0.023637 -0.872179  1 2 10 10 14 4 0 -1 10 12 14 2 0 2 haar_y2\n"
" 0.028843 0 -1 0.160910 -0.202776  1 2 4 10 9 4 0 -1 4 12 9 2 0 2 haar_y2 0.000551 0 -1\n"
" -0.615454 0.080936  -3.716091\n"
,

/* Stage 12 */
" 127 1 2 2 0 18 9 0 -1 2 3 18 3 0 3 haar_y3 0.048344 0 -1 -0.849046 0.569744  1 2\n"
" 6 3 12 8 0 -1 10 3 4 8 0 3 haar_x3 0.032460 0 -1 -0.814173 0.447817  1 2 1 1 8 5 0 -1\n"
" 5 1 4 5 0 2 haar_x2 0.033340 0 -1 -0.364238 0.679374  1 2 12 7 7 8 0 -1 12 11 7 4 0 2\n"
" haar_y2 0.006402 0 -1 -1.188546 0.192387  1 2 0 12 22 4 0 -1 0 14 22 2 0 2 haar_y2\n"
" -0.005689 0 -1 0.330853 -0.713341  1 2 15 6 4 15 0 -1 15 11 4 5 0 3 haar_y3 0.012698 0 -1\n"
" -0.509908 0.113763  1 2 5 7 7 8 0 -1 5 11 7 4 0 2 haar_y2 0.006055 0 -1 -1.047055 0.202226 \n"
" 1 2 8 18 9 4 0 -1 8 20 9 2 0 2 haar_y2 0.002642 0 -1 -0.505594 0.364412  1 2 1 2 22 4 0 -1\n"
" 1 4 22 2 0 2 haar_y2 -0.016926 0 -1 -0.995419 0.126022  1 2 17 3 6 17 0 -1 19 3 2 17 0 3\n"
" haar_x3 0.028236 0 -1 -0.094138 0.577804  1 2 8 2 8 18 0 -1 8 11 8 9 0 2 haar_y2\n"
" 0.010429 0 -1 0.232729 -0.525697  1 3 17 0 6 12 0 -1 20 0 3 6 0 2 17 6 3 6 0 2 haar_x2_y2\n"
" 0.009886 0 -1 -0.103163 0.476576  1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 0.026015 0 -1\n"
" -0.001092 -1.558173  1 2 15 5 9 12 0 -1 15 11 9 6 0 2 haar_y2 -0.025538 0 -1 -0.654514 0.188432 \n"
" 1 2 2 22 18 2 0 -1 2 23 18 1 0 2 haar_y2 -0.003531 0 -1 0.281406 -0.445753  1 3 10 10 12 6 0 -1\n"
" 16 10 6 3 0 2 10 13 6 3 0 2 haar_x2_y2 0.009245 0 -1 0.156120 -0.213710  1 2 0 1 4 11 0 -1\n"
" 2 1 2 11 0 2 haar_x2 0.021031 0 -1 -0.291703 0.522341  1 2 20 0 4 10 0 -1 20 0 2 10 0 2\n"
" haar_x2 -0.051063 0 -1 1.366129 0.030466  1 2 1 3 6 17 0 -1 3 3 2 17 0 3 haar_x3\n"
" -0.062330 0 -1 1.220702 -0.224344  1 2 15 15 9 6 0 -1 15 17 9 2 0 3 haar_y3 -0.032963 0 -1\n"
" -0.820168 0.145319  1 2 0 13 8 9 0 -1 0 16 8 3 0 3 haar_y3 -0.037418 0 -1 -1.221810 0.019449 \n"
" 1 2 16 8 6 12 0 -1 16 12 6 4 0 3 haar_y3 0.124028 0 -1 0.120823 -0.987293  1 2 2 8 6 12 0 -1\n"
" 2 12 6 4 0 3 haar_y3 -0.008923 0 -1 -1.168849 0.021105  1 2 10 2 4 15 0 -1 10 7 4 5 0 3\n"
" haar_y3 -0.059880 0 -1 -1.068933 0.198602  1 2 1 5 19 3 0 -1 1 6 19 1 0 3 haar_y3\n"
" 0.006262 0 -1 -0.362296 0.380008  1 2 11 8 9 7 0 -1 14 8 3 7 0 3 haar_x3 -0.017673 0 -1\n"
" 0.490941 -0.146067  1 2 3 8 12 9 0 -1 3 11 12 3 0 3 haar_y3 0.017579 0 -1 0.587281 -0.277744 \n"
" 1 2 3 6 18 3 0 -1 3 7 18 1 0 3 haar_y3 0.005156 0 -1 -0.075195 0.601931  1 2 10 0 4 12 0 -1\n"
" 10 6 4 6 0 2 haar_y2 -0.010600 0 -1 0.276374 -0.377943  1 2 3 9 18 14 0 -1 3 9 9 14 0 2\n"
" haar_x2 0.208841 0 -1 -0.005360 1.031781  1 2 0 0 4 9 0 -1 2 0 2 9 0 2 haar_x2 -0.026413 0 -1\n"
" 0.823364 -0.224806  1 2 12 5 4 18 0 -1 12 5 2 18 0 2 haar_x2 0.058892 0 -1 0.130983 -1.185370 \n"
" 1 2 8 5 4 18 0 -1 10 5 2 18 0 2 haar_x2 -0.011579 0 -1 -0.906678 0.044127  1 2 10 5 6 10 0 -1\n"
" 12 5 2 10 0 3 haar_x3 0.045988 0 -1 0.010144 1.074090  1 2 9 4 4 11 0 -1 11 4 2 11 0 2\n"
" haar_x2 -0.022838 0 -1 1.779199 -0.173155  1 2 4 16 18 3 0 -1 4 17 18 1 0 3 haar_y3\n"
" -0.008171 0 -1 0.573863 -0.074106  1 2 0 16 20 3 0 -1 0 17 20 1 0 3 haar_y3 0.003536 0 -1\n"
" -0.320729 0.401825  1 2 9 9 6 12 0 -1 9 13 6 4 0 3 haar_y3 0.049445 0 -1 0.192880 -1.216670 \n"
" 1 2 8 13 8 8 0 -1 8 17 8 4 0 2 haar_y2 0.003514 0 -1 0.069568 -0.713237  1 2 13 10 3 12 0 -1\n"
" 13 16 3 6 0 2 haar_y2 -0.030996 0 -1 -0.388622 0.180988  1 3 5 9 14 14 0 -1 5 9 7 7 0 2\n"
" 12 16 7 7 0 2 haar_x2_y2 0.086453 0 -1 -0.025793 -1.545322  1 3 0 0 24 10 0 -1 12 0 12 5 0 2\n"
" 0 5 12 5 0 2 haar_x2_y2 -0.136526 0 -1 -1.919942 0.166133  1 2 1 11 18 2 0 -1 1 12 18 1 0 2\n"
" haar_y2 -0.005769 0 -1 -1.282259 -0.015908  1 2 19 5 5 12 0 -1 19 9 5 4 0 3 haar_y3\n"
" -0.017900 0 -1 -0.404099 0.235916  1 2 0 5 5 12 0 -1 0 9 5 4 0 3 haar_y3 -0.019970 0 -1\n"
" -0.728919 0.056235  1 3 16 6 8 18 0 -1 20 6 4 9 0 2 16 15 4 9 0 2 haar_x2_y2 -0.057493 0 -1\n"
" 0.578308 -0.015796  1 3 0 6 8 18 0 -1 0 6 4 9 0 2 4 15 4 9 0 2 haar_x2_y2 -0.083056 0 -1\n"
" 0.915116 -0.211214  1 3 12 5 12 12 0 -1 18 5 6 6 0 2 12 11 6 6 0 2 haar_x2_y2 -0.053771 0 -1\n"
" -0.519313 0.185760  1 2 7 6 6 9 0 -1 9 6 2 9 0 3 haar_x3 -0.008367 0 -1 0.241097 -0.396486 \n"
" 1 2 9 13 6 11 0 -1 11 13 2 11 0 3 haar_x3 0.055407 0 -1 0.167712 -2.566497  1 3 0 5 12 12 0 -1\n"
" 0 5 6 6 0 2 6 11 6 6 0 2 haar_x2_y2 -0.067181 0 -1 -1.365857 -0.014232  1 2 1 2 23 3 0 -1\n"
" 1 3 23 1 0 3 haar_y3 -0.023900 0 -1 -1.708457 0.165078  1 2 1 15 19 3 0 -1 1 16 19 1 0 3\n"
" haar_y3 0.005595 0 -1 -0.313740 0.328379  1 2 13 17 11 4 0 -1 13 19 11 2 0 2 haar_y2\n"
" 0.021295 0 -1 0.149534 -0.485798  1 2 0 13 8 5 0 -1 4 13 4 5 0 2 haar_x2 -0.024613 0 -1\n"
" 0.743464 -0.223052  1 2 12 10 10 4 0 -1 12 10 5 4 0 2 haar_x2 -0.019626 0 -1 -0.409183 0.188932 \n"
" 1 2 4 6 9 9 0 -1 4 9 9 3 0 3 haar_y3 -0.053266 0 -1 0.813816 -0.208537  1 2 15 14 9 6 0 -1\n"
" 15 16 9 2 0 3 haar_y3 0.007129 0 -1 0.329961 -0.599374  1 2 1 12 9 6 0 -1 1 14 9 2 0 3\n"
" haar_y3 -0.022487 0 -1 -1.255161 -0.020413  1 3 3 10 20 8 0 -1 13 10 10 4 0 2 3 14 10 4 0 2\n"
" haar_x2_y2 -0.082311 0 -1 1.382143 0.059309  1 2 2 0 9 18 0 -1 5 0 3 18 0 3 haar_x3\n"
" 0.130970 0 -1 -0.035844 -1.539637  1 2 13 11 9 10 0 -1 16 11 3 10 0 3 haar_x3 0.014293 0 -1\n"
" -0.184752 0.374550  1 2 1 2 8 5 0 -1 5 2 4 5 0 2 haar_x2 0.006348 0 -1 -0.449011 0.138770 \n"
" 1 2 3 4 21 6 0 -1 10 4 7 6 0 3 haar_x3 -0.046055 0 -1 0.678326 -0.017072  1 3 7 0 10 14 0 -1\n"
" 7 0 5 7 0 2 12 7 5 7 0 2 haar_x2_y2 0.057694 0 -1 -0.011956 -1.226116  1 2 12 17 12 4 0 -1\n"
" 12 19 12 2 0 2 haar_y2 -0.006061 0 -1 0.339586 0.000628  1 2 0 6 23 4 0 -1 0 8 23 2 0 2\n"
" haar_y2 -0.052163 0 -1 -1.062107 -0.013780  1 3 13 10 8 10 0 -1 17 10 4 5 0 2 13 15 4 5 0 2\n"
" haar_x2_y2 0.046573 0 -1 0.145388 -1.238455  1 2 0 16 18 3 0 -1 0 17 18 1 0 3 haar_y3\n"
" 0.007531 0 -1 -0.244677 0.513771  1 2 15 16 9 4 0 -1 15 18 9 2 0 2 haar_y2 0.021615 0 -1\n"
" 0.130726 -0.709968  1 2 0 16 9 4 0 -1 0 18 9 2 0 2 haar_y2 -0.017864 0 -1 -1.047466 0.000496 \n"
" 1 2 13 11 6 6 0 -1 13 11 3 6 0 2 haar_x2 -0.037195 0 -1 -1.512673 0.148014  1 2 5 11 6 6 0 -1\n"
" 8 11 3 6 0 2 haar_x2 -0.000311 0 -1 0.139715 -0.468675  1 3 0 3 24 6 0 -1 12 3 12 3 0 2\n"
" 0 6 12 3 0 2 haar_x2_y2 0.025043 0 -1 0.286320 -0.417947  1 2 2 4 18 3 0 -1 2 5 18 1 0 3\n"
" haar_y3 0.009345 0 -1 -0.273362 0.434447  1 3 0 0 24 4 0 -1 12 0 12 2 0 2 0 2 12 2 0 2\n"
" haar_x2_y2 0.032364 0 -1 0.184389 -0.950193  1 2 1 16 18 3 0 -1 1 17 18 1 0 3 haar_y3\n"
" -0.006230 0 -1 0.325820 -0.308156  1 2 15 15 9 6 0 -1 15 17 9 2 0 3 haar_y3 0.051489 0 -1\n"
" 0.114160 -1.979548  1 2 0 15 9 6 0 -1 0 17 9 2 0 3 haar_y3 -0.026449 0 -1 -1.106730 -0.008552 \n"
" 1 2 6 17 18 3 0 -1 6 18 18 1 0 3 haar_y3 -0.015420 0 -1 0.801387 -0.032035  1 2 8 8 6 10 0 -1\n"
" 10 8 2 10 0 3 haar_x3 0.019457 0 -1 -0.264495 0.387539  1 2 10 6 6 9 0 -1 12 6 2 9 0 3\n"
" haar_x3 0.033621 0 -1 0.016052 0.588409  1 2 8 8 5 8 0 -1 8 12 5 4 0 2 haar_y2 0.028906 0 -1\n"
" 0.015216 -0.947236  1 2 12 8 6 8 0 -1 12 12 6 4 0 2 haar_y2 0.000203 0 -1 -0.307660 0.212359 \n"
" 1 2 6 5 6 11 0 -1 8 5 2 11 0 3 haar_x3 -0.049142 0 -1 -1.605861 -0.031095  1 2 13 6 8 9 0 -1\n"
" 13 9 8 3 0 3 haar_y3 0.076426 0 -1 0.074759 1.163941  1 2 1 7 21 6 0 -1 1 9 21 2 0 3\n"
" haar_y3 0.023898 0 -1 -0.006432 -1.115075  1 2 15 5 3 12 0 -1 15 11 3 6 0 2 haar_y2\n"
" 0.003897 0 -1 -0.241057 0.208589  1 2 6 9 11 12 0 -1 6 13 11 4 0 3 haar_y3 -0.089445 0 -1\n"
" 1.915779 -0.157211  1 3 13 8 10 8 0 -1 18 8 5 4 0 2 13 12 5 4 0 2 haar_x2_y2 -0.015009 0 -1\n"
" -0.251741 0.181799  1 2 5 8 12 3 0 -1 11 8 6 3 0 2 haar_x2 -0.011146 0 -1 -0.693495 0.044928 \n"
" 1 2 6 11 18 4 0 -1 12 11 6 4 0 3 haar_x3 0.094579 0 -1 0.181021 -0.749786  1 2 0 0 22 22 0 -1\n"
" 0 11 22 11 0 2 haar_y2 0.550389 0 -1 -0.030974 -1.674614  1 2 11 2 6 8 0 -1 11 6 6 4 0 2\n"
" haar_y2 0.041381 0 -1 0.063910 0.765612  1 2 9 0 6 9 0 -1 11 0 2 9 0 3 haar_x3 0.024772 0 -1\n"
" 0.011380 -0.885594  1 2 10 0 6 9 0 -1 12 0 2 9 0 3 haar_x3 0.050999 0 -1 0.148903 -2.463421 \n"
" 1 3 8 3 6 14 0 -1 8 3 3 7 0 2 11 10 3 7 0 2 haar_x2_y2 -0.016894 0 -1 0.388710 -0.298803 \n"
" 1 2 3 10 18 8 0 -1 9 10 6 8 0 3 haar_x3 -0.121623 0 -1 -1.554280 0.163008  1 2 10 0 3 14 0 -1\n"
" 10 7 3 7 0 2 haar_y2 -0.003605 0 -1 0.218428 -0.373121  1 2 4 3 16 20 0 -1 4 13 16 10 0 2\n"
" haar_y2 0.115754 0 -1 -0.047061 0.594037  1 2 9 4 6 10 0 -1 11 4 2 10 0 3 haar_x3\n"
" 0.036904 0 -1 -0.255086 0.553973  1 2 5 0 16 4 0 -1 5 2 16 2 0 2 haar_y2 0.011484 0 -1\n"
" -0.181295 0.406828  1 2 2 5 18 4 0 -1 8 5 6 4 0 3 haar_x3 -0.020234 0 -1 0.543112 -0.238224 \n"
" 1 2 13 0 6 9 0 -1 15 0 2 9 0 3 haar_x3 -0.028765 0 -1 -0.691723 0.159433  1 2 8 4 8 5 0 -1\n"
" 12 4 4 5 0 2 haar_x2 -0.005832 0 -1 0.294478 -0.340060  1 2 12 10 10 4 0 -1 12 10 5 4 0 2\n"
" haar_x2 -0.055469 0 -1 0.922008 0.094093  1 2 2 10 10 4 0 -1 7 10 5 4 0 2 haar_x2\n"
" -0.014801 0 -1 -0.795397 0.031522  1 2 7 11 12 5 0 -1 11 11 4 5 0 3 haar_x3 -0.007094 0 -1\n"
" 0.330960 -0.050887  1 3 3 10 8 10 0 -1 3 10 4 5 0 2 7 15 4 5 0 2 haar_x2_y2 -0.045124 0 -1\n"
" -1.371975 -0.021409  1 2 11 12 9 8 0 -1 14 12 3 8 0 3 haar_x3 0.064377 0 -1 0.063902 0.914783 \n"
" 1 2 0 21 24 3 0 -1 8 21 8 3 0 3 haar_x3 -0.014727 0 -1 0.360506 -0.286145  1 2 3 20 18 4 0 -1\n"
" 9 20 6 4 0 3 haar_x3 0.045007 0 -1 -0.156197 0.531603  1 2 1 15 9 6 0 -1 1 17 9 2 0 3\n"
" haar_y3 -0.001133 0 -1 0.134229 -0.443589  1 2 11 17 10 4 0 -1 11 19 10 2 0 2 haar_y2\n"
" 0.049451 0 -1 0.105718 -2.558914  1 2 9 12 4 12 0 -1 9 18 4 6 0 2 haar_y2 0.029103 0 -1\n"
" -0.010088 -1.107394  1 2 9 6 9 6 0 -1 12 6 3 6 0 3 haar_x3 0.034786 0 -1 -0.002772 0.567010 \n"
" 1 2 1 13 6 9 0 -1 1 16 6 3 0 3 haar_y3 -0.006131 0 -1 -0.468894 0.126364  1 2 6 16 12 4 0 -1\n"
" 6 18 12 2 0 2 haar_y2 0.015525 0 -1 -0.008428 0.874692  1 2 1 5 20 3 0 -1 1 6 20 1 0 3\n"
" haar_y3 0.002925 0 -1 -0.344343 0.208516  1 2 8 1 9 9 0 -1 8 4 9 3 0 3 haar_y3 -0.053571 0 -1\n"
" 1.498295 0.057328  1 2 2 19 9 4 0 -1 2 21 9 2 0 2 haar_y2 -0.019218 0 -1 -0.992341 -0.009392 \n"
" 1 2 11 1 4 18 0 -1 11 7 4 6 0 3 haar_y3 -0.055283 0 -1 -0.576823 0.168606  1 3 7 2 8 12 0 -1\n"
" 7 2 4 6 0 2 11 8 4 6 0 2 haar_x2_y2 0.056336 0 -1 -0.033775 -1.388965  1 2 11 10 9 8 0 -1\n"
" 14 10 3 8 0 3 haar_x3 -0.023824 0 -1 0.401821 0.001836  1 2 5 11 12 5 0 -1 9 11 4 5 0 3\n"
" haar_x3 0.001781 0 -1 0.181460 -0.417434  1 2 11 9 9 6 0 -1 14 9 3 6 0 3 haar_x3\n"
" -0.037689 0 -1 0.546831 0.018220  1 2 5 10 6 9 0 -1 7 10 2 9 0 3 haar_x3 -0.024145 0 -1\n"
" 0.683521 -0.196502  -3.564529\n"
,

/* Stage 13 */
" 135 1 2 4 7 5 12 0 -1 4 11 5 4 0 3 haar_y3 0.027445 0 -1 -0.899842 0.518765  1 2\n"
" 2 0 21 6 0 -1 9 0 7 6 0 3 haar_x3 0.115541 0 -1 -0.565244 0.705513  1 2 7 6 10 6 0 -1\n"
" 7 8 10 2 0 3 haar_y3 -0.022297 0 -1 0.360800 -0.668646  1 2 9 0 6 15 0 -1 11 0 2 15 0 3\n"
" haar_x3 0.013325 0 -1 -0.555734 0.357900  1 2 2 2 18 2 0 -1 2 3 18 1 0 2 haar_y2\n"
" -0.003806 0 -1 -1.071300 0.188500  1 2 8 17 8 6 0 -1 8 20 8 3 0 2 haar_y2 -0.002682 0 -1\n"
" -0.715843 0.263445  1 2 3 0 18 2 0 -1 3 1 18 1 0 2 haar_y2 0.003382 0 -1 -0.469308 0.266584 \n"
" 1 2 8 0 9 6 0 -1 11 0 3 6 0 3 haar_x3 0.037643 0 -1 0.210987 -1.080434  1 2 0 17 18 3 0 -1\n"
" 0 18 18 1 0 3 haar_y3 -0.013862 0 -1 0.669120 -0.279428  1 2 6 7 12 5 0 -1 10 7 4 5 0 3\n"
" haar_x3 -0.002735 0 -1 -0.953323 0.240513  1 2 0 3 6 9 0 -1 2 3 2 9 0 3 haar_x3 -0.038337 0 -1\n"
" 0.814328 -0.249194  1 2 20 2 4 9 0 -1 20 2 2 9 0 2 haar_x2 -0.034698 0 -1 1.233010 0.006860 \n"
" 1 2 0 2 4 9 0 -1 2 2 2 9 0 2 haar_x2 0.023361 0 -1 -0.307947 0.707145  1 3 0 1 24 4 0 -1\n"
" 12 1 12 2 0 2 0 3 12 2 0 2 haar_x2_y2 0.035058 0 -1 0.212059 -1.439983  1 2 0 16 9 6 0 -1\n"
" 0 18 9 2 0 3 haar_y3 -0.013257 0 -1 -0.902607 0.048610  1 2 14 13 9 6 0 -1 14 15 9 2 0 3\n"
" haar_y3 0.012740 0 -1 0.226552 -0.446438  1 2 0 15 19 3 0 -1 0 16 19 1 0 3 haar_y3\n"
" 0.003640 0 -1 -0.398179 0.346654  1 3 1 5 22 12 0 -1 12 5 11 6 0 2 1 11 11 6 0 2\n"
" haar_x2_y2 0.100647 0 -1 0.183836 -1.341077  1 2 5 13 6 6 0 -1 8 13 3 6 0 2 haar_x2\n"
" 0.000000 0 -1 0.155364 -0.515825  1 2 4 2 20 3 0 -1 4 3 20 1 0 3 haar_y3 0.011709 0 -1\n"
" 0.216514 -0.727052  1 2 8 14 6 10 0 -1 10 14 2 10 0 3 haar_x3 -0.035965 0 -1 -1.478950 -0.024317 \n"
" 1 3 6 12 16 6 0 -1 14 12 8 3 0 2 6 15 8 3 0 2 haar_x2_y2 -0.021236 0 -1 -0.168441 0.195266 \n"
" 1 2 2 13 8 9 0 -1 2 16 8 3 0 3 haar_y3 0.014874 0 -1 0.037336 -0.875573  1 3 11 8 6 14 0 -1\n"
" 14 8 3 7 0 2 11 15 3 7 0 2 haar_x2_y2 -0.005141 0 -1 0.334665 -0.241097  1 3 2 12 16 6 0 -1\n"
" 2 12 8 3 0 2 10 15 8 3 0 2 haar_x2_y2 0.023450 0 -1 0.005532 -1.250972  1 2 5 16 16 8 0 -1\n"
" 5 20 16 4 0 2 haar_y2 -0.025062 0 -1 0.452124 -0.084470  1 2 9 1 4 12 0 -1 9 7 4 6 0 2\n"
" haar_y2 -0.000774 0 -1 0.152499 -0.484865  1 3 8 2 8 10 0 -1 12 2 4 5 0 2 8 7 4 5 0 2\n"
" haar_x2_y2 -0.040484 0 -1 -1.302492 0.179835  1 3 6 6 12 6 0 -1 6 6 6 3 0 2 12 9 6 3 0 2\n"
" haar_x2_y2 0.028171 0 -1 -0.244109 0.622711  1 2 10 7 6 9 0 -1 12 7 2 9 0 3 haar_x3\n"
" 0.045693 0 -1 0.028122 0.923944  1 3 0 0 8 12 0 -1 0 0 4 6 0 2 4 6 4 6 0 2 haar_x2_y2\n"
" 0.039707 0 -1 -0.223328 0.776740  1 2 18 8 6 9 0 -1 18 11 6 3 0 3 haar_y3 0.050517 0 -1\n"
" 0.203200 -1.089593  1 2 2 12 6 6 0 -1 5 12 3 6 0 2 haar_x2 -0.017267 0 -1 0.685984 -0.233045 \n"
" 1 2 3 21 21 3 0 -1 10 21 7 3 0 3 haar_x3 0.080186 0 -1 -0.010292 0.618811  1 2 2 0 16 6 0 -1\n"
" 2 3 16 3 0 2 haar_y2 0.097676 0 -1 -0.200703 1.008835  1 2 13 6 7 6 0 -1 13 9 7 3 0 2\n"
" haar_y2 -0.015572 0 -1 0.476153 0.045624  1 2 6 4 4 14 0 -1 6 11 4 7 0 2 haar_y2\n"
" -0.015305 0 -1 -1.107737 0.004524  1 2 9 7 6 9 0 -1 11 7 2 9 0 3 haar_x3 -0.016485 0 -1\n"
" 1.015294 0.016328  1 3 7 8 6 14 0 -1 7 8 3 7 0 2 10 15 3 7 0 2 haar_x2_y2 -0.026142 0 -1\n"
" 0.417233 -0.286455  1 2 18 8 4 16 0 -1 18 16 4 8 0 2 haar_y2 0.008868 0 -1 0.214050 -0.167728 \n"
" 1 2 9 14 6 10 0 -1 11 14 2 10 0 3 haar_x3 -0.026887 0 -1 -1.156422 -0.010324  1 2\n"
" 6 11 12 5 0 -1 10 11 4 5 0 3 haar_x3 0.007779 0 -1 0.353595 -0.296113  1 2 0 12 23 3 0 -1\n"
" 0 13 23 1 0 3 haar_y3 -0.015974 0 -1 -1.537411 -0.029958  1 2 13 0 6 12 0 -1 15 0 2 12 0 3\n"
" haar_x3 0.020867 0 -1 0.202441 -0.712702  1 2 0 10 12 5 0 -1 4 10 4 5 0 3 haar_x3\n"
" 0.085482 0 -1 -0.025933 -1.515657  1 2 13 2 10 4 0 -1 13 4 10 2 0 2 haar_y2 0.023873 0 -1\n"
" 0.168034 -0.388062  1 2 5 0 6 12 0 -1 7 0 2 12 0 3 haar_x3 -0.039105 0 -1 -1.195835 -0.020361 \n"
" 1 2 11 6 9 6 0 -1 14 6 3 6 0 3 haar_x3 -0.077947 0 -1 -1.089895 0.145303  1 2 4 6 9 6 0 -1\n"
" 7 6 3 6 0 3 haar_x3 -0.016876 0 -1 0.280497 -0.413363  1 2 6 11 18 13 0 -1 12 11 6 13 0 3\n"
" haar_x3 0.118756 0 -1 -0.043491 0.412637  1 2 0 11 18 13 0 -1 6 11 6 13 0 3 haar_x3\n"
" 0.156242 0 -1 -0.264296 0.551278  1 2 12 16 12 6 0 -1 16 16 4 6 0 3 haar_x3 -0.045908 0 -1\n"
" 0.601892 0.018921  1 2 0 6 21 3 0 -1 0 7 21 1 0 3 haar_y3 -0.010310 0 -1 0.381530 -0.295079 \n"
" 1 2 12 16 12 6 0 -1 16 16 4 6 0 3 haar_x3 0.095769 0 -1 0.132465 -0.462668  1 2 5 7 6 14 0 -1\n"
" 5 14 6 7 0 2 haar_y2 0.013687 0 -1 0.117387 -0.516641  1 2 5 10 19 2 0 -1 5 11 19 1 0 2\n"
" haar_y2 0.002399 0 -1 -0.340076 0.209535  1 2 5 4 14 4 0 -1 5 6 14 2 0 2 haar_y2\n"
" 0.033265 0 -1 -0.170528 1.436680  1 2 3 18 18 4 0 -1 9 18 6 4 0 3 haar_x3 -0.033206 0 -1\n"
" 0.612957 -0.041550  1 2 7 0 4 9 0 -1 9 0 2 9 0 2 haar_x2 0.002798 0 -1 -0.485543 0.133727 \n"
" 1 2 13 3 11 4 0 -1 13 5 11 2 0 2 haar_y2 -0.065792 0 -1 -4.025767 0.108767  1 2 2 0 9 6 0 -1\n"
" 5 0 3 6 0 3 haar_x3 0.002143 0 -1 -0.391800 0.224271  1 2 19 1 4 23 0 -1 19 1 2 23 0 2\n"
" haar_x2 0.022364 0 -1 -0.086430 0.377852  1 2 1 1 4 23 0 -1 3 1 2 23 0 2 haar_x2\n"
" -0.057410 0 -1 1.145407 -0.197366  1 2 5 16 18 3 0 -1 5 17 18 1 0 3 haar_y3 0.006655 0 -1\n"
" -0.021105 0.584534  1 2 0 3 11 4 0 -1 0 5 11 2 0 2 haar_y2 0.012327 0 -1 0.037817 -0.669870 \n"
" 1 2 2 16 20 3 0 -1 2 17 20 1 0 3 haar_y3 -0.008187 0 -1 0.563660 -0.076878  1 2 5 3 13 4 0 -1\n"
" 5 5 13 2 0 2 haar_y2 0.036681 0 -1 -0.173433 1.167015  1 2 1 9 22 15 0 -1 1 9 11 15 0 2\n"
" haar_x2 -0.402204 0 -1 1.264082 0.043399  1 2 3 4 14 3 0 -1 10 4 7 3 0 2 haar_x2\n"
" -0.022126 0 -1 0.669781 -0.216053  1 2 8 7 10 4 0 -1 8 7 5 4 0 2 haar_x2 -0.013157 0 -1\n"
" -0.411986 0.202150  1 2 6 7 10 4 0 -1 11 7 5 4 0 2 haar_x2 -0.012860 0 -1 -0.915827 0.039233 \n"
" 1 2 10 4 6 9 0 -1 12 4 2 9 0 3 haar_x3 0.021628 0 -1 0.003872 0.356682  1 2 1 12 9 6 0 -1\n"
" 4 12 3 6 0 3 haar_x3 0.011896 0 -1 -0.373039 0.192351  1 3 8 3 8 10 0 -1 12 3 4 5 0 2\n"
" 8 8 4 5 0 2 haar_x2_y2 -0.019549 0 -1 -0.423749 0.244296  1 3 3 6 16 6 0 -1 3 6 8 3 0 2\n"
" 11 9 8 3 0 2 haar_x2_y2 0.064445 0 -1 -0.165589 1.269703  1 2 5 6 14 6 0 -1 5 9 14 3 0 2\n"
" haar_y2 0.108985 0 -1 0.148943 -2.153464  1 2 4 3 9 6 0 -1 4 5 9 2 0 3 haar_y3 -0.034078 0 -1\n"
" 1.377946 -0.161985  1 2 6 3 18 2 0 -1 6 4 18 1 0 2 haar_y2 -0.003749 0 -1 -0.338286 0.211529 \n"
" 1 2 7 6 9 6 0 -1 10 6 3 6 0 3 haar_x3 -0.010972 0 -1 0.765179 -0.196926  1 2 0 1 24 3 0 -1\n"
" 0 2 24 1 0 3 haar_y3 -0.011485 0 -1 -0.692712 0.216571  1 2 0 17 10 6 0 -1 0 19 10 2 0 3\n"
" haar_y3 0.025984 0 -1 -0.011984 -0.996973  1 2 3 18 18 3 0 -1 3 19 18 1 0 3 haar_y3\n"
" 0.004216 0 -1 -0.102057 0.488844  1 3 2 5 6 16 0 -1 2 5 3 8 0 2 5 13 3 8 0 2 haar_x2_y2\n"
" -0.047697 0 -1 1.066601 -0.175763  1 2 7 6 11 6 0 -1 7 8 11 2 0 3 haar_y3 0.000403 0 -1\n"
" 0.185248 -0.747900  1 2 5 2 12 22 0 -1 5 13 12 11 0 2 haar_y2 0.115396 0 -1 -0.220197 0.545100 \n"
" 1 2 10 7 4 10 0 -1 10 12 4 5 0 2 haar_y2 0.016021 0 -1 0.254875 -0.507401  1 2 9 0 4 18 0 -1\n"
" 9 6 4 6 0 3 haar_y3 0.056632 0 -1 -0.011256 -0.959681  1 2 18 8 6 9 0 -1 18 11 6 3 0 3\n"
" haar_y3 -0.010726 0 -1 -0.285447 0.169948  1 2 4 7 15 10 0 -1 9 7 5 10 0 3 haar_x3\n"
" 0.124200 0 -1 -0.036140 -1.313271  1 2 10 5 6 9 0 -1 12 5 2 9 0 3 haar_x3 -0.005380 0 -1\n"
" 0.330927 0.013308  1 2 9 9 6 10 0 -1 11 9 2 10 0 3 haar_x3 0.011908 0 -1 -0.348303 0.240419 \n"
" 1 2 11 14 6 10 0 -1 13 14 2 10 0 3 haar_x3 -0.043008 0 -1 -1.439047 0.155996  1 2\n"
" 7 14 6 10 0 -1 9 14 2 10 0 3 haar_x3 -0.033150 0 -1 -1.180585 -0.012348  1 2 4 8 16 9 0 -1\n"
" 4 11 16 3 0 3 haar_y3 -0.021342 0 -1 2.211944 0.062737  1 2 2 11 20 3 0 -1 2 12 20 1 0 3\n"
" haar_y3 -0.012219 0 -1 -1.870975 -0.045500  1 2 13 0 4 13 0 -1 13 0 2 13 0 2 haar_x2\n"
" -0.016861 0 -1 -0.769127 0.153300  1 2 7 0 4 13 0 -1 9 0 2 13 0 2 haar_x2 -0.002500 0 -1\n"
" -0.629874 0.051600  1 2 3 1 18 7 0 -1 9 1 6 7 0 3 haar_x3 -0.045038 0 -1 0.854289 0.006260 \n"
" 1 2 1 11 6 9 0 -1 1 14 6 3 0 3 haar_y3 0.039058 0 -1 -0.032459 -1.332567  1 2 8 18 9 6 0 -1\n"
" 8 20 9 2 0 3 haar_y3 0.006672 0 -1 -0.194236 0.373287  1 2 3 9 15 6 0 -1 3 11 15 2 0 3\n"
" haar_y3 -0.016361 0 -1 2.060587 -0.150427  1 2 5 10 19 2 0 -1 5 11 19 1 0 2 haar_y2\n"
" 0.006172 0 -1 -0.116110 0.254554  1 2 8 6 7 16 0 -1 8 14 7 8 0 2 haar_y2 0.045722 0 -1\n"
" -0.016340 -1.044914  1 2 9 14 9 6 0 -1 9 16 9 2 0 3 haar_y3 0.004121 0 -1 -0.041998 0.396810 \n"
" 1 2 0 7 8 12 0 -1 0 11 8 4 0 3 haar_y3 -0.000178 0 -1 -0.664226 0.033443  1 2 6 4 18 3 0 -1\n"
" 6 5 18 1 0 3 haar_y3 0.007111 0 -1 -0.058232 0.378573  1 2 0 16 12 6 0 -1 4 16 4 6 0 3\n"
" haar_x3 -0.049864 0 -1 0.610194 -0.210057  1 2 13 13 9 4 0 -1 13 15 9 2 0 2 haar_y2\n"
" -0.025012 0 -1 -0.571001 0.178484  1 3 5 8 14 14 0 -1 5 8 7 7 0 2 12 15 7 7 0 2 haar_x2_y2\n"
" 0.030940 0 -1 0.056363 -0.647310  1 3 1 16 22 6 0 -1 12 16 11 3 0 2 1 19 11 3 0 2\n"
" haar_x2_y2 0.046271 0 -1 0.174824 -0.989094  1 2 9 0 6 9 0 -1 11 0 2 9 0 3 haar_x3\n"
" -0.003187 0 -1 -0.668048 0.032267  1 3 9 5 10 10 0 -1 14 5 5 5 0 2 9 10 5 5 0 2 haar_x2_y2\n"
" -0.024352 0 -1 0.294449 -0.001360  1 3 5 5 10 10 0 -1 5 5 5 5 0 2 10 10 5 5 0 2 haar_x2_y2\n"
" 0.011974 0 -1 -0.283451 0.471712  1 3 4 6 16 6 0 -1 12 6 8 3 0 2 4 9 8 3 0 2 haar_x2_y2\n"
" 0.013070 0 -1 -0.108346 0.571933  1 2 0 7 6 9 0 -1 0 10 6 3 0 3 haar_y3 0.059163 0 -1\n"
" -0.050939 -1.905972  1 3 16 10 8 14 0 -1 20 10 4 7 0 2 16 17 4 7 0 2 haar_x2_y2 -0.041095 0 -1\n"
" 0.451046 -0.009760  1 2 9 12 6 12 0 -1 9 18 6 6 0 2 haar_y2 -0.083989 0 -1 -2.034920 -0.051019 \n"
" 1 3 8 10 8 12 0 -1 12 10 4 6 0 2 8 16 4 6 0 2 haar_x2_y2 0.044619 0 -1 0.170411 -1.227872 \n"
" 1 2 8 0 4 9 0 -1 10 0 2 9 0 2 haar_x2 0.024419 0 -1 -0.021797 -1.082295  1 3 10 4 8 16 0 -1\n"
" 14 4 4 8 0 2 10 12 4 8 0 2 haar_x2_y2 -0.004387 0 -1 0.304667 -0.370666  1 2 7 10 10 6 0 -1\n"
" 7 12 10 2 0 3 haar_y3 0.024608 0 -1 -0.311695 0.236573  1 3 5 6 14 14 0 -1 12 6 7 7 0 2\n"
" 5 13 7 7 0 2 haar_x2_y2 -0.085182 0 -1 -1.798235 0.152543  1 2 2 11 20 2 0 -1 2 12 20 1 0 2\n"
" haar_y2 0.021845 0 -1 -0.051888 -1.901719  1 2 18 8 4 16 0 -1 18 16 4 8 0 2 haar_y2\n"
" -0.016829 0 -1 0.210259 0.021657  1 3 1 11 12 10 0 -1 1 11 6 5 0 2 7 16 6 5 0 2 haar_x2_y2\n"
" 0.032548 0 -1 -0.202926 0.609440  1 2 6 9 12 4 0 -1 6 11 12 2 0 2 haar_y2 0.002471 0 -1\n"
" -0.953712 0.185684  1 2 9 12 6 7 0 -1 12 12 3 7 0 2 haar_x2 0.055416 0 -1 -0.144053 2.150634 \n"
" 1 3 10 4 8 16 0 -1 14 4 4 8 0 2 10 12 4 8 0 2 haar_x2_y2 -0.106355 0 -1 -1.091197 0.132280 \n"
" 1 3 6 4 8 16 0 -1 6 4 4 8 0 2 10 12 4 8 0 2 haar_x2_y2 -0.007989 0 -1 0.102534 -0.517449 \n"
" 1 2 8 9 9 6 0 -1 11 9 3 6 0 3 haar_x3 0.075568 0 -1 0.058965 1.235421  1 3 1 5 16 12 0 -1\n"
" 1 5 8 6 0 2 9 11 8 6 0 2 haar_x2_y2 -0.092806 0 -1 -1.343165 -0.034463  1 2 9 9 6 8 0 -1\n"
" 9 9 3 8 0 2 haar_x2 0.049432 0 -1 0.049602 1.605473  1 2 6 0 3 18 0 -1 7 0 1 18 0 3\n"
" haar_x3 -0.011773 0 -1 -1.026105 -0.004156  1 2 17 9 5 14 0 -1 17 16 5 7 0 2 haar_y2\n"
" 0.085886 0 -1 0.084643 0.952208  1 2 2 9 5 14 0 -1 2 16 5 7 0 2 haar_y2 0.081031 0 -1\n"
" -0.146871 1.935999  -3.702599\n"
,

/* Stage 14 */
" 136 1 2 7 4 10 6 0 -1 7 7 10 3 0 2 haar_y2 -0.033841 0 -1 0.658895 -0.697553  1 2\n"
" 1 3 23 18 0 -1 1 9 23 6 0 3 haar_y3 0.015410 0 -1 -0.907284 0.304786  1 2 1 1 21 3 0 -1\n"
" 8 1 7 3 0 3 haar_x3 0.054906 0 -1 -0.497748 0.571326  1 2 9 6 6 9 0 -1 11 6 2 9 0 3\n"
" haar_x3 0.021390 0 -1 -0.425652 0.580968  1 3 3 18 12 6 0 -1 3 18 6 3 0 2 9 21 6 3 0 2\n"
" haar_x2_y2 0.007885 0 -1 -0.479060 0.430165  1 3 16 8 8 16 0 -1 20 8 4 8 0 2 16 16 4 8 0 2\n"
" haar_x2_y2 -0.037545 0 -1 0.508616 -0.199859  1 2 0 19 24 4 0 -1 8 19 8 4 0 3 haar_x3\n"
" 0.159258 0 -1 -0.232636 1.099332  1 3 16 8 8 16 0 -1 20 8 4 8 0 2 16 16 4 8 0 2 haar_x2_y2\n"
" -0.068940 0 -1 0.405690 0.056855  1 3 0 8 8 16 0 -1 0 8 4 8 0 2 4 16 4 8 0 2 haar_x2_y2\n"
" -0.033695 0 -1 0.451328 -0.333328  1 2 8 12 8 10 0 -1 8 17 8 5 0 2 haar_y2 -0.063315 0 -1\n"
" -0.850157 0.223417  1 2 5 7 5 8 0 -1 5 11 5 4 0 2 haar_y2 0.007370 0 -1 -0.930822 0.059217 \n"
" 1 2 4 1 19 2 0 -1 4 2 19 1 0 2 haar_y2 -0.009597 0 -1 -1.279490 0.184473  1 2 0 12 24 9 0 -1\n"
" 8 12 8 9 0 3 haar_x3 -0.130680 0 -1 0.584269 -0.260072  1 2 6 0 13 8 0 -1 6 4 13 4 0 2\n"
" haar_y2 0.057403 0 -1 -0.053789 0.711756  1 2 0 0 24 3 0 -1 0 1 24 1 0 3 haar_y3\n"
" -0.007234 0 -1 -0.869622 0.075215  1 2 20 3 4 11 0 -1 20 3 2 11 0 2 haar_x2 0.031099 0 -1\n"
" -0.075007 0.907816  1 2 8 6 6 9 0 -1 10 6 2 9 0 3 haar_x3 0.035854 0 -1 -0.247955 0.722721 \n"
" 1 3 6 11 12 8 0 -1 12 11 6 4 0 2 6 15 6 4 0 2 haar_x2_y2 -0.031535 0 -1 -1.123833 0.209883 \n"
" 1 3 0 8 12 6 0 -1 0 8 6 3 0 2 6 11 6 3 0 2 haar_x2_y2 -0.019437 0 -1 -1.449939 -0.015100 \n"
" 1 2 6 17 18 3 0 -1 6 18 18 1 0 3 haar_y3 -0.007242 0 -1 0.538649 -0.113754  1 2 0 14 9 6 0 -1\n"
" 0 16 9 2 0 3 haar_y3 0.008164 0 -1 0.066889 -0.768729  1 2 20 3 4 9 0 -1 20 3 2 9 0 2\n"
" haar_x2 -0.043653 0 -1 1.141353 0.040217  1 2 0 3 4 9 0 -1 2 3 2 9 0 2 haar_x2 0.026570 0 -1\n"
" -0.247191 0.592951  1 2 15 0 9 19 0 -1 18 0 3 19 0 3 haar_x3 0.032217 0 -1 -0.040025 0.326880 \n"
" 1 2 0 0 9 19 0 -1 3 0 3 19 0 3 haar_x3 -0.072236 0 -1 0.587294 -0.253960  1 2 13 11 6 8 0 -1\n"
" 13 11 3 8 0 2 haar_x2 0.031425 0 -1 0.153151 -0.560421  1 2 5 11 6 8 0 -1 8 11 3 8 0 2\n"
" haar_x2 -0.000477 0 -1 0.169589 -0.526267  1 2 5 11 19 3 0 -1 5 12 19 1 0 3 haar_y3\n"
" 0.002719 0 -1 -0.149446 0.296587  1 2 3 20 18 4 0 -1 9 20 6 4 0 3 haar_x3 0.032875 0 -1\n"
" -0.399435 0.251566  1 2 6 6 16 6 0 -1 6 8 16 2 0 3 haar_y3 -0.014553 0 -1 0.279726 -0.472038 \n"
" 1 2 6 0 9 6 0 -1 9 0 3 6 0 3 haar_x3 0.038018 0 -1 -0.002920 -1.130006  1 2 10 3 4 14 0 -1\n"
" 10 10 4 7 0 2 haar_y2 0.002866 0 -1 0.411118 -0.262208  1 2 1 5 15 12 0 -1 1 11 15 6 0 2\n"
" haar_y2 -0.041607 0 -1 -1.429382 -0.019133  1 2 11 12 8 5 0 -1 11 12 4 5 0 2 haar_x2\n"
" -0.024803 0 -1 -0.250136 0.159787  1 2 5 0 6 9 0 -1 7 0 2 9 0 3 haar_x3 0.010098 0 -1\n"
" 0.043739 -0.699861  1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 -0.020947 0 -1 -0.941378 0.232040 \n"
" 1 3 5 5 12 8 0 -1 5 5 6 4 0 2 11 9 6 4 0 2 haar_x2_y2 0.022458 0 -1 -0.271858 0.453192 \n"
" 1 2 13 12 11 6 0 -1 13 14 11 2 0 3 haar_y3 -0.037111 0 -1 -1.031466 0.144218  1 2\n"
" 0 13 21 3 0 -1 0 14 21 1 0 3 haar_y3 -0.010648 0 -1 0.631070 -0.255208  1 3 8 1 8 12 0 -1\n"
" 12 1 4 6 0 2 8 7 4 6 0 2 haar_x2_y2 0.055423 0 -1 0.162066 -1.772264  1 3 1 0 6 12 0 -1\n"
" 1 0 3 6 0 2 4 6 3 6 0 2 haar_x2_y2 0.021602 0 -1 -0.250161 0.541198  1 2 2 2 21 2 0 -1\n"
" 2 3 21 1 0 2 haar_y2 0.000087 0 -1 -0.290089 0.335080  1 2 2 2 19 3 0 -1 2 3 19 1 0 3\n"
" haar_y3 0.014406 0 -1 -0.007884 -1.167722  1 3 17 10 6 14 0 -1 20 10 3 7 0 2 17 17 3 7 0 2\n"
" haar_x2_y2 0.107774 0 -1 0.112920 -2.494032  1 3 1 10 6 14 0 -1 1 10 3 7 0 2 4 17 3 7 0 2\n"
" haar_x2_y2 0.035944 0 -1 -0.194806 0.957575  1 3 7 6 14 14 0 -1 14 6 7 7 0 2 7 13 7 7 0 2\n"
" haar_x2_y2 -0.003951 0 -1 0.309278 -0.255302  1 2 0 12 9 6 0 -1 0 14 9 2 0 3 haar_y3\n"
" 0.020942 0 -1 -0.007632 -1.008635  1 2 15 14 8 9 0 -1 15 17 8 3 0 3 haar_y3 -0.029878 0 -1\n"
" -0.460277 0.195072  1 3 1 1 22 4 0 -1 1 1 11 2 0 2 12 3 11 2 0 2 haar_x2_y2 0.025972 0 -1\n"
" -0.012188 -1.003550  1 2 9 11 9 6 0 -1 9 13 9 2 0 3 haar_y3 0.010603 0 -1 -0.075969 0.416699 \n"
" 1 2 0 15 18 3 0 -1 0 16 18 1 0 3 haar_y3 0.008582 0 -1 -0.266486 0.391115  1 2 16 14 7 9 0 -1\n"
" 16 17 7 3 0 3 haar_y3 0.021271 0 -1 0.182739 -0.360523  1 2 4 3 16 4 0 -1 12 3 8 4 0 2\n"
" haar_x2 0.074518 0 -1 -0.189384 0.926580  1 2 7 6 12 5 0 -1 7 6 6 5 0 2 haar_x2 0.004657 0 -1\n"
" -0.145062 0.332946  1 2 9 6 4 9 0 -1 11 6 2 9 0 2 haar_x2 0.001712 0 -1 -0.524640 0.089880 \n"
" 1 2 12 1 4 10 0 -1 12 1 2 10 0 2 haar_x2 0.000985 0 -1 -0.383820 0.243930  1 2 8 1 4 10 0 -1\n"
" 10 1 2 10 0 2 haar_x2 0.028234 0 -1 -0.005788 -1.261714  1 2 15 15 6 9 0 -1 15 18 6 3 0 3\n"
" haar_y3 -0.032678 0 -1 -0.579533 0.169553  1 2 3 15 6 9 0 -1 3 18 6 3 0 3 haar_y3\n"
" 0.022536 0 -1 0.022281 -0.878696  1 2 15 1 3 19 0 -1 16 1 1 19 0 3 haar_x3 -0.021658 0 -1\n"
" -0.651085 0.129669  1 2 1 3 6 9 0 -1 3 3 2 9 0 3 haar_x3 0.007680 0 -1 -0.339652 0.220133 \n"
" 1 2 15 0 3 19 0 -1 16 0 1 19 0 3 haar_x3 0.014592 0 -1 0.150773 -0.504524  1 2 6 3 12 4 0 -1\n"
" 12 3 6 4 0 2 haar_x2 0.027868 0 -1 -0.250453 0.457420  1 2 10 5 4 9 0 -1 10 5 2 9 0 2\n"
" haar_x2 0.005694 0 -1 -0.109485 0.557578  1 2 6 0 3 19 0 -1 7 0 1 19 0 3 haar_x3\n"
" -0.010003 0 -1 -0.973663 0.018468  1 2 11 1 3 12 0 -1 11 7 3 6 0 2 haar_y2 -0.004072 0 -1\n"
" 0.382222 -0.169211  1 2 6 7 10 5 0 -1 11 7 5 5 0 2 haar_x2 -0.022594 0 -1 -1.039109 0.005184 \n"
" 1 2 11 3 3 18 0 -1 12 3 1 18 0 3 haar_x3 -0.039580 0 -1 -5.510923 0.111640  1 2 9 3 6 12 0 -1\n"
" 11 3 2 12 0 3 haar_x3 -0.017538 0 -1 0.954858 -0.185845  1 2 3 7 19 3 0 -1 3 8 19 1 0 3\n"
" haar_y3 0.009030 0 -1 0.010436 0.821148  1 2 2 7 18 3 0 -1 2 8 18 1 0 3 haar_y3 -0.007954 0 -1\n"
" 0.226329 -0.345682  1 3 3 13 18 4 0 -1 12 13 9 2 0 2 3 15 9 2 0 2 haar_x2_y2 0.027091 0 -1\n"
" 0.164301 -1.392638  1 2 3 5 6 9 0 -1 5 5 2 9 0 3 haar_x3 -0.020626 0 -1 -0.863661 0.002388 \n"
" 1 3 4 1 20 4 0 -1 14 1 10 2 0 2 4 3 10 2 0 2 haar_x2_y2 -0.071990 0 -1 -2.819263 0.115705 \n"
" 1 3 0 1 20 4 0 -1 0 1 10 2 0 2 10 3 10 2 0 2 haar_x2_y2 -0.026965 0 -1 -1.294613 -0.024661 \n"
" 1 2 10 15 6 6 0 -1 10 15 3 6 0 2 haar_x2 -0.047378 0 -1 -0.813064 0.118314  1 2 0 2 24 8 0 -1\n"
" 8 2 8 8 0 3 haar_x3 -0.108956 0 -1 0.659379 -0.208439  1 2 5 5 18 3 0 -1 5 6 18 1 0 3\n"
" haar_y3 0.013574 0 -1 0.007424 0.531522  1 2 8 15 6 6 0 -1 11 15 3 6 0 2 haar_x2\n"
" -0.006692 0 -1 0.306558 -0.310843  1 2 11 12 8 5 0 -1 11 12 4 5 0 2 haar_x2 -0.003907 0 -1\n"
" 0.255765 -0.052932  1 2 5 12 8 5 0 -1 9 12 4 5 0 2 haar_x2 -0.037613 0 -1 -1.435005 -0.015448 \n"
" 1 2 5 0 14 6 0 -1 5 2 14 2 0 3 haar_y3 0.008633 0 -1 -0.168844 0.421249  1 2 10 2 4 15 0 -1\n"
" 10 7 4 5 0 3 haar_y3 -0.032097 0 -1 -0.649794 0.041110  1 2 10 7 5 12 0 -1 10 11 5 4 0 3\n"
" haar_y3 0.058496 0 -1 -0.052964 0.633683  1 3 7 9 8 14 0 -1 7 9 4 7 0 2 11 16 4 7 0 2\n"
" haar_x2_y2 -0.040902 0 -1 -0.921011 0.009064  1 3 1 5 22 6 0 -1 12 5 11 3 0 2 1 8 11 3 0 2\n"
" haar_x2_y2 -0.019925 0 -1 0.537600 -0.062997  1 2 0 5 6 6 0 -1 0 8 6 3 0 2 haar_y2\n"
" -0.004602 0 -1 -0.543335 0.084105  1 2 12 17 9 4 0 -1 12 19 9 2 0 2 haar_y2 0.016825 0 -1\n"
" 0.155637 -0.401712  1 2 2 18 19 3 0 -1 2 19 19 1 0 3 haar_y3 0.009479 0 -1 -0.242453 0.515095 \n"
" 1 2 12 17 9 4 0 -1 12 19 9 2 0 2 haar_y2 -0.019535 0 -1 -0.511184 0.138320  1 2 1 17 18 3 0 -1\n"
" 1 18 18 1 0 3 haar_y3 0.010746 0 -1 -0.218550 0.628287  1 2 12 17 9 4 0 -1 12 19 9 2 0 2\n"
" haar_y2 0.037927 0 -1 0.116403 -2.730196  1 2 0 0 24 3 0 -1 0 1 24 1 0 3 haar_y3\n"
" 0.016391 0 -1 -0.014636 -1.079725  1 2 5 0 14 4 0 -1 5 2 14 2 0 2 haar_y2 -0.019785 0 -1\n"
" 1.216642 0.033275  1 2 6 14 9 6 0 -1 6 16 9 2 0 3 haar_y3 0.011067 0 -1 -0.253883 0.440386 \n"
" 1 2 14 13 6 9 0 -1 14 16 6 3 0 3 haar_y3 0.005248 0 -1 0.224968 -0.242165  1 2 5 20 13 4 0 -1\n"
" 5 22 13 2 0 2 haar_y2 -0.011142 0 -1 0.250181 -0.308115  1 2 9 9 6 12 0 -1 9 13 6 4 0 3\n"
" haar_y3 -0.010667 0 -1 -0.327291 0.261683  1 2 1 10 21 3 0 -1 8 10 7 3 0 3 haar_x3\n"
" 0.105453 0 -1 -0.055750 -1.960573  1 2 8 8 9 6 0 -1 11 8 3 6 0 3 haar_x3 0.054828 0 -1\n"
" -0.001952 0.738661  1 2 3 10 9 7 0 -1 6 10 3 7 0 3 haar_x3 0.017761 0 -1 -0.306472 0.263470 \n"
" 1 3 12 10 10 8 0 -1 17 10 5 4 0 2 12 14 5 4 0 2 haar_x2_y2 -0.031186 0 -1 -0.246009 0.170822 \n"
" 1 2 0 15 24 3 0 -1 8 15 8 3 0 3 haar_x3 -0.057296 0 -1 0.470335 -0.260483  1 2 8 5 9 6 0 -1\n"
" 8 7 9 2 0 3 haar_y3 -0.011312 0 -1 0.386289 -0.288170  1 2 4 13 6 9 0 -1 4 16 6 3 0 3\n"
" haar_y3 0.030592 0 -1 -0.048826 -1.763897  1 2 12 17 9 4 0 -1 12 19 9 2 0 2 haar_y2\n"
" 0.001849 0 -1 0.210999 -0.025941  1 2 9 12 6 6 0 -1 9 15 6 3 0 2 haar_y2 0.011419 0 -1\n"
" -0.168296 1.027866  1 3 9 9 14 10 0 -1 16 9 7 5 0 2 9 14 7 5 0 2 haar_x2_y2 0.081403 0 -1\n"
" 0.115320 -1.248240  1 3 1 9 14 10 0 -1 1 9 7 5 0 2 8 14 7 5 0 2 haar_x2_y2 0.053496 0 -1\n"
" -0.046304 -1.716597  1 2 8 7 9 17 0 -1 11 7 3 17 0 3 haar_x3 -0.023948 0 -1 -0.402466 0.205621 \n"
" 1 3 3 4 6 20 0 -1 3 4 3 10 0 2 6 14 3 10 0 2 haar_x2_y2 0.006769 0 -1 -0.331523 0.206834 \n"
" 1 2 7 8 10 4 0 -1 7 8 5 4 0 2 haar_x2 -0.032344 0 -1 -0.726328 0.200735  1 2 10 7 4 9 0 -1\n"
" 12 7 2 9 0 2 haar_x2 0.037863 0 -1 -0.156310 1.669746  1 2 10 15 6 9 0 -1 12 15 2 9 0 3\n"
" haar_x3 0.015440 0 -1 0.194874 -0.353842  1 3 3 8 6 16 0 -1 3 8 3 8 0 2 6 16 3 8 0 2\n"
" haar_x2_y2 -0.044376 0 -1 0.820936 -0.181936  1 2 12 17 9 4 0 -1 12 19 9 2 0 2 haar_y2\n"
" -0.023102 0 -1 -0.430441 0.123754  1 2 3 17 9 4 0 -1 3 19 9 2 0 2 haar_y2 0.019400 0 -1\n"
" -0.029726 -1.159759  1 2 10 1 9 6 0 -1 13 1 3 6 0 3 haar_x3 0.103857 0 -1 0.111499 -4.683522 \n"
" 1 2 5 7 4 10 0 -1 5 12 4 5 0 2 haar_y2 -0.018964 0 -1 2.177382 -0.145444  1 2 7 5 12 6 0 -1\n"
" 11 5 4 6 0 3 haar_x3 0.038751 0 -1 -0.049446 0.340183  1 2 6 4 9 8 0 -1 9 4 3 8 0 3\n"
" haar_x3 0.022767 0 -1 -0.328030 0.305314  1 3 12 16 10 8 0 -1 17 16 5 4 0 2 12 20 5 4 0 2\n"
" haar_x2_y2 -0.031357 0 -1 1.152082 0.027306  1 3 2 16 10 8 0 -1 2 16 5 4 0 2 7 20 5 4 0 2\n"
" haar_x2_y2 0.009691 0 -1 -0.387995 0.215126  1 3 0 0 24 4 0 -1 12 0 12 2 0 2 0 2 12 2 0 2\n"
" haar_x2_y2 -0.049285 0 -1 -1.677491 0.157742  1 2 0 6 9 6 0 -1 0 8 9 2 0 3 haar_y3\n"
" -0.039511 0 -1 -0.976479 -0.010552  1 3 0 4 24 6 0 -1 12 4 12 3 0 2 0 7 12 3 0 2\n"
" haar_x2_y2 0.047998 0 -1 0.208439 -0.689928  1 2 5 0 11 4 0 -1 5 2 11 2 0 2 haar_y2\n"
" 0.051423 0 -1 -0.166653 1.214924  1 3 1 1 22 4 0 -1 12 1 11 2 0 2 1 3 11 2 0 2 haar_x2_y2\n"
" 0.014280 0 -1 0.236277 -0.413968  1 2 9 6 6 18 0 -1 9 15 6 9 0 2 haar_y2 -0.091612 0 -1\n"
" -0.928309 -0.018345  1 2 2 9 20 4 0 -1 2 11 20 2 0 2 haar_y2 0.006508 0 -1 -0.736472 0.194971 \n"
" 1 2 5 2 14 14 0 -1 5 9 14 7 0 2 haar_y2 0.035723 0 -1 0.141978 -0.420893  1 2 4 2 16 6 0 -1\n"
" 4 5 16 3 0 2 haar_y2 0.050638 0 -1 0.011644 0.784866  1 2 2 3 19 3 0 -1 2 4 19 1 0 3\n"
" haar_y3 -0.014614 0 -1 -1.190950 -0.035128  1 2 7 1 10 4 0 -1 7 3 10 2 0 2 haar_y2\n"
" -0.038663 0 -1 2.431473 0.065648  1 2 0 9 4 15 0 -1 0 14 4 5 0 3 haar_y3 -0.040347 0 -1\n"
" 0.717553 -0.191083  1 2 2 10 21 3 0 -1 2 11 21 1 0 3 haar_y3 0.023902 0 -1 0.156462 -0.792948 \n"
" -3.426590\n"
,

/* Stage 15 */
" 137 1 2 3 0 6 6 0 -1 6 0 3 6 0 2 haar_x2 0.008564 0 -1 -0.814507 0.588753  1 2 6 4 14 9 0 -1\n"
" 6 7 14 3 0 3 haar_y3 -0.132926 0 -1 0.932134 -0.293673  1 2 9 1 6 9 0 -1 11 1 2 9 0 3\n"
" haar_x3 0.009840 0 -1 -0.564629 0.416477  1 2 15 8 9 9 0 -1 15 11 9 3 0 3 haar_y3\n"
" 0.005089 0 -1 -0.792328 0.169750  1 2 8 0 4 21 0 -1 8 7 4 7 0 3 haar_y3 -0.061039 0 -1\n"
" -1.416900 0.025021  1 2 3 22 19 2 0 -1 3 23 19 1 0 2 haar_y2 -0.000466 0 -1 0.379825 -0.415671 \n"
" 1 2 2 15 20 3 0 -1 2 16 20 1 0 3 haar_y3 0.003389 0 -1 -0.407686 0.355485  1 2 19 0 4 13 0 -1\n"
" 19 0 2 13 0 2 haar_x2 0.021007 0 -1 -0.240801 0.861127  1 2 1 7 8 8 0 -1 1 11 8 4 0 2\n"
" haar_y2 0.007556 0 -1 -0.874672 0.098572  1 2 14 14 6 9 0 -1 14 17 6 3 0 3 haar_y3\n"
" 0.024780 0 -1 0.155662 -0.692298  1 2 4 14 6 9 0 -1 4 17 6 3 0 3 haar_y3 -0.035620 0 -1\n"
" -1.147227 0.036360  1 2 14 5 4 10 0 -1 14 5 2 10 0 2 haar_x2 0.019810 0 -1 0.155162 -0.695201 \n"
" 1 2 6 5 4 10 0 -1 8 5 2 10 0 2 haar_x2 0.015020 0 -1 0.041990 -0.966228  1 2 14 5 6 6 0 -1\n"
" 14 8 6 3 0 2 haar_y2 -0.023138 0 -1 0.433969 0.002416  1 2 4 5 6 6 0 -1 4 8 6 3 0 2\n"
" haar_y2 -0.018743 0 -1 0.434811 -0.325225  1 2 0 2 24 21 0 -1 8 2 8 21 0 3 haar_x3\n"
" 0.450800 0 -1 -0.094574 0.724213  1 2 1 2 6 13 0 -1 3 2 2 13 0 3 haar_x3 0.011855 0 -1\n"
" -0.381331 0.300984  1 2 20 0 4 21 0 -1 20 0 2 21 0 2 haar_x2 -0.024830 0 -1 0.893006 -0.102959 \n"
" 1 2 0 4 4 20 0 -1 2 4 2 20 0 2 haar_x2 -0.044743 0 -1 0.862803 -0.217165  1 2 8 16 9 6 0 -1\n"
" 8 18 9 2 0 3 haar_y3 -0.014600 0 -1 0.600694 -0.159063  1 2 7 0 6 9 0 -1 9 0 2 9 0 3\n"
" haar_x3 -0.024527 0 -1 -1.587287 -0.021817  1 2 16 12 7 9 0 -1 16 15 7 3 0 3 haar_y3\n"
" 0.023024 0 -1 0.168534 -0.381069  1 2 5 21 14 3 0 -1 12 21 7 3 0 2 haar_x2 -0.024917 0 -1\n"
" 0.508109 -0.272799  1 2 11 5 6 9 0 -1 11 5 3 9 0 2 haar_x2 0.001013 0 -1 -0.431388 0.264381 \n"
" 1 2 10 5 4 10 0 -1 12 5 2 10 0 2 haar_x2 0.015603 0 -1 -0.316242 0.557159  1 2 10 6 6 9 0 -1\n"
" 12 6 2 9 0 3 haar_x3 -0.026686 0 -1 1.055392 0.029074  1 2 7 5 6 9 0 -1 10 5 3 9 0 2\n"
" haar_x2 0.001394 0 -1 -0.718738 0.065391  1 2 14 14 10 4 0 -1 14 16 10 2 0 2 haar_y2\n"
" -0.000648 0 -1 0.248844 -0.209782  1 3 5 5 14 14 0 -1 5 5 7 7 0 2 12 12 7 7 0 2 haar_x2_y2\n"
" -0.031888 0 -1 -0.688445 0.063590  1 3 12 8 12 6 0 -1 18 8 6 3 0 2 12 11 6 3 0 2\n"
" haar_x2_y2 -0.004929 0 -1 -0.591525 0.279436  1 3 6 6 12 12 0 -1 6 6 6 6 0 2 12 12 6 6 0 2\n"
" haar_x2_y2 0.031168 0 -1 0.045224 -0.886392  1 2 11 13 6 10 0 -1 13 13 2 10 0 3 haar_x3\n"
" -0.033663 0 -1 -0.615902 0.157493  1 3 1 10 20 8 0 -1 1 10 10 4 0 2 11 14 10 4 0 2\n"
" haar_x2_y2 0.011967 0 -1 -0.306067 0.422933  1 2 15 13 9 6 0 -1 15 15 9 2 0 3 haar_y3\n"
" -0.034680 0 -1 -1.373494 0.159087  1 2 9 0 6 9 0 -1 9 3 6 3 0 3 haar_y3 0.009929 0 -1\n"
" -0.558602 0.121192  1 2 10 1 5 14 0 -1 10 8 5 7 0 2 haar_y2 0.059575 0 -1 0.004972 0.820554 \n"
" 1 2 3 4 16 6 0 -1 3 6 16 2 0 3 haar_y3 -0.065428 0 -1 1.565143 -0.168175  1 2 16 3 8 9 0 -1\n"
" 16 6 8 3 0 3 haar_y3 -0.092896 0 -1 -1.579453 0.146618  1 2 7 13 6 10 0 -1 9 13 2 10 0 3\n"
" haar_x3 -0.041184 0 -1 -1.551872 -0.029970  1 2 15 13 9 6 0 -1 15 15 9 2 0 3 haar_y3\n"
" 0.021448 0 -1 0.171963 -0.693432  1 2 0 13 9 6 0 -1 0 15 9 2 0 3 haar_y3 -0.025570 0 -1\n"
" -1.306131 -0.024337  1 2 13 16 9 6 0 -1 13 18 9 2 0 3 haar_y3 -0.041201 0 -1 -1.382106 0.148018 \n"
" 1 2 2 16 9 6 0 -1 2 18 9 2 0 3 haar_y3 -0.017669 0 -1 -0.708900 0.036524  1 2 5 16 18 3 0 -1\n"
" 5 17 18 1 0 3 haar_y3 0.009006 0 -1 -0.040914 0.803731  1 2 1 16 18 3 0 -1 1 17 18 1 0 3\n"
" haar_y3 -0.011653 0 -1 0.575468 -0.249917  1 2 5 0 18 3 0 -1 5 1 18 1 0 3 haar_y3\n"
" -0.007478 0 -1 -0.492809 0.198109  1 2 1 1 19 2 0 -1 1 2 19 1 0 2 haar_y2 0.000855 0 -1\n"
" -0.488581 0.135631  1 2 14 2 6 11 0 -1 16 2 2 11 0 3 haar_x3 -0.030538 0 -1 -0.602784 0.185220 \n"
" 1 2 4 15 15 6 0 -1 9 15 5 6 0 3 haar_x3 -0.018847 0 -1 0.235656 -0.351363  1 2 14 2 6 11 0 -1\n"
" 16 2 2 11 0 3 haar_x3 -0.008113 0 -1 -0.081305 0.210696  1 2 4 2 6 11 0 -1 6 2 2 11 0 3\n"
" haar_x3 -0.034830 0 -1 -1.206567 -0.014252  1 2 18 2 6 9 0 -1 18 5 6 3 0 3 haar_y3\n"
" 0.019021 0 -1 0.233499 -0.456649  1 3 1 2 22 4 0 -1 1 2 11 2 0 2 12 4 11 2 0 2 haar_x2_y2\n"
" -0.019004 0 -1 -0.810758 0.013140  1 2 2 0 21 12 0 -1 9 0 7 12 0 3 haar_x3 -0.089058 0 -1\n"
" 0.615424 0.032983  1 2 0 12 18 3 0 -1 0 13 18 1 0 3 haar_y3 0.006862 0 -1 -0.295831 0.270037 \n"
" 1 2 12 2 6 9 0 -1 14 2 2 9 0 3 haar_x3 -0.028241 0 -1 -0.611027 0.173575  1 2 3 10 18 3 0 -1\n"
" 3 11 18 1 0 3 haar_y3 -0.000321 0 -1 -0.533229 0.068539  1 2 16 3 8 9 0 -1 16 6 8 3 0 3\n"
" haar_y3 -0.108291 0 -1 -1.287956 0.118017  1 2 3 7 18 3 0 -1 3 8 18 1 0 3 haar_y3\n"
" 0.015879 0 -1 -0.170726 1.110391  1 2 9 11 6 9 0 -1 11 11 2 9 0 3 haar_x3 0.008686 0 -1\n"
" -0.109951 0.460105  1 2 9 8 6 9 0 -1 11 8 2 9 0 3 haar_x3 -0.025235 0 -1 1.022067 -0.186943 \n"
" 1 2 15 0 2 18 0 -1 15 0 1 18 0 2 haar_x2 -0.013509 0 -1 -0.783166 0.142026  1 2 7 0 2 18 0 -1\n"
" 8 0 1 18 0 2 haar_x2 -0.007715 0 -1 -0.880607 0.011060  1 2 17 3 7 9 0 -1 17 6 7 3 0 3\n"
" haar_y3 0.071580 0 -1 0.113694 -1.103279  1 2 3 18 9 6 0 -1 3 20 9 2 0 3 haar_y3\n"
" -0.013554 0 -1 -0.810965 0.003408  1 2 3 18 21 3 0 -1 3 19 21 1 0 3 haar_y3 0.002945 0 -1\n"
" -0.072880 0.349981  1 2 0 3 7 9 0 -1 0 6 7 3 0 3 haar_y3 -0.050833 0 -1 -1.286859 -0.028842 \n"
" 1 2 2 7 22 3 0 -1 2 8 22 1 0 3 haar_y3 -0.008799 0 -1 0.476136 -0.146904  1 3 0 3 24 16 0 -1\n"
" 0 3 12 8 0 2 12 11 12 8 0 2 haar_x2_y2 0.214244 0 -1 -0.059702 -2.480226  1 2 13 17 9 4 0 -1\n"
" 13 19 9 2 0 2 haar_y2 0.013963 0 -1 0.174203 -0.439110  1 3 5 5 12 8 0 -1 5 5 6 4 0 2\n"
" 11 9 6 4 0 2 haar_x2_y2 0.042502 0 -1 -0.199653 0.706548  1 3 5 6 14 6 0 -1 12 6 7 3 0 2\n"
" 5 9 7 3 0 2 haar_x2_y2 0.019828 0 -1 -0.069136 0.616434  1 3 5 16 14 6 0 -1 5 16 7 3 0 2\n"
" 12 19 7 3 0 2 haar_x2_y2 -0.033560 0 -1 -1.274078 -0.025673  1 2 18 2 6 9 0 -1 18 5 6 3 0 3\n"
" haar_y3 0.063543 0 -1 0.124035 -1.077629  1 2 0 2 6 9 0 -1 0 5 6 3 0 3 haar_y3 0.021933 0 -1\n"
" 0.014952 -0.710235  1 3 3 4 20 10 0 -1 13 4 10 5 0 2 3 9 10 5 0 2 haar_x2_y2 -0.078425 0 -1\n"
" 0.620340 0.033611  1 2 2 13 9 8 0 -1 5 13 3 8 0 3 haar_x3 0.014390 0 -1 -0.363246 0.173083 \n"
" 1 2 2 1 21 15 0 -1 9 1 7 15 0 3 haar_x3 -0.067310 0 -1 0.523741 0.012800  1 2 5 12 14 8 0 -1\n"
" 12 12 7 8 0 2 haar_x2 0.130475 0 -1 -0.171225 1.123520  1 2 6 7 12 4 0 -1 6 7 6 4 0 2\n"
" haar_x2 -0.046246 0 -1 -1.190833 0.174256  1 2 6 5 9 6 0 -1 9 5 3 6 0 3 haar_x3 -0.029842 0 -1\n"
" 0.839306 -0.180642  1 2 13 11 6 6 0 -1 13 11 3 6 0 2 haar_x2 -0.000381 0 -1 0.355328 -0.238423 \n"
" 1 2 5 11 6 6 0 -1 8 11 3 6 0 2 haar_x2 -0.022379 0 -1 -0.879439 -0.000784  1 2 6 4 18 2 0 -1\n"
" 6 5 18 1 0 2 haar_y2 -0.001557 0 -1 -0.142533 0.258762  1 2 0 2 6 11 0 -1 2 2 2 11 0 3\n"
" haar_x3 0.012013 0 -1 -0.290155 0.260511  1 2 18 0 6 15 0 -1 20 0 2 15 0 3 haar_x3\n"
" 0.024385 0 -1 -0.031439 0.586959  1 2 0 0 6 13 0 -1 2 0 2 13 0 3 haar_x3 -0.047181 0 -1\n"
" 0.694301 -0.218161  1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 -0.024894 0 -1 -0.645993 0.156116 \n"
" 1 2 6 0 6 9 0 -1 8 0 2 9 0 3 haar_x3 0.021945 0 -1 -0.027742 -1.134688  1 2 0 2 24 4 0 -1\n"
" 8 2 8 4 0 3 haar_x3 0.188099 0 -1 -0.010076 1.242903  1 2 3 13 18 4 0 -1 12 13 9 4 0 2\n"
" haar_x2 -0.077872 0 -1 0.850080 -0.190155  1 2 9 7 10 4 0 -1 9 7 5 4 0 2 haar_x2\n"
" -0.048769 0 -1 -2.076308 0.121794  1 2 5 8 12 3 0 -1 11 8 6 3 0 2 haar_x2 -0.017115 0 -1\n"
" -0.856873 0.007876  1 2 4 14 19 3 0 -1 4 15 19 1 0 3 haar_y3 -0.002750 0 -1 0.386455 -0.113915 \n"
" 1 2 10 0 4 20 0 -1 10 10 4 10 0 2 haar_y2 -0.098794 0 -1 -1.723390 -0.056063  1 2\n"
" 8 15 9 6 0 -1 8 17 9 2 0 3 haar_y3 -0.021937 0 -1 0.547494 -0.042482  1 2 2 9 15 4 0 -1\n"
" 7 9 5 4 0 3 haar_x3 0.061097 0 -1 -0.038945 -1.080788  1 2 8 4 12 7 0 -1 12 4 4 7 0 3\n"
" haar_x3 -0.024564 0 -1 0.583111 -0.000976  1 2 0 10 6 9 0 -1 0 13 6 3 0 3 haar_y3\n"
" 0.033752 0 -1 -0.013796 -0.847303  1 2 18 5 6 9 0 -1 18 8 6 3 0 3 haar_y3 0.038199 0 -1\n"
" 0.151143 -0.794734  1 3 0 18 16 6 0 -1 0 18 8 3 0 2 8 21 8 3 0 2 haar_x2_y2 -0.020118 0 -1\n"
" 0.515791 -0.214454  1 3 9 18 14 6 0 -1 16 18 7 3 0 2 9 21 7 3 0 2 haar_x2_y2 0.024735 0 -1\n"
" -0.022105 0.429177  1 3 1 20 20 4 0 -1 1 20 10 2 0 2 11 22 10 2 0 2 haar_x2_y2 -0.024357 0 -1\n"
" -0.862013 -0.003676  1 3 2 8 20 6 0 -1 12 8 10 3 0 2 2 11 10 3 0 2 haar_x2_y2 -0.026442 0 -1\n"
" -0.453975 0.224628  1 2 7 8 6 9 0 -1 9 8 2 9 0 3 haar_x3 -0.003443 0 -1 0.130730 -0.386227 \n"
" 1 2 8 5 12 8 0 -1 12 5 4 8 0 3 haar_x3 0.107017 0 -1 0.131586 -0.793069  1 2 4 5 12 8 0 -1\n"
" 8 5 4 8 0 3 haar_x3 0.045153 0 -1 -0.252968 0.406724  1 2 10 6 6 9 0 -1 12 6 2 9 0 3\n"
" haar_x3 0.044350 0 -1 0.022613 0.796181  1 2 2 0 6 16 0 -1 4 0 2 16 0 3 haar_x3 0.001084 0 -1\n"
" -0.391584 0.116391  1 2 15 4 6 12 0 -1 15 8 6 4 0 3 haar_y3 0.071433 0 -1 0.082467 1.253059 \n"
" 1 2 3 4 6 12 0 -1 3 8 6 4 0 3 haar_y3 0.035838 0 -1 -0.182033 0.770787  1 2 15 12 9 6 0 -1\n"
" 15 14 9 2 0 3 haar_y3 -0.020839 0 -1 -0.617444 0.158914  1 2 4 0 15 22 0 -1 4 11 15 11 0 2\n"
" haar_y2 0.425258 0 -1 -0.048978 -1.842203  1 2 15 12 9 6 0 -1 15 14 9 2 0 3 haar_y3\n"
" 0.011408 0 -1 0.179182 -0.153835  1 2 0 12 9 6 0 -1 0 14 9 2 0 3 haar_y3 -0.015365 0 -1\n"
" -0.840165 -0.001028  1 2 15 15 9 6 0 -1 15 17 9 2 0 3 haar_y3 -0.015212 0 -1 -0.189957 0.171310 \n"
" 1 2 0 15 9 6 0 -1 0 17 9 2 0 3 haar_y3 -0.018972 0 -1 -0.795420 0.006680  1 3 10 0 8 10 0 -1\n"
" 14 0 4 5 0 2 10 5 4 5 0 2 haar_x2_y2 -0.003333 0 -1 -0.235308 0.247301  1 2 1 0 4 16 0 -1\n"
" 3 0 2 16 0 2 haar_x2 0.093248 0 -1 -0.054758 -1.832430  1 2 7 6 10 6 0 -1 7 8 10 2 0 3\n"
" haar_y3 -0.012555 0 -1 0.263852 -0.385264  1 2 10 12 4 10 0 -1 10 17 4 5 0 2 haar_y2\n"
" -0.027070 0 -1 -0.669298 0.020341  1 2 8 4 10 6 0 -1 8 6 10 2 0 3 haar_y3 -0.023677 0 -1\n"
" 0.672653 -0.014344  1 2 3 22 18 2 0 -1 12 22 9 2 0 2 haar_x2 -0.014275 0 -1 0.301864 -0.285144 \n"
" 1 2 7 7 11 6 0 -1 7 9 11 2 0 3 haar_y3 0.028097 0 -1 0.147660 -1.407852  1 3 0 0 12 10 0 -1\n"
" 0 0 6 5 0 2 6 5 6 5 0 2 haar_x2_y2 0.050840 0 -1 -0.186136 0.799530  1 3 10 1 12 6 0 -1\n"
" 16 1 6 3 0 2 10 4 6 3 0 2 haar_x2_y2 0.011506 0 -1 0.191184 -0.085035  1 2 7 16 9 4 0 -1\n"
" 7 18 9 2 0 2 haar_y2 -0.014661 0 -1 0.452393 -0.222052  1 2 5 7 15 16 0 -1 10 7 5 16 0 3\n"
" haar_x3 0.228425 0 -1 0.134884 -1.289461  1 2 5 10 12 13 0 -1 11 10 6 13 0 2 haar_x2\n"
" 0.111069 0 -1 -0.207538 0.545616  1 3 6 2 12 6 0 -1 12 2 6 3 0 2 6 5 6 3 0 2 haar_x2_y2\n"
" 0.003245 0 -1 0.320537 -0.164035  1 2 3 9 12 9 0 -1 3 12 12 3 0 3 haar_y3 0.085310 0 -1\n"
" -0.202105 0.532968  1 2 16 2 8 6 0 -1 16 5 8 3 0 2 haar_y2 0.022048 0 -1 0.156986 -0.170141 \n"
" 1 2 0 2 8 6 0 -1 0 5 8 3 0 2 haar_y2 -0.015677 0 -1 -0.628635 0.040762  1 2 0 3 24 11 0 -1\n"
" 0 3 12 11 0 2 haar_x2 0.331129 0 -1 0.166093 -1.032638  1 3 0 13 8 10 0 -1 0 13 4 5 0 2\n"
" 4 18 4 5 0 2 haar_x2_y2 0.008847 0 -1 -0.250762 0.316606  1 2 10 14 4 10 0 -1 10 19 4 5 0 2\n"
" haar_y2 0.046080 0 -1 0.153521 -1.633350  1 2 10 2 4 21 0 -1 10 9 4 7 0 3 haar_y3\n"
" -0.037703 0 -1 0.568738 -0.201026  -3.512527\n"
,

/* Stage 16 */
" 159 1 2 4 4 15 9 0 -1 4 7 15 3 0 3 haar_y3 -0.081809 0 -1 0.571248 -0.674388  1 2\n"
" 0 1 24 6 0 -1 8 1 8 6 0 3 haar_x3 0.217612 0 -1 -0.386102 0.903440  1 2 9 6 5 16 0 -1\n"
" 9 14 5 8 0 2 haar_y2 0.014878 0 -1 0.222416 -1.277935  1 2 3 21 18 3 0 -1 9 21 6 3 0 3\n"
" haar_x3 0.052435 0 -1 -0.286904 0.757423  1 2 6 5 3 12 0 -1 6 11 3 6 0 2 haar_y2\n"
" 0.009143 0 -1 -0.648804 0.222688  1 2 11 6 4 9 0 -1 11 6 2 9 0 2 haar_x2 0.007917 0 -1\n"
" -0.292536 0.310302  1 2 5 6 9 8 0 -1 8 6 3 8 0 3 haar_x3 -0.026084 0 -1 0.455327 -0.385006 \n"
" 1 2 4 3 20 2 0 -1 4 4 20 1 0 2 haar_y2 -0.002940 0 -1 -0.512644 0.274323  1 2 2 10 18 3 0 -1\n"
" 8 10 6 3 0 3 haar_x3 0.057130 0 -1 0.015788 -1.213310  1 2 7 15 10 6 0 -1 7 17 10 2 0 3\n"
" haar_y3 -0.006131 0 -1 0.391746 -0.308668  1 3 1 4 4 18 0 -1 1 4 2 9 0 2 3 13 2 9 0 2\n"
" haar_x2_y2 -0.040405 0 -1 1.190195 -0.203471  1 2 13 0 6 9 0 -1 15 0 2 9 0 3 haar_x3\n"
" -0.020297 0 -1 -0.682395 0.204587  1 2 5 0 6 9 0 -1 7 0 2 9 0 3 haar_x3 -0.017189 0 -1\n"
" -0.849399 0.038433  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3 -0.024216 0 -1 -1.103942 0.159751 \n"
" 1 2 6 7 9 6 0 -1 9 7 3 6 0 3 haar_x3 0.056869 0 -1 -0.195953 1.180685  1 2 3 0 18 2 0 -1\n"
" 3 1 18 1 0 2 haar_y2 0.000362 0 -1 -0.408478 0.329386  1 3 0 10 20 4 0 -1 0 10 10 2 0 2\n"
" 10 12 10 2 0 2 haar_x2_y2 0.009979 0 -1 -0.296730 0.415479  1 2 10 2 4 12 0 -1 10 8 4 6 0 2\n"
" haar_y2 -0.052625 0 -1 -1.306930 0.178626  1 3 6 5 6 12 0 -1 6 5 3 6 0 2 9 11 3 6 0 2\n"
" haar_x2_y2 -0.013749 0 -1 0.236658 -0.445366  1 3 6 0 18 22 0 -1 15 0 9 11 0 2 6 11 9 11 0 2\n"
" haar_x2_y2 -0.030517 0 -1 0.290183 -0.112101  1 3 0 0 18 22 0 -1 0 0 9 11 0 2 9 11 9 11 0 2\n"
" haar_x2_y2 -0.300375 0 -1 -2.423768 -0.042831  1 2 18 2 6 11 0 -1 20 2 2 11 0 3 haar_x3\n"
" -0.035991 0 -1 0.882065 -0.047013  1 2 0 2 6 11 0 -1 2 2 2 11 0 3 haar_x3 -0.055112 0 -1\n"
" 0.801190 -0.204910  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3 0.033762 0 -1 0.146176 -1.134949 \n"
" 1 2 0 0 20 3 0 -1 0 1 20 1 0 3 haar_y3 -0.008271 0 -1 -0.816049 0.018988  1 2 2 2 20 2 0 -1\n"
" 2 3 20 1 0 2 haar_y2 -0.005440 0 -1 -0.709809 0.223437  1 2 1 10 18 2 0 -1 1 11 18 1 0 2\n"
" haar_y2 0.003106 0 -1 -0.728086 0.040225  1 2 18 7 6 9 0 -1 18 10 6 3 0 3 haar_y3\n"
" 0.053652 0 -1 0.171709 -1.116371  1 2 0 0 22 9 0 -1 0 3 22 3 0 3 haar_y3 -0.125414 0 -1\n"
" 2.768037 -0.146115  1 2 17 3 6 9 0 -1 17 6 6 3 0 3 haar_y3 0.092542 0 -1 0.116098 -3.963553 \n"
" 1 2 0 7 6 9 0 -1 0 10 6 3 0 3 haar_y3 0.038514 0 -1 -0.007640 -0.987809  1 2 0 6 24 6 0 -1\n"
" 0 8 24 2 0 3 haar_y3 -0.002020 0 -1 0.230600 -0.749703  1 2 0 2 6 10 0 -1 2 2 2 10 0 3\n"
" haar_x3 0.009760 0 -1 -0.311380 0.302878  1 2 10 6 6 9 0 -1 12 6 2 9 0 3 haar_x3\n"
" 0.024095 0 -1 -0.049530 0.526901  1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 -0.017982 0 -1\n"
" -1.161064 -0.005700  1 2 15 0 6 9 0 -1 17 0 2 9 0 3 haar_x3 -0.010555 0 -1 -0.271891 0.235977 \n"
" 1 2 3 0 6 9 0 -1 5 0 2 9 0 3 haar_x3 -0.007289 0 -1 -0.542191 0.081914  1 2 15 17 9 6 0 -1\n"
" 15 19 9 2 0 3 haar_y3 0.023939 0 -1 0.179758 -0.670495  1 2 0 17 18 3 0 -1 0 18 18 1 0 3\n"
" haar_y3 -0.018366 0 -1 0.626643 -0.209701  1 2 15 14 9 6 0 -1 15 16 9 2 0 3 haar_y3\n"
" 0.015716 0 -1 0.241937 -1.044431  1 2 0 15 23 6 0 -1 0 17 23 2 0 3 haar_y3 -0.048804 0 -1\n"
" -0.940606 -0.003752  1 2 5 15 18 3 0 -1 5 16 18 1 0 3 haar_y3 0.006713 0 -1 -0.075432 0.615753 \n"
" 1 2 0 14 9 6 0 -1 0 16 9 2 0 3 haar_y3 0.009777 0 -1 0.039285 -0.848103  1 3 9 8 8 10 0 -1\n"
" 13 8 4 5 0 2 9 13 4 5 0 2 haar_x2_y2 0.014745 0 -1 0.169690 -0.509064  1 2 3 7 15 6 0 -1\n"
" 8 7 5 6 0 3 haar_x3 0.097079 0 -1 -0.033103 -1.270638  1 3 9 8 8 10 0 -1 13 8 4 5 0 2\n"
" 9 13 4 5 0 2 haar_x2_y2 0.048286 0 -1 0.094330 2.720319  1 2 5 0 6 12 0 -1 8 0 3 12 0 2\n"
" haar_x2 0.009781 0 -1 -0.395334 0.153638  1 3 9 8 8 10 0 -1 13 8 4 5 0 2 9 13 4 5 0 2\n"
" haar_x2_y2 -0.039894 0 -1 -0.227674 0.139140  1 2 8 5 6 9 0 -1 10 5 2 9 0 3 haar_x3\n"
" 0.022848 0 -1 -0.273920 0.341995  1 3 10 6 4 18 0 -1 12 6 2 9 0 2 10 15 2 9 0 2 haar_x2_y2\n"
" 0.006718 0 -1 -0.108743 0.481254  1 2 5 7 12 4 0 -1 11 7 6 4 0 2 haar_x2 0.059600 0 -1\n"
" -0.049522 -2.011709  1 3 9 8 8 10 0 -1 13 8 4 5 0 2 9 13 4 5 0 2 haar_x2_y2 0.006934 0 -1\n"
" 0.150375 -0.112719  1 3 7 8 8 10 0 -1 7 8 4 5 0 2 11 13 4 5 0 2 haar_x2_y2 0.015757 0 -1\n"
" -0.020885 -1.165198  1 3 11 10 6 14 0 -1 14 10 3 7 0 2 11 17 3 7 0 2 haar_x2_y2 -0.049690 0 -1\n"
" -0.802135 0.143723  1 2 9 5 6 19 0 -1 12 5 3 19 0 2 haar_x2 0.052347 0 -1 -0.208367 0.616776 \n"
" 1 3 6 12 12 6 0 -1 12 12 6 3 0 2 6 15 6 3 0 2 haar_x2_y2 0.022431 0 -1 0.203059 -0.753262 \n"
" 1 3 1 9 18 6 0 -1 1 9 9 3 0 2 10 12 9 3 0 2 haar_x2_y2 0.041142 0 -1 -0.181182 1.003336 \n"
" 1 3 16 14 8 10 0 -1 20 14 4 5 0 2 16 19 4 5 0 2 haar_x2_y2 -0.021632 0 -1 0.499990 -0.034663 \n"
" 1 3 0 9 22 8 0 -1 0 9 11 4 0 2 11 13 11 4 0 2 haar_x2_y2 -0.082808 0 -1 1.171190 -0.184336 \n"
" 1 3 8 18 12 6 0 -1 14 18 6 3 0 2 8 21 6 3 0 2 haar_x2_y2 0.008506 0 -1 -0.063225 0.290249 \n"
" 1 3 0 6 20 18 0 -1 0 6 10 9 0 2 10 15 10 9 0 2 haar_x2_y2 0.078905 0 -1 -0.232745 0.596958 \n"
" 1 3 3 6 20 12 0 -1 13 6 10 6 0 2 3 12 10 6 0 2 haar_x2_y2 -0.090207 0 -1 -0.822119 0.177722 \n"
" 1 3 0 16 10 8 0 -1 0 16 5 4 0 2 5 20 5 4 0 2 haar_x2_y2 -0.029269 0 -1 0.608607 -0.214689 \n"
" 1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 0.006950 0 -1 -0.042666 0.605121  1 2 0 11 19 3 0 -1\n"
" 0 12 19 1 0 3 haar_y3 -0.008063 0 -1 -1.150827 -0.027286  1 2 14 6 6 9 0 -1 14 9 6 3 0 3\n"
" haar_y3 0.019596 0 -1 -0.009188 0.568578  1 3 1 7 22 4 0 -1 1 7 11 2 0 2 12 9 11 2 0 2\n"
" haar_x2_y2 -0.014885 0 -1 0.376588 -0.271495  1 2 13 6 7 12 0 -1 13 10 7 4 0 3 haar_y3\n"
" 0.025217 0 -1 -0.099991 0.246647  1 2 4 7 11 9 0 -1 4 10 11 3 0 3 haar_y3 -0.015856 0 -1\n"
" 0.668267 -0.206147  1 3 12 10 10 8 0 -1 17 10 5 4 0 2 12 14 5 4 0 2 haar_x2_y2 0.029441 0 -1\n"
" 0.158322 -0.760609  1 2 2 12 9 7 0 -1 5 12 3 7 0 3 haar_x3 -0.008528 0 -1 0.382123 -0.254078 \n"
" 1 2 16 14 6 9 0 -1 16 17 6 3 0 3 haar_y3 0.024422 0 -1 0.151051 -0.287529  1 2 3 12 6 12 0 -1\n"
" 3 16 6 4 0 3 haar_y3 -0.033887 0 -1 -0.680028 0.034327  1 2 14 13 6 6 0 -1 14 16 6 3 0 2\n"
" haar_y2 -0.002081 0 -1 0.254139 -0.268591  1 2 8 0 6 9 0 -1 10 0 2 9 0 3 haar_x3\n"
" 0.030359 0 -1 -0.030842 -1.147681  1 2 9 1 6 23 0 -1 11 1 2 23 0 3 haar_x3 0.004021 0 -1\n"
" -0.352538 0.298681  1 2 0 16 9 6 0 -1 0 18 9 2 0 3 haar_y3 0.027681 0 -1 -0.038149 -1.326204 \n"
" 1 2 4 17 18 3 0 -1 4 18 18 1 0 3 haar_y3 0.007904 0 -1 -0.023737 0.705030  1 2 5 2 13 14 0 -1\n"
" 5 9 13 7 0 2 haar_y2 0.044031 0 -1 0.106749 -0.452612  1 3 15 0 8 12 0 -1 19 0 4 6 0 2\n"
" 15 6 4 6 0 2 haar_x2_y2 -0.032371 0 -1 0.466749 -0.061547  1 3 0 0 8 12 0 -1 0 0 4 6 0 2\n"
" 4 6 4 6 0 2 haar_x2_y2 0.020933 0 -1 -0.284479 0.438456  1 2 8 2 8 7 0 -1 8 2 4 7 0 2\n"
" haar_x2 0.025228 0 -1 -0.022537 0.703891  1 2 1 1 6 9 0 -1 3 1 2 9 0 3 haar_x3 0.006552 0 -1\n"
" -0.325549 0.240237  1 3 14 8 6 12 0 -1 17 8 3 6 0 2 14 14 3 6 0 2 haar_x2_y2 -0.058558 0 -1\n"
" -1.222772 0.116688  1 3 4 8 6 12 0 -1 4 8 3 6 0 2 7 14 3 6 0 2 haar_x2_y2 0.031900 0 -1\n"
" -0.019305 -1.097317  1 2 16 5 5 15 0 -1 16 10 5 5 0 3 haar_y3 -0.030445 0 -1 0.655825 0.075091 \n"
" 1 2 3 5 5 15 0 -1 3 10 5 5 0 3 haar_y3 0.014933 0 -1 -0.521558 0.115231  1 2 18 4 6 9 0 -1\n"
" 18 7 6 3 0 3 haar_y3 -0.049008 0 -1 -0.783040 0.166572  1 2 1 7 6 15 0 -1 1 12 6 5 0 3\n"
" haar_y3 0.083159 0 -1 -0.002688 -0.852823  1 3 11 15 12 8 0 -1 17 15 6 4 0 2 11 19 6 4 0 2\n"
" haar_x2_y2 0.023903 0 -1 -0.051011 0.419991  1 3 0 2 24 4 0 -1 0 2 12 2 0 2 12 4 12 2 0 2\n"
" haar_x2_y2 0.016429 0 -1 0.019233 -0.650491  1 2 15 1 2 19 0 -1 15 1 1 19 0 2 haar_x2\n"
" -0.011838 0 -1 -0.624098 0.154112  1 2 7 1 2 19 0 -1 8 1 1 19 0 2 haar_x2 -0.000168 0 -1\n"
" 0.175892 -0.343387  1 2 22 1 2 20 0 -1 22 1 1 20 0 2 haar_x2 0.019194 0 -1 0.043419 0.790692 \n"
" 1 2 0 1 2 20 0 -1 1 1 1 20 0 2 haar_x2 -0.010032 0 -1 0.456489 -0.224948  1 2 18 11 6 12 0 -1\n"
" 20 11 2 12 0 3 haar_x3 -0.014004 0 -1 0.335710 -0.004880  1 2 0 11 6 12 0 -1 2 11 2 12 0 3\n"
" haar_x3 -0.103199 0 -1 -2.337800 -0.058933  1 2 3 6 18 14 0 -1 3 13 18 7 0 2 haar_y2\n"
" -0.095697 0 -1 -0.661539 0.200986  1 2 6 10 7 8 0 -1 6 14 7 4 0 2 haar_y2 -0.041481 0 -1\n"
" 0.459392 -0.223141  1 2 7 9 12 12 0 -1 7 13 12 4 0 3 haar_y3 0.002410 0 -1 -0.268986 0.249230 \n"
" 1 2 2 18 18 5 0 -1 11 18 9 5 0 2 haar_x2 0.107250 0 -1 -0.186402 0.727698  1 2 4 21 20 3 0 -1\n"
" 4 22 20 1 0 3 haar_y3 0.003187 0 -1 -0.024609 0.286439  1 3 9 12 6 12 0 -1 9 12 3 6 0 2\n"
" 12 18 3 6 0 2 haar_x2_y2 0.029167 0 -1 -0.034683 -1.116258  1 2 4 6 18 3 0 -1 4 7 18 1 0 3\n"
" haar_y3 0.011287 0 -1 0.006376 0.666321  1 2 3 6 18 3 0 -1 3 7 18 1 0 3 haar_y3 -0.012001 0 -1\n"
" 0.424201 -0.262798  1 2 18 4 6 9 0 -1 18 7 6 3 0 3 haar_y3 -0.012696 0 -1 -0.021957 0.189368 \n"
" 1 2 2 12 9 6 0 -1 2 14 9 2 0 3 haar_y3 0.024597 0 -1 -0.034964 -1.098932  1 3 4 14 18 4 0 -1\n"
" 13 14 9 2 0 2 4 16 9 2 0 2 haar_x2_y2 0.045953 0 -1 0.111098 -2.930605  1 3 7 7 6 14 0 -1\n"
" 7 7 3 7 0 2 10 14 3 7 0 2 haar_x2_y2 -0.027241 0 -1 0.291017 -0.274079  1 3 7 13 12 6 0 -1\n"
" 13 13 6 3 0 2 7 16 6 3 0 2 haar_x2_y2 0.040064 0 -1 0.118779 -0.628018  1 2 6 7 12 9 0 -1\n"
" 10 7 4 9 0 3 haar_x3 0.023055 0 -1 0.148138 -0.370075  1 2 12 12 6 6 0 -1 12 12 3 6 0 2\n"
" haar_x2 -0.023737 0 -1 -0.537248 0.193582  1 2 0 2 4 10 0 -1 0 7 4 5 0 2 haar_y2\n"
" 0.077522 0 -1 -0.060194 -1.948967  1 2 8 0 9 6 0 -1 11 0 3 6 0 3 haar_x3 -0.013345 0 -1\n"
" -0.452296 0.187415  1 2 2 9 12 6 0 -1 2 12 12 3 0 2 haar_y2 -0.021720 0 -1 1.214425 -0.153658 \n"
" 1 2 13 10 6 9 0 -1 13 13 6 3 0 3 haar_y3 -0.071475 0 -1 -2.304713 0.109999  1 2 5 10 6 9 0 -1\n"
" 5 13 6 3 0 3 haar_y3 -0.005500 0 -1 -0.718552 0.020101  1 2 9 15 9 6 0 -1 9 17 9 2 0 3\n"
" haar_y3 0.026741 0 -1 0.073545 0.987860  1 2 5 16 12 6 0 -1 5 19 12 3 0 2 haar_y2\n"
" -0.039408 0 -1 -1.222738 -0.043507  1 2 3 2 20 3 0 -1 3 3 20 1 0 3 haar_y3 0.025889 0 -1\n"
" 0.134093 -1.177078  1 2 2 5 12 6 0 -1 6 5 4 6 0 3 haar_x3 0.048925 0 -1 -0.030810 -0.934795 \n"
" 1 2 11 0 3 24 0 -1 12 0 1 24 0 3 haar_x3 0.036893 0 -1 0.133337 -1.499829  1 2 3 16 15 4 0 -1\n"
" 8 16 5 4 0 3 haar_x3 0.078930 0 -1 -0.145388 1.563179  1 2 9 12 6 12 0 -1 9 18 6 6 0 2\n"
" haar_y2 0.029006 0 -1 0.193837 -0.676428  1 3 1 15 12 8 0 -1 1 15 6 4 0 2 7 19 6 4 0 2\n"
" haar_x2_y2 0.006309 0 -1 -0.374654 0.108575  1 3 15 10 8 14 0 -1 19 10 4 7 0 2 15 17 4 7 0 2\n"
" haar_x2_y2 -0.065831 0 -1 0.810594 0.030202  1 3 1 9 8 14 0 -1 1 9 4 7 0 2 5 16 4 7 0 2\n"
" haar_x2_y2 -0.068965 0 -1 0.837726 -0.171410  1 2 9 11 9 10 0 -1 9 16 9 5 0 2 haar_y2\n"
" -0.116691 0 -1 -0.946472 0.131232  1 2 6 7 12 6 0 -1 6 9 12 2 0 3 haar_y3 -0.001306 0 -1\n"
" 0.046008 -0.520116  1 2 10 15 6 9 0 -1 12 15 2 9 0 3 haar_x3 -0.044559 0 -1 -1.942367 0.132007 \n"
" 1 2 7 8 9 7 0 -1 10 8 3 7 0 3 haar_x3 0.051033 0 -1 -0.214810 0.486739  1 3 10 4 8 10 0 -1\n"
" 14 4 4 5 0 2 10 9 4 5 0 2 haar_x2_y2 -0.031578 0 -1 0.599898 0.007916  1 2 4 6 6 9 0 -1\n"
" 4 9 6 3 0 3 haar_y3 0.021020 0 -1 -0.220695 0.540462  1 2 0 6 24 12 0 -1 8 6 8 12 0 3\n"
" haar_x3 -0.138242 0 -1 0.629575 -0.021713  1 2 3 7 6 14 0 -1 6 7 3 14 0 2 haar_x2\n"
" 0.052229 0 -1 -0.233609 0.497608  1 2 19 8 5 8 0 -1 19 12 5 4 0 2 haar_y2 0.025884 0 -1\n"
" 0.180420 -0.220392  1 2 0 8 5 8 0 -1 0 12 5 4 0 2 haar_y2 -0.012139 0 -1 -0.697319 0.015712 \n"
" 1 2 17 3 6 6 0 -1 17 6 6 3 0 2 haar_y2 -0.024238 0 -1 0.345933 0.071470  1 2 1 3 6 6 0 -1\n"
" 1 6 6 3 0 2 haar_y2 -0.025272 0 -1 -0.875833 -0.009824  1 2 18 2 6 9 0 -1 18 5 6 3 0 3\n"
" haar_y3 0.012597 0 -1 0.236500 -0.287312  1 2 0 2 6 9 0 -1 0 5 6 3 0 3 haar_y3 0.057331 0 -1\n"
" -0.061531 -2.232604  1 2 3 3 18 6 0 -1 3 5 18 2 0 3 haar_y3 0.016671 0 -1 -0.198501 0.408107 \n"
" 1 2 2 3 9 6 0 -1 2 5 9 2 0 3 haar_y3 -0.022819 0 -1 0.964876 -0.202457  1 3 9 3 10 8 0 -1\n"
" 14 3 5 4 0 2 9 7 5 4 0 2 haar_x2_y2 0.000037 0 -1 -0.058909 0.270554  1 3 5 3 10 8 0 -1\n"
" 5 3 5 4 0 2 10 7 5 4 0 2 haar_x2_y2 -0.007670 0 -1 -0.453171 0.089628  1 2 10 11 6 12 0 -1\n"
" 10 11 3 12 0 2 haar_x2 0.094086 0 -1 0.116046 -1.095117  1 2 8 11 6 11 0 -1 11 11 3 11 0 2\n"
" haar_x2 -0.062267 0 -1 1.809653 -0.147732  1 2 7 8 10 4 0 -1 7 8 5 4 0 2 haar_x2\n"
" 0.017416 0 -1 0.230682 -0.424176  1 2 9 6 6 7 0 -1 12 6 3 7 0 2 haar_x2 -0.022066 0 -1\n"
" 0.492703 -0.206309  1 2 5 18 18 3 0 -1 5 19 18 1 0 3 haar_y3 -0.010404 0 -1 0.609243 0.028130 \n"
" 1 2 8 4 6 9 0 -1 10 4 2 9 0 3 haar_x3 -0.009367 0 -1 0.401712 -0.216817  1 2 8 1 9 7 0 -1\n"
" 11 1 3 7 0 3 haar_x3 -0.029040 0 -1 -0.848765 0.142468  1 2 6 11 6 6 0 -1 9 11 3 6 0 2\n"
" haar_x2 -0.021062 0 -1 -0.791983 -0.012596  1 2 14 12 4 11 0 -1 14 12 2 11 0 2 haar_x2\n"
" -0.037001 0 -1 -0.674889 0.128304  1 2 6 12 4 11 0 -1 8 12 2 11 0 2 haar_x2 0.010736 0 -1\n"
" 0.036780 -0.633930  1 2 8 0 12 18 0 -1 12 0 4 18 0 3 haar_x3 0.163676 0 -1 0.138039 -0.471890 \n"
" 1 2 2 12 10 5 0 -1 7 12 5 5 0 2 haar_x2 0.094918 0 -1 -0.138557 1.949242  1 2 2 20 22 3 0 -1\n"
" 2 21 22 1 0 3 haar_y3 0.035262 0 -1 0.137219 -2.118653  1 2 0 4 2 20 0 -1 1 4 1 20 0 2\n"
" haar_x2 0.012811 0 -1 -0.200081 0.495078  -3.593964\n"
,

/* Stage 17 */
" 155 1 2 0 2 24 4 0 -1 8 2 8 4 0 3 haar_x3 0.139044 0 -1 -0.465812 0.764316  1 2 7 8 10 4 0 -1\n"
" 7 10 10 2 0 2 haar_y2 0.011917 0 -1 -0.943990 0.397263  1 3 6 7 8 10 0 -1 6 7 4 5 0 2\n"
" 10 12 4 5 0 2 haar_x2_y2 -0.010007 0 -1 0.327188 -0.633674  1 3 14 0 6 14 0 -1 17 0 3 7 0 2\n"
" 14 7 3 7 0 2 haar_x2_y2 -0.006048 0 -1 0.274279 -0.574470  1 2 4 11 5 8 0 -1 4 15 5 4 0 2\n"
" haar_y2 -0.001249 0 -1 0.236293 -0.685935  1 2 2 0 20 9 0 -1 2 3 20 3 0 3 haar_y3\n"
" 0.032382 0 -1 -0.576302 0.274927  1 3 6 7 12 8 0 -1 6 7 6 4 0 2 12 11 6 4 0 2 haar_x2_y2\n"
" -0.013958 0 -1 -0.610615 0.245416  1 2 9 17 6 6 0 -1 9 20 6 3 0 2 haar_y2 0.001116 0 -1\n"
" -0.565391 0.271793  1 2 7 10 10 4 0 -1 7 12 10 2 0 2 haar_y2 0.000027 0 -1 -0.802360 0.115091 \n"
" 1 2 6 5 12 9 0 -1 10 5 4 9 0 3 haar_x3 -0.000257 0 -1 -0.812059 0.238447  1 2 5 11 6 8 0 -1\n"
" 8 11 3 8 0 2 haar_x2 0.004046 0 -1 0.139096 -0.661632  1 2 18 4 4 17 0 -1 18 4 2 17 0 2\n"
" haar_x2 0.014356 0 -1 -0.164852 0.419017  1 2 0 0 6 6 0 -1 3 0 3 6 0 2 haar_x2 -0.055375 0 -1\n"
" 1.442587 -0.188202  1 2 18 4 4 17 0 -1 18 4 2 17 0 2 haar_x2 0.093595 0 -1 0.135483 -0.916361 \n"
" 1 2 2 4 4 17 0 -1 4 4 2 17 0 2 haar_x2 0.026625 0 -1 -0.337483 0.392336  1 2 5 18 19 3 0 -1\n"
" 5 19 19 1 0 3 haar_y3 0.003747 0 -1 -0.116154 0.443993  1 2 11 0 2 18 0 -1 11 9 2 9 0 2\n"
" haar_y2 -0.031886 0 -1 -0.994983 0.001612  1 2 15 4 2 18 0 -1 15 13 2 9 0 2 haar_y2\n"
" -0.022600 0 -1 -0.480674 0.170073  1 2 7 4 2 18 0 -1 7 13 2 9 0 2 haar_y2 0.025202 0 -1\n"
" 0.035580 -0.802154  1 3 7 11 10 8 0 -1 12 11 5 4 0 2 7 15 5 4 0 2 haar_x2_y2 -0.031037 0 -1\n"
" -1.089534 0.180819  1 2 10 6 4 9 0 -1 12 6 2 9 0 2 haar_x2 -0.026476 0 -1 0.956712 -0.210494 \n"
" 1 2 10 0 6 9 0 -1 12 0 2 9 0 3 haar_x3 -0.013854 0 -1 -1.037032 0.221667  1 3 2 9 16 8 0 -1\n"
" 2 9 8 4 0 2 10 13 8 4 0 2 haar_x2_y2 -0.062925 0 -1 0.901994 -0.190853  1 2 14 15 6 9 0 -1\n"
" 14 18 6 3 0 3 haar_y3 -0.044751 0 -1 -1.011911 0.146912  1 2 8 7 6 9 0 -1 10 7 2 9 0 3\n"
" haar_x3 -0.020428 0 -1 0.616245 -0.235527  1 2 14 15 6 9 0 -1 14 18 6 3 0 3 haar_y3\n"
" -0.008033 0 -1 -0.083280 0.217287  1 2 3 12 12 6 0 -1 3 14 12 2 0 3 haar_y3 0.008728 0 -1\n"
" 0.065459 -0.603187  1 2 14 12 9 6 0 -1 14 14 9 2 0 3 haar_y3 -0.027202 0 -1 -0.934474 0.152700 \n"
" 1 2 1 12 9 6 0 -1 1 14 9 2 0 3 haar_y3 -0.016471 0 -1 -0.841771 0.013332  1 2 3 7 18 3 0 -1\n"
" 3 8 18 1 0 3 haar_y3 -0.013744 0 -1 0.605672 -0.092021  1 2 1 7 22 6 0 -1 1 9 22 2 0 3\n"
" haar_y3 0.029165 0 -1 -0.028114 -1.401457  1 2 18 4 6 6 0 -1 18 7 6 3 0 2 haar_y2\n"
" 0.037457 0 -1 0.130806 -0.493825  1 2 0 4 6 6 0 -1 0 7 6 3 0 2 haar_y2 -0.025070 0 -1\n"
" -1.128939 -0.014600  1 2 5 11 16 6 0 -1 5 14 16 3 0 2 haar_y2 -0.063812 0 -1 0.758716 -0.001820 \n"
" 1 2 6 16 9 4 0 -1 6 18 9 2 0 2 haar_y2 -0.009390 0 -1 0.299364 -0.294878  1 2 14 15 6 9 0 -1\n"
" 14 18 6 3 0 3 haar_y3 -0.000760 0 -1 0.019725 0.199939  1 2 4 15 6 9 0 -1 4 18 6 3 0 3\n"
" haar_y3 -0.021741 0 -1 -0.852479 0.049170  1 2 15 1 6 23 0 -1 17 1 2 23 0 3 haar_x3\n"
" -0.017870 0 -1 -0.059986 0.152225  1 2 0 21 24 3 0 -1 8 21 8 3 0 3 haar_x3 -0.024831 0 -1\n"
" 0.356034 -0.262599  1 2 0 20 24 4 0 -1 8 20 8 4 0 3 haar_x3 0.157155 0 -1 0.000156 1.042873 \n"
" 1 2 3 1 6 23 0 -1 5 1 2 23 0 3 haar_x3 0.069027 0 -1 -0.033007 -1.179667  1 2 3 17 18 3 0 -1\n"
" 3 18 18 1 0 3 haar_y3 -0.011022 0 -1 0.589877 -0.057648  1 2 0 16 18 3 0 -1 0 17 18 1 0 3\n"
" haar_y3 -0.013835 0 -1 0.595028 -0.244186  1 3 1 16 22 4 0 -1 12 16 11 2 0 2 1 18 11 2 0 2\n"
" haar_x2_y2 -0.030941 0 -1 -1.172380 0.169070  1 2 0 16 9 6 0 -1 0 18 9 2 0 3 haar_y3\n"
" 0.021258 0 -1 -0.018901 -1.068476  1 2 2 10 21 3 0 -1 9 10 7 3 0 3 haar_x3 0.093080 0 -1\n"
" 0.163056 -1.337527  1 3 2 18 12 6 0 -1 2 18 6 3 0 2 8 21 6 3 0 2 haar_x2_y2 0.029636 0 -1\n"
" -0.225248 0.454001  1 2 0 5 24 4 0 -1 0 7 24 2 0 2 haar_y2 -0.000122 0 -1 0.274091 -0.373714 \n"
" 1 2 10 2 4 15 0 -1 10 7 4 5 0 3 haar_y3 -0.042098 0 -1 -0.758288 0.017137  1 2 10 7 6 12 0 -1\n"
" 10 13 6 6 0 2 haar_y2 -0.022505 0 -1 -0.227593 0.236987  1 2 6 6 6 9 0 -1 8 6 2 9 0 3\n"
" haar_x3 -0.012863 0 -1 0.192524 -0.321271  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3\n"
" 0.027860 0 -1 0.167237 -1.020906  1 2 9 7 6 9 0 -1 11 7 2 9 0 3 haar_x3 -0.027808 0 -1\n"
" 1.282476 -0.172253  1 2 2 1 20 3 0 -1 2 2 20 1 0 3 haar_y3 -0.006163 0 -1 -0.540729 0.238857 \n"
" 1 3 1 18 12 6 0 -1 1 18 6 3 0 2 7 21 6 3 0 2 haar_x2_y2 -0.020436 0 -1 0.633554 -0.210906 \n"
" 1 2 13 2 4 13 0 -1 13 2 2 13 0 2 haar_x2 -0.012308 0 -1 -0.497782 0.174026  1 2 6 7 12 4 0 -1\n"
" 12 7 6 4 0 2 haar_x2 -0.040494 0 -1 -1.184874 -0.033891  1 2 10 1 4 13 0 -1 10 1 2 13 0 2\n"
" haar_x2 0.029657 0 -1 0.021741 1.006992  1 2 6 0 3 18 0 -1 7 0 1 18 0 3 haar_x3 0.006838 0 -1\n"
" 0.029218 -0.599063  1 2 14 3 10 5 0 -1 14 3 5 5 0 2 haar_x2 0.016165 0 -1 -0.210008 0.376373 \n"
" 1 2 6 15 12 8 0 -1 10 15 4 8 0 3 haar_x3 0.050193 0 -1 0.002532 -0.716682  1 2 9 10 6 9 0 -1\n"
" 11 10 2 9 0 3 haar_x3 0.001968 0 -1 -0.219214 0.322987  1 2 8 3 4 9 0 -1 10 3 2 9 0 2\n"
" haar_x2 0.024980 0 -1 -0.009684 -0.775729  1 3 17 0 6 14 0 -1 20 0 3 7 0 2 17 7 3 7 0 2\n"
" haar_x2_y2 -0.015810 0 -1 0.446375 -0.061760  1 3 1 0 6 14 0 -1 1 0 3 7 0 2 4 7 3 7 0 2\n"
" haar_x2_y2 0.037207 0 -1 -0.204954 0.577222  1 3 14 0 6 16 0 -1 17 0 3 8 0 2 14 8 3 8 0 2\n"
" haar_x2_y2 -0.079265 0 -1 -0.767454 0.125504  1 2 7 4 4 10 0 -1 9 4 2 10 0 2 haar_x2\n"
" -0.017152 0 -1 -1.412183 -0.051704  1 3 3 17 18 6 0 -1 12 17 9 3 0 2 3 20 9 3 0 2\n"
" haar_x2_y2 0.032740 0 -1 0.193340 -0.636337  1 2 1 20 22 4 0 -1 12 20 11 4 0 2 haar_x2\n"
" -0.117570 0 -1 0.843254 -0.180186  1 2 14 3 10 5 0 -1 14 3 5 5 0 2 haar_x2 0.120572 0 -1\n"
" 0.125300 -2.121360  1 2 0 3 10 5 0 -1 5 3 5 5 0 2 haar_x2 0.004278 0 -1 -0.466044 0.089644 \n"
" 1 2 12 6 12 16 0 -1 16 6 4 16 0 3 haar_x3 -0.072545 0 -1 0.518265 0.016824  1 2 0 6 12 16 0 -1\n"
" 4 6 4 16 0 3 haar_x3 0.177106 0 -1 -0.030910 -1.104664  1 2 10 9 5 15 0 -1 10 14 5 5 0 3\n"
" haar_y3 0.008423 0 -1 0.244458 -0.386131  1 2 1 18 21 2 0 -1 1 19 21 1 0 2 haar_y2\n"
" -0.013035 0 -1 0.980044 -0.170165  1 2 15 0 9 6 0 -1 15 2 9 2 0 3 haar_y3 0.018912 0 -1\n"
" 0.202485 -0.385459  1 2 6 1 12 4 0 -1 12 1 6 4 0 2 haar_x2 0.021448 0 -1 -0.257172 0.351812 \n"
" 1 3 6 0 12 12 0 -1 12 0 6 6 0 2 6 6 6 6 0 2 haar_x2_y2 0.063357 0 -1 0.169948 -0.913838 \n"
" 1 3 8 10 8 12 0 -1 8 10 4 6 0 2 12 16 4 6 0 2 haar_x2_y2 -0.032436 0 -1 -0.856816 -0.021681 \n"
" 1 3 14 16 10 8 0 -1 19 16 5 4 0 2 14 20 5 4 0 2 haar_x2_y2 -0.023565 0 -1 0.561156 -0.000224 \n"
" 1 3 0 16 10 8 0 -1 0 16 5 4 0 2 5 20 5 4 0 2 haar_x2_y2 0.018789 0 -1 -0.254598 0.345129 \n"
" 1 2 10 12 12 5 0 -1 14 12 4 5 0 3 haar_x3 0.031042 0 -1 0.007572 0.348002  1 3 6 16 10 8 0 -1\n"
" 6 16 5 4 0 2 11 20 5 4 0 2 haar_x2_y2 -0.011227 0 -1 -0.602198 0.042815  1 3 7 6 12 6 0 -1\n"
" 13 6 6 3 0 2 7 9 6 3 0 2 haar_x2_y2 -0.012846 0 -1 0.420204 -0.053801  1 3 9 6 4 18 0 -1\n"
" 9 6 2 9 0 2 11 15 2 9 0 2 haar_x2_y2 -0.012792 0 -1 0.227245 -0.323980  1 3 10 9 6 14 0 -1\n"
" 13 9 3 7 0 2 10 16 3 7 0 2 haar_x2_y2 0.068652 0 -1 0.093532 10.000000  1 3 8 9 6 14 0 -1\n"
" 8 9 3 7 0 2 11 16 3 7 0 2 haar_x2_y2 0.005279 0 -1 -0.269263 0.333032  1 2 7 4 11 12 0 -1\n"
" 7 10 11 6 0 2 haar_y2 -0.038779 0 -1 -0.723653 0.178065  1 3 4 8 6 16 0 -1 4 8 3 8 0 2\n"
" 7 16 3 8 0 2 haar_x2_y2 0.006182 0 -1 -0.351194 0.165863  1 2 17 3 4 21 0 -1 17 10 4 7 0 3\n"
" haar_y3 0.175152 0 -1 0.116231 -1.541929  1 2 3 3 4 21 0 -1 3 10 4 7 0 3 haar_y3\n"
" 0.116280 0 -1 -0.009148 -0.998426  1 3 10 1 8 18 0 -1 14 1 4 9 0 2 10 10 4 9 0 2\n"
" haar_x2_y2 -0.022964 0 -1 0.205654 0.015432  1 3 2 5 16 8 0 -1 2 5 8 4 0 2 10 9 8 4 0 2\n"
" haar_x2_y2 -0.051410 0 -1 0.580724 -0.201184  1 2 3 6 18 12 0 -1 3 10 18 4 0 3 haar_y3\n"
" 0.224742 0 -1 0.018729 1.082930  1 2 4 10 16 12 0 -1 4 14 16 4 0 3 haar_y3 0.009486 0 -1\n"
" -0.331713 0.199030  1 3 15 4 8 20 0 -1 19 4 4 10 0 2 15 14 4 10 0 2 haar_x2_y2 -0.118463 0 -1\n"
" 1.371101 0.068927  1 2 7 2 9 6 0 -1 10 2 3 6 0 3 haar_x3 0.037811 0 -1 -0.000936 -0.839970 \n"
" 1 3 15 4 8 20 0 -1 19 4 4 10 0 2 15 14 4 10 0 2 haar_x2_y2 0.022202 0 -1 -0.011964 0.366740 \n"
" 1 3 1 4 8 20 0 -1 1 4 4 10 0 2 5 14 4 10 0 2 haar_x2_y2 -0.036366 0 -1 0.378665 -0.277148 \n"
" 1 3 11 8 8 14 0 -1 15 8 4 7 0 2 11 15 4 7 0 2 haar_x2_y2 -0.131847 0 -1 -2.748118 0.106669 \n"
" 1 3 5 8 8 14 0 -1 5 8 4 7 0 2 9 15 4 7 0 2 haar_x2_y2 -0.041656 0 -1 0.475243 -0.232498 \n"
" 1 2 10 13 5 8 0 -1 10 17 5 4 0 2 haar_y2 -0.033152 0 -1 -0.579294 0.174344  1 2 4 13 7 9 0 -1\n"
" 4 16 7 3 0 3 haar_y3 0.015770 0 -1 -0.011284 -0.837014  1 2 0 13 24 10 0 -1 0 18 24 5 0 2\n"
" haar_y2 -0.039363 0 -1 0.348216 -0.174554  1 2 4 2 8 11 0 -1 8 2 4 11 0 2 haar_x2\n"
" -0.067849 0 -1 1.422570 -0.147656  1 3 10 2 8 16 0 -1 14 2 4 8 0 2 10 10 4 8 0 2\n"
" haar_x2_y2 -0.026775 0 -1 0.239470 0.013272  1 3 0 2 24 6 0 -1 0 2 12 3 0 2 12 5 12 3 0 2\n"
" haar_x2_y2 0.039919 0 -1 -0.009000 -0.759389  1 2 6 0 12 9 0 -1 6 3 12 3 0 3 haar_y3\n"
" 0.100656 0 -1 -0.018685 0.762453  1 3 1 2 12 12 0 -1 1 2 6 6 0 2 7 8 6 6 0 2 haar_x2_y2\n"
" -0.081022 0 -1 -0.904391 -0.008588  1 2 18 5 6 9 0 -1 18 8 6 3 0 3 haar_y3 -0.021258 0 -1\n"
" -0.213196 0.219197  1 3 4 3 8 10 0 -1 4 3 4 5 0 2 8 8 4 5 0 2 haar_x2_y2 -0.010631 0 -1\n"
" 0.195981 -0.357681  1 2 6 21 18 3 0 -1 6 22 18 1 0 3 haar_y3 0.000813 0 -1 -0.092795 0.261459 \n"
" 1 2 1 10 18 2 0 -1 1 11 18 1 0 2 haar_y2 0.003465 0 -1 -0.553361 0.027386  1 2 1 10 22 3 0 -1\n"
" 1 11 22 1 0 3 haar_y3 0.018836 0 -1 0.184461 -0.669343  1 2 2 8 12 9 0 -1 2 11 12 3 0 3\n"
" haar_y3 -0.025632 0 -1 1.938288 -0.147089  1 3 12 8 12 6 0 -1 18 8 6 3 0 2 12 11 6 3 0 2\n"
" haar_x2_y2 -0.004094 0 -1 -0.264516 0.207332  1 3 0 8 12 6 0 -1 0 8 6 3 0 2 6 11 6 3 0 2\n"
" haar_x2_y2 -0.000892 0 -1 -0.550316 0.050375  1 2 10 15 6 9 0 -1 12 15 2 9 0 3 haar_x3\n"
" -0.049518 0 -1 -2.561539 0.131417  1 2 7 13 9 6 0 -1 7 15 9 2 0 3 haar_y3 0.011681 0 -1\n"
" -0.248198 0.399827  1 2 9 8 7 12 0 -1 9 14 7 6 0 2 haar_y2 0.034564 0 -1 0.161788 -0.714189 \n"
" 1 2 4 13 9 6 0 -1 7 13 3 6 0 3 haar_x3 -0.008291 0 -1 0.221801 -0.291817  1 2 6 15 18 4 0 -1\n"
" 12 15 6 4 0 3 haar_x3 -0.022358 0 -1 0.310441 -0.002728  1 2 5 4 4 16 0 -1 7 4 2 16 0 2\n"
" haar_x2 -0.030801 0 -1 -0.956727 -0.008340  1 2 10 15 6 9 0 -1 12 15 2 9 0 3 haar_x3\n"
" 0.043779 0 -1 0.125569 -1.175962  1 2 8 15 6 9 0 -1 10 15 2 9 0 3 haar_x3 0.043046 0 -1\n"
" -0.058877 -1.856847  1 3 9 11 12 10 0 -1 15 11 6 5 0 2 9 16 6 5 0 2 haar_x2_y2 0.027189 0 -1\n"
" 0.042858 0.390367  1 2 3 6 14 6 0 -1 3 8 14 2 0 3 haar_y3 0.009415 0 -1 -0.043567 -1.109447 \n"
" 1 2 4 2 17 8 0 -1 4 6 17 4 0 2 haar_y2 0.094312 0 -1 0.040257 0.984423  1 2 6 2 12 21 0 -1\n"
" 6 9 12 7 0 3 haar_y3 0.170251 0 -1 0.029510 -0.695093  1 2 8 1 9 9 0 -1 8 4 9 3 0 3\n"
" haar_y3 -0.047148 0 -1 1.033857 0.067602  1 2 0 7 24 3 0 -1 12 7 12 3 0 2 haar_x2\n"
" 0.111863 0 -1 -0.068683 -2.498583  1 2 11 6 9 10 0 -1 11 11 9 5 0 2 haar_y2 -0.014354 0 -1\n"
" -0.594819 0.150017  1 2 2 11 18 3 0 -1 2 12 18 1 0 3 haar_y3 0.034024 0 -1 -0.064823 -2.138264 \n"
" 1 2 8 16 9 4 0 -1 8 18 9 2 0 2 haar_y2 0.021602 0 -1 0.055310 0.782929  1 2 0 0 9 6 0 -1\n"
" 0 2 9 2 0 3 haar_y3 0.021772 0 -1 -0.007128 -0.721481  1 2 0 11 24 6 0 -1 0 13 24 2 0 3\n"
" haar_y3 0.082417 0 -1 0.146095 -1.363667  1 2 2 9 20 6 0 -1 2 12 20 3 0 2 haar_y2\n"
" 0.084672 0 -1 -0.177847 0.728577  1 3 4 5 16 12 0 -1 12 5 8 6 0 2 4 11 8 6 0 2 haar_x2_y2\n"
" -0.055128 0 -1 -0.594024 0.193578  1 2 10 2 4 15 0 -1 10 7 4 5 0 3 haar_y3 -0.064823 0 -1\n"
" -1.078384 -0.040734  1 2 7 3 10 4 0 -1 7 5 10 2 0 2 haar_y2 -0.022769 0 -1 0.779002 0.003496 \n"
" 1 2 9 15 6 8 0 -1 9 19 6 4 0 2 haar_y2 0.054756 0 -1 -0.065684 -1.818841  1 2 17 0 7 10 0 -1\n"
" 17 5 7 5 0 2 haar_y2 -0.000089 0 -1 -0.017892 0.207683  1 2 0 0 7 10 0 -1 0 5 7 5 0 2\n"
" haar_y2 0.098362 0 -1 -0.055947 -1.415392  1 3 16 1 6 12 0 -1 19 1 3 6 0 2 16 7 3 6 0 2\n"
" haar_x2_y2 -0.007093 0 -1 0.341353 -0.120899  1 2 1 0 19 8 0 -1 1 4 19 4 0 2 haar_y2\n"
" 0.050278 0 -1 -0.262867 0.257973  1 2 12 2 9 4 0 -1 12 4 9 2 0 2 haar_y2 -0.005787 0 -1\n"
" -0.131786 0.173502  1 2 3 2 9 4 0 -1 3 4 9 2 0 2 haar_y2 0.013974 0 -1 0.028518 -0.611522 \n"
" 1 2 12 2 10 6 0 -1 12 4 10 2 0 3 haar_y3 0.021450 0 -1 0.026182 0.303066  1 2 3 4 18 2 0 -1\n"
" 12 4 9 2 0 2 haar_x2 -0.029214 0 -1 0.449406 -0.228031  1 2 12 1 4 9 0 -1 12 1 2 9 0 2\n"
" haar_x2 0.000481 0 -1 -0.198800 0.207445  1 2 8 1 4 9 0 -1 10 1 2 9 0 2 haar_x2 0.001711 0 -1\n"
" -0.540372 0.067866  1 3 10 5 8 10 0 -1 14 5 4 5 0 2 10 10 4 5 0 2 haar_x2_y2 0.008666 0 -1\n"
" -0.013128 0.522979  1 2 6 4 12 13 0 -1 10 4 4 13 0 3 haar_x3 0.063658 0 -1 0.068299 -0.492351 \n"
" 1 2 13 5 6 6 0 -1 13 5 3 6 0 2 haar_x2 -0.027968 0 -1 0.681839 0.078781  1 2 1 5 12 3 0 -1\n"
" 7 5 6 3 0 2 haar_x2 0.048954 0 -1 -0.206224 0.503881  -3.393356\n"
,

/* Stage 18 */
" 169 1 2 7 5 10 6 0 -1 7 7 10 2 0 3 haar_y3 -0.029313 0 -1 0.712847 -0.582307  1 2\n"
" 2 0 21 5 0 -1 9 0 7 5 0 3 haar_x3 0.124151 0 -1 -0.368635 0.600672  1 2 0 8 9 9 0 -1\n"
" 0 11 9 3 0 3 haar_y3 0.007935 0 -1 -0.860083 0.217247  1 2 9 6 6 9 0 -1 11 6 2 9 0 3\n"
" haar_x3 0.030366 0 -1 -0.271870 0.612479  1 2 0 3 6 7 0 -1 3 3 3 7 0 2 haar_x2 0.025218 0 -1\n"
" -0.347483 0.504277  1 3 9 18 12 6 0 -1 15 18 6 3 0 2 9 21 6 3 0 2 haar_x2_y2 0.010014 0 -1\n"
" -0.318990 0.413768  1 3 2 8 20 6 0 -1 2 8 10 3 0 2 12 11 10 3 0 2 haar_x2_y2 -0.016775 0 -1\n"
" -0.690481 0.094831  1 2 13 2 10 4 0 -1 13 4 10 2 0 2 haar_y2 -0.002695 0 -1 -0.208298 0.237372 \n"
" 1 2 4 5 5 18 0 -1 4 11 5 6 0 3 haar_y3 0.042258 0 -1 -0.493667 0.181706  1 2 20 4 4 9 0 -1\n"
" 20 4 2 9 0 2 haar_x2 -0.048505 0 -1 1.342964 0.039769  1 2 8 6 8 14 0 -1 8 13 8 7 0 2\n"
" haar_y2 0.028993 0 -1 0.046496 -0.816435  1 3 0 1 24 6 0 -1 12 1 12 3 0 2 0 4 12 3 0 2\n"
" haar_x2_y2 -0.040089 0 -1 -0.711978 0.225539  1 2 0 4 4 9 0 -1 2 4 2 9 0 2 haar_x2\n"
" -0.041022 0 -1 1.005793 -0.196902  1 2 3 6 18 3 0 -1 3 7 18 1 0 3 haar_y3 0.011838 0 -1\n"
" -0.012600 0.807671  1 2 3 17 16 6 0 -1 3 19 16 2 0 3 haar_y3 -0.021328 0 -1 -0.820239 0.020525 \n"
" 1 2 13 6 6 9 0 -1 13 9 6 3 0 3 haar_y3 -0.023905 0 -1 0.542105 -0.074767  1 3 5 6 14 6 0 -1\n"
" 5 6 7 3 0 2 12 9 7 3 0 2 haar_x2_y2 0.018009 0 -1 -0.338277 0.423586  1 3 13 5 8 10 0 -1\n"
" 17 5 4 5 0 2 13 10 4 5 0 2 haar_x2_y2 -0.043614 0 -1 -1.198349 0.155662  1 2 2 2 20 3 0 -1\n"
" 2 3 20 1 0 3 haar_y3 -0.009245 0 -1 -0.890300 0.011004  1 2 9 2 9 6 0 -1 12 2 3 6 0 3\n"
" haar_x3 0.047485 0 -1 0.166641 -0.907645  1 2 8 6 6 9 0 -1 10 6 2 9 0 3 haar_x3 -0.014234 0 -1\n"
" 0.626952 -0.257912  1 2 12 3 4 11 0 -1 12 3 2 11 0 2 haar_x2 0.003801 0 -1 -0.282300 0.266246 \n"
" 1 2 8 3 4 11 0 -1 10 3 2 11 0 2 haar_x2 0.003433 0 -1 -0.637720 0.098423  1 3 8 3 8 10 0 -1\n"
" 12 3 4 5 0 2 8 8 4 5 0 2 haar_x2_y2 -0.029221 0 -1 -0.767699 0.226345  1 2 11 1 2 18 0 -1\n"
" 12 1 1 18 0 2 haar_x2 -0.006495 0 -1 0.456001 -0.265289  1 2 9 2 9 6 0 -1 12 2 3 6 0 3\n"
" haar_x3 -0.030034 0 -1 -0.765511 0.140093  1 2 0 2 19 3 0 -1 0 3 19 1 0 3 haar_y3\n"
" 0.007836 0 -1 0.046756 -0.723562  1 2 9 14 9 6 0 -1 9 16 9 2 0 3 haar_y3 0.008855 0 -1\n"
" -0.049142 0.514727  1 2 1 8 18 5 0 -1 7 8 6 5 0 3 haar_x3 0.095974 0 -1 -0.020069 -1.085095 \n"
" 1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 -0.032877 0 -1 -0.958753 0.145436  1 2 6 0 6 9 0 -1\n"
" 8 0 2 9 0 3 haar_x3 -0.013384 0 -1 -0.700136 0.029158  1 2 13 6 4 15 0 -1 13 11 4 5 0 3\n"
" haar_y3 0.015236 0 -1 -0.282357 0.253680  1 2 1 5 18 3 0 -1 1 6 18 1 0 3 haar_y3\n"
" 0.012054 0 -1 -0.253034 0.465267  1 2 9 7 14 6 0 -1 9 9 14 2 0 3 haar_y3 -0.076295 0 -1\n"
" -0.699158 0.132172  1 2 2 16 18 3 0 -1 2 17 18 1 0 3 haar_y3 -0.012040 0 -1 0.458946 -0.238565 \n"
" 1 2 15 17 9 6 0 -1 15 19 9 2 0 3 haar_y3 0.021916 0 -1 0.182686 -0.616297  1 3 0 8 12 6 0 -1\n"
" 0 8 6 3 0 2 6 11 6 3 0 2 haar_x2_y2 -0.002733 0 -1 -0.632579 0.034219  1 2 9 13 7 8 0 -1\n"
" 9 17 7 4 0 2 haar_y2 -0.048652 0 -1 -1.029773 0.173865  1 2 2 17 20 3 0 -1 2 18 20 1 0 3\n"
" haar_y3 -0.010464 0 -1 0.347573 -0.274641  1 2 15 17 9 6 0 -1 15 19 9 2 0 3 haar_y3\n"
" -0.006655 0 -1 -0.289803 0.240379  1 2 4 0 15 4 0 -1 4 2 15 2 0 2 haar_y2 0.008547 0 -1\n"
" -0.443405 0.142674  1 2 17 2 6 6 0 -1 17 5 6 3 0 2 haar_y2 0.019914 0 -1 0.177404 -0.240963 \n"
" 1 2 0 3 6 9 0 -1 0 6 6 3 0 3 haar_y3 0.022013 0 -1 -0.010812 -0.946908  1 2 15 17 9 6 0 -1\n"
" 15 19 9 2 0 3 haar_y3 -0.052179 0 -1 1.654750 0.096487  1 2 0 17 9 6 0 -1 0 19 9 2 0 3\n"
" haar_y3 0.019699 0 -1 -0.006756 -0.863115  1 3 9 18 12 6 0 -1 15 18 6 3 0 2 9 21 6 3 0 2\n"
" haar_x2_y2 0.023040 0 -1 -0.002352 0.385313  1 2 3 15 6 9 0 -1 3 18 6 3 0 3 haar_y3\n"
" -0.015038 0 -1 -0.619057 0.031078  1 3 16 13 8 10 0 -1 20 13 4 5 0 2 16 18 4 5 0 2\n"
" haar_x2_y2 -0.049956 0 -1 0.706575 0.047881  1 2 0 14 24 4 0 -1 8 14 8 4 0 3 haar_x3\n"
" -0.069270 0 -1 0.392129 -0.238480  1 2 13 18 6 6 0 -1 13 18 3 6 0 2 haar_x2 0.004740 0 -1\n"
" -0.024309 0.253863  1 3 0 13 8 10 0 -1 0 13 4 5 0 2 4 18 4 5 0 2 haar_x2_y2 -0.033924 0 -1\n"
" 0.469304 -0.233219  1 2 0 14 24 6 0 -1 0 17 24 3 0 2 haar_y2 -0.016231 0 -1 0.323192 -0.205456 \n"
" 1 3 5 2 12 8 0 -1 5 2 6 4 0 2 11 6 6 4 0 2 haar_x2_y2 -0.050193 0 -1 -1.227787 -0.040798 \n"
" 1 2 8 9 9 6 0 -1 11 9 3 6 0 3 haar_x3 0.056944 0 -1 0.045184 0.601975  1 2 4 3 16 4 0 -1\n"
" 4 5 16 2 0 2 haar_y2 0.040937 0 -1 -0.167728 0.898193  1 2 10 2 4 10 0 -1 10 7 4 5 0 2\n"
" haar_y2 -0.003084 0 -1 0.337162 -0.272408  1 2 8 4 5 8 0 -1 8 8 5 4 0 2 haar_y2 -0.032600 0 -1\n"
" -0.854465 0.019665  1 2 11 5 9 12 0 -1 11 9 9 4 0 3 haar_y3 0.098481 0 -1 0.054742 0.638273 \n"
" 1 2 4 5 9 12 0 -1 4 9 9 4 0 3 haar_y3 -0.038185 0 -1 0.522747 -0.233848  1 2 14 6 6 9 0 -1\n"
" 14 9 6 3 0 3 haar_y3 -0.045917 0 -1 0.628292 0.032859  1 2 2 4 20 12 0 -1 2 8 20 4 0 3\n"
" haar_y3 -0.119555 0 -1 -0.615727 0.034680  1 2 4 4 17 16 0 -1 4 12 17 8 0 2 haar_y2\n"
" -0.120444 0 -1 -0.843800 0.165307  1 2 8 7 7 6 0 -1 8 10 7 3 0 2 haar_y2 0.070619 0 -1\n"
" -0.063261 -1.986393  1 2 1 9 23 2 0 -1 1 10 23 1 0 2 haar_y2 0.008489 0 -1 -0.176634 0.380112 \n"
" 1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 0.022711 0 -1 -0.027606 -0.919214  1 2 13 3 4 9 0 -1\n"
" 13 3 2 9 0 2 haar_x2 0.000497 0 -1 -0.242932 0.228789  1 2 8 1 6 13 0 -1 10 1 2 13 0 3\n"
" haar_x3 0.034652 0 -1 -0.237060 0.540110  1 2 4 22 18 2 0 -1 4 23 18 1 0 2 haar_y2\n"
" -0.004470 0 -1 0.390790 -0.126938  1 2 3 10 9 6 0 -1 6 10 3 6 0 3 haar_x3 0.023643 0 -1\n"
" -0.266637 0.323126  1 2 14 0 2 24 0 -1 14 0 1 24 0 2 haar_x2 0.012813 0 -1 0.175408 -0.607880 \n"
" 1 2 8 0 2 24 0 -1 9 0 1 24 0 2 haar_x2 -0.011251 0 -1 -1.085259 -0.028046  1 2 3 2 18 10 0 -1\n"
" 9 2 6 10 0 3 haar_x3 -0.041535 0 -1 0.718874 0.027982  1 2 4 13 15 6 0 -1 9 13 5 6 0 3\n"
" haar_x3 -0.093471 0 -1 -1.190632 -0.044811  1 2 3 21 18 3 0 -1 9 21 6 3 0 3 haar_x3\n"
" -0.027250 0 -1 0.629425 0.009504  1 2 9 1 4 11 0 -1 11 1 2 11 0 2 haar_x2 -0.021760 0 -1\n"
" 1.323365 -0.150270  1 2 9 7 10 4 0 -1 9 7 5 4 0 2 haar_x2 -0.009689 0 -1 -0.339471 0.170858 \n"
" 1 2 7 0 10 18 0 -1 12 0 5 18 0 2 haar_x2 0.069396 0 -1 -0.256578 0.476521  1 2 12 1 6 16 0 -1\n"
" 14 1 2 16 0 3 haar_x3 0.031209 0 -1 0.141540 -0.349420  1 2 6 1 6 16 0 -1 8 1 2 16 0 3\n"
" haar_x3 -0.049727 0 -1 -1.167556 -0.040758  1 2 18 2 6 6 0 -1 18 5 6 3 0 2 haar_y2\n"
" -0.020302 0 -1 -0.394864 0.158149  1 2 3 5 18 2 0 -1 3 6 18 1 0 2 haar_y2 -0.015367 0 -1\n"
" 0.493000 -0.200921  1 2 18 2 6 6 0 -1 18 5 6 3 0 2 haar_y2 -0.050735 0 -1 1.873606 0.086730 \n"
" 1 2 0 2 6 6 0 -1 0 5 6 3 0 2 haar_y2 -0.020726 0 -1 -0.889384 -0.007320  1 2 13 11 11 6 0 -1\n"
" 13 13 11 2 0 3 haar_y3 -0.030994 0 -1 -1.166490 0.142746  1 2 5 7 10 4 0 -1 10 7 5 4 0 2\n"
" haar_x2 -0.004427 0 -1 -0.668151 0.004412  1 2 11 9 10 7 0 -1 11 9 5 7 0 2 haar_x2\n"
" -0.045744 0 -1 -0.479552 0.151220  1 2 3 9 10 7 0 -1 8 9 5 7 0 2 haar_x2 0.016699 0 -1\n"
" 0.120486 -0.452359  1 2 16 4 6 6 0 -1 16 4 3 6 0 2 haar_x2 0.003221 0 -1 -0.077615 0.278466 \n"
" 1 3 5 6 10 8 0 -1 5 6 5 4 0 2 10 10 5 4 0 2 haar_x2_y2 0.024434 0 -1 -0.199871 0.672537 \n"
" 1 2 7 21 16 3 0 -1 7 21 8 3 0 2 haar_x2 -0.079678 0 -1 0.922224 0.092558  1 2 1 21 16 3 0 -1\n"
" 9 21 8 3 0 2 haar_x2 0.044530 0 -1 -0.266905 0.333205  1 3 2 5 22 14 0 -1 13 5 11 7 0 2\n"
" 2 12 11 7 0 2 haar_x2_y2 -0.125283 0 -1 -0.542531 0.139763  1 3 3 10 8 10 0 -1 3 10 4 5 0 2\n"
" 7 15 4 5 0 2 haar_x2_y2 0.017972 0 -1 0.018220 -0.680485  1 3 17 0 6 12 0 -1 20 0 3 6 0 2\n"
" 17 6 3 6 0 2 haar_x2_y2 0.019184 0 -1 -0.012584 0.541267  1 2 5 2 6 18 0 -1 7 2 2 18 0 3\n"
" haar_x3 0.040024 0 -1 -0.176388 0.788104  1 2 13 0 6 9 0 -1 15 0 2 9 0 3 haar_x3\n"
" 0.013559 0 -1 0.207376 -0.477443  1 2 0 12 7 9 0 -1 0 15 7 3 0 3 haar_y3 0.016221 0 -1\n"
" 0.023077 -0.611821  1 3 15 13 8 10 0 -1 19 13 4 5 0 2 15 18 4 5 0 2 haar_x2_y2 0.011229 0 -1\n"
" -0.017728 0.417642  1 3 1 0 6 12 0 -1 1 0 3 6 0 2 4 6 3 6 0 2 haar_x2_y2 0.039193 0 -1\n"
" -0.189485 0.740193  1 2 12 1 3 12 0 -1 12 7 3 6 0 2 haar_y2 -0.009554 0 -1 0.409471 -0.135089 \n"
" 1 3 1 13 8 10 0 -1 1 13 4 5 0 2 5 18 4 5 0 2 haar_x2_y2 0.027879 0 -1 -0.203507 0.616254 \n"
" 1 2 3 21 19 2 0 -1 3 22 19 1 0 2 haar_y2 -0.023601 0 -1 -1.696706 0.146332  1 2 6 3 4 13 0 -1\n"
" 8 3 2 13 0 2 haar_x2 0.026930 0 -1 -0.030402 -1.090947  1 2 5 10 18 3 0 -1 5 11 18 1 0 3\n"
" haar_y3 0.000290 0 -1 -0.200760 0.223141  1 2 9 3 5 12 0 -1 9 7 5 4 0 3 haar_y3 -0.041125 0 -1\n"
" -0.452422 0.057392  1 2 11 2 4 15 0 -1 11 7 4 5 0 3 haar_y3 0.006679 0 -1 0.238249 -0.212621 \n"
" 1 2 4 1 16 4 0 -1 4 3 16 2 0 2 haar_y2 0.047865 0 -1 -0.181948 0.619184  1 2 6 0 18 3 0 -1\n"
" 6 1 18 1 0 3 haar_y3 -0.003168 0 -1 -0.273932 0.250173  1 3 5 1 10 8 0 -1 5 1 5 4 0 2\n"
" 10 5 5 4 0 2 haar_x2_y2 -0.008623 0 -1 -0.462803 0.042398  1 3 11 18 12 6 0 -1 17 18 6 3 0 2\n"
" 11 21 6 3 0 2 haar_x2_y2 -0.007435 0 -1 0.417968 -0.001708  1 2 5 15 12 3 0 -1 11 15 6 3 0 2\n"
" haar_x2 -0.001877 0 -1 0.146023 -0.337211  1 2 1 10 22 4 0 -1 1 10 11 4 0 2 haar_x2\n"
" -0.086226 0 -1 0.751434 0.010712  1 2 7 9 9 6 0 -1 10 9 3 6 0 3 haar_x3 0.046834 0 -1\n"
" -0.191196 0.484149  1 2 6 11 12 5 0 -1 10 11 4 5 0 3 haar_x3 -0.000092 0 -1 0.352204 -0.173333 \n"
" 1 2 6 7 10 7 0 -1 11 7 5 7 0 2 haar_x2 -0.016344 0 -1 -0.643977 0.009068  1 2 11 2 8 10 0 -1\n"
" 11 2 4 10 0 2 haar_x2 0.045704 0 -1 0.018216 0.319708  1 2 5 2 8 10 0 -1 9 2 4 10 0 2\n"
" haar_x2 -0.027383 0 -1 1.056405 -0.172764  1 3 6 4 18 6 0 -1 15 4 9 3 0 2 6 7 9 3 0 2\n"
" haar_x2_y2 -0.027602 0 -1 0.297155 -0.009460  1 2 0 5 10 9 0 -1 0 8 10 3 0 3 haar_y3\n"
" 0.007694 0 -1 -0.216603 0.473852  1 2 2 7 21 6 0 -1 2 9 21 2 0 3 haar_y3 -0.000705 0 -1\n"
" 0.240488 -0.267760  1 3 0 4 22 16 0 -1 0 4 11 8 0 2 11 12 11 8 0 2 haar_x2_y2 0.110542 0 -1\n"
" -0.033539 -1.023388  1 2 9 0 6 22 0 -1 9 11 6 11 0 2 haar_y2 0.068766 0 -1 -0.004324 0.571534 \n"
" 1 2 9 1 3 12 0 -1 9 7 3 6 0 2 haar_y2 0.001800 0 -1 0.077575 -0.420927  1 3 12 0 12 18 0 -1\n"
" 18 0 6 9 0 2 12 9 6 9 0 2 haar_x2_y2 0.192320 0 -1 0.082022 2.881017  1 3 0 0 12 18 0 -1\n"
" 0 0 6 9 0 2 6 9 6 9 0 2 haar_x2_y2 0.157421 0 -1 -0.137082 2.089006  1 3 1 1 22 4 0 -1\n"
" 12 1 11 2 0 2 1 3 11 2 0 2 haar_x2_y2 -0.049387 0 -1 -1.861091 0.143321  1 2 3 0 18 4 0 -1\n"
" 3 2 18 2 0 2 haar_y2 0.051929 0 -1 -0.187370 0.542316  1 2 2 5 22 6 0 -1 2 7 22 2 0 3\n"
" haar_y3 0.049965 0 -1 0.141753 -1.562578  1 2 5 0 6 9 0 -1 5 3 6 3 0 3 haar_y3 -0.042633 0 -1\n"
" 1.605948 -0.147129  1 2 10 14 6 9 0 -1 12 14 2 9 0 3 haar_x3 -0.037554 0 -1 -0.809749 0.132570 \n"
" 1 2 8 14 6 9 0 -1 10 14 2 9 0 3 haar_x3 -0.037175 0 -1 -1.394502 -0.057055  1 2 5 18 18 3 0 -1\n"
" 5 19 18 1 0 3 haar_y3 0.013946 0 -1 0.033427 0.574748  1 2 6 0 6 13 0 -1 9 0 3 13 0 2\n"
" haar_x2 -0.000448 0 -1 -0.553275 0.021953  1 2 7 4 12 4 0 -1 7 4 6 4 0 2 haar_x2\n"
" 0.031993 0 -1 0.020341 0.374592  1 2 5 2 12 6 0 -1 9 2 4 6 0 3 haar_x3 -0.004280 0 -1\n"
" 0.444287 -0.229997  1 2 4 1 18 3 0 -1 4 2 18 1 0 3 haar_y3 0.009855 0 -1 0.183158 -0.409650 \n"
" 1 2 0 8 6 12 0 -1 0 12 6 4 0 3 haar_y3 0.093357 0 -1 -0.063661 -1.692929  1 2 9 15 6 9 0 -1\n"
" 11 15 2 9 0 3 haar_x3 0.017210 0 -1 0.201539 -0.460611  1 2 9 10 6 13 0 -1 11 10 2 13 0 3\n"
" haar_x3 0.008432 0 -1 -0.320040 0.153122  1 2 6 17 18 2 0 -1 6 18 18 1 0 2 haar_y2\n"
" -0.014055 0 -1 0.868824 0.032575  1 2 9 4 6 9 0 -1 11 4 2 9 0 3 haar_x3 -0.007718 0 -1\n"
" 0.636867 -0.184255  1 2 10 0 6 9 0 -1 12 0 2 9 0 3 haar_x3 0.028005 0 -1 0.173575 -0.478836 \n"
" 1 3 5 6 10 8 0 -1 5 6 5 4 0 2 10 10 5 4 0 2 haar_x2_y2 -0.018885 0 -1 0.241016 -0.265476 \n"
" 1 2 14 9 5 8 0 -1 14 13 5 4 0 2 haar_y2 -0.018585 0 -1 0.542325 0.053633  1 2 5 9 5 8 0 -1\n"
" 5 13 5 4 0 2 haar_y2 -0.036437 0 -1 2.390890 -0.136347  1 2 14 11 9 6 0 -1 14 13 9 2 0 3\n"
" haar_y3 0.032455 0 -1 0.159107 -0.675815  1 2 0 2 23 15 0 -1 0 7 23 5 0 3 haar_y3\n"
" 0.059782 0 -1 -0.002348 -0.730537  1 2 16 0 8 12 0 -1 16 6 8 6 0 2 haar_y2 0.009821 0 -1\n"
" -0.114441 0.305703  1 2 4 15 6 9 0 -1 4 18 6 3 0 3 haar_y3 -0.035164 0 -1 -1.051147 -0.033103 \n"
" 1 2 8 18 9 4 0 -1 8 20 9 2 0 2 haar_y2 0.002743 0 -1 -0.201354 0.327541  1 2 0 17 18 3 0 -1\n"
" 0 18 18 1 0 3 haar_y3 0.008106 0 -1 -0.213835 0.433621  1 2 13 11 11 6 0 -1 13 13 11 2 0 3\n"
" haar_y3 0.088943 0 -1 0.109409 -4.760934  1 2 0 11 11 6 0 -1 0 13 11 2 0 3 haar_y3\n"
" -0.030055 0 -1 -1.716930 -0.060919  1 3 0 9 24 6 0 -1 12 9 12 3 0 2 0 12 12 3 0 2\n"
" haar_x2_y2 -0.021735 0 -1 0.647789 -0.032831  1 2 6 16 8 8 0 -1 6 20 8 4 0 2 haar_y2\n"
" 0.037649 0 -1 -0.010060 -0.765691  1 2 10 16 14 6 0 -1 10 18 14 2 0 3 haar_y3 0.002719 0 -1\n"
" 0.198889 -0.082479  1 2 1 1 21 3 0 -1 1 2 21 1 0 3 haar_y3 -0.010548 0 -1 -0.866136 -0.025986 \n"
" 1 2 0 2 24 3 0 -1 0 2 12 3 0 2 haar_x2 0.129663 0 -1 0.139120 -2.227195  1 2 2 15 8 5 0 -1\n"
" 6 15 4 5 0 2 haar_x2 -0.017677 0 -1 0.339677 -0.239896  1 2 2 11 21 3 0 -1 9 11 7 3 0 3\n"
" haar_x3 -0.077052 0 -1 -2.501797 0.128420  1 3 1 18 12 6 0 -1 1 18 6 3 0 2 7 21 6 3 0 2\n"
" haar_x2_y2 -0.019230 0 -1 0.506412 -0.197516  1 2 10 14 4 10 0 -1 10 19 4 5 0 2 haar_y2\n"
" -0.051223 0 -1 -2.933337 0.138585  1 2 7 7 4 10 0 -1 7 12 4 5 0 2 haar_y2 0.002083 0 -1\n"
" -0.600436 0.029718  1 2 9 8 6 12 0 -1 9 12 6 4 0 3 haar_y3 0.025418 0 -1 0.339158 -0.143920 \n"
" 1 2 7 1 9 6 0 -1 10 1 3 6 0 3 haar_x3 -0.023906 0 -1 -1.108268 -0.047377  1 2 3 14 19 2 0 -1\n"
" 3 15 19 1 0 2 haar_y2 -0.006374 0 -1 0.445337 -0.067053  1 3 7 7 10 10 0 -1 7 7 5 5 0 2\n"
" 12 12 5 5 0 2 haar_x2_y2 -0.037699 0 -1 -1.040658 -0.041790  1 2 3 12 18 12 0 -1\n"
" 3 12 9 12 0 2 haar_x2 0.216551 0 -1 0.033863 0.820173  1 2 8 0 6 12 0 -1 10 0 2 12 0 3\n"
" haar_x3 -0.013401 0 -1 0.529035 -0.191330  -3.239693\n"
,

/* Stage 19 */
" 196 1 2 3 0 17 9 0 -1 3 3 17 3 0 3 haar_y3 0.071269 0 -1 -0.536312 0.607153  1 2\n"
" 6 0 12 11 0 -1 10 0 4 11 0 3 haar_x3 0.056111 0 -1 -0.501416 0.439761  1 2 1 0 6 13 0 -1\n"
" 4 0 3 13 0 2 haar_x2 0.040464 0 -1 -0.329222 0.548347  1 2 5 8 16 6 0 -1 5 11 16 3 0 2\n"
" haar_y2 0.063155 0 -1 -0.317017 0.461530  1 2 8 8 5 12 0 -1 8 14 5 6 0 2 haar_y2\n"
" 0.010321 0 -1 0.106950 -0.982439  1 2 3 21 18 3 0 -1 9 21 6 3 0 3 haar_x3 0.062607 0 -1\n"
" -0.143297 0.710950  1 2 0 0 6 6 0 -1 3 0 3 6 0 2 haar_x2 -0.039416 0 -1 0.943802 -0.215721 \n"
" 1 2 2 0 20 3 0 -1 2 1 20 1 0 3 haar_y3 -0.005396 0 -1 -0.546120 0.253038  1 2 4 6 15 10 0 -1\n"
" 9 6 5 10 0 3 haar_x3 0.107732 0 -1 0.012496 -1.080920  1 2 9 6 6 9 0 -1 11 6 2 9 0 3\n"
" haar_x3 0.016982 0 -1 -0.315364 0.512400  1 2 9 0 6 9 0 -1 11 0 2 9 0 3 haar_x3 0.031217 0 -1\n"
" -0.004520 -1.244348  1 2 14 0 6 9 0 -1 16 0 2 9 0 3 haar_x3 -0.023107 0 -1 -0.764929 0.206406 \n"
" 1 2 7 16 9 6 0 -1 7 18 9 2 0 3 haar_y3 -0.011204 0 -1 0.240927 -0.351421  1 2 14 0 6 9 0 -1\n"
" 16 0 2 9 0 3 haar_x3 -0.004748 0 -1 -0.097008 0.206381  1 2 4 0 6 9 0 -1 6 0 2 9 0 3\n"
" haar_x3 -0.017359 0 -1 -0.790203 0.021853  1 2 17 1 6 16 0 -1 19 1 2 16 0 3 haar_x3\n"
" 0.018852 0 -1 -0.103946 0.548442  1 2 1 1 6 16 0 -1 3 1 2 16 0 3 haar_x3 0.007225 0 -1\n"
" -0.404094 0.267638  1 2 14 13 6 9 0 -1 14 16 6 3 0 3 haar_y3 0.018916 0 -1 0.205080 -1.020634 \n"
" 1 2 0 0 6 9 0 -1 0 3 6 3 0 3 haar_y3 0.031157 0 -1 0.001240 -0.872935  1 2 9 5 6 6 0 -1\n"
" 9 5 3 6 0 2 haar_x2 0.020952 0 -1 -0.005556 0.803562  1 2 3 10 9 6 0 -1 6 10 3 6 0 3\n"
" haar_x3 0.011291 0 -1 -0.364784 0.227679  1 2 14 7 3 16 0 -1 14 15 3 8 0 2 haar_y2\n"
" -0.057011 0 -1 -1.429562 0.143220  1 3 4 10 14 12 0 -1 4 10 7 6 0 2 11 16 7 6 0 2\n"
" haar_x2_y2 0.072194 0 -1 -0.041850 -1.911183  1 2 7 6 12 6 0 -1 7 8 12 2 0 3 haar_y3\n"
" -0.019874 0 -1 0.264255 -0.326177  1 2 7 2 4 20 0 -1 9 2 2 20 0 2 haar_x2 -0.016693 0 -1\n"
" -0.839078 0.000408  1 2 14 13 6 9 0 -1 14 16 6 3 0 3 haar_y3 -0.039835 0 -1 -0.488585 0.164361 \n"
" 1 2 10 6 4 9 0 -1 12 6 2 9 0 2 haar_x2 0.027010 0 -1 -0.188625 0.834194  1 2 14 13 6 9 0 -1\n"
" 14 16 6 3 0 3 haar_y3 -0.003942 0 -1 0.232315 -0.072360  1 2 5 20 14 4 0 -1 5 22 14 2 0 2\n"
" haar_y2 0.022833 0 -1 -0.035884 -1.154940  1 2 4 4 16 12 0 -1 4 10 16 6 0 2 haar_y2\n"
" -0.068888 0 -1 -1.783731 0.151590  1 2 9 6 6 9 0 -1 11 6 2 9 0 3 haar_x3 0.043097 0 -1\n"
" -0.216081 0.506241  1 2 3 0 21 4 0 -1 3 2 21 2 0 2 haar_y2 0.008624 0 -1 -0.177956 0.289579 \n"
" 1 2 4 13 6 9 0 -1 4 16 6 3 0 3 haar_y3 0.014561 0 -1 -0.011408 -0.894020  1 2 16 16 5 8 0 -1\n"
" 16 20 5 4 0 2 haar_y2 -0.011501 0 -1 0.301720 -0.043659  1 3 4 0 16 16 0 -1 4 0 8 8 0 2\n"
" 12 8 8 8 0 2 haar_x2_y2 -0.109715 0 -1 -0.951471 -0.019973  1 3 6 6 14 6 0 -1 13 6 7 3 0 2\n"
" 6 9 7 3 0 2 haar_x2_y2 0.045228 0 -1 0.033111 0.966198  1 2 10 5 4 15 0 -1 10 10 4 5 0 3\n"
" haar_y3 -0.027048 0 -1 0.979636 -0.172619  1 3 9 15 12 8 0 -1 15 15 6 4 0 2 9 19 6 4 0 2\n"
" haar_x2_y2 0.018031 0 -1 -0.020801 0.273859  1 2 6 7 12 4 0 -1 12 7 6 4 0 2 haar_x2\n"
" 0.050525 0 -1 -0.056803 -1.777509  1 3 5 6 14 6 0 -1 12 6 7 3 0 2 5 9 7 3 0 2 haar_x2_y2\n"
" -0.029924 0 -1 0.653292 -0.023537  1 3 3 6 18 10 0 -1 3 6 9 5 0 2 12 11 9 5 0 2 haar_x2_y2\n"
" 0.038058 0 -1 0.026317 -0.706657  1 2 6 0 18 21 0 -1 12 0 6 21 0 3 haar_x3 0.185639 0 -1\n"
" -0.005604 0.328737  1 2 0 0 24 21 0 -1 8 0 8 21 0 3 haar_x3 -0.004067 0 -1 0.342048 -0.301716 \n"
" 1 2 6 18 18 3 0 -1 6 19 18 1 0 3 haar_y3 0.010109 0 -1 -0.007360 0.579816  1 2 0 15 9 6 0 -1\n"
" 0 17 9 2 0 3 haar_y3 -0.011567 0 -1 -0.527222 0.046448  1 2 4 3 19 2 0 -1 4 4 19 1 0 2\n"
" haar_y2 -0.006565 0 -1 -0.585291 0.191019  1 2 0 3 24 2 0 -1 0 4 24 1 0 2 haar_y2\n"
" 0.010582 0 -1 0.021073 -0.688926  1 2 15 14 9 4 0 -1 15 16 9 2 0 2 haar_y2 -0.020304 0 -1\n"
" -0.364007 0.153388  1 2 0 14 9 4 0 -1 0 16 9 2 0 2 haar_y2 0.002353 0 -1 0.036164 -0.598251 \n"
" 1 2 6 15 18 2 0 -1 6 16 18 1 0 2 haar_y2 -0.001469 0 -1 -0.147077 0.375080  1 2 3 17 18 3 0 -1\n"
" 3 18 18 1 0 3 haar_y3 0.008645 0 -1 -0.217085 0.519368  1 2 12 0 3 23 0 -1 13 0 1 23 0 3\n"
" haar_x3 -0.024326 0 -1 -1.084677 0.140848  1 2 6 0 8 6 0 -1 6 3 8 3 0 2 haar_y2 0.074419 0 -1\n"
" -0.155138 1.182277  1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 0.017078 0 -1 0.044231 0.915611 \n"
" 1 2 9 0 3 23 0 -1 10 0 1 23 0 3 haar_x3 -0.024578 0 -1 -1.550410 -0.054746  1 2 10 7 4 10 0 -1\n"
" 10 12 4 5 0 2 haar_y2 0.030205 0 -1 0.166628 -1.000124  1 2 7 8 10 12 0 -1 7 12 10 4 0 3\n"
" haar_y3 0.012136 0 -1 -0.770791 -0.004864  1 3 14 9 6 14 0 -1 17 9 3 7 0 2 14 16 3 7 0 2\n"
" haar_x2_y2 0.086717 0 -1 0.110617 -1.685800  1 2 2 0 10 9 0 -1 2 3 10 3 0 3 haar_y3\n"
" -0.042309 0 -1 1.107593 -0.154386  1 2 11 1 5 12 0 -1 11 7 5 6 0 2 haar_y2 -0.002642 0 -1\n"
" 0.274519 -0.184562  1 3 1 4 12 10 0 -1 1 4 6 5 0 2 7 9 6 5 0 2 haar_x2_y2 -0.056662 0 -1\n"
" -0.806256 -0.016928  1 2 15 1 9 4 0 -1 15 3 9 2 0 2 haar_y2 0.023475 0 -1 0.141877 -0.255009 \n"
" 1 3 1 2 8 10 0 -1 1 2 4 5 0 2 5 7 4 5 0 2 haar_x2_y2 -0.020803 0 -1 0.198263 -0.311712 \n"
" 1 2 10 1 5 12 0 -1 10 5 5 4 0 3 haar_y3 0.007260 0 -1 -0.050591 0.419238  1 2 4 0 14 24 0 -1\n"
" 11 0 7 24 0 2 haar_x2 0.341600 0 -1 -0.166749 0.927486  1 2 7 17 10 4 0 -1 7 19 10 2 0 2\n"
" haar_y2 0.006203 0 -1 -0.126259 0.404453  1 2 10 14 4 10 0 -1 10 19 4 5 0 2 haar_y2\n"
" 0.032692 0 -1 -0.032635 -0.989398  1 2 13 15 6 9 0 -1 15 15 2 9 0 3 haar_x3 0.000211 0 -1\n"
" -0.064534 0.254737  1 2 3 21 18 3 0 -1 3 22 18 1 0 3 haar_y3 0.000721 0 -1 -0.366186 0.119731 \n"
" 1 2 13 15 6 9 0 -1 15 15 2 9 0 3 haar_x3 0.054491 0 -1 0.120735 -1.029139  1 2 5 15 6 9 0 -1\n"
" 7 15 2 9 0 3 haar_x3 -0.010141 0 -1 -0.521772 0.033735  1 3 10 6 4 18 0 -1 12 6 2 9 0 2\n"
" 10 15 2 9 0 2 haar_x2_y2 -0.018816 0 -1 0.651818 0.001340  1 2 7 3 6 11 0 -1 9 3 2 11 0 3\n"
" haar_x3 -0.005348 0 -1 0.173707 -0.341320  1 2 15 1 9 4 0 -1 15 3 9 2 0 2 haar_y2\n"
" -0.010847 0 -1 -0.196999 0.150455  1 2 5 4 14 8 0 -1 5 8 14 4 0 2 haar_y2 -0.049926 0 -1\n"
" -0.508885 0.030762  1 2 8 1 15 9 0 -1 8 4 15 3 0 3 haar_y3 0.012160 0 -1 -0.069252 0.187455 \n"
" 1 3 7 2 8 10 0 -1 7 2 4 5 0 2 11 7 4 5 0 2 haar_x2_y2 -0.002219 0 -1 -0.408491 0.079955 \n"
" 1 2 12 2 6 12 0 -1 12 2 3 12 0 2 haar_x2 0.003158 0 -1 -0.211246 0.223664  1 2 6 2 6 12 0 -1\n"
" 9 2 3 12 0 2 haar_x2 0.004144 0 -1 -0.499003 0.062917  1 2 7 7 12 4 0 -1 7 7 6 4 0 2\n"
" haar_x2 -0.007373 0 -1 -0.205533 0.220967  1 2 6 3 12 10 0 -1 10 3 4 10 0 3 haar_x3\n"
" 0.051812 0 -1 0.180968 -0.434958  1 3 5 6 16 6 0 -1 13 6 8 3 0 2 5 9 8 3 0 2 haar_x2_y2\n"
" 0.018340 0 -1 0.015200 0.379917  1 2 3 1 18 9 0 -1 9 1 6 9 0 3 haar_x3 0.174908 0 -1\n"
" -0.209208 0.400130  1 2 3 8 18 5 0 -1 9 8 6 5 0 3 haar_x3 0.053994 0 -1 0.247516 -0.267129 \n"
" 1 3 0 0 24 22 0 -1 0 0 12 11 0 2 12 11 12 11 0 2 haar_x2_y2 -0.320332 0 -1 -1.909438 -0.066961 \n"
" 1 2 14 16 9 6 0 -1 14 18 9 2 0 3 haar_y3 -0.027060 0 -1 -0.713713 0.159046  1 2 0 16 24 8 0 -1\n"
" 0 20 24 4 0 2 haar_y2 0.077464 0 -1 -0.169702 0.775530  1 3 1 19 22 4 0 -1 12 19 11 2 0 2\n"
" 1 21 11 2 0 2 haar_x2_y2 0.023772 0 -1 0.190219 -0.601621  1 2 1 16 9 6 0 -1 1 18 9 2 0 3\n"
" haar_y3 0.011501 0 -1 0.007704 -0.617303  1 2 7 8 10 4 0 -1 7 8 5 4 0 2 haar_x2 0.032616 0 -1\n"
" 0.171592 -0.709782  1 2 9 15 6 9 0 -1 11 15 2 9 0 3 haar_x3 -0.044383 0 -1 -2.260623 -0.073277 \n"
" 1 3 10 18 12 6 0 -1 16 18 6 3 0 2 10 21 6 3 0 2 haar_x2_y2 -0.058476 0 -1 2.408775 0.083092 \n"
" 1 3 2 18 12 6 0 -1 2 18 6 3 0 2 8 21 6 3 0 2 haar_x2_y2 0.019304 0 -1 -0.270823 0.273700 \n"
" 1 2 8 3 16 9 0 -1 8 6 16 3 0 3 haar_y3 -0.044706 0 -1 0.313556 -0.062492  1 2 0 5 10 6 0 -1\n"
" 0 7 10 2 0 3 haar_y3 -0.060335 0 -1 -1.451512 -0.058761  1 2 5 5 18 3 0 -1 5 6 18 1 0 3\n"
" haar_y3 0.011667 0 -1 -0.018085 0.504797  1 2 2 6 9 6 0 -1 2 9 9 3 0 2 haar_y2 0.028010 0 -1\n"
" -0.233029 0.307087  1 2 14 2 10 9 0 -1 14 5 10 3 0 3 haar_y3 0.065397 0 -1 0.141359 -0.500109 \n"
" 1 2 3 6 18 3 0 -1 3 7 18 1 0 3 haar_y3 0.009624 0 -1 -0.220546 0.391912  1 2 9 2 15 6 0 -1\n"
" 9 4 15 2 0 3 haar_y3 0.002551 0 -1 -0.113815 0.200323  1 2 4 8 15 6 0 -1 4 10 15 2 0 3\n"
" haar_y3 0.031847 0 -1 0.025477 -0.533264  1 3 0 5 24 4 0 -1 12 5 12 2 0 2 0 7 12 2 0 2\n"
" haar_x2_y2 0.033055 0 -1 0.178077 -0.627939  1 2 7 8 6 12 0 -1 9 8 2 12 0 3 haar_x3\n"
" 0.047601 0 -1 -0.147479 1.420418  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3 -0.019572 0 -1\n"
" -0.526935 0.158386  1 3 0 12 6 12 0 -1 0 12 3 6 0 2 3 18 3 6 0 2 haar_x2_y2 -0.054730 0 -1\n"
" 0.882316 -0.166278  1 2 14 12 10 6 0 -1 14 14 10 2 0 3 haar_y3 -0.022686 0 -1 -0.483869 0.150001 \n"
" 1 2 2 7 18 9 0 -1 2 10 18 3 0 3 haar_y3 0.107132 0 -1 -0.213362 0.423339  1 2 11 14 10 9 0 -1\n"
" 11 17 10 3 0 3 haar_y3 -0.036380 0 -1 -0.074198 0.145894  1 3 7 6 10 8 0 -1 7 6 5 4 0 2\n"
" 12 10 5 4 0 2 haar_x2_y2 0.013936 0 -1 -0.249116 0.267712  1 3 6 6 14 6 0 -1 13 6 7 3 0 2\n"
" 6 9 7 3 0 2 haar_x2_y2 0.020992 0 -1 0.008796 0.430650  1 2 4 13 9 7 0 -1 7 13 3 7 0 3\n"
" haar_x3 0.049119 0 -1 -0.175920 0.692829  1 3 14 10 6 12 0 -1 17 10 3 6 0 2 14 16 3 6 0 2\n"
" haar_x2_y2 0.036316 0 -1 0.131453 -0.335973  1 3 4 10 6 12 0 -1 4 10 3 6 0 2 7 16 3 6 0 2\n"
" haar_x2_y2 0.041228 0 -1 -0.045692 -1.351593  1 2 13 9 8 6 0 -1 13 9 4 6 0 2 haar_x2\n"
" 0.015672 0 -1 0.175441 -0.060550  1 2 8 3 4 14 0 -1 10 3 2 14 0 2 haar_x2 -0.016286 0 -1\n"
" -1.130819 -0.039533  1 2 17 0 3 18 0 -1 18 0 1 18 0 3 haar_x3 -0.003023 0 -1 -0.224543 0.236281 \n"
" 1 2 4 12 16 12 0 -1 12 12 8 12 0 2 haar_x2 -0.137863 0 -1 0.453769 -0.210987  1 2\n"
" 15 0 6 14 0 -1 17 0 2 14 0 3 haar_x3 -0.009676 0 -1 -0.151051 0.207817  1 2 3 0 6 14 0 -1\n"
" 5 0 2 14 0 3 haar_x3 -0.024840 0 -1 -0.683503 -0.008004  1 2 12 2 12 20 0 -1 16 2 4 20 0 3\n"
" haar_x3 -0.139644 0 -1 0.650113 0.046544  1 2 0 2 12 20 0 -1 4 2 4 20 0 3 haar_x3\n"
" -0.082154 0 -1 0.448872 -0.235920  1 2 16 0 6 17 0 -1 18 0 2 17 0 3 haar_x3 0.003845 0 -1\n"
" -0.088173 0.273468  1 2 2 0 6 17 0 -1 4 0 2 17 0 3 haar_x3 -0.006658 0 -1 -0.468666 0.077002 \n"
" 1 2 15 6 9 6 0 -1 15 8 9 2 0 3 haar_y3 -0.015898 0 -1 0.292684 -0.021941  1 2 0 6 9 6 0 -1\n"
" 0 8 9 2 0 3 haar_y3 -0.050946 0 -1 -1.209379 -0.042110  1 2 18 1 6 13 0 -1 20 1 2 13 0 3\n"
" haar_x3 0.016838 0 -1 -0.045596 0.501807  1 2 0 1 6 13 0 -1 2 1 2 13 0 3 haar_x3\n"
" 0.015919 0 -1 -0.269043 0.265163  1 2 16 0 4 9 0 -1 16 0 2 9 0 2 haar_x2 0.003631 0 -1\n"
" -0.130461 0.318071  1 2 5 10 12 7 0 -1 9 10 4 7 0 3 haar_x3 -0.086145 0 -1 1.944366 -0.139783 \n"
" 1 2 12 9 12 6 0 -1 12 11 12 2 0 3 haar_y3 0.033141 0 -1 0.152668 -0.030866  1 2 0 9 12 6 0 -1\n"
" 0 11 12 2 0 3 haar_y3 -0.003968 0 -1 -0.712023 -0.013844  1 2 5 7 14 9 0 -1 5 10 14 3 0 3\n"
" haar_y3 -0.024008 0 -1 0.920078 0.046724  1 2 0 15 20 3 0 -1 0 16 20 1 0 3 haar_y3\n"
" 0.008732 0 -1 -0.225673 0.319318  1 3 8 10 8 10 0 -1 12 10 4 5 0 2 8 15 4 5 0 2 haar_x2_y2\n"
" -0.027787 0 -1 -0.723371 0.170186  1 2 5 4 13 9 0 -1 5 7 13 3 0 3 haar_y3 -0.194553 0 -1\n"
" 1.246186 -0.147362  1 2 10 2 6 18 0 -1 10 8 6 6 0 3 haar_y3 -0.108697 0 -1 -1.446518 0.121453 \n"
" 1 2 6 0 6 9 0 -1 8 0 2 9 0 3 haar_x3 -0.019495 0 -1 -0.781531 -0.023733  1 2 6 9 12 4 0 -1\n"
" 6 11 12 2 0 2 haar_y2 0.003065 0 -1 -0.854714 0.166870  1 2 3 2 15 12 0 -1 3 6 15 4 0 3\n"
" haar_y3 0.059194 0 -1 -0.148537 1.127347  1 2 12 0 12 5 0 -1 16 0 4 5 0 3 haar_x3\n"
" -0.054208 0 -1 0.547270 0.035524  1 2 0 15 18 3 0 -1 6 15 6 3 0 3 haar_x3 -0.039325 0 -1\n"
" 0.366426 -0.205440  1 2 0 14 24 5 0 -1 8 14 8 5 0 3 haar_x3 0.082279 0 -1 -0.035008 0.539942 \n"
" 1 2 5 1 3 18 0 -1 6 1 1 18 0 3 haar_x3 -0.007448 0 -1 -0.615375 -0.003532  1 2 10 0 4 14 0 -1\n"
" 10 0 2 14 0 2 haar_x2 0.007377 0 -1 -0.065591 0.419614  1 2 9 3 4 9 0 -1 11 3 2 9 0 2\n"
" haar_x2 0.007078 0 -1 -0.341295 0.125368  1 3 8 2 12 6 0 -1 14 2 6 3 0 2 8 5 6 3 0 2\n"
" haar_x2_y2 -0.015582 0 -1 -0.302404 0.215110  1 2 0 4 17 4 0 -1 0 6 17 2 0 2 haar_y2\n"
" -0.002740 0 -1 0.076553 -0.410605  1 2 16 16 5 8 0 -1 16 20 5 4 0 2 haar_y2 -0.070600 0 -1\n"
" -0.973562 0.112418  1 2 3 16 5 8 0 -1 3 20 5 4 0 2 haar_y2 -0.011706 0 -1 0.185607 -0.297552 \n"
" 1 2 6 18 18 2 0 -1 6 19 18 1 0 2 haar_y2 0.000715 0 -1 -0.059650 0.248247  1 2 0 0 12 5 0 -1\n"
" 4 0 4 5 0 3 haar_x3 -0.036866 0 -1 0.327517 -0.230596  1 3 14 3 6 12 0 -1 17 3 3 6 0 2\n"
" 14 9 3 6 0 2 haar_x2_y2 -0.032527 0 -1 -0.293203 0.154277  1 2 0 12 6 12 0 -1 2 12 2 12 0 3\n"
" haar_x3 -0.074814 0 -1 -1.214357 -0.052244  1 2 2 3 21 3 0 -1 2 4 21 1 0 3 haar_y3\n"
" 0.041470 0 -1 0.130625 -2.327437  1 3 4 3 6 12 0 -1 4 3 3 6 0 2 7 9 3 6 0 2 haar_x2_y2\n"
" -0.028880 0 -1 -0.660746 -0.009096  1 3 12 8 12 6 0 -1 18 8 6 3 0 2 12 11 6 3 0 2\n"
" haar_x2_y2 0.046382 0 -1 0.166302 -0.669495  1 2 0 15 16 9 0 -1 8 15 8 9 0 2 haar_x2\n"
" 0.254250 0 -1 -0.054642 -1.267608  1 2 6 13 18 5 0 -1 6 13 9 5 0 2 haar_x2 0.002400 0 -1\n"
" 0.202768 0.014668  1 2 1 6 15 6 0 -1 6 6 5 6 0 3 haar_x3 -0.082806 0 -1 -0.787136 -0.024469 \n"
" 1 2 11 9 9 6 0 -1 14 9 3 6 0 3 haar_x3 -0.011438 0 -1 0.286234 -0.030894  1 2 3 0 15 11 0 -1\n"
" 8 0 5 11 0 3 haar_x3 -0.129134 0 -1 1.729293 -0.142939  1 2 15 3 3 18 0 -1 15 9 3 6 0 3\n"
" haar_y3 0.038553 0 -1 0.019233 0.377326  1 2 6 3 3 18 0 -1 6 9 3 6 0 3 haar_y3 0.101914 0 -1\n"
" -0.074534 -3.386890  1 3 9 5 10 8 0 -1 14 5 5 4 0 2 9 9 5 4 0 2 haar_x2_y2 -0.019068 0 -1\n"
" 0.318141 0.019261  1 3 4 4 16 8 0 -1 4 4 8 4 0 2 12 8 8 4 0 2 haar_x2_y2 -0.060775 0 -1\n"
" 0.769363 -0.176440  1 2 7 7 12 3 0 -1 7 7 6 3 0 2 haar_x2 0.024680 0 -1 0.183965 -0.308688 \n"
" 1 2 5 0 9 13 0 -1 8 0 3 13 0 3 haar_x3 0.026759 0 -1 -0.234549 0.330566  1 2 11 0 6 9 0 -1\n"
" 13 0 2 9 0 3 haar_x3 0.014970 0 -1 0.172136 -0.182489  1 2 7 0 6 9 0 -1 9 0 2 9 0 3\n"
" haar_x3 0.026143 0 -1 -0.046464 -1.131838  1 2 8 1 10 9 0 -1 8 4 10 3 0 3 haar_y3\n"
" -0.037512 0 -1 0.804040 0.069660  1 2 0 2 18 2 0 -1 0 3 18 1 0 2 haar_y2 -0.005323 0 -1\n"
" -0.818844 -0.018225  1 3 10 13 14 6 0 -1 17 13 7 3 0 2 10 16 7 3 0 2 haar_x2_y2 0.017813 0 -1\n"
" 0.149578 -0.186672  1 3 0 13 14 6 0 -1 0 13 7 3 0 2 7 16 7 3 0 2 haar_x2_y2 -0.034010 0 -1\n"
" -0.728523 -0.016616  1 2 20 2 3 21 0 -1 21 2 1 21 0 3 haar_x3 -0.015953 0 -1 0.569440 0.013832 \n"
" 1 2 0 9 5 12 0 -1 0 13 5 4 0 3 haar_y3 0.019744 0 -1 0.040525 -0.417734  1 2 12 6 12 6 0 -1\n"
" 12 8 12 2 0 3 haar_y3 -0.103748 0 -1 -1.982515 0.119602  1 2 1 8 20 3 0 -1 1 9 20 1 0 3\n"
" haar_y3 -0.019285 0 -1 0.502306 -0.197459  1 2 5 7 19 3 0 -1 5 8 19 1 0 3 haar_y3\n"
" -0.012780 0 -1 0.401950 -0.026958  1 2 1 12 9 6 0 -1 1 14 9 2 0 3 haar_y3 -0.016353 0 -1\n"
" -0.766088 -0.024209  1 2 6 10 14 12 0 -1 6 14 14 4 0 3 haar_y3 -0.127637 0 -1 0.865785 0.064206 \n"
" 1 2 5 6 14 18 0 -1 5 12 14 6 0 3 haar_y3 0.019069 0 -1 -0.559298 -0.001688  1 2 11 12 9 7 0 -1\n"
" 14 12 3 7 0 3 haar_x3 0.032481 0 -1 0.040722 0.489251  1 2 1 15 18 4 0 -1 1 17 18 2 0 2\n"
" haar_y2 0.009485 0 -1 -0.192319 0.511397  1 2 11 14 6 9 0 -1 11 17 6 3 0 3 haar_y3\n"
" 0.005047 0 -1 0.187068 -0.161136  1 3 0 8 18 4 0 -1 0 8 9 2 0 2 9 10 9 2 0 2 haar_x2_y2\n"
" 0.041268 0 -1 -0.048818 -1.132630  1 3 3 10 20 6 0 -1 13 10 10 3 0 2 3 13 10 3 0 2\n"
" haar_x2_y2 -0.076359 0 -1 1.416939 0.087320  1 3 1 10 20 6 0 -1 1 10 10 3 0 2 11 13 10 3 0 2\n"
" haar_x2_y2 -0.072835 0 -1 1.318986 -0.148191  1 2 0 9 24 2 0 -1 0 9 12 2 0 2 haar_x2\n"
" 0.059577 0 -1 0.048377 0.856118  1 3 1 12 20 8 0 -1 1 12 10 4 0 2 11 16 10 4 0 2\n"
" haar_x2_y2 0.020264 0 -1 -0.210441 0.338590  1 2 11 12 9 7 0 -1 14 12 3 7 0 3 haar_x3\n"
" -0.080301 0 -1 -1.246440 0.118571  1 2 4 12 9 7 0 -1 7 12 3 7 0 3 haar_x3 -0.017835 0 -1\n"
" 0.257823 -0.245648  1 2 12 12 8 5 0 -1 12 12 4 5 0 2 haar_x2 0.011431 0 -1 0.229498 -0.294976 \n"
" 1 2 4 12 8 5 0 -1 8 12 4 5 0 2 haar_x2 -0.025541 0 -1 -0.862530 -0.000704  1 2 13 10 4 10 0 -1\n"
" 13 10 2 10 0 2 haar_x2 -0.000769 0 -1 0.315114 -0.143490  1 2 1 15 20 2 0 -1 11 15 10 2 0 2\n"
" haar_x2 -0.014454 0 -1 0.251485 -0.282329  1 2 9 10 6 6 0 -1 9 10 3 6 0 2 haar_x2\n"
" 0.008673 0 -1 0.266014 -0.281908  -3.210350\n"
,

/* Stage 20 */
" 197 1 2 0 1 21 3 0 -1 7 1 7 3 0 3 haar_x3 0.054709 0 -1 -0.541443 0.610430  1 2 6 4 13 9 0 -1\n"
" 6 7 13 3 0 3 haar_y3 -0.108388 0 -1 0.717399 -0.411961  1 2 6 5 12 5 0 -1 10 5 4 5 0 3\n"
" haar_x3 0.022997 0 -1 -0.582698 0.296456  1 2 10 10 10 6 0 -1 10 12 10 2 0 3 haar_y3\n"
" 0.002754 0 -1 -0.742439 0.141833  1 2 6 12 5 8 0 -1 6 16 5 4 0 2 haar_y2 -0.002152 0 -1\n"
" 0.178799 -0.685486  1 2 13 0 6 9 0 -1 15 0 2 9 0 3 haar_x3 -0.022559 0 -1 -1.077555 0.123890 \n"
" 1 2 2 10 18 6 0 -1 8 10 6 6 0 3 haar_x3 0.083025 0 -1 0.024501 -1.025188  1 2 11 2 9 4 0 -1\n"
" 11 4 9 2 0 2 haar_y2 -0.006674 0 -1 -0.452831 0.212302  1 2 1 20 21 3 0 -1 8 20 7 3 0 3\n"
" haar_x3 0.076485 0 -1 -0.269727 0.485802  1 2 1 10 22 2 0 -1 1 11 22 1 0 2 haar_y2\n"
" 0.005491 0 -1 -0.488712 0.316164  1 2 0 17 18 3 0 -1 0 18 18 1 0 3 haar_y3 -0.010415 0 -1\n"
" 0.415129 -0.300448  1 2 13 0 6 9 0 -1 15 0 2 9 0 3 haar_x3 0.027608 0 -1 0.162038 -0.998685 \n"
" 1 2 5 0 6 9 0 -1 7 0 2 9 0 3 haar_x3 -0.023272 0 -1 -1.102440 0.021125  1 2 18 2 6 20 0 -1\n"
" 20 2 2 20 0 3 haar_x3 -0.055620 0 -1 0.650331 -0.027938  1 2 0 2 6 20 0 -1 2 2 2 20 0 3\n"
" haar_x3 -0.040632 0 -1 0.421173 -0.267638  1 3 11 7 6 14 0 -1 14 7 3 7 0 2 11 14 3 7 0 2\n"
" haar_x2_y2 -0.007356 0 -1 0.352778 -0.378540  1 2 0 1 4 9 0 -1 2 1 2 9 0 2 haar_x2\n"
" 0.017007 0 -1 -0.291895 0.410538  1 2 12 14 9 4 0 -1 12 16 9 2 0 2 haar_y2 -0.037034 0 -1\n"
" -1.321631 0.129665  1 2 1 13 9 4 0 -1 1 15 9 2 0 2 haar_y2 -0.019633 0 -1 -0.877023 0.001080 \n"
" 1 2 7 6 15 6 0 -1 7 8 15 2 0 3 haar_y3 -0.023547 0 -1 0.261061 -0.214814  1 2 8 2 3 18 0 -1\n"
" 8 8 3 6 0 3 haar_y3 -0.043353 0 -1 -0.990897 -0.009956  1 3 6 6 12 6 0 -1 12 6 6 3 0 2\n"
" 6 9 6 3 0 2 haar_x2_y2 -0.022184 0 -1 0.634544 -0.056547  1 3 2 19 20 4 0 -1 2 19 10 2 0 2\n"
" 12 21 10 2 0 2 haar_x2_y2 0.016531 0 -1 0.024665 -0.733268  1 2 14 15 6 9 0 -1 14 18 6 3 0 3\n"
" haar_y3 -0.032744 0 -1 -0.562972 0.166403  1 3 3 5 18 14 0 -1 3 5 9 7 0 2 12 12 9 7 0 2\n"
" haar_x2_y2 0.071416 0 -1 -0.000300 -0.932864  1 3 15 6 4 18 0 -1 17 6 2 9 0 2 15 15 2 9 0 2\n"
" haar_x2_y2 0.000810 0 -1 -0.095380 0.251847  1 3 5 6 4 18 0 -1 5 6 2 9 0 2 7 15 2 9 0 2\n"
" haar_x2_y2 -0.008409 0 -1 -0.654968 0.067301  1 2 11 0 6 9 0 -1 13 0 2 9 0 3 haar_x3\n"
" -0.017254 0 -1 -0.464930 0.160709  1 2 7 0 6 9 0 -1 9 0 2 9 0 3 haar_x3 -0.018641 0 -1\n"
" -1.059401 -0.019617  1 2 11 5 6 9 0 -1 13 5 2 9 0 3 haar_x3 -0.009198 0 -1 0.507162 -0.153392 \n"
" 1 2 9 5 6 6 0 -1 12 5 3 6 0 2 haar_x2 0.018538 0 -1 -0.304982 0.735062  1 3 4 1 16 6 0 -1\n"
" 12 1 8 3 0 2 4 4 8 3 0 2 haar_x2_y2 -0.050335 0 -1 -1.114048 0.180001  1 2 9 13 6 11 0 -1\n"
" 11 13 2 11 0 3 haar_x3 -0.023529 0 -1 -0.869079 -0.012460  1 3 17 1 6 12 0 -1 20 1 3 6 0 2\n"
" 17 7 3 6 0 2 haar_x2_y2 -0.027100 0 -1 0.659429 -0.035324  1 2 1 17 18 3 0 -1 1 18 18 1 0 3\n"
" haar_y3 0.006588 0 -1 -0.229534 0.424251  1 2 7 13 10 8 0 -1 7 17 10 4 0 2 haar_y2\n"
" 0.023360 0 -1 0.183562 -0.985873  1 2 6 18 10 6 0 -1 6 20 10 2 0 3 haar_y3 0.012947 0 -1\n"
" -0.331474 0.213232  1 2 9 14 9 4 0 -1 9 16 9 2 0 2 haar_y2 -0.006656 0 -1 -0.119514 0.297528 \n"
" 1 3 1 1 6 12 0 -1 1 1 3 6 0 2 4 7 3 6 0 2 haar_x2_y2 -0.022571 0 -1 0.384994 -0.244345 \n"
" 1 2 19 4 5 12 0 -1 19 8 5 4 0 3 haar_y3 -0.063814 0 -1 -0.893835 0.142175  1 2 0 0 8 8 0 -1\n"
" 4 0 4 8 0 2 haar_x2 -0.049945 0 -1 0.538644 -0.204853  1 2 3 5 19 3 0 -1 3 6 19 1 0 3\n"
" haar_y3 0.006832 0 -1 -0.056679 0.399710  1 3 1 5 12 6 0 -1 1 5 6 3 0 2 7 8 6 3 0 2\n"
" haar_x2_y2 -0.055836 0 -1 -1.523947 -0.051183  1 2 2 1 21 8 0 -1 9 1 7 8 0 3 haar_x3\n"
" 0.319570 0 -1 0.074574 1.244780  1 2 4 1 16 8 0 -1 4 5 16 4 0 2 haar_y2 0.080956 0 -1\n"
" -0.196655 0.598897  1 2 6 0 18 3 0 -1 6 1 18 1 0 3 haar_y3 -0.014912 0 -1 -0.640206 0.158076 \n"
" 1 2 4 4 10 14 0 -1 4 11 10 7 0 2 haar_y2 0.046709 0 -1 0.085239 -0.454872  1 2 15 6 4 10 0 -1\n"
" 15 11 4 5 0 2 haar_y2 0.006054 0 -1 -0.431840 0.224526  1 2 3 18 18 3 0 -1 9 18 6 3 0 3\n"
" haar_x3 -0.034376 0 -1 0.402025 -0.239036  1 2 8 18 12 6 0 -1 12 18 4 6 0 3 haar_x3\n"
" -0.034924 0 -1 0.528701 0.039709  1 2 3 15 6 9 0 -1 6 15 3 9 0 2 haar_x2 0.003003 0 -1\n"
" -0.387543 0.141926  1 2 15 7 6 8 0 -1 15 11 6 4 0 2 haar_y2 -0.014133 0 -1 0.875284 0.085508 \n"
" 1 2 3 7 6 8 0 -1 3 11 6 4 0 2 haar_y2 -0.006794 0 -1 -1.164922 -0.033943  1 3 5 9 18 6 0 -1\n"
" 14 9 9 3 0 2 5 12 9 3 0 2 haar_x2_y2 -0.052886 0 -1 1.093068 0.051187  1 2 1 13 12 6 0 -1\n"
" 1 15 12 2 0 3 haar_y3 -0.002108 0 -1 0.136962 -0.338500  1 2 14 15 10 6 0 -1 14 17 10 2 0 3\n"
" haar_y3 0.018353 0 -1 0.136616 -0.407778  1 2 0 15 10 6 0 -1 0 17 10 2 0 3 haar_y3\n"
" 0.012672 0 -1 -0.014936 -0.817075  1 2 15 13 6 9 0 -1 15 16 6 3 0 3 haar_y3 0.012925 0 -1\n"
" 0.176251 -0.324917  1 2 3 13 6 9 0 -1 3 16 6 3 0 3 haar_y3 -0.017921 0 -1 -0.527454 0.044443 \n"
" 1 2 9 5 8 8 0 -1 9 5 4 8 0 2 haar_x2 0.001916 0 -1 -0.109786 0.220675  1 3 1 18 12 6 0 -1\n"
" 1 18 6 3 0 2 7 21 6 3 0 2 haar_x2_y2 -0.014698 0 -1 0.390678 -0.222250  1 2 13 19 10 4 0 -1\n"
" 13 21 10 2 0 2 haar_y2 -0.014973 0 -1 -0.254509 0.177900  1 2 1 19 10 4 0 -1 1 21 10 2 0 2\n"
" haar_y2 0.014637 0 -1 -0.025125 -0.871213  1 2 6 19 18 3 0 -1 6 20 18 1 0 3 haar_y3\n"
" -0.010974 0 -1 0.790828 0.020121  1 2 8 14 4 10 0 -1 8 19 4 5 0 2 haar_y2 -0.009160 0 -1\n"
" -0.479069 0.052232  1 2 0 0 24 6 0 -1 0 2 24 2 0 3 haar_y3 0.004618 0 -1 -0.172446 0.345278 \n"
" 1 2 0 1 6 9 0 -1 0 4 6 3 0 3 haar_y3 0.023477 0 -1 0.003776 -0.653337  1 3 4 9 20 6 0 -1\n"
" 14 9 10 3 0 2 4 12 10 3 0 2 haar_x2_y2 0.031767 0 -1 0.016364 0.587237  1 2 1 15 19 8 0 -1\n"
" 1 19 19 4 0 2 haar_y2 -0.018420 0 -1 0.199939 -0.320565  1 2 14 0 10 6 0 -1 14 2 10 2 0 3\n"
" haar_y3 0.019544 0 -1 0.184502 -0.237936  1 2 1 10 21 14 0 -1 8 10 7 14 0 3 haar_x3\n"
" 0.411595 0 -1 -0.060382 -1.607212  1 2 10 10 8 8 0 -1 10 10 4 8 0 2 haar_x2 -0.041596 0 -1\n"
" -0.327562 0.150580  1 2 6 8 10 4 0 -1 11 8 5 4 0 2 haar_x2 -0.010336 0 -1 -0.623944 0.013112 \n"
" 1 2 10 5 4 9 0 -1 10 5 2 9 0 2 haar_x2 0.012393 0 -1 -0.033115 0.555799  1 2 7 5 6 10 0 -1\n"
" 9 5 2 10 0 3 haar_x3 -0.008727 0 -1 0.198832 -0.376356  1 2 14 4 4 13 0 -1 14 4 2 13 0 2\n"
" haar_x2 0.016295 0 -1 0.203730 -0.428008  1 2 6 4 4 13 0 -1 8 4 2 13 0 2 haar_x2\n"
" -0.010484 0 -1 -0.568470 0.044199  1 2 8 7 9 6 0 -1 11 7 3 6 0 3 haar_x3 -0.012432 0 -1\n"
" 0.746419 0.043679  1 3 3 6 16 6 0 -1 3 6 8 3 0 2 11 9 8 3 0 2 haar_x2_y2 -0.050375 0 -1\n"
" 0.850901 -0.177738  1 3 5 4 16 14 0 -1 13 4 8 7 0 2 5 11 8 7 0 2 haar_x2_y2 0.049548 0 -1\n"
" 0.167849 -0.298775  1 3 0 0 24 4 0 -1 0 0 12 2 0 2 12 2 12 2 0 2 haar_x2_y2 -0.041085 0 -1\n"
" -1.330292 -0.049182  1 2 9 1 9 6 0 -1 12 1 3 6 0 3 haar_x3 0.001007 0 -1 -0.060539 0.184832 \n"
" 1 2 4 1 14 4 0 -1 11 1 7 4 0 2 haar_x2 -0.050143 0 -1 0.764477 -0.183570  1 2 10 14 7 9 0 -1\n"
" 10 17 7 3 0 3 haar_y3 -0.008788 0 -1 0.226560 -0.063157  1 3 8 3 8 10 0 -1 8 3 4 5 0 2\n"
" 12 8 4 5 0 2 haar_x2_y2 -0.050171 0 -1 -1.589907 -0.061255  1 2 7 3 12 5 0 -1 11 3 4 5 0 3\n"
" haar_x3 0.102161 0 -1 0.120718 -1.412011  1 2 8 2 4 13 0 -1 10 2 2 13 0 2 haar_x2\n"
" -0.014373 0 -1 -1.311697 -0.051936  1 2 11 2 3 19 0 -1 12 2 1 19 0 3 haar_x3 0.010282 0 -1\n"
" -0.002164 0.442472  1 2 7 7 9 6 0 -1 10 7 3 6 0 3 haar_x3 -0.011814 0 -1 0.653781 -0.187237 \n"
" 1 2 4 22 20 2 0 -1 4 22 10 2 0 2 haar_x2 0.072115 0 -1 0.071847 0.814963  1 3 0 16 24 4 0 -1\n"
" 0 16 12 2 0 2 12 18 12 2 0 2 haar_x2_y2 -0.019002 0 -1 -0.674272 -0.000432  1 2 7 3 12 5 0 -1\n"
" 11 3 4 5 0 3 haar_x3 -0.004699 0 -1 0.333115 0.055794  1 3 1 10 8 14 0 -1 1 10 4 7 0 2\n"
" 5 17 4 7 0 2 haar_x2_y2 -0.058157 0 -1 0.455723 -0.203051  1 2 11 16 6 6 0 -1 11 19 6 3 0 2\n"
" haar_y2 0.001136 0 -1 -0.044687 0.226819  1 3 6 0 10 24 0 -1 6 0 5 12 0 2 11 12 5 12 0 2\n"
" haar_x2_y2 -0.049415 0 -1 0.266946 -0.261170  1 3 7 5 14 14 0 -1 14 5 7 7 0 2 7 12 7 7 0 2\n"
" haar_x2_y2 -0.119138 0 -1 -0.830180 0.132485  1 3 7 8 10 8 0 -1 7 8 5 4 0 2 12 12 5 4 0 2\n"
" haar_x2_y2 -0.018304 0 -1 -0.674992 0.017092  1 2 9 1 9 6 0 -1 12 1 3 6 0 3 haar_x3\n"
" -0.007920 0 -1 -0.072287 0.144258  1 2 0 6 24 3 0 -1 12 6 12 3 0 2 haar_x2 0.051926 0 -1\n"
" 0.030922 -0.558606  1 2 7 3 12 5 0 -1 11 3 4 5 0 3 haar_x3 0.066724 0 -1 0.136664 -0.294110 \n"
" 1 3 1 13 22 4 0 -1 1 13 11 2 0 2 12 15 11 2 0 2 haar_x2_y2 -0.013778 0 -1 -0.594439 0.015300 \n"
" 1 2 9 12 12 6 0 -1 9 14 12 2 0 3 haar_y3 -0.017761 0 -1 0.404965 -0.003356  1 2 0 5 9 6 0 -1\n"
" 0 7 9 2 0 3 haar_y3 -0.042235 0 -1 -1.089794 -0.040225  1 2 1 5 23 6 0 -1 1 7 23 2 0 3\n"
" haar_y3 -0.013525 0 -1 0.289219 -0.251948  1 2 1 6 19 12 0 -1 1 10 19 4 0 3 haar_y3\n"
" -0.011106 0 -1 0.653128 -0.180537  1 2 9 1 6 21 0 -1 9 8 6 7 0 3 haar_y3 -0.122846 0 -1\n"
" -1.957065 0.148154  1 2 3 19 18 3 0 -1 9 19 6 3 0 3 haar_x3 0.047716 0 -1 -0.228756 0.342337 \n"
" 1 2 9 14 6 9 0 -1 11 14 2 9 0 3 haar_x3 0.031817 0 -1 0.159763 -1.009197  1 2 9 6 4 12 0 -1\n"
" 11 6 2 12 0 2 haar_x2 0.004257 0 -1 -0.388813 0.084210  1 2 16 0 6 9 0 -1 18 0 2 9 0 3\n"
" haar_x3 -0.061373 0 -1 1.715281 0.059325  1 2 2 0 6 9 0 -1 4 0 2 9 0 3 haar_x3 -0.002703 0 -1\n"
" -0.381617 0.085127  1 3 13 1 4 22 0 -1 15 1 2 11 0 2 13 12 2 11 0 2 haar_x2_y2 -0.068544 0 -1\n"
" -3.092589 0.117880  1 2 1 8 8 12 0 -1 1 14 8 6 0 2 haar_y2 0.103725 0 -1 -0.137693 1.900941 \n"
" 1 2 14 7 7 9 0 -1 14 10 7 3 0 3 haar_y3 0.015799 0 -1 -0.062660 0.259177  1 3 3 12 18 4 0 -1\n"
" 3 12 9 2 0 2 12 14 9 2 0 2 haar_x2_y2 -0.009804 0 -1 -0.562916 0.043923  1 3 13 1 4 22 0 -1\n"
" 15 1 2 11 0 2 13 12 2 11 0 2 haar_x2_y2 -0.009023 0 -1 0.252871 -0.041226  1 3 7 1 4 22 0 -1\n"
" 7 1 2 11 0 2 9 12 2 11 0 2 haar_x2_y2 -0.063755 0 -1 -2.617857 -0.074006  1 3 4 7 20 4 0 -1\n"
" 14 7 10 2 0 2 4 9 10 2 0 2 haar_x2_y2 0.038955 0 -1 0.059033 0.859456  1 2 9 10 6 7 0 -1\n"
" 12 10 3 7 0 2 haar_x2 -0.039803 0 -1 0.936005 -0.156394  1 2 7 7 10 4 0 -1 7 7 5 4 0 2\n"
" haar_x2 0.050302 0 -1 0.137259 -2.554973  1 2 0 3 4 15 0 -1 0 8 4 5 0 3 haar_y3 0.046250 0 -1\n"
" -0.013964 -0.710262  1 3 15 0 8 12 0 -1 19 0 4 6 0 2 15 6 4 6 0 2 haar_x2_y2 0.062196 0 -1\n"
" 0.059526 1.650910  1 3 1 0 8 12 0 -1 1 0 4 6 0 2 5 6 4 6 0 2 haar_x2_y2 -0.064776 0 -1\n"
" 0.713690 -0.172700  1 2 14 5 6 16 0 -1 16 5 2 16 0 3 haar_x3 0.027523 0 -1 0.146316 -0.081429 \n"
" 1 2 4 5 6 16 0 -1 6 5 2 16 0 3 haar_x3 0.000399 0 -1 -0.371445 0.101527  1 2 15 0 6 16 0 -1\n"
" 17 0 2 16 0 3 haar_x3 -0.004330 0 -1 -0.237563 0.267984  1 2 3 0 6 16 0 -1 5 0 2 16 0 3\n"
" haar_x3 0.047297 0 -1 -0.027682 -0.849103  1 2 0 2 24 3 0 -1 0 3 24 1 0 3 haar_y3\n"
" 0.012509 0 -1 0.187302 -0.560011  1 2 7 1 10 4 0 -1 7 3 10 2 0 2 haar_y2 0.045899 0 -1\n"
" -0.156012 0.970730  1 2 1 0 23 8 0 -1 1 4 23 4 0 2 haar_y2 0.198534 0 -1 0.148955 -1.101553 \n"
" 1 2 1 17 19 3 0 -1 1 18 19 1 0 3 haar_y3 0.016675 0 -1 -0.166153 0.822110  1 2 6 18 18 2 0 -1\n"
" 6 19 18 1 0 2 haar_y2 0.001983 0 -1 -0.071250 0.288109  1 2 1 17 9 6 0 -1 1 19 9 2 0 3\n"
" haar_y3 0.022448 0 -1 -0.020981 -0.784165  1 2 15 15 6 9 0 -1 15 18 6 3 0 3 haar_y3\n"
" -0.013913 0 -1 -0.181658 0.204918  1 2 3 15 6 9 0 -1 3 18 6 3 0 3 haar_y3 -0.007766 0 -1\n"
" -0.455959 0.063577  1 2 4 14 20 6 0 -1 4 17 20 3 0 2 haar_y2 -0.013209 0 -1 0.266323 -0.177960 \n"
" 1 3 0 10 6 14 0 -1 0 10 3 7 0 2 3 17 3 7 0 2 haar_x2_y2 0.049053 0 -1 -0.154768 1.106998 \n"
" 1 2 6 18 18 3 0 -1 6 19 18 1 0 3 haar_y3 0.020264 0 -1 0.068915 0.698675  1 2 4 12 9 7 0 -1\n"
" 7 12 3 7 0 3 haar_x3 -0.016828 0 -1 0.276072 -0.251392  1 2 6 10 18 5 0 -1 12 10 6 5 0 3\n"
" haar_x3 -0.169395 0 -1 -3.076753 0.116175  1 2 0 10 18 5 0 -1 6 10 6 5 0 3 haar_x3\n"
" -0.113361 0 -1 -1.463923 -0.051447  1 2 3 2 18 9 0 -1 9 2 6 9 0 3 haar_x3 -0.077686 0 -1\n"
" 0.884302 0.043307  1 3 4 6 10 10 0 -1 4 6 5 5 0 2 9 11 5 5 0 2 haar_x2_y2 -0.015568 0 -1\n"
" 0.136725 -0.345055  1 2 20 14 4 9 0 -1 20 14 2 9 0 2 haar_x2 -0.066019 0 -1 -1.030011 0.116014 \n"
" 1 2 0 14 4 9 0 -1 2 14 2 9 0 2 haar_x2 0.008370 0 -1 0.076429 -0.440025  1 3 11 1 4 20 0 -1\n"
" 13 1 2 10 0 2 11 11 2 10 0 2 haar_x2_y2 0.035403 0 -1 0.119795 -0.726683  1 2 6 21 12 3 0 -1\n"
" 12 21 6 3 0 2 haar_x2 -0.039051 0 -1 0.673753 -0.181960  1 3 11 1 4 20 0 -1 13 1 2 10 0 2\n"
" 11 11 2 10 0 2 haar_x2_y2 -0.009790 0 -1 0.212646 0.036756  1 3 1 16 10 8 0 -1 1 16 5 4 0 2\n"
" 6 20 5 4 0 2 haar_x2_y2 -0.023047 0 -1 0.447422 -0.209867  1 3 11 1 4 20 0 -1 13 1 2 10 0 2\n"
" 11 11 2 10 0 2 haar_x2_y2 0.003117 0 -1 0.037544 0.278082  1 2 1 0 3 19 0 -1 2 0 1 19 0 3\n"
" haar_x3 0.013136 0 -1 -0.198424 0.543357  1 3 11 1 4 20 0 -1 13 1 2 10 0 2 11 11 2 10 0 2\n"
" haar_x2_y2 0.014782 0 -1 0.135306 -0.111536  1 2 0 1 6 9 0 -1 2 1 2 9 0 3 haar_x3\n"
" -0.060139 0 -1 0.840393 -0.167116  1 2 3 7 19 4 0 -1 3 9 19 2 0 2 haar_y2 0.051999 0 -1\n"
" 0.173720 -0.785476  1 2 7 14 9 6 0 -1 7 16 9 2 0 3 haar_y3 0.024792 0 -1 -0.177392 0.667526 \n"
" 1 2 17 1 7 6 0 -1 17 4 7 3 0 2 haar_y2 -0.012015 0 -1 -0.142637 0.160705  1 2 5 0 14 8 0 -1\n"
" 5 4 14 4 0 2 haar_y2 -0.098656 0 -1 1.042977 -0.157702  1 2 16 1 8 6 0 -1 16 4 8 3 0 2\n"
" haar_y2 0.117583 0 -1 0.109557 -4.492038  1 2 0 1 8 6 0 -1 0 4 8 3 0 2 haar_y2 -0.018923 0 -1\n"
" -0.785434 0.012984  1 3 6 0 18 4 0 -1 15 0 9 2 0 2 6 2 9 2 0 2 haar_x2_y2 -0.028391 0 -1\n"
" -0.605699 0.129035  1 2 0 14 9 6 0 -1 0 16 9 2 0 3 haar_y3 0.013183 0 -1 -0.014416 -0.732105 \n"
" 1 2 3 7 18 8 0 -1 9 7 6 8 0 3 haar_x3 -0.116530 0 -1 -2.044247 0.140531  1 2 2 11 6 9 0 -1\n"
" 4 11 2 9 0 3 haar_x3 -0.003888 0 -1 -0.418616 0.078705  1 2 10 5 6 9 0 -1 12 5 2 9 0 3\n"
" haar_x3 0.031229 0 -1 0.024633 0.418704  1 3 10 6 4 18 0 -1 10 6 2 9 0 2 12 15 2 9 0 2\n"
" haar_x2_y2 0.025199 0 -1 -0.175578 0.647106  1 3 11 1 4 20 0 -1 13 1 2 10 0 2 11 11 2 10 0 2\n"
" haar_x2_y2 -0.028124 0 -1 -0.220056 0.141210  1 3 9 1 4 20 0 -1 9 1 2 10 0 2 11 11 2 10 0 2\n"
" haar_x2_y2 0.036499 0 -1 -0.068427 -2.341085  1 3 5 9 18 6 0 -1 14 9 9 3 0 2 5 12 9 3 0 2\n"
" haar_x2_y2 -0.072293 0 -1 1.289875 0.084875  1 2 6 4 6 9 0 -1 8 4 2 9 0 3 haar_x3\n"
" -0.041671 0 -1 -1.163097 -0.053753  1 2 10 16 8 6 0 -1 10 16 4 6 0 2 haar_x2 0.047703 0 -1\n"
" 0.070101 0.736765  1 3 0 0 18 8 0 -1 0 0 9 4 0 2 9 4 9 4 0 2 haar_x2_y2 0.065793 0 -1\n"
" -0.177553 0.697805  1 3 6 5 14 12 0 -1 13 5 7 6 0 2 6 11 7 6 0 2 haar_x2_y2 0.013905 0 -1\n"
" 0.219368 -0.203908  1 2 4 3 15 7 0 -1 9 3 5 7 0 3 haar_x3 -0.027731 0 -1 0.618679 -0.178041 \n"
" 1 2 14 12 10 6 0 -1 14 14 10 2 0 3 haar_y3 -0.015880 0 -1 -0.464841 0.188286  1 2\n"
" 0 11 4 10 0 -1 0 16 4 5 0 2 haar_y2 0.074128 0 -1 -0.128581 3.279248  1 2 1 10 22 3 0 -1\n"
" 1 11 22 1 0 3 haar_y3 -0.000890 0 -1 -0.301176 0.238188  1 2 8 9 6 10 0 -1 10 9 2 10 0 3\n"
" haar_x3 0.017965 0 -1 -0.222850 0.299540  1 3 13 2 6 12 0 -1 16 2 3 6 0 2 13 8 3 6 0 2\n"
" haar_x2_y2 -0.002538 0 -1 0.250644 -0.136656  1 3 10 6 4 18 0 -1 10 6 2 9 0 2 12 15 2 9 0 2\n"
" haar_x2_y2 -0.009068 0 -1 0.290175 -0.289297  1 3 7 8 10 16 0 -1 12 8 5 8 0 2 7 16 5 8 0 2\n"
" haar_x2_y2 0.049170 0 -1 0.191564 -0.683287  1 3 8 1 8 12 0 -1 8 1 4 6 0 2 12 7 4 6 0 2\n"
" haar_x2_y2 -0.030681 0 -1 -0.756770 -0.013280  1 3 7 1 12 14 0 -1 13 1 6 7 0 2 7 8 6 7 0 2\n"
" haar_x2_y2 0.100174 0 -1 0.084454 1.088871  1 2 2 14 12 6 0 -1 2 16 12 2 0 3 haar_y3\n"
" 0.003195 0 -1 -0.269194 0.195379  1 2 11 16 6 6 0 -1 11 19 6 3 0 2 haar_y2 0.035503 0 -1\n"
" 0.136323 -0.569172  1 2 7 16 6 6 0 -1 7 19 6 3 0 2 haar_y2 0.000459 0 -1 -0.404440 0.140748 \n"
" 1 2 13 4 4 10 0 -1 13 4 2 10 0 2 haar_x2 0.025259 0 -1 0.162432 -0.557418  1 2 0 19 19 3 0 -1\n"
" 0 20 19 1 0 3 haar_y3 -0.005155 0 -1 0.311326 -0.227561  1 2 12 8 6 8 0 -1 12 12 6 4 0 2\n"
" haar_y2 0.001587 0 -1 -0.268677 0.195654  1 2 8 1 8 22 0 -1 8 12 8 11 0 2 haar_y2\n"
" -0.016205 0 -1 0.154865 -0.340578  1 2 12 8 6 8 0 -1 12 12 6 4 0 2 haar_y2 -0.029624 0 -1\n"
" 1.146680 0.090558  1 2 6 8 6 8 0 -1 6 12 6 4 0 2 haar_y2 -0.001593 0 -1 -0.712575 -0.000704 \n"
" 1 2 14 5 6 9 0 -1 14 8 6 3 0 3 haar_y3 -0.054019 0 -1 0.415375 0.027246  1 2 0 6 24 4 0 -1\n"
" 0 8 24 2 0 2 haar_y2 -0.066211 0 -1 -1.334009 -0.047353  1 2 14 12 10 6 0 -1 14 14 10 2 0 3\n"
" haar_y3 0.027941 0 -1 0.144463 -0.515184  1 2 0 12 10 6 0 -1 0 14 10 2 0 3 haar_y3\n"
" 0.028957 0 -1 -0.049966 -1.192904  1 2 4 6 19 3 0 -1 4 7 19 1 0 3 haar_y3 -0.020425 0 -1\n"
" 0.638813 0.038141  1 2 1 6 19 3 0 -1 1 7 19 1 0 3 haar_y3 0.012417 0 -1 -0.215470 0.494777 \n"
" -3.277298\n"
,

/* Stage 21 */
" 181 1 2 4 0 16 9 0 -1 4 3 16 3 0 3 haar_y3 0.043274 0 -1 -0.804944 0.398973  1 2\n"
" 0 1 24 5 0 -1 8 1 8 5 0 3 haar_x3 0.186155 0 -1 -0.316553 0.688773  1 2 3 6 6 15 0 -1\n"
" 3 11 6 5 0 3 haar_y3 0.031861 0 -1 -0.642662 0.255509  1 2 9 6 6 9 0 -1 11 6 2 9 0 3\n"
" haar_x3 0.014022 0 -1 -0.459266 0.311712  1 2 0 17 18 3 0 -1 0 18 18 1 0 3 haar_y3\n"
" -0.006303 0 -1 0.460269 -0.274385  1 2 6 22 18 2 0 -1 6 23 18 1 0 2 haar_y2 -0.005431 0 -1\n"
" 0.366086 -0.272058  1 2 2 12 6 9 0 -1 2 15 6 3 0 3 haar_y3 0.016823 0 -1 0.023477 -0.884438 \n"
" 1 2 18 12 6 9 0 -1 18 15 6 3 0 3 haar_y3 0.026039 0 -1 0.174888 -0.545647  1 2 0 12 6 9 0 -1\n"
" 0 15 6 3 0 3 haar_y3 -0.026720 0 -1 -0.963965 0.023525  1 2 11 14 4 10 0 -1 11 19 4 5 0 2\n"
" haar_y2 -0.017042 0 -1 -0.708488 0.214681  1 2 9 6 6 16 0 -1 9 14 6 8 0 2 haar_y2\n"
" 0.005957 0 -1 0.073601 -0.682256  1 2 7 7 10 10 0 -1 7 12 10 5 0 2 haar_y2 -0.002868 0 -1\n"
" -0.749350 0.238034  1 2 1 3 6 13 0 -1 3 3 2 13 0 3 haar_x3 -0.043775 0 -1 0.683233 -0.213803 \n"
" 1 2 18 1 6 13 0 -1 18 1 3 13 0 2 haar_x2 0.051633 0 -1 -0.125665 0.675238  1 2 5 1 6 9 0 -1\n"
" 7 1 2 9 0 3 haar_x3 0.008178 0 -1 0.070690 -0.806659  1 2 18 2 6 11 0 -1 18 2 3 11 0 2\n"
" haar_x2 -0.052842 0 -1 0.954339 0.016548  1 2 0 2 6 11 0 -1 3 2 3 11 0 2 haar_x2\n"
" 0.052584 0 -1 -0.284144 0.471298  1 2 9 12 15 6 0 -1 9 14 15 2 0 3 haar_y3 -0.012659 0 -1\n"
" 0.384454 -0.062288  1 2 2 2 20 3 0 -1 2 3 20 1 0 3 haar_y3 0.011694 0 -1 0.000056 -1.017314 \n"
" 1 2 10 6 4 9 0 -1 10 6 2 9 0 2 haar_x2 -0.023919 0 -1 0.849213 0.005740  1 3 5 6 12 14 0 -1\n"
" 5 6 6 7 0 2 11 13 6 7 0 2 haar_x2_y2 -0.061674 0 -1 -0.925714 -0.001768  1 2 9 0 6 9 0 -1\n"
" 11 0 2 9 0 3 haar_x3 -0.001828 0 -1 -0.543723 0.249324  1 2 7 0 9 6 0 -1 10 0 3 6 0 3\n"
" haar_x3 0.035258 0 -1 -0.007372 -0.939640  1 2 10 6 6 9 0 -1 12 6 2 9 0 3 haar_x3\n"
" -0.018438 0 -1 0.721367 0.010492  1 3 4 1 12 20 0 -1 4 1 6 10 0 2 10 11 6 10 0 2\n"
" haar_x2_y2 -0.038389 0 -1 0.192726 -0.358321  1 2 6 7 18 3 0 -1 6 7 9 3 0 2 haar_x2\n"
" 0.099721 0 -1 0.113542 -1.630419  1 2 0 7 18 3 0 -1 9 7 9 3 0 2 haar_x2 0.084462 0 -1\n"
" -0.053421 -1.698112  1 2 3 20 18 3 0 -1 9 20 6 3 0 3 haar_x3 0.040270 0 -1 -0.107832 0.519266 \n"
" 1 2 9 6 6 9 0 -1 11 6 2 9 0 3 haar_x3 0.058936 0 -1 -0.180537 0.951198  1 2 6 2 12 15 0 -1\n"
" 10 2 4 15 0 3 haar_x3 0.149570 0 -1 0.167853 -1.159187  1 2 2 3 18 3 0 -1 2 4 18 1 0 3\n"
" haar_y3 0.000694 0 -1 0.204914 -0.331182  1 3 19 4 4 18 0 -1 21 4 2 9 0 2 19 13 2 9 0 2\n"
" haar_x2_y2 -0.033369 0 -1 0.934681 -0.002964  1 2 0 1 19 3 0 -1 0 2 19 1 0 3 haar_y3\n"
" 0.009376 0 -1 0.003700 -0.775498  1 2 5 0 15 4 0 -1 5 2 15 2 0 2 haar_y2 0.043194 0 -1\n"
" -0.002204 0.745897  1 2 5 2 14 5 0 -1 12 2 7 5 0 2 haar_x2 -0.067555 0 -1 0.722921 -0.184042 \n"
" 1 2 1 2 22 14 0 -1 1 2 11 14 0 2 haar_x2 -0.311686 0 -1 1.001427 0.034003  1 2 8 15 6 9 0 -1\n"
" 10 15 2 9 0 3 haar_x3 0.029744 0 -1 -0.046356 -1.278181  1 2 6 17 18 3 0 -1 6 18 18 1 0 3\n"
" haar_y3 0.010737 0 -1 0.014812 0.666500  1 2 9 6 3 18 0 -1 9 12 3 6 0 3 haar_y3 -0.028841 0 -1\n"
" -0.942226 -0.020797  1 2 2 0 20 3 0 -1 2 1 20 1 0 3 haar_y3 -0.005765 0 -1 -0.435419 0.233860 \n"
" 1 2 5 4 5 12 0 -1 5 8 5 4 0 3 haar_y3 0.028411 0 -1 -0.176158 0.857653  1 2 8 6 12 5 0 -1\n"
" 12 6 4 5 0 3 haar_x3 -0.029008 0 -1 0.579781 0.028566  1 3 9 12 6 12 0 -1 9 12 3 6 0 2\n"
" 12 18 3 6 0 2 haar_x2_y2 0.024966 0 -1 -0.022729 -0.967731  1 3 14 14 8 10 0 -1 18 14 4 5 0 2\n"
" 14 19 4 5 0 2 haar_x2_y2 0.012036 0 -1 -0.142147 0.516880  1 3 2 14 8 10 0 -1 2 14 4 5 0 2\n"
" 6 19 4 5 0 2 haar_x2_y2 -0.042514 0 -1 0.972738 -0.181198  1 3 10 18 12 6 0 -1 16 18 6 3 0 2\n"
" 10 21 6 3 0 2 haar_x2_y2 0.010276 0 -1 -0.083100 0.317628  1 2 1 3 6 9 0 -1 1 6 6 3 0 3\n"
" haar_y3 -0.069192 0 -1 -2.066858 -0.060174  1 2 11 3 3 20 0 -1 12 3 1 20 0 3 haar_x3\n"
" -0.004677 0 -1 0.441318 0.023209  1 3 4 6 14 6 0 -1 4 6 7 3 0 2 11 9 7 3 0 2 haar_x2_y2\n"
" -0.013924 0 -1 0.286067 -0.291527  1 2 6 5 12 13 0 -1 10 5 4 13 0 3 haar_x3 -0.015334 0 -1\n"
" -0.574145 0.230633  1 2 5 4 4 15 0 -1 5 9 4 5 0 3 haar_y3 -0.010239 0 -1 0.344792 -0.260804 \n"
" 1 2 9 16 15 4 0 -1 14 16 5 4 0 3 haar_x3 -0.050989 0 -1 0.561541 0.061219  1 3 7 8 6 14 0 -1\n"
" 7 8 3 7 0 2 10 15 3 7 0 2 haar_x2_y2 0.030690 0 -1 -0.147728 1.637849  1 2 7 6 10 6 0 -1\n"
" 7 8 10 2 0 3 haar_y3 -0.011224 0 -1 0.240062 -0.448649  1 2 2 5 18 3 0 -1 2 6 18 1 0 3\n"
" haar_y3 -0.006290 0 -1 0.431195 -0.238090  1 2 5 1 15 8 0 -1 5 5 15 4 0 2 haar_y2\n"
" 0.078591 0 -1 0.019865 0.808538  1 2 7 1 8 18 0 -1 7 10 8 9 0 2 haar_y2 -0.010179 0 -1\n"
" 0.181932 -0.328778  1 2 0 10 24 3 0 -1 0 11 24 1 0 3 haar_y3 0.031227 0 -1 0.149739 -1.418034 \n"
" 1 2 0 2 6 13 0 -1 2 2 2 13 0 3 haar_x3 0.040197 0 -1 -0.197605 0.585082  1 3 16 0 8 10 0 -1\n"
" 20 0 4 5 0 2 16 5 4 5 0 2 haar_x2_y2 0.016138 0 -1 0.000500 0.390500  1 2 5 1 10 9 0 -1\n"
" 5 4 10 3 0 3 haar_y3 -0.045519 0 -1 1.264682 -0.156326  1 2 5 6 18 3 0 -1 5 7 18 1 0 3\n"
" haar_y3 -0.018130 0 -1 0.651485 0.010236  1 2 0 1 24 3 0 -1 0 2 24 1 0 3 haar_y3\n"
" -0.014002 0 -1 -1.034482 -0.032183  1 2 11 4 6 11 0 -1 13 4 2 11 0 3 haar_x3 -0.038816 0 -1\n"
" -0.478743 0.162907  1 3 0 0 8 10 0 -1 0 0 4 5 0 2 4 5 4 5 0 2 haar_x2_y2 0.031656 0 -1\n"
" -0.209834 0.545759  1 2 4 16 18 3 0 -1 4 17 18 1 0 3 haar_y3 -0.010840 0 -1 0.518988 -0.015080 \n"
" 1 2 2 16 18 3 0 -1 2 17 18 1 0 3 haar_y3 0.012033 0 -1 -0.211076 0.759370  1 3 3 0 18 10 0 -1\n"
" 12 0 9 5 0 2 3 5 9 5 0 2 haar_x2_y2 0.070773 0 -1 0.180488 -0.740485  1 2 2 3 20 21 0 -1\n"
" 12 3 10 21 0 2 haar_x2 0.531398 0 -1 -0.144917 1.536004  1 2 6 7 14 3 0 -1 6 7 7 3 0 2\n"
" haar_x2 -0.014774 0 -1 -0.281537 0.204073  1 3 0 9 12 6 0 -1 0 9 6 3 0 2 6 12 6 3 0 2\n"
" haar_x2_y2 -0.002241 0 -1 -0.448763 0.053989  1 2 3 14 21 4 0 -1 10 14 7 4 0 3 haar_x3\n"
" 0.049968 0 -1 0.041514 0.294171  1 2 0 14 21 4 0 -1 7 14 7 4 0 3 haar_x3 -0.047702 0 -1\n"
" 0.396743 -0.283018  1 2 5 21 18 3 0 -1 11 21 6 3 0 3 haar_x3 -0.091311 0 -1 2.199426 0.087965 \n"
" 1 2 1 21 18 3 0 -1 7 21 6 3 0 3 haar_x3 0.038070 0 -1 -0.280256 0.251562  1 3 19 4 4 18 0 -1\n"
" 21 4 2 9 0 2 19 13 2 9 0 2 haar_x2_y2 -0.015539 0 -1 0.341575 0.017925  1 2 3 7 18 3 0 -1\n"
" 3 8 18 1 0 3 haar_y3 -0.015446 0 -1 0.286802 -0.251359  1 3 19 4 4 18 0 -1 21 4 2 9 0 2\n"
" 19 13 2 9 0 2 haar_x2_y2 -0.057388 0 -1 0.638300 0.088598  1 2 7 15 10 6 0 -1 7 17 10 2 0 3\n"
" haar_y3 -0.005944 0 -1 0.079017 -0.407749  1 2 9 13 11 9 0 -1 9 16 11 3 0 3 haar_y3\n"
" -0.069969 0 -1 -0.446442 0.172196  1 2 0 6 4 10 0 -1 0 11 4 5 0 2 haar_y2 -0.025065 0 -1\n"
" -0.982702 -0.035388  1 2 15 16 9 6 0 -1 15 18 9 2 0 3 haar_y3 0.017216 0 -1 0.227059 -0.805501 \n"
" 1 3 1 5 4 18 0 -1 1 5 2 9 0 2 3 14 2 9 0 2 haar_x2_y2 -0.044279 0 -1 0.839520 -0.174296 \n"
" 1 3 9 8 8 10 0 -1 13 8 4 5 0 2 9 13 4 5 0 2 haar_x2_y2 0.043989 0 -1 0.115572 -1.966689 \n"
" 1 3 7 8 8 10 0 -1 7 8 4 5 0 2 11 13 4 5 0 2 haar_x2_y2 0.015907 0 -1 -0.037576 -1.031110 \n"
" 1 2 9 8 12 5 0 -1 13 8 4 5 0 3 haar_x3 -0.092755 0 -1 -1.353002 0.121413  1 2 7 8 9 7 0 -1\n"
" 10 8 3 7 0 3 haar_x3 0.071037 0 -1 -0.176843 0.744852  1 2 9 8 12 5 0 -1 13 8 4 5 0 3\n"
" haar_x3 0.057762 0 -1 0.128356 -0.444442  1 2 7 6 9 7 0 -1 10 6 3 7 0 3 haar_x3 -0.016432 0 -1\n"
" 0.801527 -0.174917  1 2 9 8 12 5 0 -1 13 8 4 5 0 3 haar_x3 0.023939 0 -1 0.161450 -0.123645 \n"
" 1 2 10 5 4 18 0 -1 10 11 4 6 0 3 haar_y3 0.012636 0 -1 0.154120 -0.332938  1 2 5 5 14 12 0 -1\n"
" 5 11 14 6 0 2 haar_y2 -0.054348 0 -1 -1.840070 0.148360  1 2 0 1 11 4 0 -1 0 3 11 2 0 2\n"
" haar_y2 -0.013262 0 -1 -0.808388 -0.027726  1 2 9 10 6 10 0 -1 11 10 2 10 0 3 haar_x3\n"
" 0.006134 0 -1 -0.137850 0.328585  1 2 2 17 11 6 0 -1 2 19 11 2 0 3 haar_y3 0.028991 0 -1\n"
" -0.025517 -0.833872  1 2 15 16 9 6 0 -1 15 18 9 2 0 3 haar_y3 -0.021986 0 -1 -0.737400 0.178871 \n"
" 1 2 1 10 18 2 0 -1 1 11 18 1 0 2 haar_y2 0.005327 0 -1 -0.454493 0.068791  1 2 6 4 12 13 0 -1\n"
" 10 4 4 13 0 3 haar_x3 0.086048 0 -1 0.210085 -0.378089  1 2 0 18 18 3 0 -1 0 19 18 1 0 3\n"
" haar_y3 -0.008555 0 -1 0.401350 -0.210741  1 2 6 18 18 3 0 -1 6 19 18 1 0 3 haar_y3\n"
" 0.006779 0 -1 -0.021649 0.454215  1 2 0 16 9 6 0 -1 0 18 9 2 0 3 haar_y3 -0.006396 0 -1\n"
" -0.498186 0.075908  1 2 13 15 9 6 0 -1 13 17 9 2 0 3 haar_y3 0.008947 0 -1 0.178577 -0.284549 \n"
" 1 2 2 15 9 6 0 -1 2 17 9 2 0 3 haar_y3 0.003259 0 -1 0.046625 -0.552063  1 2 13 1 6 16 0 -1\n"
" 13 1 3 16 0 2 haar_x2 0.041477 0 -1 0.175505 -0.207040  1 2 5 1 6 16 0 -1 8 1 3 16 0 2\n"
" haar_x2 -0.006745 0 -1 -0.463926 0.069304  1 2 11 5 6 10 0 -1 13 5 2 10 0 3 haar_x3\n"
" 0.030565 0 -1 0.051735 0.755505  1 2 7 5 6 10 0 -1 9 5 2 10 0 3 haar_x3 -0.007478 0 -1\n"
" 0.148939 -0.319068  1 2 10 0 6 24 0 -1 12 0 2 24 0 3 haar_x3 0.089089 0 -1 0.137388 -1.137971 \n"
" 1 3 3 4 4 20 0 -1 3 4 2 10 0 2 5 14 2 10 0 2 haar_x2_y2 0.007323 0 -1 -0.288292 0.190886 \n"
" 1 2 14 0 6 9 0 -1 16 0 2 9 0 3 haar_x3 -0.018205 0 -1 -0.301786 0.167958  1 2 4 0 6 9 0 -1\n"
" 6 0 2 9 0 3 haar_x3 -0.025828 0 -1 -0.981380 -0.019861  1 2 4 5 18 5 0 -1 10 5 6 5 0 3\n"
" haar_x3 0.109362 0 -1 0.048790 0.531183  1 2 5 6 6 9 0 -1 7 6 2 9 0 3 haar_x3 -0.011425 0 -1\n"
" 0.237060 -0.279253  1 2 7 2 15 8 0 -1 12 2 5 8 0 3 haar_x3 -0.057566 0 -1 0.472554 0.065171 \n"
" 1 2 2 2 15 8 0 -1 7 2 5 8 0 3 haar_x3 0.102783 0 -1 -0.207651 0.509477  1 2 10 0 4 9 0 -1\n"
" 10 0 2 9 0 2 haar_x2 0.027042 0 -1 0.164212 -1.450862  1 3 3 4 6 12 0 -1 3 4 3 6 0 2\n"
" 6 10 3 6 0 2 haar_x2_y2 -0.013635 0 -1 -0.565439 0.023789  1 2 16 0 8 18 0 -1 16 0 4 18 0 2\n"
" haar_x2 -0.321582 0 -1 -3.560283 0.118013  1 2 0 0 8 18 0 -1 4 0 4 18 0 2 haar_x2\n"
" 0.204581 0 -1 -0.037016 -1.022550  1 2 0 7 24 6 0 -1 0 9 24 2 0 3 haar_y3 -0.070347 0 -1\n"
" -0.564919 0.185252  1 2 4 7 14 3 0 -1 11 7 7 3 0 2 haar_x2 0.037831 0 -1 -0.029902 -0.829215 \n"
" 1 2 10 8 8 15 0 -1 10 8 4 15 0 2 haar_x2 -0.070298 0 -1 -0.531723 0.144302  1 2 7 0 10 14 0 -1\n"
" 12 0 5 14 0 2 haar_x2 0.063221 0 -1 -0.220412 0.479522  1 3 13 10 8 10 0 -1 17 10 4 5 0 2\n"
" 13 15 4 5 0 2 haar_x2_y2 0.036393 0 -1 0.142227 -0.611939  1 2 3 0 4 9 0 -1 5 0 2 9 0 2\n"
" haar_x2 0.004010 0 -1 -0.345608 0.117387  1 2 16 1 6 8 0 -1 16 1 3 8 0 2 haar_x2\n"
" -0.049106 0 -1 0.959841 0.064935  1 2 2 1 6 8 0 -1 5 1 3 8 0 2 haar_x2 -0.071583 0 -1\n"
" 1.738567 -0.142529  1 2 3 6 18 12 0 -1 3 10 18 4 0 3 haar_y3 -0.038009 0 -1 1.387282 0.066188 \n"
" 1 2 4 12 16 4 0 -1 4 14 16 2 0 2 haar_y2 -0.003157 0 -1 0.053677 -0.540480  1 2 4 9 16 15 0 -1\n"
" 4 14 16 5 0 3 haar_y3 0.019459 0 -1 -0.093620 0.391310  1 3 3 10 8 10 0 -1 3 10 4 5 0 2\n"
" 7 15 4 5 0 2 haar_x2_y2 0.011294 0 -1 0.037224 -0.542518  1 3 8 18 16 6 0 -1 16 18 8 3 0 2\n"
" 8 21 8 3 0 2 haar_x2_y2 -0.033495 0 -1 0.953079 0.037697  1 2 2 16 12 5 0 -1 6 16 4 5 0 3\n"
" haar_x3 0.092035 0 -1 -0.134884 2.289707  1 2 14 14 9 4 0 -1 14 16 9 2 0 2 haar_y2\n"
" 0.003753 0 -1 0.228242 -0.599837  1 2 7 14 9 6 0 -1 7 16 9 2 0 3 haar_y3 0.012848 0 -1\n"
" -0.220052 0.372219  1 2 4 10 16 12 0 -1 4 14 16 4 0 3 haar_y3 -0.143162 0 -1 1.285579 0.047237 \n"
" 1 2 0 13 19 6 0 -1 0 15 19 2 0 3 haar_y3 -0.096880 0 -1 -3.955093 -0.072904  1 2\n"
" 10 13 9 6 0 -1 10 15 9 2 0 3 haar_y3 -0.008846 0 -1 0.376750 -0.046484  1 2 5 0 3 23 0 -1\n"
" 6 0 1 23 0 3 haar_x3 0.015900 0 -1 -0.024457 -0.800348  1 2 0 8 24 6 0 -1 0 10 24 2 0 3\n"
" haar_y3 0.070372 0 -1 0.170190 -0.630690  1 2 0 5 5 12 0 -1 0 9 5 4 0 3 haar_y3 -0.037954 0 -1\n"
" -0.936672 -0.041214  1 2 3 0 19 18 0 -1 3 9 19 9 0 2 haar_y2 0.515979 0 -1 0.130806 -1.580229 \n"
" 1 3 9 11 6 12 0 -1 9 11 3 6 0 2 12 17 3 6 0 2 haar_x2_y2 -0.032843 0 -1 -1.144162 -0.049174 \n"
" 1 3 0 5 24 8 0 -1 12 5 12 4 0 2 0 9 12 4 0 2 haar_x2_y2 -0.036357 0 -1 0.496064 -0.034459 \n"
" 1 2 6 18 9 4 0 -1 6 20 9 2 0 2 haar_y2 0.006808 0 -1 -0.309978 0.170548  1 2 8 8 10 6 0 -1\n"
" 8 10 10 2 0 3 haar_y3 -0.016114 0 -1 -0.379046 0.160790  1 2 2 7 20 3 0 -1 2 8 20 1 0 3\n"
" haar_y3 0.008453 0 -1 -0.186555 0.563677  1 2 12 0 7 20 0 -1 12 10 7 10 0 2 haar_y2\n"
" -0.137524 0 -1 -0.589899 0.117495  1 2 5 0 7 20 0 -1 5 10 7 10 0 2 haar_y2 0.176880 0 -1\n"
" -0.154249 0.929111  1 2 14 2 2 18 0 -1 14 11 2 9 0 2 haar_y2 0.007931 0 -1 0.321907 -0.163926 \n"
" 1 2 5 8 10 12 0 -1 10 8 5 12 0 2 haar_x2 0.109718 0 -1 -0.158765 1.018626  1 3 6 9 12 8 0 -1\n"
" 12 9 6 4 0 2 6 13 6 4 0 2 haar_x2_y2 -0.030293 0 -1 0.755873 0.031795  1 2 7 7 3 14 0 -1\n"
" 7 14 3 7 0 2 haar_y2 -0.023118 0 -1 -0.884515 -0.009504  1 3 11 2 12 16 0 -1 17 2 6 8 0 2\n"
" 11 10 6 8 0 2 haar_x2_y2 -0.003090 0 -1 0.238383 -0.116062  1 2 7 0 6 9 0 -1 9 0 2 9 0 3\n"
" haar_x3 -0.033392 0 -1 -1.873814 -0.068503  1 2 13 14 9 4 0 -1 13 16 9 2 0 2 haar_y2\n"
" 0.013190 0 -1 0.129199 -0.675122  1 3 0 12 22 4 0 -1 0 12 11 2 0 2 11 14 11 2 0 2\n"
" haar_x2_y2 0.014661 0 -1 -0.024829 -0.743968  1 3 1 12 22 6 0 -1 12 12 11 3 0 2 1 15 11 3 0 2\n"
" haar_x2_y2 -0.013248 0 -1 0.468202 -0.024165  1 2 6 6 9 6 0 -1 9 6 3 6 0 3 haar_x3\n"
" -0.016219 0 -1 0.400838 -0.212557  1 2 10 0 4 9 0 -1 10 0 2 9 0 2 haar_x2 -0.029052 0 -1\n"
" -1.565002 0.143759  1 2 3 8 18 7 0 -1 9 8 6 7 0 3 haar_x3 -0.101532 0 -1 -1.922069 -0.069560 \n"
" 1 2 0 6 24 6 0 -1 0 8 24 2 0 3 haar_y3 0.037754 0 -1 0.133968 -2.263914  1 2 0 11 24 10 0 -1\n"
" 8 11 8 10 0 3 haar_x3 -0.285556 0 -1 1.021527 -0.152322  1 2 3 3 18 21 0 -1 9 3 6 21 0 3\n"
" haar_x3 0.153607 0 -1 -0.097409 0.416624  1 2 7 12 4 10 0 -1 9 12 2 10 0 2 haar_x2\n"
" -0.000212 0 -1 0.112719 -0.416540  1 3 10 16 10 8 0 -1 15 16 5 4 0 2 10 20 5 4 0 2\n"
" haar_x2_y2 -0.020598 0 -1 0.605405 0.062468  1 2 8 6 6 9 0 -1 10 6 2 9 0 3 haar_x3\n"
" 0.037354 0 -1 -0.189190 0.464647  1 3 12 10 6 12 0 -1 15 10 3 6 0 2 12 16 3 6 0 2\n"
" haar_x2_y2 0.057275 0 -1 0.115653 -1.321301  1 3 6 10 6 12 0 -1 6 10 3 6 0 2 9 16 3 6 0 2\n"
" haar_x2_y2 0.005103 0 -1 -0.280615 0.193134  1 3 16 12 6 12 0 -1 19 12 3 6 0 2 16 18 3 6 0 2\n"
" haar_x2_y2 -0.054645 0 -1 0.724285 0.075448  1 3 2 12 6 12 0 -1 2 12 3 6 0 2 5 18 3 6 0 2\n"
" haar_x2_y2 0.025349 0 -1 -0.194818 0.460328  1 2 10 15 6 9 0 -1 12 15 2 9 0 3 haar_x3\n"
" 0.024311 0 -1 0.155641 -0.499139  1 2 8 15 6 9 0 -1 10 15 2 9 0 3 haar_x3 0.035962 0 -1\n"
" -0.058573 -1.541840  1 2 14 20 10 4 0 -1 14 20 5 4 0 2 haar_x2 -0.100007 0 -1 -1.610004 0.114505 \n"
" 1 2 0 20 10 4 0 -1 5 20 5 4 0 2 haar_x2 0.084436 0 -1 -0.061407 -1.467335  1 2 11 17 9 6 0 -1\n"
" 11 19 9 2 0 3 haar_y3 0.015948 0 -1 0.162879 -0.110264  1 2 3 2 14 4 0 -1 3 4 14 2 0 2\n"
" haar_y2 0.033824 0 -1 -0.179327 0.572184  1 2 10 1 10 4 0 -1 10 3 10 2 0 2 haar_y2\n"
" -0.061996 0 -1 4.651181 0.094534  1 2 0 15 10 4 0 -1 5 15 5 4 0 2 haar_x2 0.069877 0 -1\n"
" -0.169859 0.870290  1 2 19 2 3 19 0 -1 20 2 1 19 0 3 haar_x3 -0.027917 0 -1 0.910425 0.056827 \n"
" 1 2 4 12 9 8 0 -1 7 12 3 8 0 3 haar_x3 -0.012764 0 -1 0.220667 -0.277691  -3.319641\n"
"\n"
,

/* Stage 22 */
" 199 1 2 4 7 5 12 0 -1 4 11 5 4 0 3 haar_y3 0.021662 0 -1 -0.898689 0.294363  1 2\n"
" 0 1 24 3 0 -1 8 1 8 3 0 3 haar_x3 0.100445 0 -1 -0.376592 0.608910  1 2 6 8 12 4 0 -1\n"
" 6 10 12 2 0 2 haar_y2 0.026004 0 -1 -0.381285 0.392174  1 2 19 3 4 10 0 -1 19 3 2 10 0 2\n"
" haar_x2 0.028441 0 -1 -0.181823 0.589272  1 2 0 6 9 6 0 -1 3 6 3 6 0 3 haar_x3 0.038612 0 -1\n"
" -0.223996 0.637800  1 2 18 0 6 22 0 -1 20 0 2 22 0 3 haar_x3 -0.046595 0 -1 0.708122 -0.146662 \n"
" 1 2 0 0 6 22 0 -1 2 0 2 22 0 3 haar_x3 -0.042792 0 -1 0.476804 -0.292332  1 2 5 15 19 3 0 -1\n"
" 5 16 19 1 0 3 haar_y3 0.003796 0 -1 -0.185103 0.526267  1 2 10 7 4 15 0 -1 10 12 4 5 0 3\n"
" haar_y3 0.042349 0 -1 0.039245 -0.891977  1 2 9 6 6 9 0 -1 11 6 2 9 0 3 haar_x3 0.019599 0 -1\n"
" -0.233584 0.441465  1 2 0 21 18 3 0 -1 0 22 18 1 0 3 haar_y3 0.000874 0 -1 -0.460636 0.176896 \n"
" 1 2 7 3 10 15 0 -1 7 8 10 5 0 3 haar_y3 -0.004363 0 -1 0.334932 -0.298934  1 2 1 7 18 3 0 -1\n"
" 1 8 18 1 0 3 haar_y3 0.016973 0 -1 -0.164087 1.599368  1 2 8 2 9 6 0 -1 11 2 3 6 0 3\n"
" haar_x3 0.036064 0 -1 0.226017 -0.531861  1 2 0 10 24 14 0 -1 0 17 24 7 0 2 haar_y2\n"
" -0.070865 0 -1 0.152205 -0.419146  1 3 13 9 8 10 0 -1 17 9 4 5 0 2 13 14 4 5 0 2\n"
" haar_x2_y2 -0.063076 0 -1 -1.487402 0.129537  1 2 10 5 4 9 0 -1 12 5 2 9 0 2 haar_x2\n"
" 0.029670 0 -1 -0.191459 0.981849  1 3 13 9 8 10 0 -1 17 9 4 5 0 2 13 14 4 5 0 2 haar_x2_y2\n"
" 0.037874 0 -1 0.134595 -0.563163  1 3 7 11 10 10 0 -1 7 11 5 5 0 2 12 16 5 5 0 2\n"
" haar_x2_y2 -0.033289 0 -1 -1.082803 -0.011504  1 3 4 13 18 4 0 -1 13 13 9 2 0 2 4 15 9 2 0 2\n"
" haar_x2_y2 -0.031609 0 -1 -0.592245 0.133948  1 2 0 0 19 2 0 -1 0 1 19 1 0 2 haar_y2\n"
" 0.001074 0 -1 -0.491858 0.094446  1 2 0 18 24 6 0 -1 8 18 8 6 0 3 haar_x3 -0.071556 0 -1\n"
" 0.597102 -0.039553  1 2 6 4 8 16 0 -1 6 12 8 8 0 2 haar_y2 -0.081170 0 -1 -1.181782 -0.028254 \n"
" 1 2 7 8 10 4 0 -1 7 10 10 2 0 2 haar_y2 0.004486 0 -1 -0.610281 0.226191  1 2 0 3 6 9 0 -1\n"
" 0 6 6 3 0 3 haar_y3 -0.042176 0 -1 -1.143562 -0.029002  1 2 13 15 7 9 0 -1 13 18 7 3 0 3\n"
" haar_y3 -0.065640 0 -1 -1.647028 0.128103  1 3 3 18 12 6 0 -1 3 18 6 3 0 2 9 21 6 3 0 2\n"
" haar_x2_y2 0.018189 0 -1 -0.311494 0.257396  1 2 12 14 6 9 0 -1 12 17 6 3 0 3 haar_y3\n"
" -0.051520 0 -1 -0.692069 0.152708  1 2 2 15 15 8 0 -1 2 19 15 4 0 2 haar_y2 -0.047151 0 -1\n"
" -0.718683 0.002688  1 2 9 6 6 16 0 -1 9 14 6 8 0 2 haar_y2 0.017489 0 -1 0.223712 -0.553818 \n"
" 1 2 6 6 7 12 0 -1 6 10 7 4 0 3 haar_y3 -0.025264 0 -1 1.031982 -0.174965  1 2 14 6 6 9 0 -1\n"
" 14 9 6 3 0 3 haar_y3 -0.040745 0 -1 0.449616 0.039349  1 2 5 14 6 9 0 -1 5 17 6 3 0 3\n"
" haar_y3 -0.037667 0 -1 -0.854757 -0.012464  1 2 10 8 6 9 0 -1 12 8 2 9 0 3 haar_x3\n"
" -0.013411 0 -1 0.578456 -0.017468  1 3 6 6 4 18 0 -1 6 6 2 9 0 2 8 15 2 9 0 2 haar_x2_y2\n"
" -0.000079 0 -1 -0.377492 0.139618  1 3 14 9 6 12 0 -1 17 9 3 6 0 2 14 15 3 6 0 2\n"
" haar_x2_y2 -0.011415 0 -1 -0.261866 0.237125  1 3 4 9 6 12 0 -1 4 9 3 6 0 2 7 15 3 6 0 2\n"
" haar_x2_y2 0.037200 0 -1 -0.028626 -1.294524  1 2 14 15 9 6 0 -1 14 17 9 2 0 3 haar_y3\n"
" 0.003405 0 -1 0.205314 -0.187475  1 3 0 20 18 4 0 -1 0 20 9 2 0 2 9 22 9 2 0 2 haar_x2_y2\n"
" -0.022483 0 -1 0.670272 -0.195940  1 2 13 18 9 6 0 -1 13 20 9 2 0 3 haar_y3 0.023275 0 -1\n"
" 0.174054 -0.327463  1 2 2 18 9 6 0 -1 2 20 9 2 0 3 haar_y3 -0.013917 0 -1 -0.839543 -0.006376 \n"
" 1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 0.007543 0 -1 -0.034195 0.589982  1 2 0 16 18 3 0 -1\n"
" 0 17 18 1 0 3 haar_y3 -0.011539 0 -1 0.421428 -0.235105  1 3 19 2 4 22 0 -1 21 2 2 11 0 2\n"
" 19 13 2 11 0 2 haar_x2_y2 0.052502 0 -1 0.069304 0.732265  1 3 1 2 4 22 0 -1 1 2 2 11 0 2\n"
" 3 13 2 11 0 2 haar_x2_y2 0.052716 0 -1 -0.156881 1.090729  1 2 15 0 2 24 0 -1 15 0 1 24 0 2\n"
" haar_x2 -0.011726 0 -1 -0.709343 0.168288  1 2 3 20 16 4 0 -1 11 20 8 4 0 2 haar_x2\n"
" 0.095946 0 -1 -0.161929 1.007252  1 3 11 6 4 18 0 -1 13 6 2 9 0 2 11 15 2 9 0 2 haar_x2_y2\n"
" -0.015872 0 -1 0.390084 -0.053777  1 3 7 9 10 14 0 -1 7 9 5 7 0 2 12 16 5 7 0 2 haar_x2_y2\n"
" 0.034818 0 -1 0.017180 -0.939418  1 2 14 6 6 9 0 -1 14 9 6 3 0 3 haar_y3 0.034792 0 -1\n"
" 0.050463 0.544657  1 2 3 6 7 9 0 -1 3 9 7 3 0 3 haar_y3 0.016284 0 -1 -0.269813 0.403653 \n"
" 1 3 20 4 4 20 0 -1 22 4 2 10 0 2 20 14 2 10 0 2 haar_x2_y2 -0.044319 0 -1 0.844000 0.032883 \n"
" 1 2 7 6 6 9 0 -1 7 9 6 3 0 3 haar_y3 -0.005569 0 -1 0.153094 -0.349598  1 3 7 0 10 14 0 -1\n"
" 12 0 5 7 0 2 7 7 5 7 0 2 haar_x2_y2 -0.065842 0 -1 -0.927112 0.168010  1 2 2 1 18 6 0 -1\n"
" 11 1 9 6 0 2 haar_x2 -0.073337 0 -1 0.516145 -0.202360  1 2 15 0 2 24 0 -1 15 0 1 24 0 2\n"
" haar_x2 0.016450 0 -1 0.139506 -0.493013  1 2 7 0 2 24 0 -1 8 0 1 24 0 2 haar_x2\n"
" -0.009263 0 -1 -0.901020 -0.016116  1 2 13 12 6 7 0 -1 13 12 3 7 0 2 haar_x2 0.005914 0 -1\n"
" 0.198582 -0.167313  1 2 5 12 6 7 0 -1 8 12 3 7 0 2 haar_x2 -0.000847 0 -1 0.094005 -0.415709 \n"
" 1 2 3 5 18 19 0 -1 9 5 6 19 0 3 haar_x3 0.205329 0 -1 -0.060022 0.709936  1 2 5 6 9 6 0 -1\n"
" 8 6 3 6 0 3 haar_x3 -0.016883 0 -1 0.243922 -0.305518  1 2 9 5 9 6 0 -1 12 5 3 6 0 3\n"
" haar_x3 -0.019111 0 -1 0.612299 0.024253  1 3 3 16 10 8 0 -1 3 16 5 4 0 2 8 20 5 4 0 2\n"
" haar_x2_y2 -0.025963 0 -1 0.907650 -0.167221  1 2 19 8 5 15 0 -1 19 13 5 5 0 3 haar_y3\n"
" -0.021762 0 -1 -0.313847 0.201346  1 2 0 8 5 15 0 -1 0 13 5 5 0 3 haar_y3 -0.024120 0 -1\n"
" -0.665884 0.007456  1 3 20 4 4 20 0 -1 22 4 2 10 0 2 20 14 2 10 0 2 haar_x2_y2 0.047130 0 -1\n"
" 0.059534 0.878045  1 3 0 4 4 20 0 -1 0 4 2 10 0 2 2 14 2 10 0 2 haar_x2_y2 -0.045985 0 -1\n"
" 0.800680 -0.172523  1 2 7 7 10 4 0 -1 7 7 5 4 0 2 haar_x2 0.026508 0 -1 0.187741 -0.608506 \n"
" 1 2 4 19 14 4 0 -1 11 19 7 4 0 2 haar_x2 -0.048615 0 -1 0.586441 -0.194277  1 2 10 11 12 3 0 -1\n"
" 10 11 6 3 0 2 haar_x2 -0.018562 0 -1 -0.255879 0.163262  1 2 0 1 24 3 0 -1 0 2 24 1 0 3\n"
" haar_y3 0.012678 0 -1 -0.014228 -0.767381  1 3 7 2 14 20 0 -1 14 2 7 10 0 2 7 12 7 10 0 2\n"
" haar_x2_y2 -0.001192 0 -1 0.204950 -0.114043  1 2 0 13 6 9 0 -1 2 13 2 9 0 3 haar_x3\n"
" -0.049089 0 -1 -1.074085 -0.038941  1 2 13 0 4 19 0 -1 13 0 2 19 0 2 haar_x2 -0.017437 0 -1\n"
" -0.579738 0.185845  1 2 1 11 14 3 0 -1 8 11 7 3 0 2 haar_x2 -0.014770 0 -1 -0.661503 0.005312 \n"
" 1 3 7 1 16 20 0 -1 15 1 8 10 0 2 7 11 8 10 0 2 haar_x2_y2 -0.229052 0 -1 -0.483051 0.123264 \n"
" 1 2 0 10 21 9 0 -1 7 10 7 9 0 3 haar_x3 -0.127071 0 -1 0.574526 -0.194204  1 2 6 19 15 5 0 -1\n"
" 11 19 5 5 0 3 haar_x3 0.010339 0 -1 -0.054642 0.245018  1 2 8 10 6 6 0 -1 11 10 3 6 0 2\n"
" haar_x2 0.006901 0 -1 0.121806 -0.387974  1 3 7 1 16 20 0 -1 15 1 8 10 0 2 7 11 8 10 0 2\n"
" haar_x2_y2 0.290254 0 -1 0.109662 -30.000000  1 3 1 1 16 20 0 -1 1 1 8 10 0 2 9 11 8 10 0 2\n"
" haar_x2_y2 -0.238050 0 -1 -1.735268 -0.063810  1 2 16 4 3 12 0 -1 16 10 3 6 0 2 haar_y2\n"
" 0.062481 0 -1 0.135230 -0.703011  1 2 5 4 3 12 0 -1 5 10 3 6 0 2 haar_y2 0.004711 0 -1\n"
" -0.469841 0.060342  1 3 7 6 10 8 0 -1 12 6 5 4 0 2 7 10 5 4 0 2 haar_x2_y2 -0.027816 0 -1\n"
" 0.698076 0.001372  1 2 4 9 6 6 0 -1 4 12 6 3 0 2 haar_y2 -0.017020 0 -1 1.687044 -0.143148 \n"
" 1 2 6 5 12 4 0 -1 6 7 12 2 0 2 haar_y2 -0.049755 0 -1 0.794977 0.000772  1 2 9 2 5 15 0 -1\n"
" 9 7 5 5 0 3 haar_y3 -0.074733 0 -1 -1.013236 -0.019389  1 2 15 0 9 6 0 -1 15 2 9 2 0 3\n"
" haar_y3 0.032009 0 -1 0.144121 -0.421391  1 2 6 0 11 10 0 -1 6 5 11 5 0 2 haar_y2\n"
" -0.094464 0 -1 0.506826 -0.204789  1 2 12 7 4 12 0 -1 12 13 4 6 0 2 haar_y2 -0.015427 0 -1\n"
" -0.158113 0.178069  1 2 7 2 9 4 0 -1 7 4 9 2 0 2 haar_y2 -0.004054 0 -1 -0.543667 0.031235 \n"
" 1 2 6 0 13 6 0 -1 6 2 13 2 0 3 haar_y3 0.003008 0 -1 -0.173768 0.304417  1 3 10 6 4 18 0 -1\n"
" 10 6 2 9 0 2 12 15 2 9 0 2 haar_x2_y2 -0.010092 0 -1 0.251038 -0.262241  1 2 10 8 6 9 0 -1\n"
" 12 8 2 9 0 3 haar_x3 -0.038818 0 -1 0.932267 0.072660  1 2 3 18 10 6 0 -1 3 20 10 2 0 3\n"
" haar_y3 0.034652 0 -1 -0.033935 -0.857079  1 2 4 14 20 3 0 -1 4 15 20 1 0 3 haar_y3\n"
" -0.004673 0 -1 0.349693 -0.048518  1 2 2 15 9 6 0 -1 2 17 9 2 0 3 haar_y3 0.000685 0 -1\n"
" 0.066573 -0.449738  1 2 13 0 4 19 0 -1 13 0 2 19 0 2 haar_x2 0.035317 0 -1 0.142758 -0.467264 \n"
" 1 2 7 0 4 19 0 -1 9 0 2 19 0 2 haar_x2 -0.023570 0 -1 -1.028608 -0.045288  1 2 1 4 22 2 0 -1\n"
" 1 5 22 1 0 2 haar_y2 -0.001911 0 -1 -0.196522 0.286610  1 2 0 0 9 6 0 -1 0 2 9 2 0 3\n"
" haar_y3 -0.016659 0 -1 -0.775322 -0.008328  1 2 0 0 24 18 0 -1 0 9 24 9 0 2 haar_y2\n"
" 0.660622 0 -1 0.132325 -3.526668  1 2 3 2 16 8 0 -1 3 6 16 4 0 2 haar_y2 0.109706 0 -1\n"
" -0.155472 1.467414  1 2 3 6 18 6 0 -1 3 8 18 2 0 3 haar_y3 0.013501 0 -1 0.152334 -1.302093 \n"
" 1 2 3 1 6 10 0 -1 5 1 2 10 0 3 haar_x3 -0.022872 0 -1 -0.713260 -0.008704  1 2 13 0 9 6 0 -1\n"
" 16 0 3 6 0 3 haar_x3 -0.081821 0 -1 1.112758 0.083220  1 2 2 0 9 6 0 -1 5 0 3 6 0 3\n"
" haar_x3 -0.052728 0 -1 0.931651 -0.171040  1 2 10 2 4 15 0 -1 10 7 4 5 0 3 haar_y3\n"
" -0.025242 0 -1 -0.197338 0.253594  1 2 6 0 7 10 0 -1 6 5 7 5 0 2 haar_y2 -0.043819 0 -1\n"
" 0.418152 -0.245855  1 3 2 2 20 4 0 -1 12 2 10 2 0 2 2 4 10 2 0 2 haar_x2_y2 -0.018189 0 -1\n"
" -0.517432 0.201742  1 2 2 11 19 3 0 -1 2 12 19 1 0 3 haar_y3 0.023466 0 -1 -0.043071 -1.063658 \n"
" 1 2 10 8 6 9 0 -1 12 8 2 9 0 3 haar_x3 0.034216 0 -1 0.053781 0.497072  1 2 8 8 6 9 0 -1\n"
" 10 8 2 9 0 3 haar_x3 0.025693 0 -1 -0.238001 0.416515  1 2 13 8 4 9 0 -1 13 8 2 9 0 2\n"
" haar_x2 -0.026565 0 -1 -0.885748 0.133659  1 2 3 11 9 9 0 -1 6 11 3 9 0 3 haar_x3\n"
" 0.060942 0 -1 -0.206697 0.583090  1 2 3 9 18 5 0 -1 9 9 6 5 0 3 haar_x3 0.144745 0 -1\n"
" 0.132823 -3.144935  1 2 2 4 2 20 0 -1 2 14 2 10 0 2 haar_y2 0.053411 0 -1 -0.173252 0.691907 \n"
" 1 2 14 17 8 6 0 -1 14 20 8 3 0 2 haar_y2 0.011408 0 -1 0.054822 0.302404  1 2 3 21 18 2 0 -1\n"
" 3 22 18 1 0 2 haar_y2 -0.002318 0 -1 0.158209 -0.319732  1 2 5 4 15 6 0 -1 10 4 5 6 0 3\n"
" haar_x3 -0.029695 0 -1 0.712748 0.058136  1 2 2 15 12 6 0 -1 2 17 12 2 0 3 haar_y3\n"
" 0.027250 0 -1 -0.157541 0.921438  1 2 17 8 6 9 0 -1 17 11 6 3 0 3 haar_y3 -0.003620 0 -1\n"
" -0.345484 0.202210  1 3 2 12 20 4 0 -1 2 12 10 2 0 2 12 14 10 2 0 2 haar_x2_y2 -0.012579 0 -1\n"
" -0.556503 0.020389  1 2 0 17 24 6 0 -1 0 19 24 2 0 3 haar_y3 -0.088849 0 -1 -3.610001 0.131642 \n"
" 1 2 7 16 9 4 0 -1 7 18 9 2 0 2 haar_y2 -0.019257 0 -1 0.519090 -0.192843  1 3 15 1 4 22 0 -1\n"
" 17 1 2 11 0 2 15 12 2 11 0 2 haar_x2_y2 -0.016667 0 -1 -0.087500 0.158125  1 3 5 1 4 22 0 -1\n"
" 5 1 2 11 0 2 7 12 2 11 0 2 haar_x2_y2 0.012932 0 -1 0.027406 -0.551239  1 2 11 13 8 9 0 -1\n"
" 11 16 8 3 0 3 haar_y3 -0.013432 0 -1 0.234578 -0.043235  1 2 6 1 6 9 0 -1 8 1 2 9 0 3\n"
" haar_x3 0.018810 0 -1 -0.039681 -0.943733  1 2 11 4 3 18 0 -1 11 10 3 6 0 3 haar_y3\n"
" -0.006435 0 -1 0.457037 -0.004052  1 3 5 8 12 6 0 -1 5 8 6 3 0 2 11 11 6 3 0 2 haar_x2_y2\n"
" -0.024249 0 -1 -0.762480 -0.019857  1 2 15 7 5 8 0 -1 15 11 5 4 0 2 haar_y2 -0.029668 0 -1\n"
" -3.741251 0.112506  1 2 4 7 5 8 0 -1 4 11 5 4 0 2 haar_y2 0.005115 0 -1 -0.637818 0.011224 \n"
" 1 3 12 6 6 12 0 -1 15 6 3 6 0 2 12 12 3 6 0 2 haar_x2_y2 -0.005782 0 -1 0.193744 -0.082042 \n"
" 1 3 6 6 6 12 0 -1 6 6 3 6 0 2 9 12 3 6 0 2 haar_x2_y2 0.016607 0 -1 -0.161921 1.133499 \n"
" 1 3 5 9 14 8 0 -1 12 9 7 4 0 2 5 13 7 4 0 2 haar_x2_y2 0.038228 0 -1 0.021105 0.762642 \n"
" 1 2 9 1 3 14 0 -1 9 8 3 7 0 2 haar_y2 -0.057094 0 -1 -1.697493 -0.059762  1 2 12 6 6 12 0 -1\n"
" 12 10 6 4 0 3 haar_y3 -0.053883 0 -1 1.185019 0.090967  1 3 4 5 4 18 0 -1 4 5 2 9 0 2\n"
" 6 14 2 9 0 2 haar_x2_y2 -0.002611 0 -1 -0.409412 0.083821  1 2 4 6 16 18 0 -1 4 12 16 6 0 3\n"
" haar_y3 0.297144 0 -1 0.155299 -1.099541  1 2 5 4 7 20 0 -1 5 14 7 10 0 2 haar_y2\n"
" -0.089063 0 -1 0.489472 -0.200412  1 2 14 8 8 12 0 -1 14 14 8 6 0 2 haar_y2 -0.056193 0 -1\n"
" -0.245814 0.143655  1 3 9 10 6 14 0 -1 9 10 3 7 0 2 12 17 3 7 0 2 haar_x2_y2 0.037005 0 -1\n"
" -0.048169 -1.231071  1 2 9 5 9 6 0 -1 12 5 3 6 0 3 haar_x3 -0.008484 0 -1 0.433726 0.013780 \n"
" 1 2 9 4 3 18 0 -1 10 4 1 18 0 3 haar_x3 -0.002438 0 -1 0.189497 -0.322942  1 3 1 4 22 14 0 -1\n"
" 12 4 11 7 0 2 1 11 11 7 0 2 haar_x2_y2 -0.071640 0 -1 -0.439790 0.227302  1 2 2 7 18 2 0 -1\n"
" 2 8 18 1 0 2 haar_y2 0.005226 0 -1 -0.205484 0.509333  1 2 12 6 6 12 0 -1 12 10 6 4 0 3\n"
" haar_y3 -0.006136 0 -1 0.311572 0.070681  1 2 6 5 9 7 0 -1 9 5 3 7 0 3 haar_x3 0.015595 0 -1\n"
" -0.309348 0.156277  1 2 12 7 4 12 0 -1 12 13 4 6 0 2 haar_y2 0.025996 0 -1 0.138216 -0.176166 \n"
" 1 2 8 7 4 12 0 -1 8 13 4 6 0 2 haar_y2 -0.012085 0 -1 -0.510702 0.058441  1 2 7 2 10 22 0 -1\n"
" 7 13 10 11 0 2 haar_y2 -0.067836 0 -1 0.477571 -0.071446  1 2 0 1 3 20 0 -1 1 1 1 20 0 3\n"
" haar_x3 -0.014715 0 -1 0.452389 -0.198614  1 3 4 13 18 4 0 -1 13 13 9 2 0 2 4 15 9 2 0 2\n"
" haar_x2_y2 0.025119 0 -1 0.129549 -0.862664  1 3 2 13 18 4 0 -1 2 13 9 2 0 2 11 15 9 2 0 2\n"
" haar_x2_y2 0.018826 0 -1 -0.041570 -1.135470  1 2 15 15 9 6 0 -1 15 17 9 2 0 3 haar_y3\n"
" -0.021264 0 -1 -0.347380 0.157795  1 2 0 15 9 6 0 -1 0 17 9 2 0 3 haar_y3 0.009461 0 -1\n"
" 0.004864 -0.616548  1 3 6 0 18 24 0 -1 15 0 9 12 0 2 6 12 9 12 0 2 haar_x2_y2 0.229577 0 -1\n"
" 0.081373 0.698414  1 2 6 6 6 12 0 -1 6 10 6 4 0 3 haar_y3 -0.038062 0 -1 1.161637 -0.149767 \n"
" 1 2 8 7 10 4 0 -1 8 9 10 2 0 2 haar_y2 -0.013485 0 -1 -0.320364 0.173651  1 3 1 9 18 6 0 -1\n"
" 1 9 9 3 0 2 10 12 9 3 0 2 haar_x2_y2 0.036239 0 -1 -0.181585 0.619567  1 2 6 6 18 3 0 -1\n"
" 6 7 18 1 0 3 haar_y3 0.006721 0 -1 0.000796 0.424414  1 2 7 7 9 8 0 -1 10 7 3 8 0 3\n"
" haar_x3 0.096526 0 -1 -0.146968 1.252568  1 2 10 12 6 12 0 -1 12 12 2 12 0 3 haar_x3\n"
" -0.035657 0 -1 -0.397817 0.141914  1 2 3 14 18 3 0 -1 3 15 18 1 0 3 haar_y3 0.010772 0 -1\n"
" -0.181940 0.597622  1 2 15 17 9 7 0 -1 18 17 3 7 0 3 haar_x3 0.079280 0 -1 0.146425 -0.788369 \n"
" 1 2 1 12 10 6 0 -1 1 14 10 2 0 3 haar_y3 0.032841 0 -1 -0.062408 -1.422749  1 2 15 17 9 7 0 -1\n"
" 18 17 3 7 0 3 haar_x3 -0.027781 0 -1 0.340331 0.030670  1 2 10 3 3 19 0 -1 11 3 1 19 0 3\n"
" haar_x3 -0.004034 0 -1 0.310847 -0.225957  1 2 15 17 9 7 0 -1 18 17 3 7 0 3 haar_x3\n"
" 0.007426 0 -1 -0.038937 0.317021  1 2 6 1 11 9 0 -1 6 4 11 3 0 3 haar_y3 0.112140 0 -1\n"
" -0.175783 0.650566  1 2 15 17 9 7 0 -1 18 17 3 7 0 3 haar_x3 -0.118781 0 -1 -1.009299 0.110697 \n"
" 1 2 6 5 11 6 0 -1 6 8 11 3 0 2 haar_y2 -0.041585 0 -1 -0.538064 0.019905  1 2 16 7 8 5 0 -1\n"
" 16 7 4 5 0 2 haar_x2 -0.027966 0 -1 0.481432 0.033591  1 2 2 4 20 19 0 -1 12 4 10 19 0 2\n"
" haar_x2 -0.125064 0 -1 0.263522 -0.257379  1 2 2 1 21 6 0 -1 9 1 7 6 0 3 haar_x3\n"
" 0.236669 0 -1 0.036508 0.906556  1 3 6 5 12 14 0 -1 6 5 6 7 0 2 12 12 6 7 0 2 haar_x2_y2\n"
" -0.029476 0 -1 -0.600488 0.009588  1 2 9 0 6 9 0 -1 11 0 2 9 0 3 haar_x3 0.037793 0 -1\n"
" 0.155062 -0.957335  1 2 2 11 8 5 0 -1 6 11 4 5 0 2 haar_x2 0.072044 0 -1 -0.145259 1.367673 \n"
" 1 2 16 7 8 5 0 -1 16 7 4 5 0 2 haar_x2 0.009776 0 -1 0.012916 0.216409  1 2 0 7 8 5 0 -1\n"
" 4 7 4 5 0 2 haar_x2 0.052154 0 -1 -0.016360 -0.883563  1 2 15 17 9 7 0 -1 18 17 3 7 0 3\n"
" haar_x3 -0.043791 0 -1 0.358296 0.065131  1 3 8 6 8 10 0 -1 8 6 4 5 0 2 12 11 4 5 0 2\n"
" haar_x2_y2 -0.038379 0 -1 1.196104 -0.149715  1 2 15 15 9 9 0 -1 18 15 3 9 0 3 haar_x3\n"
" -0.098839 0 -1 -0.618340 0.127862  1 2 0 15 9 9 0 -1 3 15 3 9 0 3 haar_x3 -0.121907 0 -1\n"
" -1.827612 -0.064863  1 2 12 10 9 7 0 -1 15 10 3 7 0 3 haar_x3 -0.119817 0 -1 -30.000000 0.113233 \n"
" 1 2 3 10 9 7 0 -1 6 10 3 7 0 3 haar_x3 0.030910 0 -1 -0.239340 0.363329  1 3 13 15 10 8 0 -1\n"
" 18 15 5 4 0 2 13 19 5 4 0 2 haar_x2_y2 0.010801 0 -1 -0.035140 0.277079  1 3 0 1 6 12 0 -1\n"
" 0 1 3 6 0 2 3 7 3 6 0 2 haar_x2_y2 0.056845 0 -1 -0.155243 1.080270  1 3 10 0 6 12 0 -1\n"
" 13 0 3 6 0 2 10 6 3 6 0 2 haar_x2_y2 0.001028 0 -1 -0.061203 0.205080  1 3 7 0 10 12 0 -1\n"
" 7 0 5 6 0 2 12 6 5 6 0 2 haar_x2_y2 -0.028274 0 -1 -0.647780 0.023917  1 2 4 1 16 8 0 -1\n"
" 4 1 8 8 0 2 haar_x2 -0.160136 0 -1 1.089205 0.058389  1 2 0 21 19 3 0 -1 0 22 19 1 0 3\n"
" haar_y3 0.004963 0 -1 -0.258063 0.208346  1 3 6 9 18 4 0 -1 15 9 9 2 0 2 6 11 9 2 0 2\n"
" haar_x2_y2 0.046937 0 -1 0.138863 -1.566262  1 2 3 4 9 6 0 -1 3 6 9 2 0 3 haar_y3\n"
" 0.024286 0 -1 -0.207283 0.524310  1 2 9 1 6 15 0 -1 9 6 6 5 0 3 haar_y3 0.070202 0 -1\n"
" 0.147969 -1.309509  1 2 5 9 6 6 0 -1 8 9 3 6 0 2 haar_x2 0.009812 0 -1 0.027906 -0.508646 \n"
" 1 2 5 1 14 9 0 -1 5 4 14 3 0 3 haar_y3 -0.056201 0 -1 1.261813 0.063802  1 3 3 0 8 20 0 -1\n"
" 3 0 4 10 0 2 7 10 4 10 0 2 haar_x2_y2 0.109828 0 -1 -0.128501 3.077617  -3.257332\n"
"\n"
,

/* Stage 23 */
" 211 1 2 5 0 7 9 0 -1 5 3 7 3 0 3 haar_y3 0.020910 0 -1 -0.685594 0.389843  1 2 6 6 12 5 0 -1\n"
" 10 6 4 5 0 3 haar_x3 0.035032 0 -1 -0.477244 0.450272  1 2 0 1 8 14 0 -1 4 1 4 14 0 2\n"
" haar_x2 0.039799 0 -1 -0.470111 0.427025  1 2 2 12 22 4 0 -1 2 14 22 2 0 2 haar_y2\n"
" -0.004841 0 -1 0.256143 -0.665563  1 2 8 17 6 6 0 -1 8 20 6 3 0 2 haar_y2 0.002344 0 -1\n"
" -0.480835 0.280138  1 2 18 1 6 7 0 -1 18 1 3 7 0 2 haar_x2 0.025313 0 -1 -0.239482 0.441918 \n"
" 1 2 0 0 6 6 0 -1 3 0 3 6 0 2 haar_x2 -0.032193 0 -1 0.760867 -0.250591  1 2 4 6 17 18 0 -1\n"
" 4 12 17 6 0 3 haar_y3 0.075409 0 -1 -0.349746 0.343803  1 3 6 0 12 6 0 -1 6 0 6 3 0 2\n"
" 12 3 6 3 0 2 haar_x2_y2 -0.018469 0 -1 -0.790856 0.034788  1 3 4 7 18 4 0 -1 13 7 9 2 0 2\n"
" 4 9 9 2 0 2 haar_x2_y2 -0.012802 0 -1 0.471078 -0.060006  1 2 4 12 10 6 0 -1 4 14 10 2 0 3\n"
" haar_y3 -0.026598 0 -1 0.671161 -0.242575  1 3 7 9 10 12 0 -1 12 9 5 6 0 2 7 15 5 6 0 2\n"
" haar_x2_y2 0.021989 0 -1 0.247175 -0.483017  1 2 0 1 24 3 0 -1 8 1 8 3 0 3 haar_x3\n"
" 0.146541 0 -1 -0.215041 0.720559  1 2 13 11 6 6 0 -1 13 11 3 6 0 2 haar_x2 0.003531 0 -1\n"
" 0.279310 -0.343399  1 2 5 11 6 6 0 -1 8 11 3 6 0 2 haar_x2 0.009401 0 -1 0.055862 -0.821436 \n"
" 1 2 3 10 19 3 0 -1 3 11 19 1 0 3 haar_y3 -0.008639 0 -1 -0.996206 0.188750  1 2 0 2 6 9 0 -1\n"
" 0 5 6 3 0 3 haar_y3 -0.039193 0 -1 -1.194556 -0.029198  1 2 14 16 10 6 0 -1 14 18 10 2 0 3\n"
" haar_y3 0.024855 0 -1 0.149876 -0.541378  1 2 0 16 10 6 0 -1 0 18 10 2 0 3 haar_y3\n"
" -0.034995 0 -1 -1.421018 -0.042314  1 2 14 13 9 6 0 -1 14 15 9 2 0 3 haar_y3 -0.018379 0 -1\n"
" -0.282426 0.155818  1 2 0 16 18 3 0 -1 0 17 18 1 0 3 haar_y3 -0.013592 0 -1 0.473171 -0.219372 \n"
" 1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 0.006263 0 -1 -0.059714 0.606259  1 2 0 18 9 6 0 -1\n"
" 0 20 9 2 0 3 haar_y3 -0.018478 0 -1 -0.856472 -0.013784  1 2 14 13 9 6 0 -1 14 15 9 2 0 3\n"
" haar_y3 0.014236 0 -1 0.166548 -0.277140  1 2 6 2 6 9 0 -1 8 2 2 9 0 3 haar_x3 -0.032547 0 -1\n"
" -1.172824 -0.040185  1 2 15 8 4 12 0 -1 15 8 2 12 0 2 haar_x2 -0.002641 0 -1 0.265143 -0.056343 \n"
" 1 2 8 13 8 8 0 -1 8 17 8 4 0 2 haar_y2 -0.000878 0 -1 0.036556 -0.550752  1 2 4 20 18 3 0 -1\n"
" 10 20 6 3 0 3 haar_x3 0.047372 0 -1 -0.042614 0.481949  1 2 5 8 4 12 0 -1 7 8 2 12 0 2\n"
" haar_x2 -0.007079 0 -1 0.286990 -0.329230  1 2 7 7 12 3 0 -1 7 7 6 3 0 2 haar_x2\n"
" -0.043146 0 -1 -1.406542 0.128364  1 2 10 6 4 9 0 -1 12 6 2 9 0 2 haar_x2 0.020592 0 -1\n"
" -0.214353 0.539818  1 2 5 20 18 3 0 -1 11 20 6 3 0 3 haar_x3 -0.022367 0 -1 0.337183 0.045212 \n"
" 1 2 1 20 18 3 0 -1 7 20 6 3 0 3 haar_x3 0.050040 0 -1 -0.251217 0.417505  1 3 18 1 6 20 0 -1\n"
" 21 1 3 10 0 2 18 11 3 10 0 2 haar_x2_y2 0.061795 0 -1 0.040085 0.687798  1 3 0 1 6 20 0 -1\n"
" 0 1 3 10 0 2 3 11 3 10 0 2 haar_x2_y2 -0.041862 0 -1 0.530274 -0.229020  1 3 13 3 4 18 0 -1\n"
" 15 3 2 9 0 2 13 12 2 9 0 2 haar_x2_y2 -0.003196 0 -1 0.251615 -0.215146  1 2 0 2 6 12 0 -1\n"
" 0 6 6 4 0 3 haar_y3 0.024255 0 -1 0.007232 -0.725191  1 3 12 9 12 6 0 -1 18 9 6 3 0 2\n"
" 12 12 6 3 0 2 haar_x2_y2 -0.017304 0 -1 -0.499582 0.183945  1 3 7 3 4 18 0 -1 7 3 2 9 0 2\n"
" 9 12 2 9 0 2 haar_x2_y2 -0.004147 0 -1 0.085212 -0.463647  1 2 14 0 6 9 0 -1 16 0 2 9 0 3\n"
" haar_x3 -0.014370 0 -1 -0.522589 0.238926  1 3 0 9 12 6 0 -1 0 9 6 3 0 2 6 12 6 3 0 2\n"
" haar_x2_y2 -0.009040 0 -1 -0.632504 0.032551  1 3 14 4 8 20 0 -1 18 4 4 10 0 2 14 14 4 10 0 2\n"
" haar_x2_y2 -0.123731 0 -1 1.285621 0.076545  1 3 2 4 8 20 0 -1 2 4 4 10 0 2 6 14 4 10 0 2\n"
" haar_x2_y2 -0.082222 0 -1 0.832082 -0.185906  1 2 14 13 9 6 0 -1 14 15 9 2 0 3 haar_y3\n"
" 0.065659 0 -1 0.112988 -30.000000  1 2 1 13 9 6 0 -1 1 15 9 2 0 3 haar_y3 -0.031583 0 -1\n"
" -1.348590 -0.047097  1 2 3 15 18 3 0 -1 9 15 6 3 0 3 haar_x3 -0.079636 0 -1 -1.353364 0.156688 \n"
" 1 2 5 13 9 6 0 -1 5 15 9 2 0 3 haar_y3 -0.018880 0 -1 0.403003 -0.251489  1 2 5 0 18 3 0 -1\n"
" 5 1 18 1 0 3 haar_y3 -0.005015 0 -1 -0.262871 0.185825  1 2 8 2 6 7 0 -1 11 2 3 7 0 2\n"
" haar_x2 -0.012218 0 -1 0.586924 -0.194277  1 2 9 1 9 6 0 -1 12 1 3 6 0 3 haar_x3\n"
" 0.001271 0 -1 -0.166890 0.230069  1 2 6 1 9 6 0 -1 9 1 3 6 0 3 haar_x3 0.029744 0 -1\n"
" 0.012520 -0.667236  1 3 5 6 14 6 0 -1 12 6 7 3 0 2 5 9 7 3 0 2 haar_x2_y2 0.028175 0 -1\n"
" -0.017060 0.645794  1 2 8 2 6 13 0 -1 10 2 2 13 0 3 haar_x3 0.030345 0 -1 -0.241787 0.348789 \n"
" 1 3 6 11 12 6 0 -1 12 11 6 3 0 2 6 14 6 3 0 2 haar_x2_y2 -0.017326 0 -1 -0.535994 0.209960 \n"
" 1 2 3 1 18 15 0 -1 9 1 6 15 0 3 haar_x3 -0.084178 0 -1 0.750933 -0.175932  1 2 13 0 6 7 0 -1\n"
" 13 0 3 7 0 2 haar_x2 0.007495 0 -1 -0.161881 0.306575  1 2 3 3 16 6 0 -1 3 6 16 3 0 2\n"
" haar_y2 0.056495 0 -1 -0.173188 1.001615  1 2 12 1 3 12 0 -1 12 7 3 6 0 2 haar_y2\n"
" -0.005294 0 -1 0.234176 -0.065347  1 2 7 7 6 9 0 -1 9 7 2 9 0 3 haar_x3 -0.014945 0 -1\n"
" 0.250189 -0.305912  1 2 13 0 4 24 0 -1 13 0 2 24 0 2 haar_x2 0.054919 0 -1 0.131220 -0.937651 \n"
" 1 2 7 0 4 24 0 -1 9 0 2 24 0 2 haar_x2 -0.019722 0 -1 -0.839785 -0.023473  1 2 11 9 5 12 0 -1\n"
" 11 13 5 4 0 3 haar_y3 -0.067159 0 -1 2.358684 0.082971  1 2 7 15 9 6 0 -1 7 17 9 2 0 3\n"
" haar_y3 -0.014326 0 -1 0.188145 -0.312216  1 2 5 7 18 6 0 -1 5 9 18 2 0 3 haar_y3\n"
" 0.029841 0 -1 0.148251 -0.846817  1 2 8 9 5 12 0 -1 8 13 5 4 0 3 haar_y3 0.051883 0 -1\n"
" -0.043731 -1.336617  1 2 4 17 17 6 0 -1 4 19 17 2 0 3 haar_y3 0.041127 0 -1 0.176601 -0.609041 \n"
" 1 3 0 3 18 14 0 -1 0 3 9 7 0 2 9 10 9 7 0 2 haar_x2_y2 -0.128651 0 -1 -0.987010 -0.037785 \n"
" 1 2 0 1 24 2 0 -1 0 2 24 1 0 2 haar_y2 0.002417 0 -1 -0.161196 0.326757  1 2 0 15 18 3 0 -1\n"
" 0 16 18 1 0 3 haar_y3 0.007703 0 -1 -0.238415 0.293194  1 2 9 0 6 9 0 -1 11 0 2 9 0 3\n"
" haar_x3 0.045520 0 -1 0.144246 -1.501016  1 2 3 3 14 12 0 -1 3 9 14 6 0 2 haar_y2\n"
" -0.078701 0 -1 -1.039456 -0.045376  1 2 12 1 3 12 0 -1 12 7 3 6 0 2 haar_y2 0.007862 0 -1\n"
" 0.196336 -0.144724  1 2 8 0 6 9 0 -1 10 0 2 9 0 3 haar_x3 -0.013459 0 -1 -0.906347 -0.038049 \n"
" 1 2 10 6 6 10 0 -1 12 6 2 10 0 3 haar_x3 0.028827 0 -1 -0.029474 0.600584  1 2 5 0 6 9 0 -1\n"
" 7 0 2 9 0 3 haar_x3 -0.027366 0 -1 -0.998040 -0.038653  1 2 2 0 21 7 0 -1 9 0 7 7 0 3\n"
" haar_x3 -0.072918 0 -1 0.733615 0.057440  1 2 6 11 12 5 0 -1 10 11 4 5 0 3 haar_x3\n"
" -0.013989 0 -1 0.278926 -0.265163  1 2 8 7 9 8 0 -1 11 7 3 8 0 3 haar_x3 0.043243 0 -1\n"
" 0.004776 0.359259  1 3 9 6 6 18 0 -1 9 6 3 9 0 2 12 15 3 9 0 2 haar_x2_y2 0.029533 0 -1\n"
" -0.200840 0.512029  1 3 15 14 8 10 0 -1 19 14 4 5 0 2 15 19 4 5 0 2 haar_x2_y2 -0.031897 0 -1\n"
" 0.647217 -0.001376  1 3 1 14 8 10 0 -1 1 14 4 5 0 2 5 19 4 5 0 2 haar_x2_y2 0.037869 0 -1\n"
" -0.183638 0.613431  1 3 11 0 8 10 0 -1 15 0 4 5 0 2 11 5 4 5 0 2 haar_x2_y2 -0.022418 0 -1\n"
" -0.291879 0.181948  1 3 5 0 8 10 0 -1 5 0 4 5 0 2 9 5 4 5 0 2 haar_x2_y2 0.058959 0 -1\n"
" -0.066452 -1.929003  1 2 6 1 12 5 0 -1 6 1 6 5 0 2 haar_x2 0.031223 0 -1 -0.012732 0.615608 \n"
" 1 2 1 12 18 2 0 -1 10 12 9 2 0 2 haar_x2 0.037485 0 -1 -0.208569 0.443640  1 3 2 8 20 6 0 -1\n"
" 12 8 10 3 0 2 2 11 10 3 0 2 haar_x2_y2 -0.020966 0 -1 -0.357128 0.242522  1 2 7 6 9 7 0 -1\n"
" 10 6 3 7 0 3 haar_x3 -0.025478 0 -1 1.084656 -0.150544  1 3 10 5 8 16 0 -1 14 5 4 8 0 2\n"
" 10 13 4 8 0 2 haar_x2_y2 -0.007257 0 -1 0.213026 -0.183082  1 3 3 9 16 8 0 -1 3 9 8 4 0 2\n"
" 11 13 8 4 0 2 haar_x2_y2 -0.050983 0 -1 0.517368 -0.188331  1 2 7 8 10 4 0 -1 7 8 5 4 0 2\n"
" haar_x2 -0.020640 0 -1 -0.440302 0.227460  1 3 7 12 10 8 0 -1 7 12 5 4 0 2 12 16 5 4 0 2\n"
" haar_x2_y2 0.010673 0 -1 0.035060 -0.516650  1 2 9 19 15 4 0 -1 14 19 5 4 0 3 haar_x3\n"
" 0.031896 0 -1 0.013228 0.349152  1 2 1 0 18 9 0 -1 7 0 6 9 0 3 haar_x3 -0.023825 0 -1\n"
" 0.341188 -0.215102  1 3 13 4 10 8 0 -1 18 4 5 4 0 2 13 8 5 4 0 2 haar_x2_y2 -0.006068 0 -1\n"
" 0.329374 -0.285238  1 2 3 16 18 4 0 -1 9 16 6 4 0 3 haar_x3 0.023882 0 -1 -0.253338 0.262961 \n"
" 1 3 8 7 10 12 0 -1 13 7 5 6 0 2 8 13 5 6 0 2 haar_x2_y2 0.027966 0 -1 0.140491 -0.498871 \n"
" 1 3 6 7 10 12 0 -1 6 7 5 6 0 2 11 13 5 6 0 2 haar_x2_y2 0.014603 0 -1 -0.015396 -0.769580 \n"
" 1 2 4 6 18 7 0 -1 10 6 6 7 0 3 haar_x3 0.108724 0 -1 0.190696 -0.323931  1 2 0 17 18 3 0 -1\n"
" 0 18 18 1 0 3 haar_y3 -0.014038 0 -1 0.349247 -0.223587  1 2 3 17 18 3 0 -1 3 18 18 1 0 3\n"
" haar_y3 0.004044 0 -1 -0.038329 0.511773  1 2 2 4 6 10 0 -1 4 4 2 10 0 3 haar_x3\n"
" -0.004977 0 -1 -0.428883 0.049174  1 2 16 0 8 24 0 -1 16 0 4 24 0 2 haar_x2 -0.085183 0 -1\n"
" 0.666246 0.007808  1 2 4 0 8 15 0 -1 8 0 4 15 0 2 haar_x2 0.002156 0 -1 -0.491352 0.069556 \n"
" 1 2 16 0 8 24 0 -1 16 0 4 24 0 2 haar_x2 0.363845 0 -1 0.129971 -1.894951  1 2 1 4 18 9 0 -1\n"
" 7 4 6 9 0 3 haar_x3 0.220825 0 -1 -0.057212 -1.428112  1 2 15 12 9 6 0 -1 15 14 9 2 0 3\n"
" haar_y3 -0.016140 0 -1 -0.575894 0.180625  1 3 3 9 18 6 0 -1 3 9 9 3 0 2 12 12 9 3 0 2\n"
" haar_x2_y2 -0.048330 0 -1 0.973085 -0.165130  1 2 18 5 6 9 0 -1 18 8 6 3 0 3 haar_y3\n"
" 0.017530 0 -1 0.179327 -0.279489  1 2 0 5 6 9 0 -1 0 8 6 3 0 3 haar_y3 -0.034310 0 -1\n"
" -0.810725 -0.016596  1 3 4 7 18 4 0 -1 13 7 9 2 0 2 4 9 9 2 0 2 haar_x2_y2 -0.004583 0 -1\n"
" 0.279090 -0.007452  1 3 2 1 12 20 0 -1 2 1 6 10 0 2 8 11 6 10 0 2 haar_x2_y2 0.128964 0 -1\n"
" -0.135085 2.541154  1 2 17 0 6 23 0 -1 17 0 3 23 0 2 haar_x2 0.030361 0 -1 -0.068419 0.287341 \n"
" 1 2 1 6 2 18 0 -1 1 15 2 9 0 2 haar_y2 0.044086 0 -1 -0.181359 0.654132  1 2 8 8 10 6 0 -1\n"
" 8 10 10 2 0 3 haar_y3 0.003016 0 -1 -0.156905 0.269638  1 3 0 6 20 6 0 -1 0 6 10 3 0 2\n"
" 10 9 10 3 0 2 haar_x2_y2 -0.026337 0 -1 0.291756 -0.252741  1 2 11 12 12 5 0 -1 15 12 4 5 0 3\n"
" haar_x3 -0.027866 0 -1 0.443875 0.055038  1 2 0 4 3 19 0 -1 1 4 1 19 0 3 haar_x3\n"
" 0.011725 0 -1 -0.193465 0.466567  1 2 19 1 3 18 0 -1 20 1 1 18 0 3 haar_x3 0.001569 0 -1\n"
" -0.008236 0.257009  1 2 2 1 3 18 0 -1 3 1 1 18 0 3 haar_x3 -0.003555 0 -1 -0.424309 0.071174 \n"
" 1 2 3 10 18 3 0 -1 9 10 6 3 0 3 haar_x3 -0.031695 0 -1 -0.853935 0.169162  1 2 4 4 10 9 0 -1\n"
" 9 4 5 9 0 2 haar_x2 -0.032097 0 -1 0.837849 -0.175973  1 2 7 13 14 7 0 -1 7 13 7 7 0 2\n"
" haar_x2 0.155442 0 -1 0.099550 2.387330  1 2 3 13 14 7 0 -1 10 13 7 7 0 2 haar_x2\n"
" 0.088046 0 -1 -0.187253 0.623843  1 2 8 15 9 6 0 -1 11 15 3 6 0 3 haar_x3 -0.001672 0 -1\n"
" 0.250087 -0.065119  1 3 4 14 8 10 0 -1 4 14 4 5 0 2 8 19 4 5 0 2 haar_x2_y2 0.009341 0 -1\n"
" -0.353789 0.107150  1 2 10 14 4 10 0 -1 10 19 4 5 0 2 haar_y2 0.037138 0 -1 0.163870 -0.917184 \n"
" 1 2 3 8 5 16 0 -1 3 16 5 8 0 2 haar_y2 0.080184 0 -1 -0.148130 1.489519  1 2 15 10 9 6 0 -1\n"
" 15 12 9 2 0 3 haar_y3 -0.000791 0 -1 -0.213269 0.196764  1 2 0 10 9 6 0 -1 0 12 9 2 0 3\n"
" haar_y3 -0.005040 0 -1 -0.713187 0.001824  1 2 6 7 12 9 0 -1 6 10 12 3 0 3 haar_y3\n"
" 0.119624 0 -1 0.033099 1.044171  1 2 9 10 5 8 0 -1 9 14 5 4 0 2 haar_y2 -0.004528 0 -1\n"
" -0.273085 0.272298  1 2 12 1 3 12 0 -1 12 7 3 6 0 2 haar_y2 -0.029639 0 -1 0.362258 0.056795 \n"
" 1 2 8 15 6 9 0 -1 10 15 2 9 0 3 haar_x3 0.026650 0 -1 -0.048041 -0.967235  1 2 16 6 7 6 0 -1\n"
" 16 9 7 3 0 2 haar_y2 0.044422 0 -1 0.130529 -0.350773  1 2 8 1 4 22 0 -1 10 1 2 22 0 2\n"
" haar_x2 -0.024360 0 -1 -1.076690 -0.051223  1 2 6 6 14 3 0 -1 6 6 7 3 0 2 haar_x2\n"
" 0.019735 0 -1 0.026238 0.280705  1 2 0 18 19 3 0 -1 0 19 19 1 0 3 haar_y3 0.005493 0 -1\n"
" -0.261113 0.210114  1 2 17 0 6 24 0 -1 17 0 3 24 0 2 haar_x2 -0.232003 0 -1 -1.774844 0.114826 \n"
" 1 2 0 13 15 6 0 -1 5 13 5 6 0 3 haar_x3 -0.025614 0 -1 0.299008 -0.225025  1 3 9 6 10 14 0 -1\n"
" 14 6 5 7 0 2 9 13 5 7 0 2 haar_x2_y2 -0.006495 0 -1 0.195638 -0.099763  1 3 1 6 8 10 0 -1\n"
" 1 6 4 5 0 2 5 11 4 5 0 2 haar_x2_y2 0.003984 0 -1 -0.430215 0.081261  1 2 7 6 12 5 0 -1\n"
" 7 6 6 5 0 2 haar_x2 -0.035813 0 -1 -0.509874 0.163459  1 2 7 7 9 6 0 -1 10 7 3 6 0 3\n"
" haar_x3 -0.014169 0 -1 0.779781 -0.174763  1 3 7 8 14 14 0 -1 14 8 7 7 0 2 7 15 7 7 0 2\n"
" haar_x2_y2 -0.126421 0 -1 -0.630479 0.127283  1 3 3 8 14 14 0 -1 3 8 7 7 0 2 10 15 7 7 0 2\n"
" haar_x2_y2 0.068678 0 -1 -0.046448 -1.112898  1 2 9 8 13 4 0 -1 9 10 13 2 0 2 haar_y2\n"
" 0.085865 0 -1 0.118354 -4.823516  1 3 3 2 6 12 0 -1 3 2 3 6 0 2 6 8 3 6 0 2 haar_x2_y2\n"
" 0.015512 0 -1 -0.017468 -0.636934  1 2 6 10 17 6 0 -1 6 13 17 3 0 2 haar_y2 0.081091 0 -1\n"
" 0.086133 2.455943  1 2 1 10 17 6 0 -1 1 13 17 3 0 2 haar_y2 0.018495 0 -1 0.040229 -0.508582 \n"
" 1 2 16 7 8 9 0 -1 16 10 8 3 0 3 haar_y3 -0.086321 0 -1 -1.900676 0.110191  1 2 0 7 8 9 0 -1\n"
" 0 10 8 3 0 3 haar_y3 0.072355 0 -1 -0.062112 -1.416518  1 3 0 9 24 10 0 -1 12 9 12 5 0 2\n"
" 0 14 12 5 0 2 haar_x2_y2 -0.078179 0 -1 0.888493 0.042370  1 2 3 2 15 8 0 -1 8 2 5 8 0 3\n"
" haar_x3 0.096682 0 -1 -0.220942 0.335751  1 2 4 2 18 8 0 -1 10 2 6 8 0 3 haar_x3\n"
" -0.039876 0 -1 0.578048 0.045348  1 3 0 1 18 4 0 -1 0 1 9 2 0 2 9 3 9 2 0 2 haar_x2_y2\n"
" -0.009535 0 -1 -0.541757 0.003240  1 2 20 2 3 18 0 -1 21 2 1 18 0 3 haar_x3 0.000406 0 -1\n"
" -0.081549 0.358379  1 2 1 3 3 19 0 -1 2 3 1 19 0 3 haar_x3 0.012108 0 -1 -0.202804 0.437680 \n"
" 1 2 18 8 6 16 0 -1 20 8 2 16 0 3 haar_x3 -0.020874 0 -1 0.414699 -0.045568  1 2 0 8 6 16 0 -1\n"
" 2 8 2 16 0 3 haar_x3 0.057888 0 -1 -0.029010 -0.918223  1 2 8 18 11 6 0 -1 8 20 11 2 0 3\n"
" haar_y3 0.000132 0 -1 -0.117724 0.200000  1 2 4 6 12 5 0 -1 8 6 4 5 0 3 haar_x3 -0.017137 0 -1\n"
" 0.330048 -0.230552  1 2 7 6 12 5 0 -1 11 6 4 5 0 3 haar_x3 0.030655 0 -1 -0.021545 0.268782 \n"
" 1 2 6 3 9 6 0 -1 9 3 3 6 0 3 haar_x3 -0.000787 0 -1 -0.441007 0.049158  1 2 7 6 12 5 0 -1\n"
" 7 6 6 5 0 2 haar_x2 0.088037 0 -1 0.117820 -2.829331  1 2 9 8 6 7 0 -1 12 8 3 7 0 2\n"
" haar_x2 -0.039029 0 -1 0.917772 -0.158274  1 2 8 2 9 6 0 -1 11 2 3 6 0 3 haar_x3\n"
" 0.080106 0 -1 0.112892 -1.993728  1 2 8 14 6 9 0 -1 8 17 6 3 0 3 haar_y3 0.039539 0 -1\n"
" -0.143574 1.308524  1 2 8 2 9 6 0 -1 11 2 3 6 0 3 haar_x3 0.020684 0 -1 0.200481 -0.044187 \n"
" 1 3 4 3 16 20 0 -1 4 3 8 10 0 2 12 13 8 10 0 2 haar_x2_y2 -0.067038 0 -1 0.326186 -0.205504 \n"
" 1 3 7 6 10 12 0 -1 12 6 5 6 0 2 7 12 5 6 0 2 haar_x2_y2 0.046815 0 -1 0.158253 -0.955351 \n"
" 1 2 0 2 7 12 0 -1 0 6 7 4 0 3 haar_y3 0.078444 0 -1 -0.074651 -2.116150  1 2 12 17 11 6 0 -1\n"
" 12 19 11 2 0 3 haar_y3 0.066380 0 -1 0.116419 -1.611352  1 3 4 7 12 8 0 -1 4 7 6 4 0 2\n"
" 10 11 6 4 0 2 haar_x2_y2 0.030054 0 -1 -0.165626 0.700254  1 3 8 11 8 10 0 -1 12 11 4 5 0 2\n"
" 8 16 4 5 0 2 haar_x2_y2 0.017120 0 -1 0.226277 -0.401150  1 2 9 1 4 9 0 -1 11 1 2 9 0 2\n"
" haar_x2 0.020073 0 -1 -0.193897 0.444203  1 2 14 0 3 22 0 -1 15 0 1 22 0 3 haar_x3\n"
" 0.033102 0 -1 0.116375 -1.577168  1 2 7 0 3 22 0 -1 8 0 1 22 0 3 haar_x3 -0.014882 0 -1\n"
" -0.896803 -0.042010  1 3 4 7 18 4 0 -1 13 7 9 2 0 2 4 9 9 2 0 2 haar_x2_y2 -0.010281 0 -1\n"
" 0.356030 -0.013124  1 2 10 2 4 15 0 -1 10 7 4 5 0 3 haar_y3 -0.028695 0 -1 -0.460396 0.026802 \n"
" 1 2 12 1 3 12 0 -1 12 7 3 6 0 2 haar_y2 -0.004719 0 -1 0.237888 -0.065519  1 2 0 0 18 13 0 -1\n"
" 9 0 9 13 0 2 haar_x2 0.322016 0 -1 -0.028490 -0.842346  1 2 16 0 3 24 0 -1 17 0 1 24 0 3\n"
" haar_x3 -0.017045 0 -1 -0.509388 0.160576  1 2 5 0 3 24 0 -1 6 0 1 24 0 3 haar_x3\n"
" -0.007347 0 -1 -0.541550 0.004732  1 2 10 15 5 8 0 -1 10 19 5 4 0 2 haar_y2 -0.030002 0 -1\n"
" -0.887858 0.136218  1 2 2 18 18 2 0 -1 2 19 18 1 0 2 haar_y2 -0.011293 0 -1 0.806152 -0.161595 \n"
" 1 2 2 8 20 3 0 -1 2 9 20 1 0 3 haar_y3 0.004775 0 -1 0.012968 0.550799  1 2 7 6 9 6 0 -1\n"
" 7 8 9 2 0 3 haar_y3 0.005071 0 -1 -0.045728 -1.076626  1 2 3 2 19 10 0 -1 3 7 19 5 0 2\n"
" haar_y2 0.193441 0 -1 0.071262 1.169452  1 2 2 7 19 3 0 -1 2 8 19 1 0 3 haar_y3 0.005375 0 -1\n"
" -0.197362 0.382069  1 2 15 6 9 4 0 -1 15 8 9 2 0 2 haar_y2 -0.068276 0 -1 -5.437234 0.111519 \n"
" 1 2 2 2 18 8 0 -1 8 2 6 8 0 3 haar_x3 -0.034933 0 -1 0.447934 -0.186579  1 2 10 9 14 4 0 -1\n"
" 10 9 7 4 0 2 haar_x2 0.005122 0 -1 -0.014872 0.184139  1 2 4 4 6 16 0 -1 7 4 3 16 0 2\n"
" haar_x2 0.095312 0 -1 -0.151171 0.949915  1 2 15 8 9 16 0 -1 18 8 3 16 0 3 haar_x3\n"
" -0.062849 0 -1 0.464736 0.038405  1 2 0 8 9 16 0 -1 3 8 3 16 0 3 haar_x3 -0.170407 0 -1\n"
" -1.650000 -0.063237  1 2 18 0 6 14 0 -1 20 0 2 14 0 3 haar_x3 0.010584 0 -1 -0.038349 0.419138 \n"
" 1 2 0 0 6 14 0 -1 2 0 2 14 0 3 haar_x3 -0.041579 0 -1 0.344619 -0.211877  1 2 15 0 6 22 0 -1\n"
" 17 0 2 22 0 3 haar_x3 0.127186 0 -1 0.123982 -2.125489  1 2 3 0 6 22 0 -1 5 0 2 22 0 3\n"
" haar_x3 0.082557 0 -1 -0.062024 -1.487582  1 2 12 2 12 20 0 -1 16 2 4 20 0 3 haar_x3\n"
" 0.085293 0 -1 0.017088 0.320766  1 2 0 2 12 20 0 -1 4 2 4 20 0 3 haar_x3 0.055544 0 -1\n"
" -0.274140 0.189764  1 2 11 6 4 9 0 -1 11 6 2 9 0 2 haar_x2 0.004565 0 -1 -0.179202 0.279673 \n"
" 1 2 9 0 6 16 0 -1 12 0 3 16 0 2 haar_x2 0.012998 0 -1 -0.322975 0.269418  1 2 12 1 3 12 0 -1\n"
" 12 7 3 6 0 2 haar_y2 0.057892 0 -1 0.126444 -0.607135  1 3 3 4 18 6 0 -1 3 4 9 3 0 2\n"
" 12 7 9 3 0 2 haar_x2_y2 -0.022824 0 -1 -0.496821 0.022377  1 3 5 5 16 8 0 -1 13 5 8 4 0 2\n"
" 5 9 8 4 0 2 haar_x2_y2 0.048312 0 -1 0.043607 0.485378  1 2 0 13 10 6 0 -1 0 15 10 2 0 3\n"
" haar_y3 0.025714 0 -1 -0.042951 -0.930235  1 2 8 14 9 6 0 -1 8 16 9 2 0 3 haar_y3\n"
" 0.006927 0 -1 -0.002968 0.342963  1 2 6 2 9 6 0 -1 9 2 3 6 0 3 haar_x3 -0.034447 0 -1\n"
" -1.529977 -0.061015  1 3 14 1 10 8 0 -1 19 1 5 4 0 2 14 5 5 4 0 2 haar_x2_y2 0.029388 0 -1\n"
" 0.037596 0.641724  1 2 9 1 3 12 0 -1 9 7 3 6 0 2 haar_y2 -0.002432 0 -1 0.099089 -0.396881 \n"
" -3.370300\n"
,

/* Stage 24 */
" 200 1 2 6 4 12 9 0 -1 6 7 12 3 0 3 haar_y3 -0.095944 0 -1 0.624191 -0.458752  1 2\n"
" 6 5 12 6 0 -1 10 5 4 6 0 3 haar_x3 0.016834 0 -1 -0.930728 0.215636  1 2 1 1 8 5 0 -1\n"
" 5 1 4 5 0 2 haar_x2 0.026050 0 -1 -0.405323 0.422566  1 2 12 12 6 8 0 -1 12 16 6 4 0 2\n"
" haar_y2 0.000365 0 -1 0.095288 -0.632981  1 2 3 12 12 6 0 -1 3 14 12 2 0 3 haar_y3\n"
" -0.006694 0 -1 0.372438 -0.303324  1 3 9 18 12 6 0 -1 15 18 6 3 0 2 9 21 6 3 0 2\n"
" haar_x2_y2 0.018874 0 -1 -0.233572 0.403307  1 2 4 13 6 6 0 -1 4 16 6 3 0 2 haar_y2\n"
" -0.000163 0 -1 0.042887 -0.777968  1 2 11 3 7 18 0 -1 11 12 7 9 0 2 haar_y2 -0.076259 0 -1\n"
" -0.496285 0.163354  1 2 3 9 18 3 0 -1 9 9 6 3 0 3 haar_x3 0.050149 0 -1 0.032747 -0.800479 \n"
" 1 2 5 3 19 2 0 -1 5 4 19 1 0 2 haar_y2 -0.002924 0 -1 -0.500028 0.254806  1 3 4 2 12 6 0 -1\n"
" 4 2 6 3 0 2 10 5 6 3 0 2 haar_x2_y2 0.016244 0 -1 0.038913 -0.707249  1 2 9 6 6 9 0 -1\n"
" 11 6 2 9 0 3 haar_x3 0.037812 0 -1 -0.066268 0.738688  1 2 8 6 6 9 0 -1 10 6 2 9 0 3\n"
" haar_x3 -0.012320 0 -1 0.486964 -0.244856  1 2 16 9 5 15 0 -1 16 14 5 5 0 3 haar_y3\n"
" 0.058004 0 -1 0.134591 -0.132321  1 2 3 9 5 15 0 -1 3 14 5 5 0 3 haar_y3 0.004863 0 -1\n"
" -0.441729 0.140056  1 3 6 6 14 6 0 -1 13 6 7 3 0 2 6 9 7 3 0 2 haar_x2_y2 0.045691 0 -1\n"
" 0.031218 0.898183  1 2 8 6 3 14 0 -1 8 13 3 7 0 2 haar_y2 0.021321 0 -1 0.012008 -0.860662 \n"
" 1 2 0 16 24 5 0 -1 8 16 8 5 0 3 haar_x3 0.156791 0 -1 0.014056 0.853329  1 2 0 20 20 3 0 -1\n"
" 10 20 10 3 0 2 haar_x2 -0.010329 0 -1 0.290228 -0.294788  1 2 5 10 18 2 0 -1 5 11 18 1 0 2\n"
" haar_y2 0.002429 0 -1 -0.404399 0.194002  1 2 0 6 6 10 0 -1 2 6 2 10 0 3 haar_x3\n"
" -0.023339 0 -1 0.329452 -0.257127  1 2 2 1 20 3 0 -1 2 2 20 1 0 3 haar_y3 -0.006897 0 -1\n"
" -0.533530 0.216352  1 2 9 13 6 11 0 -1 11 13 2 11 0 3 haar_x3 -0.034403 0 -1 -1.442549 -0.044683 \n"
" 1 2 9 15 6 8 0 -1 9 19 6 4 0 2 haar_y2 -0.021235 0 -1 -0.790175 0.190841  1 2 9 12 6 9 0 -1\n"
" 9 15 6 3 0 3 haar_y3 0.002062 0 -1 -0.269312 0.314880  1 2 5 11 18 2 0 -1 5 12 18 1 0 2\n"
" haar_y2 -0.004219 0 -1 -0.544644 0.165746  1 2 2 6 15 6 0 -1 2 8 15 2 0 3 haar_y3\n"
" -0.014335 0 -1 0.022105 -0.623425  1 2 6 0 18 3 0 -1 6 1 18 1 0 3 haar_y3 -0.008212 0 -1\n"
" -0.498850 0.192371  1 2 5 0 3 18 0 -1 6 0 1 18 0 3 haar_x3 -0.009335 0 -1 -0.791312 -0.014144 \n"
" 1 2 18 3 6 10 0 -1 20 3 2 10 0 3 haar_x3 -0.037938 0 -1 0.798413 -0.033799  1 2 0 3 6 10 0 -1\n"
" 2 3 2 10 0 3 haar_x3 0.004706 0 -1 -0.331634 0.207263  1 2 10 5 8 9 0 -1 10 5 4 9 0 2\n"
" haar_x2 -0.004450 0 -1 -0.272563 0.184022  1 2 6 5 8 9 0 -1 10 5 4 9 0 2 haar_x2\n"
" 0.005219 0 -1 -0.530960 0.052608  1 2 3 2 20 3 0 -1 3 3 20 1 0 3 haar_y3 -0.009540 0 -1\n"
" -0.564854 0.192694  1 2 5 2 13 4 0 -1 5 4 13 2 0 2 haar_y2 0.044970 0 -1 -0.174115 0.953826 \n"
" 1 2 17 0 7 14 0 -1 17 7 7 7 0 2 haar_y2 0.014209 0 -1 -0.091949 0.248361  1 2 0 0 7 14 0 -1\n"
" 0 7 7 7 0 2 haar_y2 0.163802 0 -1 -0.058497 -1.640441  1 2 9 11 10 6 0 -1 9 11 5 6 0 2\n"
" haar_x2 0.002558 0 -1 0.234480 -0.092734  1 2 5 11 10 6 0 -1 10 11 5 6 0 2 haar_x2\n"
" -0.003850 0 -1 0.178807 -0.358441  1 2 11 6 3 18 0 -1 11 12 3 6 0 3 haar_y3 -0.025222 0 -1\n"
" -0.429030 0.202445  1 2 0 16 18 3 0 -1 0 17 18 1 0 3 haar_y3 -0.019415 0 -1 0.580163 -0.188064 \n"
" 1 2 6 16 18 3 0 -1 6 17 18 1 0 3 haar_y3 0.014420 0 -1 0.032847 0.819805  1 2 4 6 9 10 0 -1\n"
" 4 11 9 5 0 2 haar_y2 0.051583 0 -1 0.069176 -0.458663  1 2 9 7 15 4 0 -1 9 9 15 2 0 2\n"
" haar_y2 -0.037960 0 -1 -1.255300 0.143329  1 3 5 6 12 6 0 -1 5 6 6 3 0 2 11 9 6 3 0 2\n"
" haar_x2_y2 -0.029561 0 -1 0.531518 -0.205965  1 2 6 1 12 9 0 -1 6 4 12 3 0 3 haar_y3\n"
" -0.039111 0 -1 1.165872 0.053897  1 3 7 9 6 12 0 -1 7 9 3 6 0 2 10 15 3 6 0 2 haar_x2_y2\n"
" -0.029159 0 -1 0.393076 -0.221845  1 2 11 5 13 6 0 -1 11 7 13 2 0 3 haar_y3 -0.083617 0 -1\n"
" -0.737445 0.142682  1 2 1 11 22 13 0 -1 12 11 11 13 0 2 haar_x2 0.420040 0 -1 -0.142774 1.789484 \n"
" 1 2 18 8 6 6 0 -1 18 11 6 3 0 2 haar_y2 0.060005 0 -1 0.119767 -1.888619  1 2 0 8 6 6 0 -1\n"
" 0 11 6 3 0 2 haar_y2 -0.018981 0 -1 -1.414845 -0.056523  1 2 0 6 24 3 0 -1 0 7 24 1 0 3\n"
" haar_y3 -0.006005 0 -1 0.441708 -0.102008  1 2 0 5 10 6 0 -1 0 7 10 2 0 3 haar_y3\n"
" -0.058214 0 -1 -1.391847 -0.048269  1 2 6 7 18 3 0 -1 6 8 18 1 0 3 haar_y3 -0.012271 0 -1\n"
" 0.513177 -0.093697  1 2 0 0 10 6 0 -1 0 2 10 2 0 3 haar_y3 0.046586 0 -1 -0.057484 -1.428317 \n"
" 1 2 19 0 3 19 0 -1 20 0 1 19 0 3 haar_x3 0.001211 0 -1 -0.080892 0.323332  1 3 4 6 12 16 0 -1\n"
" 4 6 6 8 0 2 10 14 6 8 0 2 haar_x2_y2 -0.088642 0 -1 -0.864491 -0.033147  1 3 19 6 4 18 0 -1\n"
" 21 6 2 9 0 2 19 15 2 9 0 2 haar_x2_y2 -0.023185 0 -1 0.521622 -0.016168  1 3 1 6 4 18 0 -1\n"
" 1 6 2 9 0 2 3 15 2 9 0 2 haar_x2_y2 0.043090 0 -1 -0.161538 1.091500  1 2 3 21 18 3 0 -1\n"
" 3 22 18 1 0 3 haar_y3 0.000206 0 -1 -0.170915 0.312367  1 2 0 19 9 4 0 -1 0 21 9 2 0 2\n"
" haar_y2 0.008916 0 -1 -0.006704 -0.688104  1 3 12 18 12 6 0 -1 18 18 6 3 0 2 12 21 6 3 0 2\n"
" haar_x2_y2 -0.017753 0 -1 0.632928 -0.004236  1 2 7 18 9 4 0 -1 7 20 9 2 0 2 haar_y2\n"
" 0.006230 0 -1 -0.336372 0.127906  1 3 12 16 10 8 0 -1 17 16 5 4 0 2 12 20 5 4 0 2\n"
" haar_x2_y2 0.022770 0 -1 -0.034704 0.391418  1 3 2 16 10 8 0 -1 2 16 5 4 0 2 7 20 5 4 0 2\n"
" haar_x2_y2 -0.021535 0 -1 0.647651 -0.200978  1 3 14 0 10 12 0 -1 19 0 5 6 0 2 14 6 5 6 0 2\n"
" haar_x2_y2 0.061759 0 -1 0.054297 0.907001  1 3 0 0 10 12 0 -1 0 0 5 6 0 2 5 6 5 6 0 2\n"
" haar_x2_y2 -0.078070 0 -1 0.655234 -0.197544  1 2 15 14 9 6 0 -1 15 16 9 2 0 3 haar_y3\n"
" 0.011315 0 -1 0.193853 -0.517073  1 2 0 14 9 6 0 -1 0 16 9 2 0 3 haar_y3 -0.025590 0 -1\n"
" -0.930965 -0.031547  1 2 14 14 10 6 0 -1 14 16 10 2 0 3 haar_y3 -0.038059 0 -1 -0.683269 0.127091 \n"
" 1 2 0 14 10 6 0 -1 0 16 10 2 0 3 haar_y3 0.009797 0 -1 0.015524 -0.633479  1 2 5 18 18 2 0 -1\n"
" 5 19 18 1 0 2 haar_y2 -0.013842 0 -1 1.006053 0.062813  1 2 0 18 18 3 0 -1 0 19 18 1 0 3\n"
" haar_y3 0.008346 0 -1 -0.233832 0.309827  1 3 3 5 18 12 0 -1 12 5 9 6 0 2 3 11 9 6 0 2\n"
" haar_x2_y2 -0.071440 0 -1 -0.725054 0.171483  1 2 5 3 7 9 0 -1 5 6 7 3 0 3 haar_y3\n"
" 0.010006 0 -1 -0.220720 0.352662  1 2 4 0 19 15 0 -1 4 5 19 5 0 3 haar_y3 0.110053 0 -1\n"
" 0.166620 -0.743190  1 2 3 0 16 4 0 -1 3 2 16 2 0 2 haar_y2 0.035311 0 -1 -0.239827 0.414360 \n"
" 1 2 4 12 16 12 0 -1 4 12 8 12 0 2 haar_x2 -0.111747 0 -1 0.510454 0.002232  1 2 4 3 12 15 0 -1\n"
" 10 3 6 15 0 2 haar_x2 -0.113678 0 -1 0.904752 -0.166153  1 2 16 4 2 19 0 -1 16 4 1 19 0 2\n"
" haar_x2 0.016668 0 -1 0.140245 -0.521785  1 2 6 4 2 19 0 -1 7 4 1 19 0 2 haar_x2\n"
" -0.008034 0 -1 -0.661784 0.003764  1 3 13 14 8 10 0 -1 17 14 4 5 0 2 13 19 4 5 0 2\n"
" haar_x2_y2 -0.033097 0 -1 0.801859 0.059385  1 3 3 14 8 10 0 -1 3 14 4 5 0 2 7 19 4 5 0 2\n"
" haar_x2_y2 0.012548 0 -1 -0.335455 0.145786  1 2 12 6 3 18 0 -1 12 12 3 6 0 3 haar_y3\n"
" -0.042074 0 -1 -0.555091 0.132666  1 3 5 11 12 6 0 -1 5 11 6 3 0 2 11 14 6 3 0 2\n"
" haar_x2_y2 0.025222 0 -1 -0.061632 -1.367877  1 3 10 5 8 10 0 -1 14 5 4 5 0 2 10 10 4 5 0 2\n"
" haar_x2_y2 -0.024269 0 -1 0.341851 -0.007416  1 3 6 4 12 10 0 -1 6 4 6 5 0 2 12 9 6 5 0 2\n"
" haar_x2_y2 -0.012280 0 -1 0.277458 -0.310339  1 3 6 8 18 10 0 -1 15 8 9 5 0 2 6 13 9 5 0 2\n"
" haar_x2_y2 -0.113771 0 -1 1.171954 0.083681  1 3 0 8 18 10 0 -1 0 8 9 5 0 2 9 13 9 5 0 2\n"
" haar_x2_y2 -0.084772 0 -1 0.816948 -0.178375  1 2 12 6 3 18 0 -1 12 12 3 6 0 3 haar_y3\n"
" -0.024552 0 -1 -0.186273 0.143401  1 2 0 14 18 3 0 -1 0 15 18 1 0 3 haar_y3 -0.009027 0 -1\n"
" 0.326592 -0.235413  1 2 12 6 3 18 0 -1 12 12 3 6 0 3 haar_y3 0.011178 0 -1 0.197612 -0.021701 \n"
" 1 2 9 6 3 18 0 -1 9 12 3 6 0 3 haar_y3 -0.029367 0 -1 -0.934148 -0.021705  1 2 6 14 18 3 0 -1\n"
" 6 15 18 1 0 3 haar_y3 0.006364 0 -1 0.025573 0.464128  1 2 0 5 18 3 0 -1 0 6 18 1 0 3\n"
" haar_y3 0.014026 0 -1 -0.212286 0.400788  1 2 2 5 22 3 0 -1 2 6 22 1 0 3 haar_y3\n"
" -0.013342 0 -1 0.742027 0.029002  1 2 0 0 21 10 0 -1 7 0 7 10 0 3 haar_x3 0.284228 0 -1\n"
" -0.192436 0.436312  1 2 6 3 18 17 0 -1 12 3 6 17 0 3 haar_x3 -0.237240 0 -1 0.697364 0.069308 \n"
" 1 2 0 3 18 17 0 -1 6 3 6 17 0 3 haar_x3 -0.111697 0 -1 0.391472 -0.209220  1 2 0 12 24 11 0 -1\n"
" 8 12 8 11 0 3 haar_x3 0.127875 0 -1 -0.072556 0.360882  1 2 4 10 16 6 0 -1 4 13 16 3 0 2\n"
" haar_y2 -0.062901 0 -1 0.954250 -0.154028  1 2 12 8 6 8 0 -1 12 12 6 4 0 2 haar_y2\n"
" 0.017439 0 -1 -0.051135 0.277503  1 2 6 14 8 7 0 -1 10 14 4 7 0 2 haar_x2 0.001232 0 -1\n"
" 0.075628 -0.364561  1 3 15 10 6 14 0 -1 18 10 3 7 0 2 15 17 3 7 0 2 haar_x2_y2 0.027495 0 -1\n"
" 0.051844 0.415626  1 3 3 10 6 14 0 -1 3 10 3 7 0 2 6 17 3 7 0 2 haar_x2_y2 -0.043544 0 -1\n"
" 0.719700 -0.171322  1 2 6 12 18 2 0 -1 6 13 18 1 0 2 haar_y2 0.011026 0 -1 0.143546 -0.654030 \n"
" 1 2 5 8 10 6 0 -1 5 10 10 2 0 3 haar_y3 0.020866 0 -1 0.040089 -0.457433  1 2 12 11 9 4 0 -1\n"
" 12 13 9 2 0 2 haar_y2 -0.022304 0 -1 0.538550 0.071663  1 2 0 11 9 6 0 -1 0 13 9 2 0 3\n"
" haar_y3 0.032492 0 -1 -0.045992 -1.004707  1 2 11 2 3 18 0 -1 12 2 1 18 0 3 haar_x3\n"
" 0.012270 0 -1 0.034335 0.424318  1 2 10 2 3 18 0 -1 11 2 1 18 0 3 haar_x3 0.008382 0 -1\n"
" -0.258506 0.262635  1 2 9 12 6 10 0 -1 11 12 2 10 0 3 haar_x3 0.037354 0 -1 0.156925 -1.042909 \n"
" 1 2 1 10 6 9 0 -1 1 13 6 3 0 3 haar_y3 -0.014111 0 -1 -0.731777 -0.020277  1 3 6 9 16 6 0 -1\n"
" 14 9 8 3 0 2 6 12 8 3 0 2 haar_x2_y2 0.057067 0 -1 0.083360 1.566150  1 2 1 8 9 6 0 -1\n"
" 1 10 9 2 0 3 haar_y3 0.004968 0 -1 -0.353182 0.146984  1 2 7 7 16 6 0 -1 7 9 16 2 0 3\n"
" haar_y3 -0.024493 0 -1 0.283259 -0.003464  1 2 0 0 18 3 0 -1 0 1 18 1 0 3 haar_y3\n"
" -0.011255 0 -1 -0.840175 -0.036252  1 2 10 0 6 9 0 -1 12 0 2 9 0 3 haar_x3 0.034533 0 -1\n"
" 0.149985 -0.873671  1 2 9 5 6 6 0 -1 12 5 3 6 0 2 haar_x2 0.024303 0 -1 -0.187875 0.594840 \n"
" 1 3 10 6 4 18 0 -1 12 6 2 9 0 2 10 15 2 9 0 2 haar_x2_y2 -0.007879 0 -1 0.443157 -0.056571 \n"
" 1 2 8 0 6 9 0 -1 10 0 2 9 0 3 haar_x3 0.035142 0 -1 -0.056495 -1.361719  1 2 9 1 6 9 0 -1\n"
" 9 4 6 3 0 3 haar_y3 0.004626 0 -1 -0.311617 0.254477  1 2 1 0 18 9 0 -1 1 3 18 3 0 3\n"
" haar_y3 -0.083131 0 -1 1.642435 -0.144294  1 2 0 3 24 3 0 -1 0 4 24 1 0 3 haar_y3\n"
" -0.014016 0 -1 -0.778195 0.171733  1 2 6 14 9 4 0 -1 6 16 9 2 0 2 haar_y2 0.001245 0 -1\n"
" -0.231914 0.285279  1 3 8 9 8 10 0 -1 12 9 4 5 0 2 8 14 4 5 0 2 haar_x2_y2 -0.016803 0 -1\n"
" -0.359651 0.204130  1 2 5 2 13 9 0 -1 5 5 13 3 0 3 haar_y3 -0.076748 0 -1 0.780505 -0.156128 \n"
" 1 2 4 4 16 9 0 -1 4 7 16 3 0 3 haar_y3 -0.236720 0 -1 1.181370 0.078112  1 2 4 4 14 9 0 -1\n"
" 4 7 14 3 0 3 haar_y3 -0.100574 0 -1 -0.471041 0.079173  1 2 8 5 9 6 0 -1 8 7 9 2 0 3\n"
" haar_y3 0.001324 0 -1 0.222627 -0.370998  1 2 1 7 16 6 0 -1 1 9 16 2 0 3 haar_y3\n"
" 0.022153 0 -1 -0.038649 -0.922750  1 2 10 5 13 9 0 -1 10 8 13 3 0 3 haar_y3 -0.112462 0 -1\n"
" 0.418996 0.080411  1 2 1 5 13 9 0 -1 1 8 13 3 0 3 haar_y3 0.016481 0 -1 -0.167567 0.718424 \n"
" 1 3 0 4 24 6 0 -1 12 4 12 3 0 2 0 7 12 3 0 2 haar_x2_y2 0.068114 0 -1 0.157199 -0.876811 \n"
" 1 2 1 14 10 9 0 -1 1 17 10 3 0 3 haar_y3 0.016012 0 -1 -0.004160 -0.593278  1 2 5 17 18 3 0 -1\n"
" 5 18 18 1 0 3 haar_y3 0.004664 0 -1 -0.030154 0.483453  1 2 0 16 18 3 0 -1 0 17 18 1 0 3\n"
" haar_y3 0.006758 0 -1 -0.226674 0.336623  1 2 9 17 9 6 0 -1 9 19 9 2 0 3 haar_y3\n"
" 0.004729 0 -1 -0.060374 0.314581  1 3 1 20 22 4 0 -1 1 20 11 2 0 2 12 22 11 2 0 2\n"
" haar_x2_y2 0.002587 0 -1 -0.298726 0.177875  1 2 8 14 8 6 0 -1 8 17 8 3 0 2 haar_y2\n"
" 0.002899 0 -1 0.218902 -0.295671  1 2 8 6 8 15 0 -1 8 11 8 5 0 3 haar_y3 -0.030054 0 -1\n"
" 1.215043 -0.143550  1 2 5 4 18 3 0 -1 5 5 18 1 0 3 haar_y3 0.014181 0 -1 0.012452 0.554901 \n"
" 1 2 9 3 5 10 0 -1 9 8 5 5 0 2 haar_y2 -0.060527 0 -1 -1.493400 -0.065227  1 2 6 8 12 3 0 -1\n"
" 6 8 6 3 0 2 haar_x2 -0.019883 0 -1 -0.385264 0.197612  1 3 2 6 18 6 0 -1 2 6 9 3 0 2\n"
" 11 9 9 3 0 2 haar_x2_y2 0.031219 0 -1 -0.212812 0.294465  1 3 10 6 4 18 0 -1 12 6 2 9 0 2\n"
" 10 15 2 9 0 2 haar_x2_y2 0.018272 0 -1 0.000972 0.668142  1 2 7 5 6 6 0 -1 10 5 3 6 0 2\n"
" haar_x2 0.001109 0 -1 -0.624679 -0.001660  1 2 14 5 2 18 0 -1 14 14 2 9 0 2 haar_y2\n"
" -0.036714 0 -1 -0.423339 0.120847  1 2 8 5 2 18 0 -1 8 14 2 9 0 2 haar_y2 0.012044 0 -1\n"
" 0.025882 -0.507324  1 2 9 2 10 6 0 -1 9 2 5 6 0 2 haar_x2 0.074749 0 -1 0.131847 -0.217396 \n"
" 1 2 3 1 18 12 0 -1 12 1 9 12 0 2 haar_x2 -0.234732 0 -1 1.177561 -0.151147  1 2 5 2 17 22 0 -1\n"
" 5 13 17 11 0 2 haar_y2 0.140965 0 -1 0.033991 0.399231  1 2 4 0 12 6 0 -1 4 2 12 2 0 3\n"
" haar_y3 0.006179 0 -1 -0.318067 0.116817  1 3 6 9 16 6 0 -1 14 9 8 3 0 2 6 12 8 3 0 2\n"
" haar_x2_y2 -0.057217 0 -1 0.843991 0.083889  1 2 9 0 5 18 0 -1 9 9 5 9 0 2 haar_y2\n"
" -0.055227 0 -1 0.368883 -0.189134  1 2 12 0 6 9 0 -1 14 0 2 9 0 3 haar_x3 -0.021583 0 -1\n"
" -0.521618 0.157726  1 2 6 0 6 9 0 -1 8 0 2 9 0 3 haar_x3 0.025748 0 -1 -0.059922 -1.067499 \n"
" 1 2 9 1 6 12 0 -1 11 1 2 12 0 3 haar_x3 -0.013099 0 -1 0.789584 0.052100  1 2 5 9 13 4 0 -1\n"
" 5 11 13 2 0 2 haar_y2 0.002280 0 -1 -1.170443 -0.059357  1 2 5 8 19 3 0 -1 5 9 19 1 0 3\n"
" haar_y3 0.008806 0 -1 0.041718 0.663526  1 2 9 9 6 8 0 -1 9 13 6 4 0 2 haar_y2 -0.008970 0 -1\n"
" -0.358627 0.060458  1 2 11 9 4 15 0 -1 11 14 4 5 0 3 haar_y3 0.004023 0 -1 0.209794 -0.248060 \n"
" 1 3 2 0 6 14 0 -1 2 0 3 7 0 2 5 7 3 7 0 2 haar_x2_y2 0.025017 0 -1 -0.187959 0.395471 \n"
" 1 3 15 1 6 14 0 -1 18 1 3 7 0 2 15 8 3 7 0 2 haar_x2_y2 -0.005901 0 -1 0.256639 -0.094919 \n"
" 1 3 3 1 6 14 0 -1 3 1 3 7 0 2 6 8 3 7 0 2 haar_x2_y2 0.004385 0 -1 0.033139 -0.460754 \n"
" 1 3 3 20 18 4 0 -1 12 20 9 2 0 2 3 22 9 2 0 2 haar_x2_y2 -0.033772 0 -1 -0.988816 0.146369 \n"
" 1 3 5 0 4 20 0 -1 5 0 2 10 0 2 7 10 2 10 0 2 haar_x2_y2 0.044523 0 -1 -0.132867 1.579679 \n"
" 1 3 16 8 8 12 0 -1 20 8 4 6 0 2 16 14 4 6 0 2 haar_x2_y2 -0.040929 0 -1 0.338771 0.074971 \n"
" 1 3 0 8 8 12 0 -1 0 8 4 6 0 2 4 14 4 6 0 2 haar_x2_y2 0.039352 0 -1 -0.183279 0.469807 \n"
" 1 3 13 13 10 8 0 -1 18 13 5 4 0 2 13 17 5 4 0 2 haar_x2_y2 -0.070323 0 -1 -0.983227 0.118081 \n"
" 1 3 1 13 10 8 0 -1 1 13 5 4 0 2 6 17 5 4 0 2 haar_x2_y2 0.035743 0 -1 -0.033051 -0.836109 \n"
" 1 2 15 8 4 15 0 -1 15 13 4 5 0 3 haar_y3 -0.042962 0 -1 1.167081 0.080692  1 2 5 8 4 15 0 -1\n"
" 5 13 4 5 0 3 haar_y3 -0.021008 0 -1 0.638698 -0.176263  1 2 6 11 16 12 0 -1 6 15 16 4 0 3\n"
" haar_y3 -0.157422 0 -1 -0.233025 0.125175  1 2 2 11 16 12 0 -1 2 15 16 4 0 3 haar_y3\n"
" 0.007866 0 -1 -0.220380 0.271968  1 2 14 12 7 9 0 -1 14 15 7 3 0 3 haar_y3 0.023622 0 -1\n"
" 0.161273 -0.433290  1 2 10 1 3 21 0 -1 10 8 3 7 0 3 haar_y3 0.074692 0 -1 -0.169920 0.588849 \n"
" 1 2 13 11 9 4 0 -1 13 13 9 2 0 2 haar_y2 -0.000648 0 -1 0.258429 -0.035912  1 2 3 10 17 9 0 -1\n"
" 3 13 17 3 0 3 haar_y3 -0.016291 0 -1 -0.767644 -0.020473  1 2 13 8 8 15 0 -1 13 13 8 5 0 3\n"
" haar_y3 -0.033134 0 -1 -0.271801 0.143257  1 2 3 8 8 15 0 -1 3 13 8 5 0 3 haar_y3\n"
" 0.048798 0 -1 0.076409 -0.414452  1 3 11 14 10 8 0 -1 16 14 5 4 0 2 11 18 5 4 0 2\n"
" haar_x2_y2 0.002287 0 -1 -0.038629 0.207538  1 3 0 18 22 6 0 -1 0 18 11 3 0 2 11 21 11 3 0 2\n"
" haar_x2_y2 0.045304 0 -1 -0.177779 0.634614  1 2 0 16 24 4 0 -1 0 16 12 4 0 2 haar_x2\n"
" 0.107058 0 -1 0.189723 -0.512362  1 2 6 20 12 3 0 -1 12 20 6 3 0 2 haar_x2 -0.040525 0 -1\n"
" 0.706150 -0.178033  1 3 18 12 6 12 0 -1 21 12 3 6 0 2 18 18 3 6 0 2 haar_x2_y2 0.031969 0 -1\n"
" 0.068150 0.687331  1 3 0 12 6 12 0 -1 0 12 3 6 0 2 3 18 3 6 0 2 haar_x2_y2 -0.057617 0 -1\n"
" 0.751705 -0.157650  1 2 15 17 9 6 0 -1 15 19 9 2 0 3 haar_y3 0.013594 0 -1 0.194119 -0.245619 \n"
" 1 3 1 6 22 10 0 -1 1 6 11 5 0 2 12 11 11 5 0 2 haar_x2_y2 0.071396 0 -1 -0.046881 -0.881983 \n"
" 1 2 15 17 9 6 0 -1 15 19 9 2 0 3 haar_y3 -0.014896 0 -1 -0.445324 0.176799  1 2 0 18 18 2 0 -1\n"
" 0 19 18 1 0 2 haar_y2 -0.010026 0 -1 0.651227 -0.167100  1 2 3 15 19 3 0 -1 3 16 19 1 0 3\n"
" haar_y3 0.003759 0 -1 -0.058301 0.344833  1 2 0 13 18 3 0 -1 0 14 18 1 0 3 haar_y3\n"
" 0.016263 0 -1 -0.155815 0.864327  1 2 15 17 9 6 0 -1 15 19 9 2 0 3 haar_y3 -0.040176 0 -1\n"
" -0.610286 0.117964  1 2 0 17 9 6 0 -1 0 19 9 2 0 3 haar_y3 0.027081 0 -1 -0.049602 -0.899900 \n"
" 1 2 12 17 9 6 0 -1 12 19 9 2 0 3 haar_y3 0.052420 0 -1 0.112972 -1.083364  1 2 3 17 9 6 0 -1\n"
" 3 19 9 2 0 3 haar_y3 -0.019160 0 -1 -0.798801 -0.034079  1 2 16 2 3 20 0 -1 17 2 1 20 0 3\n"
" haar_x3 -0.003773 0 -1 -0.191241 0.215352  1 2 0 13 24 8 0 -1 0 17 24 4 0 2 haar_y2\n"
" 0.075762 0 -1 -0.134217 1.680706  1 3 9 1 6 22 0 -1 12 1 3 11 0 2 9 12 3 11 0 2 haar_x2_y2\n"
" -0.022173 0 -1 0.486010 0.003616  -2.992828\n"
,

/*End of cascade*/
NULL
};

/* End of file. */
