///////////////////////////////////////////////////////////////////////////////
// $Id: Frame.hxx,v 1.1 1995/01/08 06:51:10 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Frame.hxx - Frame widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Frame.hxx,v $
// Revision 1.1  1995/01/08  06:51:10  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef FRAME_HXX
#define FRAME_HXX

#include "ContainerWidget.hxx"
#include "misc.hxx"

class Frame : public ContainerWidget {
  private:
    BorderStyle myBorderStyle;

  protected:
    // Called whenever an event arrives for me (I need to override the default)
    virtual void handleEvent(XEvent* event);

    // Update the graphical view of myself
    void updateView();

  public:
    // Constructor
    Frame(ContainerWidget *const parent, const char *const name,
        int x, int y, int width, int height, BorderStyle borderStyle);

    // Destructor
    virtual ~Frame();

    // Answer my class
    virtual const char *const className() const { return("Frame"); }
};
#endif

