#ifndef __NWS_BACK_CACHE_H
#define __NWS_BACK_CACHE_H

#include "config_nws.h"

#include <string.h>
#include <stdio.h>
#include <pthread.h>

#include "messages.h"
#include "protocol.h"
#include "host_protocol.h"
#include "register.h"
#include "nws_messages.h"
#include "nws_memory.h"
#include "experiments.h"
#include "hosts.h"
#include "diagnostic.h"
#include "forc.h"
#define NWSAPI_SHORTNAMES
#include "nws_api.h"
#include "nws_cache.h"
#include "nws_obj.h"
#include "nws_back_rb.h"

typedef struct nws_series_cache2coll {
  struct nws_series_cache *nser;
  struct nws_series_cache *lat_nser;
  struct nws_series_cache *ban_nser;
  int index0;
  int index1;
} nwsSeriesCache2Coll;

/* represents iteration thru an index */
typedef struct nws_collection_iterator {
  struct nws_series_collection *nser_coll;
  int position;
  int count;
} nwsCollIter;

typedef struct nws_collection_index {
  char *name;
  char *value;
  Rb_node idx_tree;
} nwsCollIdx;

typedef struct nws_series_collection {
  int status;
  struct nws_series_cache2coll **series_rel;
  int series_rel_count;
  char *name;
  char **member;
  int member_count;
  char *type;
  /* these indices must be updated on insert, etc.*/
  struct nws_collection_index **index;
  int index_count;
  struct timeval lastseen;
  struct timeval lastupdate;
} nwsSeriesColl;

typedef struct nws_series_cache {
  char *name;
  char *memory;
  struct host_cookie mem_cookie;
  struct timeval lastseen;
  struct timeval lastupdate;
  int period;
  size_t count;
  double seq_no;
  struct nws_memory_state state;
  char *forecast_state;
  Experiment *exper;
  /* for external forecaster */
  ForecastCollection *forc;
  int exp_count;
  pthread_mutex_t nser_mutex;
  struct nws_series_cache *next;
  struct nws_series_cache *prev;
} nwsSeriesCache;

typedef struct grid_target {
  char *file;
  char *server;
  int port;
  char *base;
  char *filter;
  char **attribute;
} gridTarget;

typedef struct archive_target {
  char *server;
  int port;
  char *base;
  char *filter;
  char **attribute;
} archiveTarget;

typedef struct nws_cache_config {
  NWSobj *nws_cache_root;
  struct nws_series_cache *nser_root;
  void *env_config;
  char *nws_nameserver;
  int nws_nameserv_port;
  char *nws_forecaster;
  int nws_forecaster_port;
  struct host_cookie ns_cookie;
  struct host_cookie forc_cookie;
  int max_data_entries;
  int max_forc_entries;
  char *nws_reg_objs;
  NWSobj *nws_obj_list;
  struct nws_series_cache *nser;
  struct nws_series_collection *nser_coll;
  Rb_node nser_coll_tree;
  pthread_mutex_t reg_objs_mutex;
  pthread_mutex_t obj_list_mutex;
  pthread_mutex_t nser_coll_mutex;
  pthread_mutex_t nws_connect_mutex;
  archiveTarget **arch_list;
  int arch_count;
  gridTarget **grid_list;
  int grid_count;
  /* configuration options */
  int initial_fetch_size;
  int min_refresh_period;
  void *proto;
} nwsCacheConfig;

/*
 * Function Prototypes
 */

char * 
nws_next_object(char *obj);


NWSobj *
nws_new_obj(void);

int
nws_free_obj(NWSobj *obj);

nwsSeriesCache *
nws_find_series(nwsCacheConfig *ncc, char *name);

NWSobj *
nws_find_obj(nwsCacheConfig *ncc, char *name);

int
nws_insert_obj(nwsCacheConfig *ncc, NWSobj *head, NWSobj *newobj);

int 
nws_new_tree(nwsCacheConfig *ncc, NWSobj *newobj);

int
nws_make_coll(nwsCacheConfig *ncc, char *name, char *memberlist, char *type);

int
nws_coll_addmember(nwsCacheConfig *ncc, nwsSeriesColl *nser_coll,
				   char *member);

struct nws_series_collection *
nws_new_coll(nwsCacheConfig *ncc);

int
nws_free_coll(nwsCacheConfig *ncc, struct nws_series_collection *nser_coll);

struct nws_series_collection *
nws_collection_by_name(nwsCacheConfig *ncc, const char *name);

#endif
