#!/bin/sh
# Written by Tibor Koleszar <oldw@debian.org> at Mon Feb 15 11:25:54 1999
# start/stop nsmon

PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/sbin/nsmon

FLAGS="defaults 50"

test -f $DAEMON || exit 0

case "$1" in
  start)
    echo -n "Starting network security monitor: "
    start-stop-daemon --start --quiet --exec $DAEMON &
    echo "nsmon."
    ;;
  stop)
    echo -n "Stopping network security monitor: "
    start-stop-daemon --stop --quiet --exec $DAEMON
    LOCK=`cat /etc/nsmon.conf | grep lock | sed -e s/" "/""/g | sed -e s/"lock="/""/g`
    rm -f $LOCK/*.ping.lock $LOCK/*.port.lock
    echo "nsmon."
    ;;
  restart|force-reload)
    echo -n "Restarting network security monitor: "
    start-stop-daemon --stop --quiet --exec $DAEMON
    sleep 1
    start-stop-daemon --start --quiet --exec $DAEMON &
    echo "nsmon."
    ;;
  *)
    echo "Usage: /etc/init.d/nsmon {start|stop|restart|force-reload}"
    exit 1
    ;;
esac

exit 0
