#ifndef __NPACONSTS_H__
#define __NPACONSTS_H__

/* These apply to operflags */
#define NEED_HOSTMIB_FLAG  0x00000001ul
#define NEED_PRINTMIB_FLAG 0x00000002ul
#define NEED_VENDOR_FLAG   0x00000004ul
#define HAS_HOSTMIB_FLAG   0x00000008ul
#define HAS_PRINTMIB_FLAG  0x00000010ul //2,4,&8 skipped to reduce confusion

/* these all work together in operflags */
#define HP_VENDOR          0x00000100ul
#define LEX_VENDOR         0x00000200ul
#define XER_VENDOR         0x00000300ul
#define TEK_VENDOR         0x00000400ul
#define QMS_VENDOR         0x00000500ul
#define IBM_VENDOR         0x00000600ul
#define EFI_VENDOR         0x00000700ul
#define FUJI_VENDOR        0x00000800ul

// these are associated with the vendor flags above but are seperate
#define VENDOR_BITS        0x00000F00ul
#define VENDOR_OFFSET      8 // number of bits to shift left
#define CFGSRC_IDX 0

// Misc consts
#define LETTER_SHORT_IN     85000ul 
#define LETTER_LONG_IN     110000ul
#define LEGAL_SHORT_IN     LETTER_SHORT_IN 
#define LEGAL_LONG_IN      140000ul
#define TABLOID_SHORT_IN   LETTER_LONG_IN
#define TABLOID_LONG_IN    170000ul
#define EXECUTIVE_SHORT_IN  75000ul
#define EXECUTIVE_LONG_IN  105000ul
#define A4_SHORT_IN         82677ul
#define A4_LONG_IN         116929ul
#define A3_SHORT_IN        109842ul
#define A3_LONG_IN         165354ul
#define B5_SHORT_IN         72834ul
#define B5_LONG_IN         101181ul
#define B4_SHORT_IN        B5_LONG_IN
#define B4_LONG_IN         143307ul

#define LETTER_SHORT_M     215900ul
#define LETTER_LONG_M      279400ul
#define LEGAL_SHORT_M      LETTER_SHORT_M
#define LEGAL_LONG_M       355600ul
#define TABLOID_SHORT_M    LETTER_LONG_M
#define TABLOID_LONG_M     431800ul
#define EXECUTIVE_SHORT_M  190500ul
#define EXECUTIVE_LONG_M   266700ul
#define A4_SHORT_M         210000ul
#define A4_LONG_M          297000ul
#define A3_SHORT_M         279000ul
#define A3_LONG_M          420000ul
#define B5_SHORT_M         182000ul
#define B5_LONG_M          257000ul
#define B4_SHORT_M         B5_LONG_M
#define B4_LONG_M          364000ul

#define PCL_C_FLAG       0x01
#define PJL_C_FLAG       0x02
#define PS_C_FLAG        0x04
#define HPGL_C_FLAG      0x08
#define PSPRINTER_C_FLAG 0x10
#define AUTOLANG_C_FLAG  0x20

#define APPLETALK_C_FLAG 0x01
#define LPD_C_FLAG       0x02
#define NETWARE_C_FLAG   0x04
#define PORT9100_C_FLAG  0x08

#endif
