/* a toggle button ... put/get methods
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

#include "ip.h"

/*
#define DEBUG
 */

static ClassmodelClass *parent_class = NULL;

static void
toggle_finalize( GObject *gobject )
{
	Toggle *tog;

	g_return_if_fail( gobject != NULL );
	g_return_if_fail( IS_TOGGLE( gobject ) );

	tog = TOGGLE( gobject );

	/* My instance destroy stuff.
	 */

	G_OBJECT_CLASS( parent_class )->finalize( gobject );
}

/* Widgets for toggle edit.
 */
typedef struct _ToggleEdit {
	iDialog *idlg;

	Toggle *toggle;

	GtkWidget *caption;
	GtkWidget *value;
} ToggleEdit;

/* Done button hit.
 */
/*ARGSUSED*/
static void
toggle_done_cb( iWindow *iwnd, void *client, 
	iWindowNotifyFn nfn, void *sys )
{
	ToggleEdit *eds = (ToggleEdit *) client;
	Toggle *toggle = eds->toggle;
	Classmodel *classmodel = CLASSMODEL( toggle );

	gboolean value = GTK_TOGGLE_BUTTON( eds->value )->active;
	const char *caption = gtk_editable_get_chars( 
		GTK_EDITABLE( eds->caption ), 0, -1 );

	/* Reset toggle.
	 */
	toggle->value = value;
	iobject_set( IOBJECT( toggle ), NULL, caption );

	/* Rebuild object.
	 */
	classmodel_update( classmodel );
	symbol_recalculate_all();

	nfn( sys, IWINDOW_TRUE );
}

/* Build the insides of toggle edit.
 */
static void
toggle_buildedit( iDialog *idlg, GtkWidget *vb, ToggleEdit *eds )
{
	Toggle *toggle = eds->toggle;

        eds->caption = build_glabeltext4( vb, NULL, _( "Caption" ) );
	idialog_init_entry( idlg, eds->caption,
		_( "Set toggle caption here" ), "%s", 
		IOBJECT( toggle )->caption );

        eds->value = build_gtoggle( vb, _( "State" ) );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( eds->value ), 
		toggle->value );
	set_tooltip( eds->value, _( "Set toggle state here" ) );

        gtk_widget_show_all( vb );
}

/* Pop up a toggle edit box.
 */
static void 
toggle_edit( GtkWidget *parent, Model *model )
{
	Toggle *toggle = TOGGLE( model );
	ToggleEdit *eds = INEW( NULL, ToggleEdit );
	GtkWidget *idlg;

	eds->toggle = toggle;

	idlg = idialog_new();
	iwindow_set_title( IWINDOW( idlg ), _( "Edit Toggle" ) );
	idialog_set_build( IDIALOG( idlg ), 
		(iWindowBuildFn) toggle_buildedit, eds, NULL, NULL );
	idialog_set_callbacks( IDIALOG( idlg ), 
		iwindow_true_cb, NULL, idialog_free_client, eds );
	idialog_add_ok( IDIALOG( idlg ), toggle_done_cb, _( "Set Toggle" ) );
	idialog_set_parent( IDIALOG( idlg ), parent );
	idialog_set_iobject( IDIALOG( idlg ), IOBJECT( model ) );
	iwindow_build( IWINDOW( idlg ) );

	gtk_widget_show( GTK_WIDGET( idlg ) );
}

static xmlNode *
toggle_save( Model *model, xmlNode *xnode )
{
	Toggle *toggle = TOGGLE( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_sprop( xthis, "value", 
			bool_to_char( toggle->value ) ) )
			return( NULL );
	}

	return( xthis );
}

static gboolean
toggle_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Toggle *toggle = TOGGLE( model );

	assert( IS_RHS( parent ) );

	if( get_bprop( xnode, "value", &toggle->value ) )
		classmodel_set_edited( CLASSMODEL( model ), TRUE );

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

static gboolean
toggle_class_get( Classmodel *classmodel, PElement *root )
{
	Toggle *toggle = TOGGLE( classmodel );
	char buf[MAX_STRSIZE];

	if( !class_get_member_string( root, MEMBER_CAPTION, 
		buf, MAX_STRSIZE ) ||
		!class_get_member_bool( root, MEMBER_VALUE, &toggle->value ) )
		return( FALSE );

	iobject_set( IOBJECT( classmodel ), NULL, buf );

	return( TRUE );
}

/* Make a new "fn caption value" application.
 */
static gboolean
toggle_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *heap = reduce_context->heap;
	Toggle *toggle = TOGGLE( classmodel );

	PElement rhs;

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, 
			IOBJECT( classmodel )->caption, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_bool_new( heap, toggle->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
toggle_class_init( ToggleClass *class )
{
	GObjectClass *gobject_class = (GObjectClass *) class;
	ModelClass *model_class = (ModelClass *) class;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) class;

	parent_class = g_type_class_peek_parent( class );

	/* Create signals.
	 */

	/* Init methods.
	 */
	gobject_class->finalize = toggle_finalize;

	model_class->view_new = toggleview_new;
	model_class->edit = toggle_edit;
	model_class->save = toggle_save;
	model_class->load = toggle_load;

	classmodel_class->class_get = toggle_class_get;
	classmodel_class->class_new = toggle_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( class ) );
}

static void
toggle_init( Toggle *toggle )
{
        toggle->value = FALSE;

	iobject_set( IOBJECT( toggle ), CLASS_TOGGLE, NULL );
}

GType
toggle_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( ToggleClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) toggle_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( Toggle ),
			32,             /* n_preallocs */
			(GInstanceInitFunc) toggle_init,
		};

		type = g_type_register_static( TYPE_CLASSMODEL, 
			"Toggle", &info, 0 );
	}

	return( type );
}

Classmodel *
toggle_new( Rhs *rhs )
{
	Toggle *tog;

	tog = TOGGLE( g_object_new( TYPE_TOGGLE, NULL ) );
	icontainer_child_add( ICONTAINER( rhs ), ICONTAINER( tog ), -1 );

	return( CLASSMODEL( tog ) );
}
