/* run the display for an arrow in a workspace 
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static GraphicviewClass *parent_class = NULL;

static void
groupview_destroy( GtkObject *object )
{
	Groupview *groupview;

#ifdef DEBUG
	printf( "groupview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_GROUPVIEW( object ) );

	groupview = GROUPVIEW( object );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void 
groupview_refresh( vObject *vobject )
{
	Groupview *groupview = GROUPVIEW( vobject );
	Group *group = GROUP( vobject->iobject );

#ifdef DEBUG
	printf( "groupview_refresh: " );
	row_name_print( HEAPMODEL( group )->row );
	printf( "\n" );
#endif /*DEBUG*/

	set_gcaption( groupview->label, "%s", 
		NN( IOBJECT( group )->caption ) );

	VOBJECT_CLASS( parent_class )->refresh( vobject );
}

static void
groupview_class_init( GroupviewClass *class )
{
	GtkObjectClass *object_class = (GtkObjectClass *) class;
	vObjectClass *vobject_class = (vObjectClass *) class;

	parent_class = g_type_class_peek_parent( class );

	object_class->destroy = groupview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	vobject_class->refresh = groupview_refresh;
}

static void
groupview_init( Groupview *groupview )
{
	GtkWidget *eb;

#ifdef DEBUG
	printf( "groupview_init\n" );
#endif /*DEBUG*/

        eb = gtk_event_box_new();
        gtk_box_pack_start( GTK_BOX( groupview ), eb, FALSE, FALSE, 0 );
	groupview->label = gtk_label_new( "" );
        gtk_misc_set_alignment( GTK_MISC( groupview->label ), 0, 0.5 );
        gtk_misc_set_padding( GTK_MISC( groupview->label ), 2, 0 );
        gtk_container_add( GTK_CONTAINER( eb ), groupview->label );
	set_name( eb, "caption_widget" );

        gtk_widget_show_all( GTK_WIDGET( eb ) );
}

GtkType
groupview_get_type( void )
{
	static GtkType groupview_type = 0;

	if( !groupview_type ) {
		static const GtkTypeInfo info = {
			"Groupview",
			sizeof( Groupview ),
			sizeof( GroupviewClass ),
			(GtkClassInitFunc) groupview_class_init,
			(GtkObjectInitFunc) groupview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		groupview_type = gtk_type_unique( TYPE_GRAPHICVIEW, &info );
	}

	return( groupview_type );
}

View *
groupview_new( void )
{
	Groupview *groupview = gtk_type_new( TYPE_GROUPVIEW );

	return( VIEW( groupview ) );
}
