/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <netdude/gtkhex.h>

#include <netdude/nd_debug.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_protocol_inst.h>
#include <netdude/nd.h>
#include <netdude/nd_raw_protocol.h>

#define ND_RAW_HEX_KEY "raw_hex"

/* These are the implementations of ND_Protocol's callbacks: */
static GtkWidget *raw_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf);
static void       raw_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf);
static void       raw_init_packet(ND_Packet *packet, guchar *data, guchar *data_end);
static gboolean   raw_header_complete(const ND_Packet *packet, guint nesting);


static ND_Protocol *raw = NULL;


void         
nd_raw_proto_init(void)
{
  if (!raw)
    {
      raw = nd_proto_new("(raw)", 0, 0);
	
      raw->create_gui      = raw_create_gui;
      raw->set_gui         = raw_set_gui;
      raw->init_packet     = raw_init_packet;
      raw->header_complete = raw_header_complete;
    }
}


ND_Protocol *
nd_raw_proto_get(void)
{
  return raw;
}


static gboolean
on_hex_changed(GtkWidget *widget,
	       int index,
	       int len,
	       gpointer user_data)
{
  ND_Trace *trace = user_data;

  nd_packet_modified(nd_trace_get_current_packet(trace));

  return FALSE;
  TOUCH(widget);
  TOUCH(index);
  TOUCH(len);
}

static gboolean
on_hex_destroy(GtkObject *object)
{
  nd_gui_del_monowidth_widget(GTK_WIDGET(object));
  return FALSE;
}

/* Protocol method implementations: ------------------------------------ */

static GtkWidget *
raw_create_gui(ND_Trace *trace, ND_ProtoInfo *pinf)
{
  GtkWidget *hex = gtk_hex_new();

  gtk_signal_connect(GTK_OBJECT(hex), "changed",
		     GTK_SIGNAL_FUNC(on_hex_changed),
		     trace);

  gtk_signal_connect(GTK_OBJECT(GTK_HEX(hex)->hex_text), "destroy",
		     GTK_SIGNAL_FUNC(on_hex_destroy),
		     trace);

  nd_proto_info_set_data(pinf, ND_RAW_HEX_KEY, hex);
  nd_gui_add_monowidth_widget(GTK_HEX(hex)->hex_text);  
  gtk_widget_show(hex);

  return hex;
}


static void       
raw_set_gui(const ND_Packet *packet, ND_ProtoInfo *pinf)
{
  guchar *data     = nd_packet_get_data(packet, raw, pinf->inst.nesting);
  guchar *data_end = nd_packet_get_data_end(packet, raw, pinf->inst.nesting);
  GtkHex *hex;
  
  if (!pinf)
    {
      D(("Protocol info for raw at %i not found\n", pinf->inst.nesting));
      return;
    }
  
  hex = nd_proto_info_get_data(pinf, ND_RAW_HEX_KEY);

  if (data != hex->data)
    gtk_hex_set_content(hex, data, data_end - data);
}


static void       
raw_init_packet(ND_Packet *packet, guchar *data, guchar *data_end)
{
  if (!packet || !data)
    return;

  if (data_end - data <= 0)
    return;

  nd_packet_add_proto_data(packet, raw, data, data_end);  
}


static gboolean
raw_header_complete(const ND_Packet *packet, guint nesting)
{
  /* For raw data there's no header, thus this is
     always complete and thus TRUE.
  */

  return TRUE;
  TOUCH(packet);
  TOUCH(nesting);
}
