/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <netdude/nd.h>
#include <netdude/nd_debug.h>
#include <netdude/nd_gui.h>
#include <netdude/nd_packet.h>
#include <netdude/nd_dialog.h>
#include <netdude/nd_misc.h>
#include <netdude/nd_packet_iterator.h>

#include <nd_snap.h>
#include <nd_proto_snap.h>
#include <nd_snap_callbacks.h>


void   
nd_snap_dsap_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct nd_snap_header *sh;

  sh = (struct nd_snap_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_snap_get(), data, data-header, TRUE);
  
  nd_dialog_number(_("Enter 8-bit DSAP:"),
		   ND_BASE_HEX,
		   sh->dsap, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet, &cb_data);
}


void   
nd_snap_ssap_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct nd_snap_header *sh;

  sh = (struct nd_snap_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_snap_get(), data, data-header, TRUE);

  nd_dialog_number(_("Enter 8-bit SSAP:"),
		   ND_BASE_HEX,
		   sh->ssap, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet, &cb_data);
}


void   
nd_snap_ctrl_cb(ND_Packet   *packet,
		guchar      *header,
		guchar      *data)
{
  static ND_ProtoCallbackData cb_data;
  struct nd_snap_header *sh;

  sh = (struct nd_snap_header *) header;
  nd_proto_cb_data_init(&cb_data, nd_snap_get(), data, data-header, FALSE);

  nd_dialog_number(_("Enter 8-bit control code:"),
		   ND_BASE_HEX,
		   sh->ctrl, 255,
		   nd_proto_iterate_8bit_cb,
		   NULL,
		   packet, &cb_data);
}


static void
snap_oui_ok_cb(ND_Packet *packet, void *user_data, guint value)
{
  ND_PacketIterator      pit;
  struct nd_snap_header *sh;
  guchar                *val;
  int                    nesting;

  nesting = nd_packet_get_proto_nesting(packet, nd_snap_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  val = (guchar *) &value;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      sh = (struct nd_snap_header *) nd_packet_get_data(nd_pit_get(&pit), nd_snap_get(), nesting);
      if (!sh)
	continue;
  
#ifdef WORDS_BIGENDIAN
      sh->oui[0] = val[0];
      sh->oui[1] = val[1];
      sh->oui[2] = val[2];
#else
      sh->oui[0] = val[2];
      sh->oui[1] = val[1];
      sh->oui[2] = val[0];
#endif
      nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
    }

  return;
  TOUCH(user_data);
}

void   
nd_snap_oui_cb(ND_Packet   *packet,
	       guchar      *header,
	       guchar      *data)
{
  guint32 value;
  struct  nd_snap_header *sh;

  sh = (struct nd_snap_header *) header;

#ifdef WORDS_BIGENDIAN
  value = (sh->oui[2] << 16) | (sh->oui[1] << 8) | (sh->oui[0]);
#else
  value = (sh->oui[0] << 16) | (sh->oui[1] << 8) | (sh->oui[2]);
#endif

  nd_dialog_number(_("Enter 24-bit OUI code:"),
		   ND_BASE_HEX,
		   value, (1<<24) - 1,
		   snap_oui_ok_cb,
		   NULL,
		   packet, data);
}


/* The callback that gets called when the user has clicked
   one of the predefined Ethernet protocol values: */
void    
nd_snap_proto_value_cb(ND_Packet   *packet,
		       guchar      *header,
		       int          value)
{
  struct nd_snap_header *sh;
  ND_PacketIterator      pit;
  int                    nesting;

  nesting = nd_packet_get_proto_nesting(packet, nd_snap_get(), header);
  if (nesting < 0)
    return;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      sh = (struct nd_snap_header *) nd_packet_get_data(nd_pit_get(&pit), nd_snap_get(), nesting);
      if (!sh)
	continue;

      sh->proto = htons(value);
      nd_packet_update(packet, nd_snap_get(), nesting);
      nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
    }

  return;
  TOUCH(header);
}


/* The callback that gets called when the user selected "Custom"
   from the Ethernet protocol type menu, and then clicked "Okay": */
static void
snap_proto_custom_okay_cb(ND_Packet *packet, void *user_data, guint value)
{
  struct nd_snap_header *sh;
  ND_PacketIterator      pit;
  int                    nesting;

  nesting = nd_packet_get_proto_nesting(packet, nd_snap_get(), (guchar*) user_data);
  if (nesting < 0)
    return;

  for (nd_pit_init(&pit, packet->trace, TRUE); nd_pit_get(&pit); nd_pit_next(&pit))
    {
      sh = (struct nd_snap_header *) nd_packet_get_data(nd_pit_get(&pit), nd_snap_get(), nesting);
      if (!sh)
	continue;

      sh->proto = htons((u_int16_t) value);
      nd_packet_update(packet, nd_snap_get(), nesting);
      nd_packet_modified_at_index(nd_pit_get(&pit), nd_pit_get_index(&pit));
    }

  return;
  TOUCH(user_data);
}


/* The callback that gets called when the user selected "Custom"
   from the SNAP protocol type menu: */
void    
nd_snap_proto_custom_cb(ND_Packet   *packet,
			guchar      *header,
			int          value)
{
  struct nd_snap_header   *sh;
  
  sh = (struct nd_snap_header *) header;
  nd_dialog_number(_("Enter protocol number:"),
		   ND_BASE_DEC,
		   ntohs(sh->proto),
		   65535,
		   snap_proto_custom_okay_cb,
		   NULL,
		   packet, header);

  return;
  TOUCH(value);
}


/* The callback that gets called when the user clicks the button
   for the Ethernet protocol type in the table. Pops up the menu. */
void
nd_snap_proto_cb(ND_Packet   *packet,
		 guchar      *header,
		 guchar      *data)
{
  static GtkWidget *menu = NULL;

  if (!menu)
    menu = nd_gui_create_menu(snap_menu_type_data);

  gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);
      
  return;
  TOUCH(header);
  TOUCH(packet);
  TOUCH(data);
}


