#
# This script was written by George A. Theall, <theall@tifaware.com>.
#
# See the Nessus Scripts License for details.
#
 
if (description) {
  script_id(16339);
  script_version("$Revision: 1.2 $");
  script_bugtraq_id(12504);
  script_cve_id("CAN-2005-0202");
 
  name["english"] = "Mailman private.py Directory Traversal Vulnerability";
  script_name(english:name["english"]);
 
  desc["english"] = "

The target is running a version of the Mailman mailing list software
that might suffer from a directory traversal vulnerability in
Cgi/private.py.  This flaw comes into play only on web servers that
don't strip extraneous slashes from URLs, such as Apache 1.3.x, and
allows a list subscriber, using a specially crafted web request, to
retrieve arbitrary files from the server - any file accessible by the
user under which the web server operates, including email addresses
and passwords of subscribers of any lists hosted on the server. 

***** Nessus has determined the vulnerability exists on the target
***** simply by looking at the version number of Mailman installed
***** there.

See also : http://lists.netsys.com/pipermail/full-disclosure/2005-February/031562.html

Solution : Upgrade to Mailman 2.1.6 as soon as it becomes available or
apply the fix described in the URL above.

Risk factor : High";
  script_description(english:desc["english"]);

  summary["english"] = "Checks for Mailman private.py Directory Traversal Vulnerability";
  script_summary(english:summary["english"]);

  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2005 George A. Theall");

  family["english"] = "Remote file access";
  script_family(english:family["english"]);

  script_dependencie("global_settings.nasl", "mailman_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("global_settings.inc");
include("http_func.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
debug_print("checking for Mailman private.py Directory Traversal Vulnerability on port ", port, ".\n");

# Check each installed instance, stopping if we find a vulnerability.
installs = get_kb_list(string("www/", port, "/Mailman"));
if (isnull(installs)) exit(0);
foreach install (installs) {
  matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
  if (!isnull(matches)) {
    ver = matches[1];
    dir = matches[2];
    debug_print("checking version ", ver, " under ", dir, ".");

    if (ereg(pattern:"^2\.(0|(1|1\.[1-5]([^0-9]|$)))", string:ver)) {
      security_hole(port);
      exit(0);
    }
  }
}
