#TRUSTED ac12444f0c37b0f25dacce9c139c70d3b3600ef68e76e87a770d0a4c088e36c97196655052f59f4c1dd4131ac9077a655f50fa709a60be868a9cb127b074e112c50f11f3bf9a991c40f03e4dee52b77d3394d0e1c3deb3936bccabd5fb9c7b9be459eefd45907d5926bb62d69b774b08745e95aad16eca5965beccdcb672e5cb67db3c528fc5497bd493ee19c0bc61b84e6bf07300e66af5f266aa1bd0aa545de9c84dc59fb6f30e4c9e5faa44ef85fed03cd00f3cad72232b5e12d66c3a16b0d5b7266fea8a13c036ed2df1809134a0955a7d7a6f1a7a5d8ad95c075bac6c6b6dae2639767987e69b0429bf7863e5c29cf89470de0505efae7b81f197e1e60ae6f849f4efdd4825dd71c596e8b6678a1d9e2b32c6529817d32194c2e4f7f6e0f92f75a1a3c7af735d8109ddccc1356df82fc97b5713a31adbab9a448cd781672b9cdd895300b43b5d7c8347a538514490ffae2163eb88ed82af0c843d28859fffbe3b1edde15df00ffea8007c3e5030c24da11c8bcf82f24bb1e4e025c5217562ea5cd8cbed0d3d5b030798c5d2f71ede3cf2a52d141cae29d6954452e7880675d7d594d64123f885985356e4d5b7d880cb683c6e9bbdb4611fde9fcccee54a75ddeb094605be56960ed7a790e044ceb8aab2e49e48bc633862e1f21c5530703288d259ac414937cea22683d908b601e92d10a4ef41c297eda44e274f36a209
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15871);
 script_version ("1.1");
 name["english"] = "Hydra: CVS";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find CVS accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force CVS authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/cvspserver", 2401);
 script_dependencies("hydra_options.nasl", "find_service.nes", "cvs_detect.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/cvspserver");
if (! port) port = 2401;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "cvs";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/cvs/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following CVS accounts:\n' + report);
