#include "query.h"
#include "mdiwindow.h"
#include "mainwindow.h"
#include "include/sql.h"

#include <qmessagebox.h>
#include <qstatusbar.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <qclipboard.h>

void Query::slot_database()
{
	QList<QString> value;
	value = ((MainWindow *)qApp->mainWidget())->database->get_value();

	database->slot_value(value);
}

void Query::slot_close()
{
	if(exit == FALSE)
	{
		exit = TRUE;
		save_sql();
		parentWidget()->close();
	}
}

void Query::slot_delete()
{
	sql1->clear();				
	sql2->slot_clear();
}

void Query::slot_undo()
{
	sql1->undo();
}

void Query::slot_redo()
{
	sql1->redo();
}

void Query::slot_cut()
{
	sql1->cut();
}

void Query::slot_copy()
{
	sql1->copy();
}

void Query::slot_paste()
{
	sql1->paste();
}

void Query::slot_select_all()
{
	sql1->selectAll();
}

void Query::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), "This is Query"); 
}

void Query::slot_fire()
{
	((QMainWindow *)parentWidget())->statusBar()->message("");

	if(mysql_select_db(mysql, database->currentText().latin1()))
		return;

	if(this->sql1->text().isEmpty())
		return;

	QString sql = SQL::strip_comment(this->sql1->text().local8Bit().data());
	QList<QString> z = SQL::split_sql(sql);
	z.setAutoDelete(TRUE);

	for(unsigned int s = 0; s < z.count(); s++)
	{
		if((*z.at(s)).stripWhiteSpace().isEmpty())
			continue;

		sql2->set_sql(database->currentText(), (*z.at(s)).stripWhiteSpace());
		
		if(sql2->is_select())
			sql3->set_sql(database->currentText(), QString("explain ") + (*z.at(s)).stripWhiteSpace());
		
		sql3->slot_clear();
		
		switch(sql2->execute())
		{
			case SQL_SCHEMA:
				emit signal_schema();
				continue;
			case SQL_UPDATE:
				continue;
		}
		
		if(sql2->is_select())
			sql3->execute();	
	}

	value->setCurrentPage(0);

	if(query->currentText().isEmpty() == FALSE)
	{
		struct sql_data data;
		data.database = database->currentText();
		data.sql = this->sql1->text().local8Bit();

		sql_map.replace(query->currentText(), data);

		if(is_exist_in_query(query->currentText()) == FALSE)
			query->insertItem(query->currentText());
	}
}

void Query::slot_sql(const QString &s)
{
	struct sql_data data;

	if(sql_map.find(s) != sql_map.end())
	{
		data = sql_map.find(s).data();

		slot_database(data.database);

		this->sql1->setText(QString::fromLocal8Bit(data.sql));

		sql2->slot_clear();
		sql3->slot_clear();
		value->setCurrentPage(0);
		((QMainWindow *)parentWidget())->statusBar()->message("");
	}
}

void Query::slot_sql(const QString &sql, bool)
{
	this->sql1->setText(QString::fromLocal8Bit(sql));
}


void Query::slot_database(const QString &value)
{
	for(int z = 0; z < database->count(); z++)
	{
		if(value == database->text(z))
		{
			database->setCurrentItem(z);
			database->data = value;
			break;
		}
	}
}

void Query::slot_import()
{
	QString sql = QFileDialog::getOpenFileName(QString::null, "*.sql", this);

	if(sql.isEmpty())
		return;
	
	QFile query(sql);

	if(!query.open(IO_ReadOnly))
	{
		return;
	}

	char *value = new char[query.size() + 1];
	memset(value, 0, query.size() + 1);

	query.readBlock(value, query.size());

	this->sql1->setAutoUpdate(FALSE);
	this->sql1->setText(QString::fromLocal8Bit(value));
	this->sql1->setAutoUpdate(TRUE);
	this->sql1->repaint();

	delete value;
}

void Query::slot_export()
{
	QString sql = QFileDialog::getSaveFileName(QString::null, "*.sql", this);

	if(sql.isEmpty())
		return;
	
	QFile query(sql);
 
	if (!query.open(IO_WriteOnly)) 
	{
	    return;
	}

	query.writeBlock(this->sql1->text().local8Bit().data(), this->sql1->text().length());

	query.close();
}

void Query::slot_clear_query()
{
	query->clear();
	sql_map.clear();
}

void Query::slot_clipboard()
{
	QClipboard *z = QApplication::clipboard();
    QString s;

    s = z->text();
    if(s.isEmpty() == FALSE)
        this->sql1->setText(s);
}