#include "mainwindow.h"
#include <qmessagebox.h>

void MainWindow::signal_connect()
{
	connect(query, SIGNAL(activated(const QString &)), this, SLOT(slot_query()));
	connect((const QObject *)menuBar(), SIGNAL(highlighted(int)), (const QObject *)this, SLOT(slot_highlight(int)));
	connect((const QObject *)workspace, SIGNAL(signal_workspace_clicked()), (const QObject *)this,SLOT(slot_workspace_clicked()));
}

void MainWindow::keyPressEvent(QKeyEvent *s)
{
	QWidget::keyPressEvent(s);
}

void MainWindow::closeEvent(QCloseEvent *s)
{
	if(option.exit)
	{
		switch(QMessageBox::warning(this, tr("MySQL Navigator"), tr("Are you sure you want to exit MySQL Navigator ?"), "&Yes", "&No", 0, 0, 1 ))
		{
			case 1: 
			return;
			break;
		}
	}

	if(option.clear)
		query->clear();

	if(open)
		slot_quit();

	save_session();
		
	s->accept();
}

void MainWindow::resizeEvent(QResizeEvent *z)
{
	option.size = z->size();
	QMainWindow::resizeEvent(z);
}
