// processfun.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// ProcessFunction is a subclass of Modifier that includes all routines
// that alter the contents of a Data subclass via iterative operations on the
// samples.
// ProcessFunction is abstract because its DataModifier methods are not
// redefined.

#ifndef PROCESSFUN_H
#ifdef __GNUG__
#pragma interface
#endif
#define PROCESSFUN_H

#include "datamodifier.h"

class Data;
class DataEditor;

class ProcessFunction : public DataModifier {
public:
	ProcessFunction(Data* d, bool needUndo) : DataModifier(d, needUndo) {}
	virtual void restoreState() {}
};

// a SimpleFunction takes a single double input and returns a double

class SimpleFunction : public ProcessFunction {
	typedef ProcessFunction Super;
public:
	SimpleFunction(Data* d, bool needUndo) : ProcessFunction(d, needUndo) {}
	virtual void operator () (double *input, int count) = 0;
protected:
	redefined int doApply(Data *);
};

// abstract base class for simple functions with only one factor

class SingleFactorFunction : public SimpleFunction {
	typedef SimpleFunction Super;
	friend class SingleFactorRequester;
protected:
	SingleFactorFunction(Data *, double defaultVal, bool needUndo);
	double _factor;
};

// this does f(x) = x + n

class Offset : public SingleFactorFunction {
	typedef SingleFactorFunction Super;
public:
	Offset(Data* d, double val);
	Offset(Data* d);
	static Modifier* create(DataEditor*);
	redefined void operator () (double *input, int count);
	redefined const char* message() { return "Adding offset..."; }
	redefined Modifier* createUndo();
protected:
	redefined Requester* createRequester();
	redefined void saveConfig();
	redefined Status doConfigure(Controller *);
private:
	static double _savedOffset;
};

// this does f(x) = rx

class Scaler : public SingleFactorFunction {
	typedef SingleFactorFunction Super;
public:
	Scaler(Data* d, double val, bool needUndo=false);
	Scaler(Data* d, bool needUndo=true);
	static Modifier* create(DataEditor*);
	redefined void operator () (double *input, int count);
	redefined const char* message() {
		return (_factor == 0.0) ? "Erasing..." : "Scaling...";
	}
	redefined Modifier* createUndo();
protected:
	redefined Requester* createRequester();
	redefined void saveConfig();
	redefined Status doConfigure(Controller *);
private:
	static double _savedFactor;
};

class Eraser : public Scaler {
public:
	Eraser(Data* d);
	static Modifier* create(DataEditor*);
	redefined Modifier* createUndo();
protected:
	redefined Requester* createRequester() { return nil; }
};

#endif
