float fir_coeff[72] = {
               0.000709,        0.000686,        0.000440,       -0.000018,
              -0.000618,       -0.001198,       -0.001520,       -0.001332,
              -0.000493,        0.000909,        0.002494,        0.003648,
               0.003711,        0.002258,       -0.000630,       -0.004235,
              -0.007308,       -0.008433,       -0.006559,       -0.001538,
               0.005567,        0.012568,        0.016708,        0.015557,
               0.008024,       -0.004897,       -0.019931,       -0.032062,
              -0.035748,       -0.026514,       -0.002471,        0.034724,
               0.079822,        0.124956,        0.161417,        0.181779,
               0.181779,        0.161417,        0.124956,        0.079822,
               0.034724,       -0.002471,       -0.026514,       -0.035748,
              -0.032062,       -0.019931,       -0.004897,        0.008024,
               0.015557,        0.016708,        0.012568,        0.005567,
              -0.001538,       -0.006559,       -0.008433,       -0.007308,
              -0.004235,       -0.000630,        0.002258,        0.003711,
               0.003648,        0.002494,        0.000909,       -0.000493,
              -0.001332,       -0.001520,       -0.001198,       -0.000618,
              -0.000018,        0.000440,        0.000686,        0.000709
};

#include <stdio.h>
#define UPSAMP 3
#define FILTLEN (sizeof(fir_coeff)/sizeof(fir_coeff[0])/UPSAMP)

void main(void)
{
	const float *f;
	int i, j;
	
	printf("#define FILTLEN %d\n"
	       "#define UPSAMP %d\n"
	       "static const float inp_filt[%d][%d] = {\n\t", FILTLEN, UPSAMP, UPSAMP, FILTLEN);
	for (i = 0; i < UPSAMP; i++) {
		printf("{");
		for (j = 0, f = fir_coeff+i; j < FILTLEN; j++, f += UPSAMP) 
			printf("%10f%s", *f, (j < FILTLEN-1) ? (((j & 3) == 3) ? ",\n\t " : ",") : "");
		printf("}%s", (i < UPSAMP-1) ? ",\n\t" : "");
	}
	printf("\n};\n\n");
	exit(0);
}
	       
