/*

    mp_video.h

    Video driver definitions.

    mp - Programmer Text Editor

    Copyright (C) 1991-2001 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

*/

extern int _mpv_x_size;
extern int _mpv_y_size;

/* colors */

#define MP_COLOR_NORMAL 	1
#define MP_COLOR_SELECTED	2
#define MP_COLOR_COMMENT	3
#define MP_COLOR_STRING 	4
#define MP_COLOR_TOKEN		5
#define MP_COLOR_VAR		6
#define MP_COLOR_CURSOR 	7
#define MP_COLOR_CAPS		8
#define MP_COLOR_LOCAL		9
#define MP_COLOR_NUM		MP_COLOR_LOCAL

/* keys */

#define MPK_UP			0x1000
#define MPK_DOWN		0x1001
#define MPK_LEFT		0x1002
#define MPK_RIGHT		0x1003
#define MPK_PGUP		0x1004
#define MPK_PGDN		0x1005
#define MPK_BOL 		0x1006
#define MPK_EOL 		0x1007
#define MPK_BOF 		0x1008
#define MPK_EOF 		0x1009
#define MPK_FNUP		0x100a
#define MPK_FNDN		0x100b
#define MPK_WORDLEFT		0x100c
#define MPK_WORDRIGHT		0x100d
#define MPK_GOTO		0x100e
#define MPK_SEEK		0x100f
#define MPK_SEEKNEXT		0x1010
#define MPK_TOGGLECASE		0x1011
#define MPK_COMPLETION		0x1012

#define MPK_INSMODE		0x1100
#define MPK_BACKSPC		0x1101
#define MPK_DELCHAR		0x1102
#define MPK_DELLINE		0x1103
#define MPK_REPLACE		0x1104
#define MPK_REPLACE_ALL 	0x1105

#define MPK_MARK		0x1200
#define MPK_UNMARK		0x1201
#define MPK_COPY		0x1202
#define MPK_PASTE		0x1203
#define MPK_CUT 		0x1204

#define MPK_NEW 		0x2000
#define MPK_OPEN		0x2001
#define MPK_SAVE		0x2002
#define MPK_SAVEAS		0x2003
#define MPK_CLOSE		0x2004
#define MPK_NEXT		0x2005
#define MPK_HELP		0x2006
#define MPK_TAG 		0x2007
#define MPK_RECORDMACRO 	0x2008
#define MPK_MAKE		0x2009
#define MPK_EXIT		0x200a
#define MPK_ZOOM		0x200b
#define MPK_UNZOOM		0x200c
#define MPK_OPEN2		0x200d
#define MPK_ABOUT		0x200e
#define MPK_PLAYMACRO		0x200f
#define MPK_EXEC		0x2010
#define MPK_REOPEN		0x2011

#define MPK_SHIFT		0x2100
#define MPK_MENU		0x2101
#define MPK_SAVETABS		0x2102
#define MPK_AUTOINDENT		0x2103
#define MPK_WORDWRAP		0x2104
#define MPK_TABSIZE		0x2105
#define MPK_CRLF		0x2106
#define MPK_KEYHELP		0x2107
#define MPK_COL80		0x2108
#define MPK_TEMPLATE		0x2109
#define MPK_EDITTMPL		0x210a

#define MPK_NONE		0x2200
#define MPK_CANCEL		0x2201

#define MPK_ESCAPE		MPK_SHIFT
#define MPK_CLEARLINE		MPK_TEMPLATE

/* mpv_readline types */

#define MPR_OPEN		0x0001
#define MPR_SAVE		0x0002
#define MPR_SEEK		0x0003
#define MPR_GOTO		0x0004
#define MPR_REPLACETHIS 	0x0005
#define MPR_REPLACEWITH 	0x0006
#define MPR_TAG 		0x0007
#define MPR_EXEC		0x0008
#define MPR_WORDWRAP		0x0009
#define MPR_TABSIZE		0x000a
#define MPR_LAST		MPR_TABSIZE

int mpv_strcasecmp(char * s1, char * s2);

void mpv_goto(int x, int y);
void mpv_char(int c, int color);
void mpv_str(char * str, int color);
void mpv_cursor(int x, int y);
void mpv_refresh(void);

void mpv_title(char * str);
void mpv_status_line(char * str);

void mpv_add_menu(char * label);
void mpv_add_menu_item(char * label, int key, int * toggle);
int mpv_menu(void);

void mpv_alert(char * msg, char * msg2);
int mpv_confirm(char * prompt);
int mpv_list(char * title, mp_txt * txt);
char * mpv_readline(int type, char * prompt, char * def);

void mpv_about(void);
int mpv_help(char * term, int synhi);
int mpv_zoom(int inc);

void mpv_scrollbar(int pos, int size, int max);
void mpv_filetabs(void);

int mpv_startup(void);
void mpv_shutdown(void);
