// -*- c++ -*-
#ifndef INCLUDED_MATH3D_MLINE_H
#define INCLUDED_MATH3D_MLINE_H
/*
 * Math3d - The 3D Computer Graphics Math Library
 * Copyright (C) 1996-2000 by J.E. Hoffmann <je-h@gmx.net>
 * All rights reserved.
 *
 * This program is  free  software;  you can redistribute it and/or modify it
 * under the terms of the  GNU Lesser General Public License  as published by 
 * the  Free Software Foundation;  either version 2.1 of the License,  or (at 
 * your option) any later version.
 *
 * This  program  is  distributed in  the  hope that it will  be useful,  but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or  FITNESS FOR A  PARTICULAR PURPOSE.  See the  GNU Lesser General Public  
 * License for more details.
 *
 * You should  have received  a copy of the GNU Lesser General Public License
 * along with  this program;  if not, write to the  Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mline.h,v 1.1 2000/10/09 17:55:51 jeh Exp $
 */

#ifndef INCLUDED_MATH3D_M3D_H
#include <math3d/m3d.h>
#endif

namespace Math3d {
  
/** 
 * 3-dimensional line.
 */
  class _CCMATH3D MLine {
    protected:
      M3d d_p1;
      M3d d_p2;
    public:
      MLine();
      MLine(const M3d& p1, const M3d& p2);
      MLine(const MLine& line);

      const MLine& operator=(const MLine& line);
      void copy(const MLine& l);
      
      M3d getP1() const {return(d_p1);}
      M3d getP2() const {return(d_p2);}

      bool operator==(const MLine& l) const;
      bool operator!=(const MLine& l) const;
      bool cmp(const MLine& l, double epsilon=EPSILON) const;
  };
  
}
#endif // INCLUDED_MATH3D_MLINE_H





