"""Copyright (c) 1999-2002 Ng Pheng Siong. All rights reserved."""

RCS_id='$Id: ssl_dispatcher.py,v 1.4 2002/12/23 03:56:38 ngps Exp $'

# Python
import asyncore, socket

# M2Crypto
from Connection import Connection
from M2Crypto import Err, m2


class ssl_dispatcher(asyncore.dispatcher):

    def create_socket(self, ssl_context):
        self.family_and_type=socket.AF_INET, socket.SOCK_STREAM
        self.ssl_ctx=ssl_context
        self.socket=Connection(self.ssl_ctx)
        #self.socket.setblocking(0)
        self.add_channel()

    def connect(self, addr):
        self.socket.setblocking(1)
        self.socket.connect(addr)
        self.socket.setblocking(0)

    def recv(self, buffer_size=4096):
        """Receive data over SSL."""
        return self.socket.recv(buffer_size)

    def send(self, buffer):
        """Send data over SSL."""
        return self.socket.send(buffer)

