#GPL
#GPL  libwhisker copyright 2000,2001,2002 by rfp.labs
#GPL
#GPL  This program is free software; you can redistribute it and/or
#GPL  modify it under the terms of the GNU General Public License
#GPL  as published by the Free Software Foundation; either version 2
#GPL  of the License, or (at your option) any later version.
#GPL
#GPL  This program is distributed in the hope that it will be useful,
#GPL  but WITHOUT ANY WARRANTY; without even the implied warranty of
#GPL  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GPL  GNU General Public License for more details.
#GPL

=pod    

=head1 ++ Sub package: encode

Various type encodings.  Installing MIME::Base64 will result in a 
compiled C version of base64 functions, which means they will be tons 
faster.  This is useful if you're going to run a Basic authentication 
brute force, which requires a high processing speed.  However, it's not 
required, since I include a Perl version, which is slower.

=cut

########################################################################

=pod    

=head1 - Function: LW::encode_base64
  
Params: $data, $eol
Return: $base64_encoded_data
        
LW::encode_base64 is a stub function which will choose the fastest
function available for doing base64 encoding.  This is done by checking to
see if the MIME::Base64 perl module is available (which uses fast C
routines).  If it's not, then it defaults to a perl version (which is
slower).  You can call the perl version direct, but I suggest using the
stub to gain speed advantages where possible.

=cut

#sub encode_base64;


########################################################################

=pod    

=head1 - Function: LW::decode_base64
  
Params: $data
Return: $base64_decoded_data
        
LW::decode_base64 is a stub function which will choose the fastest
function available for doing base64 decoding.  This is done by checking to
see if the MIME::Base64 perl module is available (which uses fast C
routines).  If it's not, then it defaults to a perl version (which is
slower).  You can call the perl version direct, but I suggest using the
stub to gain speed advantages where possible.

=cut

#sub decode_base64;


########################################################################

=pod    

=head1 - Function: LW::encode_base64_perl
        
Params: $data, $eol
Return: $b64_encoded_data

A perl implementation of base64 encoding.  I recommend you use
LW::encode_base64 instead, since it may use the MIME::Base64 module (if
available), which lead to speed advantages.  The perl code for this
function was actually taken from an older MIME::Base64 perl module, and
bears the following copyright:

Copyright 1995-1999 Gisle Aas <gisle@aas.no>

NOTE: the $eol parameter will be inserted every 76 characters.  This is
used to format the data for output on a 80 character wide terminal.

=cut

sub encode_base64_perl { # ripped from MIME::Base64
    my $res = "";
    my $eol = $_[1];
    $eol = "\n" unless defined $eol;
    pos($_[0]) = 0;
    while ($_[0] =~ /(.{1,45})/gs) {
        $res .= substr(pack('u', $1), 1);
        chop($res);}
    $res =~ tr|` -_|AA-Za-z0-9+/|;
    my $padding = (3 - length($_[0]) % 3) % 3;
    $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
    if (length $eol) {
        $res =~ s/(.{1,76})/$1$eol/g;
    } $res; }


########################################################################

=pod    

=head1 - Function: LW::decode_base64_perl
  
Params: $data
Return: $b64_decoded_data

A perl implementation of base64 decoding.  The perl code for this function
was actually taken from an older MIME::Base64 perl module, and bears the 
following copyright:

Copyright 1995-1999 Gisle Aas <gisle@aas.no>

=cut

sub decode_base64_perl { # ripped from MIME::Base64
    my $str = shift;
    my $res = "";
    $str =~ tr|A-Za-z0-9+=/||cd;
    $str =~ s/=+$//;                        # remove padding
    $str =~ tr|A-Za-z0-9+/| -_|;            # convert to uuencoded format
    while ($str =~ /(.{1,60})/gs) {
        my $len = chr(32 + length($1)*3/4); # compute length byte
        $res .= unpack("u", $len . $1 );    # uudecode
    }$res;}


########################################################################

=pod    

=head1 - Function: LW::encode_str2uri
  
Params: $data
Return: $result

This function encodes every character (except the / character) with normal 
URL hex encoding.

=cut

sub encode_str2uri { # normal hex encoding
	my $str=shift;
	$str=~s/([^\/])/sprintf("%%%02x",ord($1))/ge;
	return $str;}


#########################################################################

=pod    

=head1 - Function: LW::encode_str2ruri
  
Params: $data
Return: $result

This function randomly encodes characters (except the / character) with 
normal URL hex encoding.

=cut

sub encode_str2ruri { # random normal hex encoding
    my @T=split(//,shift);
    my $s;
    foreach (@T) {
     if(m#;=:&@\?#){
        $s.=$_;
        next;
      }
      if((rand()*2)%2 == 1){	$s.=sprintf("%%%02x",ord($_)) ;
      }else{			$s.=$_; }
    }
    return $s;
}

#########################################################################

=pod    

=head1 - Function: LW::encode_unicode
  
Params: $data
Return: $result

This function converts a normal string into Windows unicode format.

=cut

sub encode_unicode
{
	my $r='';
 	foreach $c (split(//,shift)){
		$r.=pack("v",ord($c));
	}
	return $r;
}

#########################################################################