#GPL
#GPL  libwhisker copyright 2000,2001,2002 by rfp.labs
#GPL
#GPL  This program is free software; you can redistribute it and/or
#GPL  modify it under the terms of the GNU General Public License
#GPL  as published by the Free Software Foundation; either version 2
#GPL  of the License, or (at your option) any later version.
#GPL
#GPL  This program is distributed in the hope that it will be useful,
#GPL  but WITHOUT ANY WARRANTY; without even the implied warranty of
#GPL  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GPL  GNU General Public License for more details.
#GPL

=pod


=head1 ++ Sub package: anti-ids

The anti-ids sub package implements management routines for various
rewriting/encoding in order to evade intrusion detection systems.

=cut

########################################################################

=pod

=head1 - Function: LW::anti_ids

Params: \%hin, $modes
Return: nothing

LW::anti_ids computes the proper anti-ids encoding/tricks specified by
$modes, and sets up %hin in order to use those tricks.  Valid modes
are (the mode numbers are the same as those found in whisker 1.4):

1 -	Encode some of the characters via normal URL encoding
2 -	Insert directory self-references (/./)
3 -	Premature URL ending (make it appear the request line is done)
4 -	Prepend a long random string in the form of "/string/../URL"
5 -	Add a fake URL parameter
6 -	Use a tab instead of a space as a request spacer
7 -	Change the case of the URL around (works against Windows and Novell)
8 -	Change normal seperators ('/') to Windows version ('\')
9 -	Session splicing (sending data in multiple packets)

You can set multiple modes by setting the string to contain all the modes
desired; i.e. $modes="146" will use modes 1, 4, and 6.

=cut


sub anti_ids {
	my ($rhin,$modes)=(shift,shift);
	my (@T,$x,$c,$s,$y);
	my $ENCODED=0;
	my $W = $$rhin{'whisker'};

	return if(!(defined $rhin && ref($rhin)));

	# in case they didn't do it already
	$$rhin{'whisker'}->{'uri_orig'}=$$rhin{'whisker'}->{'uri'};

	# note: order is important!

	# mode 9 - session splicing
	if($modes=~/9/){
		$$rhin{'whisker'}->{'ids_session_splice'}=1;
	}

	# mode 4 - prepend long random string
	if($modes=~/4/){$s='';
		if($$W{'uri'}=~m#^/#){
			$y=&utils_randstr;
			$s.=$y while(length($s)<512);
			$$W{'uri'}="/$s/..".$$W{'uri'};
		}
	}

	# mode 7  - (windows) random case sensitivity
	if($modes=~/7/){ 
		@T=split(//,$$W{'uri'});
		for($x=0;$x<(scalar @T);$x++){
			if((rand()*2)%2 == 1){
				$T[$x]=uc($T[$x]);}}
		$$W{'uri'}=join('',@T);
	}

	# mode 2 - directory self-reference (/./)
	if($modes=~/2/){
		$$W{'uri'}=~s#/#/./#g;
	}


	# mode 8 - windows directory separator (\)
	if($modes=~/8/){
		$$W{'uri'}=~s#/#\\#g;
		$$W{'uri'}=~s#^\\#/#;
		$$W{'uri'}=~s#^(http|file|ftp|nntp|news|telnet):\\#$1://#;
		$$W{'uri'}=~s#\\$#/#;
	}

	# mode 1 - random URI (non-UTF8) encoding
	if($modes=~/1/){
		if($ENCODED==0){
			$$W{'uri'}=encode_str2ruri($$W{'uri'});
		$ENCODED=1;}
	}	


	# mode 5 - fake parameter
	if($modes=~/5/){ 
		($s,$y)=(&utils_randstr,&utils_randstr); 
		$$W{'uri'}="/$s.html%3f$y=/../$$W{'uri'}";
	}

	# mode 3 - premature URL ending
	if($modes=~/3/){ 
		$s=&utils_randstr;
		$$W{'uri'}="/%20HTTP/1.1%0D%0A%0D%0AAccept%3A%20$s/../..$$W{'uri'}";
	}
	
	# mode 6 - TAB as request spacer
	if($modes=~/6/){
		$$W{'req_spacer'}="\t";
	}	

} # end anti_ids



