#!/do/not/bash
# toc_run_description = looking for ${@-pkg-config}

# toc_begin_help =

# This test plays 2 roles:

# 1) if called with no arguments, it searches for the pkg-config tool
#    and returns 0 if found or non-zero if not found.

# 2) if called with arguments it calls pkg-config --exists on each $@.
#    If any search fails this test will return non-zero.

# It exports the following variables:

#	PKG_CONFIG_BIN = /path/to/pkg-config or empty string if not found.
#
# = toc_end_help

if [ x = "x${PKG_CONFIG_BIN}" ] ; then
    toc_find pkg-config
    ret=$?
    toc_export PKG_CONFIG_BIN=${TOC_FIND_RESULT}
fi

if [ x = "x${PKG_CONFIG_BIN}" ] ; then
    return 1
fi

if [ x = "x$1" ]; then
    return $ret
fi

for i in "$@"; do
    echo -ne "?   pkg-config --exists $i ... "
    if ${PKG_CONFIG_BIN} --exists $i ; then
        echo "${TOC_EMOTICON_OKAY}"
    else
        echo "${TOC_EMOTICON_WARNING}"
        ret=1
    fi
done

return $ret

