#ifndef S11N_NS_SAM_STANDARD_SPECIALIZATIONS_H
#define S11N_NS_SAM_STANDARD_SPECIALIZATIONS_H 1
////////////////////////////////////////////////////////////////////////
// some SAM specializations for common container types.
////////////////////////////////////////////////////////////////////////
#include <S11N_NS/class_name.h>
#include <map>
#include <list>
#include <utility> // pair
#include <vector>
#include <set>

#include <S11N_NS/map.h> // map/pair proxy functor
#include <S11N_NS/list.h> // list proxy functor
namespace {


        ////////////////////////////////////////////////////////////
        // std::list
        template <typename ValueType>
        struct class_name< std::list<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::list<ValueType> list_type;
                static bool cl_reg_placeholder;
                static const char * name()
                {
                        static std::string n =
                                std::string("std::list<")
                                + ::classname<value_type>() 
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                S11N_NS::classloader_register<
                                        list_type,list_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };
        template <typename VT>
        bool class_name< std::list<VT> >::cl_reg_placeholder = (::classname< std::list<VT> >(),false);

        template <typename ValueType>
        struct s11n_api_marshaler< std::list<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::list<ValueType> serializable_type;
                typedef S11N_NS::list::list_serializer_proxy proxy_type;

                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };
        // end std::list
        ////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////
        // std::vector
        template <typename ValueType>
        struct class_name< std::vector<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::vector<ValueType> vector_type;
                static bool cl_reg_placeholder;
                static const char * name()
                {
                        static std::string n =
                                std::string("std::vector<")
                                + ::classname<value_type>()
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                S11N_NS::classloader_register<
                                        vector_type,vector_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };
        template <typename VT>
        bool class_name< std::vector<VT> >::cl_reg_placeholder = (::classname< std::vector<VT> >(),false);

        template <typename ValueType>
        struct s11n_api_marshaler< std::vector<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::vector<ValueType> serializable_type;
                typedef S11N_NS::list::list_serializer_proxy proxy_type;

                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };

        // end std::vector
        ////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////
        // std::set
        template <typename ValueType>
        struct class_name< std::set<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::set<ValueType> set_type;
                static bool cl_reg_placeholder;
                static const char * name()
                {
                        static std::string n =
                                std::string("std::set<")
                                + ::classname<value_type>() 
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                S11N_NS::classloader_register<
                                        set_type,set_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };
        template <typename VT>
        bool class_name< std::set<VT> >::cl_reg_placeholder = (::classname< std::set<VT> >(),false);

        template <typename ValueType>
        struct s11n_api_marshaler< std::set<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::set<ValueType> serializable_type;
                typedef S11N_NS::list::list_serializer_proxy proxy_type;

                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };

        // end std::set
        ////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////
        // std::multiset
        template <typename ValueType>
        struct class_name< std::multiset<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::multiset<ValueType> set_type;
                static bool cl_reg_placeholder;

                static const char * name()
                {
                        static std::string n =
                                std::string("std::multiset<")
                                + ::classname<value_type>() 
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                S11N_NS::classloader_register<
                                        set_type,set_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };
        template <typename VT>
        bool class_name< std::multiset<VT> >::cl_reg_placeholder = (::classname< std::multiset<VT> >(),false);

        template <typename ValueType>
        struct s11n_api_marshaler< std::multiset<ValueType> >
        {
                typedef ValueType value_type;
                typedef std::multiset<ValueType> serializable_type;
                typedef S11N_NS::list::list_serializer_proxy proxy_type;

                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };

        // end std::multiset
        ////////////////////////////////////////////////////////////


        ////////////////////////////////////////////////////////////
        // std::pair
        template <typename FirstT, typename SecondT>
        struct class_name< std::pair<FirstT,SecondT> >
        {
                typedef FirstT first_type;
                typedef SecondT second_type;
                typedef std::pair<FirstT,SecondT> pair_type;
                static bool cl_reg_placeholder;

                static const char * name()
                {
                        static std::string n = 
                                std::string("std::pair<")
                                + ::classname<first_type>() 
                                + ","
                                + ::classname<second_type>() 
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                S11N_NS::classloader_register<
                                        pair_type,pair_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };
        template <typename KT, typename MT>
        bool class_name< std::pair<KT,MT> >::cl_reg_placeholder = (::classname< std::pair<KT,MT> >(),false);

        template <typename FirstT, typename SecondT>
        struct s11n_api_marshaler< std::pair<FirstT,SecondT> >
        {
                typedef FirstT first_type;
                typedef SecondT second_type;
                typedef std::pair<FirstT,SecondT> serializable_type;
                typedef S11N_NS::map::pair_serializer_proxy proxy_type;


                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };
        // end std::pair
        ////////////////////////////////////////////////////////////


        ////////////////////////////////////////////////////////////
        // std::map
        template <typename KeyT, typename MappedT>
        struct class_name< std::map<KeyT,MappedT> >
        {
                typedef KeyT key_type;
                typedef MappedT mapped_type;
                typedef std::map<KeyT,MappedT> map_type;
                static bool cl_reg_placeholder;

                static const char * name()
                {
                        static std::string n =
                                std::string("std::map<")
                                + ::classname<key_type>() 
                                + ","
                                + ::classname<mapped_type>() 
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                //CERR << "Registering map type ["<<n<<"]\n";
                                S11N_NS::classloader_register<
                                        map_type,map_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };

        template <typename KT, typename MT>
        bool class_name< std::map<KT,MT> >::cl_reg_placeholder = (::classname< std::map<KT,MT> >(),false);

        template <typename KeyT, typename MappedT>
        struct s11n_api_marshaler< std::map<KeyT,MappedT> >
        {
                typedef KeyT key_type;
                typedef MappedT mapped_type;
                typedef std::map<KeyT,MappedT> serializable_type;
                typedef typename serializable_type::value_type pair_type;

                typedef S11N_NS::map::map_serializer_proxy proxy_type;


                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };
        // end std::map
        ////////////////////////////////////////////////////////////




        ////////////////////////////////////////////////////////////
        // std::multimap
        template <typename KeyT, typename MappedT>
        struct class_name< std::multimap<KeyT,MappedT> >
        {
                typedef KeyT key_type;
                typedef MappedT mapped_type;
                typedef std::multimap<KeyT,MappedT> map_type;
                static bool cl_reg_placeholder;

                static const char * name()
                {
                        static std::string n =
                                std::string("std::multimap<")
                                + ::classname<key_type>() 
                                + ","
                                + ::classname<mapped_type>() 
                                + ">";
                        if( !cl_reg_placeholder && (cl_reg_placeholder=true) )
                        {
                                S11N_NS::classloader_register<
                                        map_type,map_type
                                        >( n );
                        }
                        return n.c_str();
                }
        };
        template <typename KT, typename MT>
        bool class_name< std::multimap<KT,MT> >::cl_reg_placeholder = (::classname< std::multimap<KT,MT> >(),false);

        template <typename KeyT, typename MappedT>
        struct s11n_api_marshaler< std::multimap<KeyT,MappedT> >
        {
                typedef KeyT key_type;
                typedef MappedT mapped_type;
                typedef std::multimap<KeyT,MappedT> serializable_type;
                typedef typename serializable_type::value_type pair_type;

                typedef S11N_NS::map::map_serializer_proxy proxy_type;

                /**
                   Returns proxy_type()( dest, src ).
                */
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname<serializable_type>() );
                        return proxy_type()( dest, src );
                }

                /**
                   Returns proxy_type()( src, dest ).
                */
                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest )
                {
                        return proxy_type()( src, dest );
                }
        };
        // end std::multimap
        ////////////////////////////////////////////////////////////

} // anonymous namespace

#endif // S11N_NS_SAM_STANDARD_SPECIALIZATIONS_H
