////////////////////////////////////////////////////////////////////////
// "supermacro" code for doing some registration stuff for Serializers.
// License: Public Domain
// Author: stephan@s11n.net
////////////////////////////////////////////////////////////////////////
// NOTE: this file does not use a conventional BLAH_H_INCLUDED guard.
// Yes, that's on purpose.
////////////////////////////////////////////////////////////////////////
// Boilerplate code for a
// proxies.
//
//
// The s11n header files are expected to have been included by the
// time this file is ever included.
//
//
// usage:
// define:
// SERIALIZER_TYPE serializer_class
// SERIALIZER_BASE base_of_serializer (or SERIALIZER_TYPE)
// SERIALIZER_MAGIC_COOKIE optional "#!/magic/cookie/string"
// SERIALIZER_ALIAS optional "alias_string" for classloading
//
// #include <this_file>
//
// After each include all of these macros are unset so that they may
// be immediately re-used for another registration.
//
// The cookie is required if s11n is to be able to load
// your files transparently. An alias is convenient for s11nconvert
// and such, but not required.
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
// General notes:
//
// By s11n convention S11N_NAME should contain no spaces, even for
// template types. Thus, please use:
//
//    "std::list<std::list<foo*>>"
//
// instead of:
//
//     "std::list<std::<list<foo *> >"
//
// C++ needs a space between "> >", but s11n does not.
// That said, s11n DOESN'T CARE what class names you use, as long
// as you're consistent.
//
////////////////////////////////////////////////////////////////////////

#include <stdlib.h> // abort

#define DEBUG_REG 0
#if DEBUG_REG
#  include <S11N_NS/debuggering_macros.h>
#endif


#ifndef SERIALIZER_TYPE
#    error "SERIALIZER_TYPE is not set. Set it to the type you want to proxy before including this file!"
#endif

#ifndef SERIALIZER_NAME
#    error "SERIALIZER_NAME must be set to the string form of SERIALIZER_TYPE"
#endif

#ifndef SERIALIZER_BASE
#    error "SERIALIZER_BASE must be the base-most type of SERIALIZER_TYPE (may be the same)."
#endif

// #warning "Running reg for serializer"

namespace { // anonymous namespace is important for complex linking reasons.

        ////////////////////////////////////////////////////////////////////////
        // A utility to keep us from having to hard-code or macro-ize the class
        // name (macroing won't work with commas in the class names, anyway).
        template <> struct class_name< SERIALIZER_TYPE >  {
                static const char * name()
                {
                        return SERIALIZER_NAME;
                }
        };



#ifndef S11N_NS_SERIALIZER_REG_CONTEXT_DEFINED
#define S11N_NS_SERIALIZER_REG_CONTEXT_DEFINED 1
        ///////////////////////////////////////////////////////////////
        // we must not include this more than once per compilation unit
        ///////////////////////////////////////////////////////////////
        // A unique (per SERIALIZER_BASE/per compilation unit) space to assign
        // a bogus value for classloader registration purposes (see
        // the classloader docs for a full description of how this
        // works).
        template <typename Context>
        struct serializer_reg_context
        {
                typedef Context context;
                static bool placeholder;
                static void reg()
                {
                        CERR << "ACHTUNG: << " << ::classname< serializer_reg_context<context> >()
                             << " is not specialized, which means that registration hasn't been done.\n"
                             << "For instructions see: " << __FILE__ << "\n";
                        abort();
                }
        };
        template <typename Context> bool serializer_reg_context<Context>::placeholder = false;
#endif
// !S11N_NS_SERIALIZER_REG_CONTEXT_DEFINED
////////////////////////////////////////////////////////////////////////////////

        template <>
        struct serializer_reg_context< SERIALIZER_TYPE >
        {
                typedef SERIALIZER_TYPE context;
                static bool placeholder;
                static void reg()
                {
#if DEBUG_REG
                        CERR << "\nRegistering Serializer: " << SERIALIZER_NAME << "\n"
                             << "classname() says: " << ::classname< SERIALIZER_TYPE >() << "\n"
#  ifdef SERIALIZER_MAGIC_COOKIE
                             << "cookie="<< SERIALIZER_MAGIC_COOKIE << "\n"
#  endif
#  ifdef SERIALIZER_ALIAS
                             << "alias="<< SERIALIZER_ALIAS << "\n"
#  endif
                                ; // CERR
#endif // DEBUG_REG

#ifdef SERIALIZER_ABSTRACT
                        cllite::register_abstract_base< SERIALIZER_BASE >( ::classname< context >() );
#  undef SERIALIZER_ABSTRACT
#else
                        cllite::register_factory< SERIALIZER_BASE, SERIALIZER_TYPE >( ::classname< context >() );
                        cllite::register_factory< SERIALIZER_TYPE, SERIALIZER_TYPE >( ::classname< context >() );
#endif
#ifdef SERIALIZER_MAGIC_COOKIE
                        cllite::alias< SERIALIZER_BASE >( SERIALIZER_MAGIC_COOKIE, ::classname< context >() );
                        cllite::alias< SERIALIZER_TYPE >( SERIALIZER_MAGIC_COOKIE, ::classname< context >() );
#  undef SERIALIZER_MAGIC_COOKIE
#endif
#ifdef SERIALIZER_ALIAS
                        cllite::alias< SERIALIZER_BASE >( SERIALIZER_ALIAS, ::classname< context >() );
                        cllite::alias< SERIALIZER_TYPE >( SERIALIZER_ALIAS, ::classname< context >() );
#  undef SERIALIZER_ALIAS
#endif
                }
        };

        bool serializer_reg_context< SERIALIZER_TYPE >::placeholder = (
                                                                       serializer_reg_context< SERIALIZER_TYPE >::reg()
                                                                       ,
                                                                       true
                                                                       );

} // anon namespace 

////////////////////////////////////////////////////////////////////////////////
// end proxy code for [SERIALIZER]
////////////////////////////////////////////////////////////////////////////////
#undef SERIALIZER_TYPE
#undef SERIALIZER_NAME
#undef DEBUG_REG


