/*
  imho_italiano.pike v0.1 for IMHO v0.95.2
  
  Copyright  
  Domenico Silvestro Scavone <hks1@freaknet.org> 2001
  
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.


*/

// Messages
//
//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407
// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601
// dialog
#define M_QUESTION 700
#define M_INFO 701
// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007
// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102
// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
// general
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003

string imho_lang() {
  return "italiano";
}


string msg(object sessobj,int m,array arg) {
  switch(m) {
    
    // Login page
    
  case M_LOGIN:
    //return "Login:";
    return "Utente:";
  case M_PASSWORD:
    //return "Password:";
    return "Password:";
  case M_NOLOGIN:
    //return "<b>Could not log in:</b> Wrong login or password. Try again. ";
    return "<b>Impossibile accedere:</b> Nome utente o password sbagliati. Prova ancora. ";
  case M_IMAPERROR:
    //return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
    return "Si e' verificato un problema comunicando con il mail server (IMAP). Per favore, contattare l'amministratore.";
    
  case M_NEWMAIL:
    //return "New mail";
    return "Posta in arrivo";
  case M_MAILBOX:
    //return sprintf("Mailbox: %s",@arg);
    return sprintf("Cartella: %s",@arg);
  case M_MAILBOXES:
    //return "Mailboxes";
    return "Cartelle";
  case M_FILES:
    //return "Files";
    return "Archivi";
  case M_PREFS:
    //return "Preferences";
    return "Preferenze";
  case M_LOGOUT:
    //return "Logout";
    return "Uscita";

  case M_FROM:
    //return "From";
    return "Da";
  case M_TO:
    //return "To";
    return "A";
  case M_CC:
    //return "Cc";
    return "Cc";
  case M_BCC:
    //return "Bcc";
    return "Bcc";
  case M_SUBJECT:
    //return "Subject";
    return "Oggetto";
  case M_ATTACHMENTS:
    //return "Attachments";
    return "Allegati";
  case M_TIME:
    //return "Time";
    return "Ora";
  case M_DATE:
    //return "Date";
    return "Data";
    
  case  M_MARKFLAG:
    //return "M";
    return "M";
  case M_NEWFLAG:
    //return "N";
    return "N";
  case M_ANSWEREDFLAG:
    //return "A";
    return "R";
    
    
  case M_SEND:
    //return "Send";
    return "Invio";
  case M_CANCELSEND:
    //return "Cancel";
    return "Cancellare";
  case M_SENDMOREFILES:
    //return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
    return "Selezionare gli archivi da inviare. Premere 'Ctrl' per (de)selezionare piu' archivi.";
  case M_COMPOSEMAIL:
    //return "Compose mail";
    return "Scrivi messaggio";
  case M_SPELLCHECK:
    return "Controllo Ortografico";
  case M_DONTSAVEMAIL:
    //return "Do not save this mail.";
    return "Non salvare questo messaggio";
  case M_ADDFILEASATTACHMENT:
    //return "Add file as attachment";
    return "Aggiungi l'archivio come allegato";
  case M_NOATTACHMENTS:
    //return "No attachments";
    return "Nessun allegato";
  case M_ADDATTACHMENT:
    //return "Add attachment...";
    return "Aggiungi allegato...";
  case M_REMOVEMARKEDATTACHMENTS:
    //return "Remove marked attachments";
    return "Elimina gli allegati selezionati";
  case M_UPLOADATTACHMENT:
    //return "Upload attachment";
    return "Carica l'allegato";
  case M_ADDMARKEDTOATTACHMENTS:
    //return "Add marked to attachments";
    return "Aggiungi i selezionati agli allegati";
  case M_UPLOADTOATTACHMENTS:
    //return "Upload to attachments";
    return "Carica agli allegati";
  case M_BACKTOCOMPOSE:
    //return "Back to compose";
    return "Torna alla Composizione";
  case M_NOATTACHFILES:
    //return "No files";
    return "Nessun archivio";
  case  M_ATTACHMENTSHEADER:
    //return "Attachments";
    return "Allegati";
    
  case M_DELETEMARKED:
    //return "Delete marked";
    return "Cancella i selezionati";
  case M_MOVEMARKED:
    //return "Move marked to";
    return "Sposta i selezionati a";
  case M_SELECTMBOX:
    //return "(Select a mailbox)";
    return "(Scegli una cartella)";
  case M_CHECKNEWMAIL:
    //return "Check for new mail";
    return "Controlla la posta in arrivo";
  case M_MAILSHOWN:
    // return sprintf("Mail %d-%d of %d", @arg);
    return sprintf("Messaggio %d-%d di %d", @arg);
  case M_BACKN:
    //return sprintf("[<< Prev %d]", @arg);
    return sprintf("[<< Precedente %d]", @arg);
  case M_FORWARDN:
    // return sprintf("[Next %d >>]", @arg);
    return sprintf("[Successivo %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    //sprintf("Are you sure you want to delete the %d marked message(s)?", 
    return 
      sprintf("Sei sicuro di volere eliminare i %d messaggi selezionati?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    //return "Please mark some messages first.";
    return "Per favore, seleziona alcuni messaggi prima.";
  case M_CHANGESORTORDER:
    //return "Change sort order";
    return "Cambia l'ordine";
  case M_MOVETOTRASH:
    //return "Move marked to trash";
    return "Sposta i selezionati nel cestino";
  case M_DELETEALLTRASH:
    //return "Delete all Trash";
    return "Svuota il cestino";
  case M_NOMAILS:
    // return "[No mails]";
    return "[Nessun messaggio]";

  case M_MBOXNAME:
    //return "Mailbox";
    return "Cartella";
  case M_DELETEMARKEDMBOX:
    //return "Delete marked";
    return "Cancellare i selezionati";
  case M_CREATEMBOX:
    //return "Create a new mailbox";
    return "Creare una nuova cartella";
  case M_NEWMBOXNAME:
    //return "(Name)";
    return "(Nome)";
  case M_MBOXREMOVEP:
    //return "Are you sure you want to delete the following mailboxes?";
    return "Sei sicuro di voler cancellare le seguenti cartelle?";
  case M_MBOXMARKONE:
    //return "Mark at least one mailbox.";
    return "Seleziona almeno una cartella";    
  case M_NEWMBOXNONAME:
    // return "Type in a name first.";
    return "Scrivi un nome prima";
  case M_CREATEMBOXERROR:
    //return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
    return "Impossibile creare la cartella. Il nome potrebbe essere non valido o la cartella potrebbe gia' esistere.";
	
  case M_FILENAME:
    //return "Filename";
    return "Nome dell'archivio";
  case M_SIZE:
    //return "Size";
    return "Dimensione";
  case M_MIMETYPE:
    //return "Type";
    return "Tipo";
  case M_DELETEMARKEDFILES:
    //return "Delete marked";
    return "Cancella i selezionati";
  case M_UPLOAD:
    //return "Upload";
    return "Carica";
  case M_AVAILSPACE:
    //return sprintf("You have %d Kb available for upload.",@arg);
    return sprintf("Puoi caricare fino a %d Kbytes.",@arg);
  case M_WINDOWSBUG :
    //return "Windowsusers: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
    return "Per gli utenti Windows: A causa di un errore di alcuni browsers, i nomi degli archivi potrebbero apparire danneggiati. Per evitare questo, potete sostituire l'ultimo '\\' con '\\\\' prima di premere 'Caricare'.";
  case M_NOFILES:
    //return "You have no uploades files.";
    return "Non avete caricato nessun archivio.";

  case M_PNAME:
    //return "Name";
    return "Nome";
  case M_PMAILADDRESS:
    //return "Mail address";
    return "Indirizzo E-mail";
  case M_PMAILPATH:
    //return "Mail searchpath";
    return "Percorso di ricerca";
  case M_PINCLUDEMAIL:
    //return "Include mail when replying";
    return "Includi il messaggio quando rispondi";
  case M_PQUOTEPREFIX :
    //return "Prefix";
    return "Prefisso";
  case M_PSIGNATURE:
    //return "Signature";
    return "Firma";
  case M_PINACTIVELOGOUT:
    //return "Inactive logout (minutes)";
    return "Uscita per inattivita' (minuti)";
  case M_PSAVEANDUSE:
    //return "Save and use";
    return "Salva e utilizza";
  case M_PVISIBLEMESSAGES:
    //return "Messages shown in mailbox";
    return "Messaggi visibili nella cartella";
  case M_PSORTORDER:
    //return "Mail sort order";
    return "Ordine dei messaggi";
  case M_PSORTORDERS:
    //return ([ "forward": "forward", "backward":"backward"])[arg[0]];
    return ([ "forward": "avanti", "backward":"indietro"])[arg[0]];
  case M_PTRASHFOLDER:
    //return "Trash folder";
    return "Cestino";
  case M_PSENTFOLDER:
    //return "Sent mail folder";
    return "Cartella dei messaggi inviati";
  case M_PDEFAULTBCC:
    //return "Default Bcc address";
    return "Indirizzo Bcc predefinito";
  case M_PSAVEATTACHMENTS:
    //return "Save attachments";
    return "Salva allegati";
  case M_PLANGUAGE:
    //return "Language";
    return "Linguaggio";

  case M_SPELLDONE:
    //return "Done";
    return "Fatto";
  case M_SPELLPREV:
    //return "Previous";
    return "Precedente";
  case M_SPELLNEXT:
    //return "Next";
    return "Successivo";
  case  M_SPELLCHANGETO:
    //return "Change to";
    return "Cambia in";
  case M_SPELLSUGGESTIONS:
    //return "Suggestions";
    return "Suggerimenti";

  case M_LOGOUTMSG:
    //return "You are logged out. Close this browser window to make sure no one can read your mails.<br><br>Reload this page to login.";
    return "Sei uscito dalla casella. Chiudi questa finestra del browser per essere certo che nessuno possa leggere i tuoi messaggi.<br><br>Ricarica questa pagina per rientrare.";
  case M_LOGGEDOUT:
    //return "Logged out";
    return "Uscito dalla casella";

  case M_QUESTION:
    //return "Question"; 
    return "Domanda";
  case M_INFO:
    //return "Info"; 
    return "Informazione";

  case M_REPLY:
    //return "Reply";
    return "Rispondere";
  case M_READPREV:
    //return "Read previous";
    return "Leggi il precedente";
  case M_READNEXT:
    //return "Read next";
    return "Leggi il successivo";
  case M_ATTACHMENTLINK:
    //return sprintf("%sattachment of type %s",@arg);
    return sprintf("%sallegato del tipo %s",@arg);
  case M_MAILMISSING:
    //return "<b>Error:</b> Failed to fetch mail. Try again. <br>";
    return "<b>Error:</b> Impossibile scaricare la posta. Riprova.<br>";
  case M_MAILMISSINGBACK:
    //return "Back";
    return "Indietro";
  case M_DELETE:
    //return "Delete";
    return "Cancellare";
  case M_FORWARD:
    //return "Forward";
    return "Avanti";

  case M_ADDRESSBOOKTITLE: 
    //return("Address Book");         
    return("Rubrica");
  case M_ADDRESSBOOK:
    //return("Address book...");
    return("Rubrica...");
  case M_INDEXNAMERECIPIENT:
    //return("Index name (click to add as recipient)");
    return("Nome dell'indice (premi per aggiungere come destinatario)");
  case M_INDEXNAMEEDIT:
    //return("Index name (click to edit)");
    return("Nome dell'indice (premi per modificarlo)");
  case M_ADDRESS:
    //return("Address");
    return("Indirizzo");
  case M_NOADDRESSES:
    //return("No addresses");
    return("Nessun indirizzo");
  case M_NEWADDRESS:
    //return("New address...");
    return("Nuovo indirizzo...");
  case M_EDITADDRESS:
    //return("Edit address");
    return("Modifica l'indirizzo");
  case M_ADDADDRESS:
    //return("Add to address book");
    return("Aggiungi alla rubrica");
  case M_INDEXNAME:
    //return("Index name");
    return("Nome dell'indice");
  case M_ADDRESSFORMAT:
    //return("Address(es), comma separated");
    return("Indirizzo(i), separati dalla virgola");
  case M_SAVEADDRESS:
    //return("Save and use");
    return("Salva e utilizza");
  case M_DELETEADDRESS:
    //return("Delete address");
    return("Cancella indirizzo");
  case M_CANCELADDRESS:
    //return("Cancel");
    return("Cancella");
  case M_CANNOTIMPORT:
    //return("Cannot import this addressbook, since its\nformat is not recognized.");
    return("Impossibile importare questa rubrica, finche' il suo\nformato non e' riconosciuto.");
  case M_IMPORTADDRESSBOOKTITLE:
    //return("Import address book");
    return("Importare rubrica");
  case M_UPLOADADDRESSBOOK:
    //return("Upload a Pine or exported Netscape (.ldif) address book");
    return("Carica una rubrica Pine o Netscape(.ldif)");
  case M_PINELOCATION:
    //return("The Pine address book is often in ~/.addressbook");
    return("La rubrica Pine is spesso in ~/.addressbook");
  case M_UPLOADANDIMPORT:
    //return("Upload and import");
    return("Carica e importa");
  case M_IMPORTADDRESSBOOK:
    // return("Import address book...");
    return("Importa la rubrica...");

  case M_YES:
    //return "Yes";
    return "Si";
  case M_NO:
    //return "No";
    return "No";
  case M_DIALOGOK:
    // return "OK";
    return "OK";
  case M_DIALOGCANCEL:
    // return "Cancel";
    return "Cancellare";
   
  }
  return 0;
}





