#!NOMODULE

constant cvs_version="$Id: ecms_util.pike,v 1.0 2000/07/17 07:40:12 pit Exp $";

class TemplateStructure {

  mapping inheritance=([]);
  array finfo=({});
  mixed inheritance_last;
  string data;
  
  string Tchild(Parser.HTML p, mapping attr, mapping extra) {
    inheritance[inheritance_last]+= ({ ([ "file" : attr->file ]) });
    return "";
  }
  
  
  string Tfield(Parser.HTML p, mapping attr, mapping extra) {
    mapping fi=([]);
    fi+=(["name":attr->name]);
    fi+=(["type":attr->type]);
    fi+=(["options":attr->options]);
    finfo+=({ fi });
    return "";
  }
  
  
  string Cnode(Parser.HTML p, mapping attr, string contents, mapping extra) {
    mapping res = ([ ]);
    
    inheritance+=([attr->file : ({}) ]);
    inheritance_last=attr->file;
    
    Parser.HTML()
      ->add_container ("node", Cnode)
      ->add_tag ("child", Tchild)
      ->add_quote_tag ("!--", "", "--")
      ->set_extra (res)
      ->finish (contents);
    extra[attr->name] = res;
    
    return "";
  }
  
  string Cinheritance(Parser.HTML p, mapping attr, string contents, mapping extra) {
    mapping res = ([ ]);
    Parser.HTML()
      ->add_container ("node", Cnode)
      ->add_quote_tag ("!--", "", "--")
      ->set_extra (res)
      ->finish (contents);
    extra[attr->name] = res;
    return "";
  }
  
  string Cxmltemplateinfo(Parser.HTML p, mapping attr, string contents, mapping extra) {
    mapping res = ([ ]);
    Parser.HTML()
      ->add_tag ("field", Tfield)
      ->add_quote_tag ("!--", "", "--")
      ->set_extra (res)
      ->finish (contents);
    extra[attr->name] = res;
    return "";
  }
  
  
  mapping inheritance_decode(string s) {
    inheritance_last="";
    mapping res = ([ ]);
    Parser.HTML()
      ->add_container ("inheritance", Cinheritance)
      ->add_quote_tag ("!--", "", "--")
      ->set_extra (res)
      ->finish (s);
    return res;
  }
  
  
  mapping xmltemplateinfo_decode(string s) {
    mapping res = ([ ]);
    Parser.HTML()
      ->add_container ("xmltemplateinfo", Cxmltemplateinfo)
      ->add_quote_tag ("!--", "", "--")
      ->set_extra (res)
      ->finish (s);
    return res;
  }
 
  string template_dir;
  
  void create(string file) {
    template_dir=file;
    data=Stdio.read_file(file+"INHERITANCE");
  }
  
  void destruct () {
  }
  
  
  mapping get_structure() {
    inheritance_decode(data);
    string templatefile;
    return inheritance;
  }
  
  array get_fields(string file) {
    string content=Stdio.read_file(template_dir+file);
    finfo=({});
    xmltemplateinfo_decode(content);
    return(finfo);
  }
  
  
  
};  



string mk_font(string s) {
  return(sprintf("<gtext nfont=\"futura\" scale=\"0.5\">%s</gtext>", s));
}


string mk_err_font(string s) {
  return(sprintf("<gtext fgcolor=\"#CC2020\" nfont=\"futura\" scale=\"0.5\">%s</gtext>", s));
}


string mk_ok_font(string s) {
  return(sprintf("<gtext fgcolor=\"#20CC20\" nfont=\"futura\" scale=\"0.5\">%s</gtext>", s));
}

