/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_CALCOPT_H
#define PXMCHEM_CALCOPT_H

#include "libpolyxmass-globals.h"
#include "pxmchem-ionizerule.h"



#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* typedef's
 */
typedef struct _PxmCalcOpt PxmCalcOpt;

struct _PxmCalcOpt
{
  /* Index of first polymer/oligomer monomer to 
   * integrate into mass calc., default 0.
   */
  gint start_idx;

  /* Index of last prot. residue to integrate into mass 
   * calc. , default -1 (which is polymer full length).
   */
  gint end_idx;

  /* Tells if the mass(es) to be computed is monoisotopic (MASS_MONO), 
   * average (MASS_AVG) or both. Default: PXM_MASS_BOTH.
   */
  PxmMassType mass_type;

  /* Tells if the polymer should be capped or not and if so at which
     end: PXM_CAPPING_NONE, PXM_CAPPING_LEFT,
     PXM_CAPPING_RIGHT.
     Default: (PXM_CAPPING_LEFT | PXM_CAPPING_RIGHT).
   */
  PxmCapping capping;

  /* What chemical entities should be taken into account at the level
   * of the monomers? Default:PXMCHEMENT_MNM_NONE.
   */
  PxmMnmChement mnm_chement;

  /* What chemical entities should be taken into account at the level
     of the whole polymer sequence?
     Default:PXMCHEMENT_PLM_NONE_MODIF
   */
  PxmPlmChement plm_chement;
};



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmCalcOpt * 
pxmchem_calcopt_new (void);
  

PxmCalcOpt * 
pxmchem_calcopt_dup (const PxmCalcOpt * calcopt);
  

/* UTILITY FUNCTIONS
 */
gboolean
pxmchem_calcopt_set_default (PxmCalcOpt * calcopt);
  

/* XML-format TRANSACTIONS
 */
gchar *
pxmchem_calcopt_format_xml_string_calcopt (PxmCalcOpt *calcopt, 
				       gchar *indent, gint offset);
  

PxmCalcOpt *
pxmchem_calcopt_render_xml_node_calcopt (xmlDocPtr xml_doc,
					  xmlNodePtr xml_node,
				       gpointer user_data);
  

/* FREE'ING FUNCTIONS
 */
gboolean
pxmchem_calcopt_free (PxmCalcOpt * calcopt);
  






#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_CALCOPT_H */
