/***************************************************************************
  $RCSfile: ddvcard.h,v $
  -------------------
  cvs         : $Id: ddvcard.h,v 1.7 2003/09/23 17:04:09 aquamaniac Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef DDVCARD_H
#define DDVCARD_H



#include <openhbci.h>
#include <openhbci/mediumplugin.h>

#include "mediumddv.h"


#define DDVCARD_PLUGIN_VMAJOR 1
#define DDVCARD_PLUGIN_VMINOR 2


#ifdef __cplusplus
namespace HBCI {



/**
 * This is the plugin for DDV chip cards.
 * @author Martin Preuss<martin@libchipcard.de>
 */
class DDVCardPlugin: public MediumPlugin {
private:
  const API *_api;

public:
  DDVCardPlugin(const API *api);
  virtual ~DDVCardPlugin();

  virtual string name() const { return "DDVCardPlugin";};
  virtual string description() const { return "Plugin for DDV chip cards";};
  virtual unsigned int vmajor() const { return DDVCARD_PLUGIN_VMAJOR;};
  virtual unsigned int vminor() const { return DDVCARD_PLUGIN_VMINOR;};

  /**
   * Returns the name of the MediumType (such as "RSACard", "DDVCard").
   */
  virtual string mediumTypeName() const { return DDVCARD_TYPENAME;};

  virtual MediumType mediumType() const { return MediumTypeCard;};

  /**
   * This method should only be used if there is no configuration file.
   * It creates a medium with default settings.
   */
  virtual Pointer<Medium> mediumFactory(const string &name);

  virtual Error mediumCheck(string &name) const;

  /**
   * Creates a new medium. This method simply creates a medium object
   * and returns the pointer (or did you expect this method to
   * build a card ;-) )
   */
  virtual Pointer<Medium> createNewMedium(bool readonly,
					  int country,
					  const string &bankId,
					  const string &userid,
					  const string &name);

  /**
   * This method is used to create a medium object using the data given in
   * a configuration file.
   * There are some mandatory variables in this group:
   * <ul>
   *  <li>
   *   mediumtype: This is used to lookup the medium plugin that is
   *   responsible for this medium
   *  </li>
   *  <li>
   *   mediumname: This is used to identify a medium. Each medium MUST have
   *   a unique name. RDHFiles use the path and name of the keyfile here,
   *   while chipcard media use the card's serial number.
   *  </li>
   * </ul>
   * The plugin may additionally use whichever variables it finds necessary.
   */
  virtual Pointer<Medium> mediumFromConfig(SimpleConfig &cfg,
					   cfgPtr group);

  /**
   * This method is used to store information from a medium to a configuration
   * file (in order to be restorable by @ref mediumFromConfig).
   * See @ref mediumFromConfig for details about the config group.
   */
  virtual Error mediumToConfig(Pointer<Medium> m,
			       SimpleConfig &cfg,
			       cfgPtr group);


  static Error checkVersion(const API *api);

};

}; // namespace

#endif // __cplusplus

#endif



