package uk.co.tigress ;

/**
 * The <code>System</code> class provides an implementation of
 * <code>getenv</code> that actually works, unlike the one in
 * <code>java.lang.System</code>.  The class cannot be instantiated.
 *
 * @author   R M Yorston
 * @version  1.0
 */
public class System {
	static {
		java.lang.System.loadLibrary("getenv") ;
	}

	private System() {
	}

	/**
	 * Gets an environment variable. An environment variable is a
	 * system-dependent external variable that has a string value.
	 *
	 * @param	name	name of the environment variable
	 * @return	the value of the variable, or <code>null</code> if the
	 * variable is not defined.
	 */
	public static native String getenv(String name) ;
}
