/*
 * $Id: ktree.h,v 1.4 2000/08/23 00:53:02 cbond Exp $
 */

#if !defined(__include_ktree_h__)
#define __include_ktree_h__

#include "arr.h"

extern int ktree_init(void);
extern void ktree_free(void);

typedef struct __kqueue_entry {
	char *tc_code;			/* value of variable */
	int tc_off;			/* termcap offset */
	int arr_code;			/* arr symbol */
} kqueue_entry;

typedef struct __kqueue_entry_c {
	int arr_code;			/* arr symbol */
	const char *str;		/* supposed value */
} kqueue_entry_c;

#define KQUEUE_ENTRY(t, a)	{ NULL, (int)t, (int)a }
#define KQUEUE_ENTRY_C(a, s)	{ (int)a, (const char *)s }

typedef struct __ktree_t {
	struct __ktree_t *child, *next, *parent;
	char key;
	int symbol;
} ktree_t;

extern arr_kqueue *read_queue(int (*_func)(FILE *));

#endif
