/* 
**  mod_layout.h -- Common defines.
**  $Revision: 1.33 $
*/

#define CORE_PRIVATE
#include <sys/stat.h>
#include <unistd.h>
#include "httpd.h"
#include "http_config.h"
#include "http_protocol.h"
#include "http_request.h"
#include "http_main.h"
#include "ap_config.h"
#include "http_log.h"
#include "buff.h"
#include "fnmatch.h"
#include "http_core.h"
#include <sys/mman.h>
#include "version.h"

#define BUFFER_LENGTH 1024

#define UNSET (-1)
#define OFF (0)
#define ON (1)
#define isOff(a) ((a == ON) ? 0 : 1 )
#define isOn(a) ((a == ON) ? 1 : 0 )
/* Yeah, I write perl, got a problem with that? */
#define unless(a) if(!(a))

/* layout states */
#define LAYOUT (0)
#define HTTP (1)
#define HEADER (2)
#define ORIGIN (3)
#define FOOTER (4)

/* layout ? */
#define APPEND (1)
#define REPLACE (2)
#define PREPEND (3)

#define WATCHPOINT printf("WATCHPOINT %s %d\n", __FILE__, __LINE__);
#define AWATCHPOINT ap_rprintf(r, "WATCHPOINT %s %d\n", __FILE__, __LINE__);
#define LAYOUT_EXPORT(type)    type

#define LAYOUT_CACHE "/tmp"
#define LAYOUT_BEGINTAG "<body*>"
#define LAYOUT_ENDTAG "</body>"
#define LAYOUT_TIMEFORMAT "%A, %d-%b-%Y %H:%M:%S %Z"

typedef struct {
	int type;									/* If it is static, file, dynamic */
	int kind;									/* Header, Footer or random layout */
	int append;								/* Either APPEND, REPLACE, or PREPEND */
	const char *string;				/* Whatever the layout is */
	const char *comment;			/* The comment that is displayed if comments are on */
	const char *pattern;			/* The pattern we match against */
} layout_string;

typedef struct {
	size_t size;
	char *file;
} mmap_data;

typedef struct {
	int http_header;
	int header;
	int footer;
	int length;
	int pid;
	int http;
	int origin;
	int merge;
	const char *type;
	const char *mime;
} layout_request;

typedef struct {
	int proxy;
	int glob;
	array_header *layouts;
	int header_enabled;
	int footer_enabled;
	int pattern_enabled;
	int display_origin;
	table *override;
	table *override_uri;
	int async_post;
	const char *async_cache;
	int http_header_enabled;
	int comment;
	/* These next three variables change with each request */
	char *http_header;
	const char *time_format;
	table *types;
	table *uris_ignore;
	table *uris_ignore_header;
	table *uris_ignore_http_header;
	table *uris_ignore_footer;
	table *tag_ignore;
	table *tag_ignore_footer;
	table *tag_ignore_header;
	int append_header;
	int append_footer;
	int cache_needed;
	int merge;
	int notes;
	int replace_tags;
	const char *begin_tag;
	const char *end_tag;
	const char *dir;
	int layout_html_handler;
} layout_conf;

module MODULE_VAR_EXPORT layout_module;

#include "proto.h"
