/**
 * \file insetfoot.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Jrgen Vigna
 * \author Lars Gullik Bjnnes
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include "insetfoot.h"
#include "gettext.h"
#include "lyxfont.h"
#include "BufferView.h"
#include "lyxtext.h"
#include "insets/insettext.h"
#include "support/LOstream.h"
#include "debug.h"
// the following are needed just to get the layout of the enclosing
// paragraph. This seems a bit too much to me (JMarc)
#include "lyxlayout.h"
#include "buffer.h"
#include "paragraph.h"


using std::ostream;


InsetFoot::InsetFoot(BufferParams const & bp)
	: InsetFootlike(bp)
{
	setLabel(_("foot"));
	setInsetName("Foot");
}


InsetFoot::InsetFoot(InsetFoot const & in, bool same_id)
	: InsetFootlike(in, same_id)
{
	setLabel(_("foot"));
	setInsetName("Foot");
}


Inset * InsetFoot::clone(Buffer const &, bool same_id) const
{
	return new InsetFoot(*const_cast<InsetFoot *>(this), same_id);
}


string const InsetFoot::editMessage() const
{
	return _("Opened Footnote Inset");
}


int InsetFoot::latex(Buffer const * buf,
		     ostream & os, bool fragile, bool fp) const
{
	if (buf && parOwner()) {
		LyXLayout_ptr const & layout = parOwner()->layout();
		fragile |= layout->intitle;
	}

	os << "%\n\\footnote{";

	int const i = inset.latex(buf, os, fragile, fp);
	os << "%\n}";

	return i + 2;
}


int InsetFoot::docbook(Buffer const * buf, ostream & os, bool mixcont) const
{
	os << "<footnote>";
	int const i = inset.docbook(buf, os, mixcont);
	os << "</footnote>";

	return i;
}
