/**
 * \file QParagraphDialog.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 * \author Edwin Leuven
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include "QParagraphDialog.h"
#include "QParagraph.h"

#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qvalidator.h>

#include "helper_funcs.h"

using std::vector;


QParagraphDialog::QParagraphDialog(QParagraph * form)
	: QParagraphDialogBase(0, 0, false, 0),
	form_(form)
{
	connect(okPB, SIGNAL(clicked()),
		form_, SLOT(slotOK()));
	connect(applyPB, SIGNAL(clicked()),
		form_, SLOT(slotApply()));
	connect(closePB, SIGNAL(clicked()),
		form_, SLOT(slotClose()));


	linespacingValue->setValidator(new QDoubleValidator(linespacingValue));
	// disabled to allow glue spacing for latexperts
	//valueAbove->setValidator(new QDoubleValidator(valueAbove));
	//valueBelow->setValidator(new QDoubleValidator(valueBelow));
}


void QParagraphDialog::closeEvent(QCloseEvent * e)
{
	form_->slotWMHide();
	e->accept();
}


void QParagraphDialog::change_adaptor()
{
	form_->changed();
}


void QParagraphDialog::enableAbove(int)
{
	bool const enable = spacingAbove->currentItem()==6;
	valueAbove->setEnabled(enable);
	unitAbove->setEnabled(enable);

}


void QParagraphDialog::enableBelow(int)
{
	bool const enable = spacingBelow->currentItem()==6;
	valueBelow->setEnabled(enable);
	unitBelow->setEnabled(enable);
}


void QParagraphDialog::enableLinespacingValue(int)
{
	bool const enable = linespacing->currentItem()==4;
	linespacingValue->setEnabled(enable);
}
