/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

/* new stuff for maze generation */


#ifndef MAZEGEN

#define MAZEGEN


typedef void *(*voidfunc)(void *, long, long, long);

typedef struct point {
  int x;
  int y;
} point;

typedef struct set {
  point *ptlist;
  long size;
} set;

/* ----------------------------------------- */
/*                    MAZE                   */
/* ----------------------------------------- */

typedef struct maze {
  long x;
  long y;
  long maxlen;
  voidfunc hfptr;
  voidfunc vfptr;
  void *walls;
  char *pts;
  set *nsew_set[4];
} maze;

void maze_gen_vline( maze *m, long x, long y, int direction );
void maze_gen_hline( maze *m, long x, long y, int direction );
maze *maze_init( void *wall, voidfunc h, voidfunc v, long x, long y );
void maze_finish( maze *m );


#endif /* MAZEGEN */


