/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef _SNIPES_CHARS_H
#define _SNIPES_CHARS_H

//#define PLAIN_CHARS

#ifdef PLAIN_CHARS

#define	HIVE_TOPLEFT		'['
#define	HIVE_TOPRIGHT		']'
#define HIVE_BOTTOMLEFT		'['
#define HIVE_BOTTOMRIGHT	']'

#define EVILFACE		'0'
#define GHOSTFACE		'@'
#define WEAPON_UP		'^'
#define WEAPON_DOWN		'v'
#define WEAPON_LEFT		'<'
#define WEAPON_RIGHT		'>'
#define WEAPON_DIAG_POS		'/'
#define WEAPON_DIAG_NEG		'\\'

#define	PLAYER_LEFTFACE		'<'
#define	PLAYER_RIGHTFACE	'>'
#define PLAYER_BIGEYE		'O'
#define PLAYER_SMALLEYE		'o'

#define PLAYER_BULLET_1		'o'
#define PLAYER_BULLET_2		'*'

#define PLAYER_DIE_1		'o'
#define PLAYER_DIE_2		'*'
#define PLAYER_DIE_3		'#'
#define PLAYER_DIE_4		'%'

#define VERTICAL_BAR		'|'

#define BLANK_CHAR		' '
#define VERTICAL_WALL_CHAR	'|'
#define HORIZONTAL_WALL_CHAR	'-'
#define UPPER_LEFT_CORNER_CHAR	'+'
#define LOWER_LEFT_CORNER_CHAR	'+'
#define UPPER_RIGHT_CORNER_CHAR	'+'
#define LOWER_RIGHT_CORNER_CHAR	'+'
#define VERTICAL_T_RIGHT_CHAR	'*'
#define VERTICAL_T_LEFT_CHAR	'*'
#define HORIZONTAL_T_UP_CHAR	'*'
#define HORIZONTAL_T_DOWN_CHAR	'*'
#define FOUR_WAY_INTERSECTION	'*'

/**************************************************/
#else
/**************************************************/

#define	HIVE_TOPLEFT		0xDA
#define	HIVE_TOPRIGHT		0xBF
#define HIVE_BOTTOMLEFT		0xC0
#define HIVE_BOTTOMRIGHT	0xD9

#define EVILFACE		0x01
#define GHOSTFACE		0x02
#define WEAPON_UP		0x18
#define WEAPON_DOWN		0x19
/* next 2 were 1A */
#define WEAPON_LEFT		0x1D
#define WEAPON_RIGHT		0x1D
#define WEAPON_DIAG_POS		'/'
#define WEAPON_DIAG_NEG		'\\'

#define	PLAYER_LEFTFACE		0x11
#define	PLAYER_RIGHTFACE	0x10
#define PLAYER_BIGEYE		'O'
#define PLAYER_SMALLEYE		0x93

#define PLAYER_BULLET_1		0x09
#define PLAYER_BULLET_2		0x2A

#define PLAYER_DIE_1		0x09
#define PLAYER_DIE_2		0x2A
#define PLAYER_DIE_3		0xB0
#define PLAYER_DIE_4		0xB2

#define VERTICAL_BAR		0xB3

#define BLANK_CHAR		' '
#define VERTICAL_WALL_CHAR	0xBA
#define HORIZONTAL_WALL_CHAR	0xCD
#define UPPER_LEFT_CORNER_CHAR	0xC9
#define LOWER_LEFT_CORNER_CHAR	0xC8
#define UPPER_RIGHT_CORNER_CHAR	0xBB
#define LOWER_RIGHT_CORNER_CHAR	0xBC
#define VERTICAL_T_RIGHT_CHAR	0xCC
#define VERTICAL_T_LEFT_CHAR	0xB9
#define HORIZONTAL_T_UP_CHAR	0xCA
#define HORIZONTAL_T_DOWN_CHAR	0xCB
#define FOUR_WAY_INTERSECTION	0xCE

#endif


#endif // _SNIPES_CHARS_H
