import gtk


import BaseFolderTree
import MetaData


class Model(BaseFolderTree.Model):

    def __init__(self, doc):
    	BaseFolderTree.Model.__init__(self, doc)
	self.editable = gtk.FALSE
	self.photo_deletion_folder = None

    def make_folder_for_photo_deletions(self):
    	if not self.photo_deletion_folder:
	    self.photo_deletion_folder = MetaData.Folder()
	    self.photo_deletion_folder[u"name"] = u"Deleted photos"
	    iter = self.store.insert_after(None, None)
	    self.set_folder(iter, self.photo_deletion_folder)

    def copy_folder(self, store, iter):
    	assert store != self.store
    	new_iter = self.store.insert_after(None, None)
	self.set_folder(new_iter, store.get_value(iter, self.OBJECT_COLUMN))

    def copy_file(self, input, output):
    	if input:
	    while 1:
		data = input.read(4096)
		if not data:
		    break
		output.write(data)
	output.close()

    def copy_photos(self, doc, photos):
    	self.make_folder_for_photo_deletions()
	for photo in photos:
	    self.photo_deletion_folder.photos.add(photo)
	    f = self.doc.storage.new_original(photo[u"id"])
	    self.copy_file(doc.storage.get_original(photo[u"id"]), f)
    	    self.doc.storage.close_original(photo[u"id"], f)
	    f = self.doc.storage.new_thumbnail(photo[u"id"])
	    self.copy_file(doc.storage.get_thumbnail(photo[u"id"]), f)
    	    self.doc.storage.close_thumbnail(photo[u"id"], f)

    def empty_trash(self):
    	self.store.clear()


class View(BaseFolderTree.View):

    def __init__(self, window, doc, xml):
    	model = Model(doc)
    	BaseFolderTree.View.__init__(self, window, model,
				BaseFolderTree.Controller(model, self),
	    	    	    	xml)
